/*
 * Decompiled with CFR 0.152.
 */
package JMWiki;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

class BinaryTree<T>
implements Iterable<T> {
    private int count = 0;
    private int nodeCount = 0;
    private final BinaryTreeNode<T> root = new BinaryTreeNode();
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.root.nodeL == null && this.root.nodeR == null;
    }

    public void put(String key, T object) {
        this.put(key.hashCode(), object);
    }

    public void put(T object) {
        this.put(object.toString(), object);
    }

    public void put(long key, T object) {
        this.putNode(object, this.numberToKey(key), true);
    }

    public void putIfAbsent(String key, T object) {
        this.putIfAbsent(key.hashCode(), object);
    }

    public void putIfAbsent(long key, T object) {
        this.putNode(object, this.numberToKey(key), false);
    }

    public T get(String key) {
        return this.get(key.hashCode());
    }

    public T get(String key, T defaultValue) {
        T obj = this.get(key);
        return obj != null ? obj : defaultValue;
    }

    public T get(long key) {
        BinaryTreeNode<T> node = this.getNode(this.numberToKey(key), false);
        return node == null ? null : (T)node.object;
    }

    public boolean contains(String key) {
        return this.contains(key.hashCode());
    }

    public boolean containsKey(String key) {
        return this.contains(key.hashCode());
    }

    public boolean contains(long key) {
        BinaryTreeNode<T> node = this.getNode(this.numberToKey(key), false);
        return node != null && node.object != null;
    }

    public void remove(long key) {
        this.removeNode(this.getNode(this.numberToKey(key), false));
    }

    public void remove(String key) {
        this.remove(key.hashCode());
    }

    public void clear() {
        this.clearNode(this.root.nodeL);
        this.clearNode(this.root.nodeR);
    }

    void clearNode(BinaryTreeNode node) {
        if (node != null) {
            this.clearNode(node.nodeL);
            this.clearNode(node.nodeR);
            node.nodeL = null;
            node.nodeR = null;
            node.object = null;
            node.parent = null;
        }
    }

    public String toString() {
        return super.toString() + ", size=" + this.count;
    }

    public BinaryTree<T> clone() {
        BinaryTree<T> retTree = new BinaryTree<T>();
        return retTree;
    }

    private void removeNode(BinaryTreeNode<T> node) {
        if (node == null) {
            return;
        }
        if (node.object != null) {
            --this.count;
            node.object = null;
        }
        BinaryTreeNode<T> n = node;
        while (n.nodeL == null && n.nodeR == null && n.parent != null) {
            if (n.parent.nodeL == n) {
                n.parent.nodeL = null;
            } else {
                n.parent.nodeR = null;
            }
            n = n.parent;
        }
    }

    private void putNode(T object, byte[] key, boolean overwrite) {
        BinaryTreeNode<T> node = this.getNode(key, true);
        if (node.object == null) {
            ++this.count;
        } else if (!overwrite) {
            System.out.println("ID has an item");
            return;
        }
        node.object = object;
    }

    public void showNodeCount() {
        System.out.println("total objects = " + this.count + ", total nodes = " + this.nodeCount + ".  node : Object ratio =  " + (float)this.nodeCount / (float)this.count);
    }

    private BinaryTreeNode<T> getNode(byte[] key, boolean create) {
        BinaryTreeNode<T> currentNode = this.root;
        for (int charIndex = 0; charIndex < key.length; ++charIndex) {
            byte c = key[charIndex];
            if (c == 0) {
                if (currentNode.nodeL == null) {
                    if (!create) {
                        return null;
                    }
                    currentNode.nodeL = new BinaryTreeNode();
                    ++this.nodeCount;
                }
                currentNode = currentNode.nodeL;
                continue;
            }
            if (c != 1) continue;
            if (currentNode.nodeR == null) {
                if (!create) {
                    return null;
                }
                currentNode.nodeR = new BinaryTreeNode();
                ++this.nodeCount;
            }
            currentNode = currentNode.nodeR;
        }
        return currentNode;
    }

    private byte[] numberToKey(long key) {
        return BinaryTree.toRevBinaryArray(key);
    }

    private static byte[] toRevBinaryArray(long val) {
        int shift = 1;
        int mag = 64 - Long.numberOfLeadingZeros(val);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        byte[] buf = new byte[chars];
        int charPos = 0;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[charPos] = (byte)(digits[(int)val & mask] - 48);
            val >>>= shift;
        } while (++charPos < buf.length);
        return buf;
    }

    private static byte[] toBinary(long val) {
        int shift = 1;
        int mag = 64 - Long.numberOfLeadingZeros(val);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        byte[] buf = new byte[chars];
        int charPos = 0;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[charPos] = (byte)(digits[(int)val & mask] - 48);
            val >>>= shift;
        } while (++charPos < buf.length);
        return buf;
    }

    public T[] toArray() {
        Object[] array = null;
        if (this.count > 0) {
            Object object = null;
            Iterator<T> iterator = this.iterator();
            if (iterator.hasNext()) {
                T t = iterator.next();
                object = t;
            }
            if (object != null) {
                array = (Object[])Array.newInstance(object.getClass(), this.count);
                int x = 0;
                for (T obj : this) {
                    array[x] = obj;
                    ++x;
                }
            }
        }
        return array;
    }

    public Object[] toObjectArray() {
        Object[] array = null;
        if (this.count > 0) {
            array = new Object[this.count];
            int x = 0;
            for (T obj : this) {
                array[x] = obj;
                ++x;
            }
        }
        return array;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr(this);
    }

    private static class BinaryTreeNode<T> {
        T object;
        BinaryTreeNode<T> parent;
        BinaryTreeNode<T> nodeL = null;
        BinaryTreeNode<T> nodeR = null;

        private BinaryTreeNode() {
        }
    }

    private class Itr
    implements Iterator<T> {
        private T next = null;
        private Stack<BinaryTreeNode<T>> traversal = new Stack();

        public Itr(BinaryTree binaryTree) {
            this.moveLeft(binaryTree.root);
        }

        private void moveLeft(BinaryTreeNode<T> current) {
            while (current != null) {
                this.traversal.push(current);
                current = current.nodeL;
            }
        }

        @Override
        public boolean hasNext() {
            this.next = null;
            while (this.next == null && !this.traversal.isEmpty()) {
                BinaryTreeNode current = this.traversal.pop();
                if (current.nodeR != null) {
                    this.moveLeft(current.nodeR);
                }
                if (current.object == null) continue;
                this.next = current.object;
                break;
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next != null) {
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }
}

