/*
 * Decompiled with CFR 0.152.
 */
package JMWiki;

import JMWiki.DocumentWikiModel;
import JMWiki.UndoRedoManager;
import JMWiki.Undoable;
import JMWiki.WikiEvent;
import JMWiki.WikiModelListener;
import JMWiki.WikiPage;
import JMWiki.WikiPaneListener;
import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class JWikiPane
extends JEditorPane
implements WikiModelListener {
    DocumentWikiModel model;
    private final UndoRedoManager undoManager = new UndoRedoManager(){

        @Override
        public void undoRedoOccurred() {
            JWikiPane.this.fireEvents(new WikiEvent(0));
        }
    };
    private WikiPage currentPage = null;
    private WikiPaneListener listener = null;

    public void clear() {
        if (this.model != null) {
            this.model.clear();
        }
    }

    public void clearHistory() {
        this.fireEvents(new WikiEvent(4));
    }

    public JWikiPane() {
        this.setEditable(false);
        this.setModel(new DocumentWikiModel());
        this.setContentType("text/html");
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                String eType = e.getEventType().toString();
                String linkText = e.getDescription();
                URL linkURL = e.getURL();
                switch (eType) {
                    case "ENTERED": {
                        JWikiPane.this.model.fireEvents(new WikiEvent(11, linkText, linkURL));
                        break;
                    }
                    case "EXITED": {
                        JWikiPane.this.model.fireEvents(new WikiEvent(12, linkText, linkURL));
                        break;
                    }
                    case "ACTIVATED": {
                        if (JWikiPane.this.isExternalURL(linkText)) {
                            JWikiPane.this.openURL(linkText);
                            break;
                        }
                        JWikiPane.this.openPage(linkText);
                    }
                }
            }
        });
    }

    private boolean isExternalURL(String url) {
        return !url.equals(WikiPage.safeID(url));
    }

    private void openURL(String url) {
        try {
            Desktop.getDesktop().browse(new URL(url).toURI());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(JWikiPane.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException | URISyntaxException ex) {
            Logger.getLogger(JWikiPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setModel(DocumentWikiModel model) {
        if (this.model != null) {
            this.model.removeListener(this);
        }
        if (model != null) {
            this.clear();
            this.model = model;
            this.model.addListener(this);
            this.displayPage(model.getHomePage());
        }
    }

    public DocumentWikiModel getModel() {
        return this.model;
    }

    public void displayPage(final WikiPage page) {
        if (page == null || page == this.currentPage) {
            return;
        }
        final WikiPage prevPage = this.currentPage != null ? this.currentPage : this.model.getHomePage();
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                if (prevPage.contents != null) {
                    JWikiPane.this.setText(prevPage.contents);
                } else {
                    JWikiPane.this.setText("Page is not yet available.");
                }
                JWikiPane.this.setCaretPosition(0);
                JWikiPane.this.currentPage = prevPage;
                JWikiPane.this.fireEvents(new WikiEvent[0]);
                return true;
            }

            @Override
            public boolean redo() {
                if (prevPage.contents != null) {
                    JWikiPane.this.setText(page.contents);
                } else {
                    JWikiPane.this.setText("Page is not yet available.");
                }
                JWikiPane.this.setCaretPosition(0);
                JWikiPane.this.currentPage = page;
                JWikiPane.this.fireEvents(new WikiEvent[0]);
                return true;
            }
        };
        edit.redoName = "go forward to (" + page.title + ")";
        edit.undoName = "go back to (" + prevPage.title + ")";
        this.undoManager.runEdit(edit);
    }

    public void openPage(String linkName) {
        WikiPage newPage = this.model.getPage(linkName);
        if (newPage != null && newPage != this.currentPage) {
            this.displayPage(newPage);
        }
    }

    public void openPage(WikiPage page) {
        if (page != null && page != this.currentPage) {
            this.displayPage(page);
        }
    }

    public boolean canGoBack() {
        return this.undoManager.canUndo();
    }

    public boolean canGoForward() {
        return this.undoManager.canRedo();
    }

    public void goBack() {
        this.undoManager.undo();
    }

    public void goForward() {
        this.undoManager.redo();
    }

    public String getBackPageName() {
        return this.undoManager.getUndoName();
    }

    public String getForwardPageName() {
        return this.undoManager.getRedoName();
    }

    public WikiPage getCurrentPage() {
        return this.currentPage;
    }

    public void setListener(WikiPaneListener listener) {
        this.listener = listener;
    }

    public WikiPaneListener getListener() {
        return this.listener;
    }

    public void fireEvents(WikiEvent ... events) {
        if (this.listener != null) {
            this.listener.wikiPanelEvent(events);
        }
    }

    @Override
    public void wikiModelPropertyChanged(WikiEvent ... events) {
        for (WikiEvent event : events) {
            switch (event.value) {
                case 4: {
                    this.currentPage = null;
                    this.undoManager.clear();
                }
            }
        }
    }
}

