/*
 * Decompiled with CFR 0.152.
 */
package JMWiki;

import JMWiki.XMLElement;

public class WikiPage {
    String id;
    String title;
    String contents;
    private static final String ID_FILTER_STRING = "[^A-Za-z0-9_]";

    static WikiPage fromXMLElement(XMLElement xmlPage) {
        WikiPage page = new WikiPage();
        page.id = xmlPage.getAttribute("id", "default");
        page.title = xmlPage.getAttribute("title", "");
        page.contents = xmlPage.body;
        return page;
    }

    static XMLElement toXMLElement(WikiPage page) {
        XMLElement xmlPage = new XMLElement();
        xmlPage.addAttribute("id", page.id);
        xmlPage.addAttribute("title", page.title);
        xmlPage.setText(page.contents);
        return xmlPage;
    }

    public WikiPage() {
    }

    public WikiPage(String id) {
        this(null, null, null);
    }

    public WikiPage(String id, String title) {
        this(id, title, null);
    }

    public WikiPage(String id, String title, String contents) {
        this.setID(id);
        this.setTitle(title);
        this.setContents(contents);
    }

    public String getContents() {
        return this.contents != null ? this.contents : "";
    }

    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    public String getID() {
        return this.id != null ? this.id : "default";
    }

    public void setContents(String value) {
        if (value != null && value.length() > 0) {
            this.contents = value;
        }
    }

    public void setTitle(String value) {
        if (value != null && value.length() > 0) {
            this.title = value;
        }
    }

    public void setID(String value) {
        this.id = WikiPage.safeID(value);
    }

    static final String safeID(String id) {
        if (id == null || id.length() == 0) {
            return "default";
        }
        return (id = id.replaceAll(ID_FILTER_STRING, "")) == null || id.length() == 0 ? "default" : id;
    }

    public String toString() {
        return this.title + " (id: " + this.id + ")";
    }
}

