/*
 * Decompiled with CFR 0.152.
 */
package JXTableEditorsAndRenderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ColorCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    ColorButton button = new ColorButton();
    String title = "Select a new color";

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Object getCellEditorValue() {
        return this.button.getForeground();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.button.setBackground(table.getBackground());
        this.button.setForeground((Color)value);
        return this.button;
    }

    public JButton getButton() {
        return this.button;
    }

    class ColorButton
    extends JButton {
        public ColorButton() {
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setHorizontalAlignment(0);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = JColorChooser.showDialog(ColorCellEditor.this.button, ColorCellEditor.this.title, ColorCellEditor.this.button.getForeground());
                    if (color != null) {
                        ColorCellEditor.this.button.setForeground(color);
                    }
                    ColorCellEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public void setForeground(Color color) {
            int iconWidth = 15;
            super.setForeground(color);
            BufferedImage icon = new BufferedImage(iconWidth, iconWidth, 2);
            Graphics2D g2d = icon.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(color);
            g2d.fillRect(0, 0, iconWidth, iconWidth);
            g2d.setColor(Color.BLACK);
            g2d.drawRect(0, 0, iconWidth - 1, iconWidth - 1);
            this.setIcon(new ImageIcon(icon));
        }
    }
}

