/*
 * Decompiled with CFR 0.152.
 */
package NotePad;

import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import FontChooser.JFontChooser;
import GhostTextControls.GhostTextPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.rtf.RTFEditorKit;

public abstract class NotePadWindow
extends JFrame {
    private boolean promptSave = true;
    private boolean mIsChanged = false;
    private StyledDocument doc;
    private SimpleAttributeSet attrs;
    private RTFEditorKit kit = new RTFEditorKit();
    protected String mKey = "";
    private GlossyButton cmdBackColor;
    private GlossyButton cmdBold;
    private GlossyButton cmdCenter;
    private GlossyButton cmdFont;
    private GlossyButton cmdFontColor;
    private GlossyButton cmdFontSizeDec;
    private GlossyButton cmdFontSizeInc;
    private GlossyButton cmdItalics;
    private GlossyButton cmdLeft;
    private GlossyButton cmdRight;
    private GlossyButton cmdSave;
    private GlossyButton cmdSelBackcolor;
    private GlossyButton cmdSelFontColor;
    private GlossyButton cmdStrikeThrough;
    private GlossyButton cmdSubscript;
    private GlossyButton cmdSuperscript;
    private GlossyButton cmdUnderline;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JMenuItem mnuBold;
    private JMenuItem mnuDecSize;
    private JMenuItem mnuExit;
    private JMenuItem mnuIncSize;
    private JMenuItem mnuItalics;
    private JMenuItem mnuSave;
    private JMenuItem mnuStrikethrough;
    private JMenuItem mnuSubscript;
    private JMenuItem mnuSuperscript;
    private JMenuItem mnuUnderline;
    private GhostTextPane noteTextBox;
    private JToolBar toolBar;

    public void beforeClose() {
    }

    public NotePadWindow() {
        this.initComponents();
        this.toolBar.setFloatable(false);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/Icons/NOTES.png")).getImage());
        this.doc = this.noteTextBox.getStyledDocument();
        this.doc.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NotePadWindow.this.mIsChanged = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NotePadWindow.this.mIsChanged = true;
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                NotePadWindow.this.mIsChanged = true;
            }
        });
        this.setLocationRelativeTo(null);
    }

    public StyledDocument getStyledDocument() {
        return this.doc;
    }

    public String getKey() {
        return this.mKey;
    }

    public void setKey(String key) {
        this.mKey = key;
    }

    public boolean isChanged() {
        return this.mIsChanged;
    }

    public void setIsChanged(boolean IsChanged) {
        this.mIsChanged = IsChanged;
    }

    public boolean getPromtSaveOnClose() {
        return this.promptSave;
    }

    public void setPromtSaveOnClose(boolean prompt) {
    }

    public String getText() {
        return this.noteTextBox.getText();
    }

    public void setText(String text) {
        this.noteTextBox.setText(text);
        this.noteTextBox.select(0, 0);
        this.mIsChanged = false;
    }

    public boolean hasText() {
        return this.doc.getLength() > 0;
    }

    public String getTextRTF() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            this.kit.write(outBytes, (Document)((DefaultStyledDocument)this.doc), 0, this.doc.getLength());
            String outString = new String(outBytes.toByteArray());
            return outString;
        }
        catch (IOException | BadLocationException ex) {
            return "";
        }
    }

    public void setTextRTF(String textRTF) {
        ByteArrayInputStream stream = new ByteArrayInputStream(textRTF.trim().getBytes(StandardCharsets.UTF_8));
        try {
            this.noteTextBox.setText("");
            this.kit.read(stream, (Document)this.doc, 0);
        }
        catch (IOException | BadLocationException exception) {
            // empty catch block
        }
        this.noteTextBox.select(0, 0);
        this.mIsChanged = false;
    }

    public boolean OkToClose() {
        boolean closeMe = true;
        if (this.mIsChanged && this.promptSave) {
            int confirm = JOptionPane.showOptionDialog(null, "Save changes before closing?", "Save changes?", 1, 3, null, null, null);
            switch (confirm) {
                case 0: {
                    closeMe = this.SaveNote();
                    break;
                }
                case -1: 
                case 2: {
                    closeMe = false;
                    break;
                }
                case 1: {
                    closeMe = true;
                }
            }
        }
        if (closeMe && this.CloseWindow()) {
            this.setDefaultCloseOperation(2);
            return true;
        }
        this.setDefaultCloseOperation(0);
        return false;
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.cmdSave = new GlossyButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.cmdFontColor = new GlossyButton();
        this.cmdSelFontColor = new GlossyButton();
        this.cmdBackColor = new GlossyButton();
        this.cmdSelBackcolor = new GlossyButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.cmdFont = new GlossyButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.cmdFontSizeInc = new GlossyButton();
        this.cmdFontSizeDec = new GlossyButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.cmdStrikeThrough = new GlossyButton();
        this.cmdSuperscript = new GlossyButton();
        this.cmdSubscript = new GlossyButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.cmdBold = new GlossyButton();
        this.cmdItalics = new GlossyButton();
        this.cmdUnderline = new GlossyButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.cmdLeft = new GlossyButton();
        this.cmdCenter = new GlossyButton();
        this.cmdRight = new GlossyButton();
        this.jScrollPane2 = new JScrollPane();
        this.noteTextBox = new GhostTextPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.mnuSave = new JMenuItem();
        this.mnuExit = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.mnuBold = new JMenuItem();
        this.mnuItalics = new JMenuItem();
        this.mnuUnderline = new JMenuItem();
        this.mnuStrikethrough = new JMenuItem();
        this.mnuSuperscript = new JMenuItem();
        this.mnuSubscript = new JMenuItem();
        this.mnuIncSize = new JMenuItem();
        this.mnuDecSize = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Notes Editor");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                NotePadWindow.this.formWindowClosed(evt);
            }
        });
        this.toolBar.setBackground(new Color(255, 255, 255));
        this.toolBar.setRollover(true);
        this.toolBar.setDoubleBuffered(true);
        this.toolBar.setPreferredSize(new Dimension(100, 33));
        this.cmdSave.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Save.png")));
        this.cmdSave.setToolTipText("Save changes");
        this.cmdSave.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdSave.setColorHot(new Color(255, 255, 255));
        this.cmdSave.setColorNormal(new Color(255, 255, 255));
        this.cmdSave.setColorPressed(new Color(255, 255, 255));
        this.cmdSave.setFocusable(false);
        this.cmdSave.setHorizontalTextPosition(0);
        this.cmdSave.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/Save.png")));
        this.cmdSave.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/Save.png")));
        this.cmdSave.setMaximumSize(new Dimension(30, 30));
        this.cmdSave.setMinimumSize(new Dimension(30, 30));
        this.cmdSave.setVerticalTextPosition(3);
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdSaveActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdSave);
        this.jSeparator1.setSeparatorSize(new Dimension(7, 0));
        this.toolBar.add(this.jSeparator1);
        this.cmdFontColor.setText("F");
        this.cmdFontColor.setToolTipText("Change text color");
        this.cmdFontColor.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdFontColor.setColorHot(new Color(255, 255, 255));
        this.cmdFontColor.setColorNormal(new Color(255, 255, 255));
        this.cmdFontColor.setColorPressed(new Color(255, 255, 255));
        this.cmdFontColor.setFocusable(false);
        this.cmdFontColor.setFont(new Font("Tahoma", 1, 18));
        this.cmdFontColor.setHorizontalTextPosition(0);
        this.cmdFontColor.setMaximumSize(new Dimension(30, 30));
        this.cmdFontColor.setMinimumSize(new Dimension(30, 30));
        this.cmdFontColor.setPreferredSize(new Dimension(30, 30));
        this.cmdFontColor.setVerticalTextPosition(3);
        this.cmdFontColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdFontColorActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdFontColor);
        this.cmdSelFontColor.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/ArrowDown.png")));
        this.cmdSelFontColor.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdSelFontColor.setColorHot(new Color(255, 255, 255));
        this.cmdSelFontColor.setColorNormal(new Color(255, 255, 255));
        this.cmdSelFontColor.setColorPressed(new Color(255, 255, 255));
        this.cmdSelFontColor.setFocusable(false);
        this.cmdSelFontColor.setHorizontalTextPosition(0);
        this.cmdSelFontColor.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/ArrowDown.png")));
        this.cmdSelFontColor.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/ArrowDown.png")));
        this.cmdSelFontColor.setMaximumSize(new Dimension(12, 30));
        this.cmdSelFontColor.setMinimumSize(new Dimension(12, 30));
        this.cmdSelFontColor.setPreferredSize(new Dimension(12, 30));
        this.cmdSelFontColor.setVerticalTextPosition(3);
        this.cmdSelFontColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdSelFontColorActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdSelFontColor);
        this.cmdBackColor.setText("F");
        this.cmdBackColor.setToolTipText("Change background color");
        this.cmdBackColor.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdBackColor.setColorHot(new Color(255, 255, 255));
        this.cmdBackColor.setColorNormal(new Color(255, 255, 255));
        this.cmdBackColor.setColorPressed(new Color(255, 255, 255));
        this.cmdBackColor.setFocusable(false);
        this.cmdBackColor.setFont(new Font("Tahoma", 1, 18));
        this.cmdBackColor.setHorizontalTextPosition(0);
        this.cmdBackColor.setMaximumSize(new Dimension(30, 30));
        this.cmdBackColor.setMinimumSize(new Dimension(30, 30));
        this.cmdBackColor.setPreferredSize(new Dimension(30, 30));
        this.cmdBackColor.setVerticalTextPosition(3);
        this.cmdBackColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdBackColorActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdBackColor);
        this.cmdSelBackcolor.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/ArrowDown.png")));
        this.cmdSelBackcolor.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdSelBackcolor.setColorHot(new Color(255, 255, 255));
        this.cmdSelBackcolor.setColorNormal(new Color(255, 255, 255));
        this.cmdSelBackcolor.setColorPressed(new Color(255, 255, 255));
        this.cmdSelBackcolor.setFocusable(false);
        this.cmdSelBackcolor.setHorizontalTextPosition(0);
        this.cmdSelBackcolor.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/ArrowDown.png")));
        this.cmdSelBackcolor.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/ArrowDown.png")));
        this.cmdSelBackcolor.setMaximumSize(new Dimension(12, 30));
        this.cmdSelBackcolor.setMinimumSize(new Dimension(12, 30));
        this.cmdSelBackcolor.setPreferredSize(new Dimension(12, 30));
        this.cmdSelBackcolor.setVerticalTextPosition(3);
        this.cmdSelBackcolor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdSelBackcolorActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdSelBackcolor);
        this.jSeparator5.setPreferredSize(new Dimension(7, 0));
        this.jSeparator5.setSeparatorSize(new Dimension(7, 0));
        this.toolBar.add(this.jSeparator5);
        this.cmdFont.setText("Abc");
        this.cmdFont.setToolTipText("Change font");
        this.cmdFont.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdFont.setColorHot(new Color(255, 255, 255));
        this.cmdFont.setColorNormal(new Color(255, 255, 255));
        this.cmdFont.setColorPressed(new Color(255, 255, 255));
        this.cmdFont.setFocusable(false);
        this.cmdFont.setHorizontalTextPosition(0);
        this.cmdFont.setMaximumSize(new Dimension(30, 30));
        this.cmdFont.setMinimumSize(new Dimension(30, 30));
        this.cmdFont.setPreferredSize(new Dimension(30, 30));
        this.cmdFont.setVerticalTextPosition(3);
        this.cmdFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdFontActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdFont);
        this.jSeparator2.setPreferredSize(new Dimension(7, 0));
        this.jSeparator2.setSeparatorSize(new Dimension(7, 0));
        this.toolBar.add(this.jSeparator2);
        this.cmdFontSizeInc.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/LargeA.png")));
        this.cmdFontSizeInc.setToolTipText("Increase font size");
        this.cmdFontSizeInc.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdFontSizeInc.setColorHot(new Color(255, 255, 255));
        this.cmdFontSizeInc.setColorNormal(new Color(255, 255, 255));
        this.cmdFontSizeInc.setColorPressed(new Color(255, 255, 255));
        this.cmdFontSizeInc.setFocusable(false);
        this.cmdFontSizeInc.setHorizontalTextPosition(0);
        this.cmdFontSizeInc.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/LargeA.png")));
        this.cmdFontSizeInc.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/LargeA.png")));
        this.cmdFontSizeInc.setMaximumSize(new Dimension(30, 30));
        this.cmdFontSizeInc.setMinimumSize(new Dimension(30, 30));
        this.cmdFontSizeInc.setPreferredSize(new Dimension(30, 30));
        this.cmdFontSizeInc.setVerticalTextPosition(3);
        this.cmdFontSizeInc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdFontSizeIncActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdFontSizeInc);
        this.cmdFontSizeDec.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/SmallA.png")));
        this.cmdFontSizeDec.setToolTipText("Decrease font size");
        this.cmdFontSizeDec.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdFontSizeDec.setColorHot(new Color(255, 255, 255));
        this.cmdFontSizeDec.setColorNormal(new Color(255, 255, 255));
        this.cmdFontSizeDec.setColorPressed(new Color(255, 255, 255));
        this.cmdFontSizeDec.setFocusable(false);
        this.cmdFontSizeDec.setHorizontalTextPosition(0);
        this.cmdFontSizeDec.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/SmallA.png")));
        this.cmdFontSizeDec.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/SmallA.png")));
        this.cmdFontSizeDec.setMaximumSize(new Dimension(30, 30));
        this.cmdFontSizeDec.setMinimumSize(new Dimension(30, 30));
        this.cmdFontSizeDec.setPreferredSize(new Dimension(30, 30));
        this.cmdFontSizeDec.setVerticalTextPosition(3);
        this.cmdFontSizeDec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdFontSizeDecActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdFontSizeDec);
        this.jSeparator3.setPreferredSize(new Dimension(7, 0));
        this.jSeparator3.setSeparatorSize(new Dimension(7, 0));
        this.toolBar.add(this.jSeparator3);
        this.cmdStrikeThrough.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Strikethrough.png")));
        this.cmdStrikeThrough.setToolTipText("Toggle strikethrough");
        this.cmdStrikeThrough.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdStrikeThrough.setColorHot(new Color(255, 255, 255));
        this.cmdStrikeThrough.setColorNormal(new Color(255, 255, 255));
        this.cmdStrikeThrough.setColorPressed(new Color(255, 255, 255));
        this.cmdStrikeThrough.setFocusable(false);
        this.cmdStrikeThrough.setHorizontalTextPosition(0);
        this.cmdStrikeThrough.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/Strikethrough.png")));
        this.cmdStrikeThrough.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/Strikethrough.png")));
        this.cmdStrikeThrough.setMaximumSize(new Dimension(30, 30));
        this.cmdStrikeThrough.setMinimumSize(new Dimension(30, 30));
        this.cmdStrikeThrough.setPreferredSize(new Dimension(30, 30));
        this.cmdStrikeThrough.setVerticalTextPosition(3);
        this.cmdStrikeThrough.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdStrikeThroughActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdStrikeThrough);
        this.cmdSuperscript.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/superscript.png")));
        this.cmdSuperscript.setToolTipText("Toggle superscript");
        this.cmdSuperscript.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdSuperscript.setColorHot(new Color(255, 255, 255));
        this.cmdSuperscript.setColorNormal(new Color(255, 255, 255));
        this.cmdSuperscript.setColorPressed(new Color(255, 255, 255));
        this.cmdSuperscript.setFocusable(false);
        this.cmdSuperscript.setHorizontalTextPosition(0);
        this.cmdSuperscript.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/superscript.png")));
        this.cmdSuperscript.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/superscript.png")));
        this.cmdSuperscript.setMaximumSize(new Dimension(30, 30));
        this.cmdSuperscript.setMinimumSize(new Dimension(30, 30));
        this.cmdSuperscript.setPreferredSize(new Dimension(30, 30));
        this.cmdSuperscript.setVerticalTextPosition(3);
        this.cmdSuperscript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdSuperscriptActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdSuperscript);
        this.cmdSubscript.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/subscript.png")));
        this.cmdSubscript.setToolTipText("Toggle subscript");
        this.cmdSubscript.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdSubscript.setColorHot(new Color(255, 255, 255));
        this.cmdSubscript.setColorNormal(new Color(255, 255, 255));
        this.cmdSubscript.setColorPressed(new Color(255, 255, 255));
        this.cmdSubscript.setFocusable(false);
        this.cmdSubscript.setHorizontalTextPosition(0);
        this.cmdSubscript.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/subscript.png")));
        this.cmdSubscript.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/subscript.png")));
        this.cmdSubscript.setMaximumSize(new Dimension(30, 30));
        this.cmdSubscript.setMinimumSize(new Dimension(30, 30));
        this.cmdSubscript.setPreferredSize(new Dimension(30, 30));
        this.cmdSubscript.setVerticalTextPosition(3);
        this.cmdSubscript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdSubscriptActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdSubscript);
        this.jSeparator6.setSeparatorSize(new Dimension(7, 0));
        this.toolBar.add(this.jSeparator6);
        this.cmdBold.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Bold.png")));
        this.cmdBold.setToolTipText("Toggle bold");
        this.cmdBold.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdBold.setColorHot(new Color(255, 255, 255));
        this.cmdBold.setColorNormal(new Color(255, 255, 255));
        this.cmdBold.setColorPressed(new Color(255, 255, 255));
        this.cmdBold.setFocusable(false);
        this.cmdBold.setHorizontalTextPosition(0);
        this.cmdBold.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/Bold.png")));
        this.cmdBold.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/Bold.png")));
        this.cmdBold.setMaximumSize(new Dimension(30, 30));
        this.cmdBold.setMinimumSize(new Dimension(30, 30));
        this.cmdBold.setPreferredSize(new Dimension(30, 30));
        this.cmdBold.setVerticalTextPosition(3);
        this.cmdBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdBoldActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdBold);
        this.cmdItalics.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Italics.png")));
        this.cmdItalics.setToolTipText("Toggle italics");
        this.cmdItalics.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdItalics.setColorHot(new Color(255, 255, 255));
        this.cmdItalics.setColorNormal(new Color(255, 255, 255));
        this.cmdItalics.setColorPressed(new Color(255, 255, 255));
        this.cmdItalics.setFocusable(false);
        this.cmdItalics.setHorizontalTextPosition(0);
        this.cmdItalics.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/Italics.png")));
        this.cmdItalics.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/Italics.png")));
        this.cmdItalics.setMaximumSize(new Dimension(30, 30));
        this.cmdItalics.setMinimumSize(new Dimension(30, 30));
        this.cmdItalics.setPreferredSize(new Dimension(30, 30));
        this.cmdItalics.setVerticalTextPosition(3);
        this.cmdItalics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdItalicsActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdItalics);
        this.cmdUnderline.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Underline.png")));
        this.cmdUnderline.setToolTipText("Toggle underlined");
        this.cmdUnderline.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdUnderline.setColorHot(new Color(255, 255, 255));
        this.cmdUnderline.setColorNormal(new Color(255, 255, 255));
        this.cmdUnderline.setColorPressed(new Color(255, 255, 255));
        this.cmdUnderline.setFocusable(false);
        this.cmdUnderline.setHorizontalTextPosition(0);
        this.cmdUnderline.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/Underline.png")));
        this.cmdUnderline.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/Underline.png")));
        this.cmdUnderline.setMaximumSize(new Dimension(30, 30));
        this.cmdUnderline.setMinimumSize(new Dimension(30, 30));
        this.cmdUnderline.setPreferredSize(new Dimension(30, 30));
        this.cmdUnderline.setVerticalTextPosition(3);
        this.cmdUnderline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdUnderlineActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdUnderline);
        this.jSeparator4.setPreferredSize(new Dimension(7, 0));
        this.jSeparator4.setSeparatorSize(new Dimension(7, 0));
        this.toolBar.add(this.jSeparator4);
        this.cmdLeft.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Left.png")));
        this.cmdLeft.setToolTipText("Change alignment to left");
        this.cmdLeft.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdLeft.setColorHot(new Color(255, 255, 255));
        this.cmdLeft.setColorNormal(new Color(255, 255, 255));
        this.cmdLeft.setColorPressed(new Color(255, 255, 255));
        this.cmdLeft.setFocusable(false);
        this.cmdLeft.setHorizontalTextPosition(0);
        this.cmdLeft.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/Left.png")));
        this.cmdLeft.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/Left.png")));
        this.cmdLeft.setMaximumSize(new Dimension(30, 30));
        this.cmdLeft.setMinimumSize(new Dimension(30, 30));
        this.cmdLeft.setPreferredSize(new Dimension(30, 30));
        this.cmdLeft.setVerticalTextPosition(3);
        this.cmdLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdLeftActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdLeft);
        this.cmdCenter.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Center.png")));
        this.cmdCenter.setToolTipText("Change alignment to center");
        this.cmdCenter.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdCenter.setColorHot(new Color(255, 255, 255));
        this.cmdCenter.setColorNormal(new Color(255, 255, 255));
        this.cmdCenter.setColorPressed(new Color(255, 255, 255));
        this.cmdCenter.setFocusable(false);
        this.cmdCenter.setHorizontalTextPosition(0);
        this.cmdCenter.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/Center.png")));
        this.cmdCenter.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/Center.png")));
        this.cmdCenter.setMaximumSize(new Dimension(30, 30));
        this.cmdCenter.setMinimumSize(new Dimension(30, 30));
        this.cmdCenter.setPreferredSize(new Dimension(30, 30));
        this.cmdCenter.setVerticalTextPosition(3);
        this.cmdCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdCenterActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdCenter);
        this.cmdRight.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Right.png")));
        this.cmdRight.setToolTipText("Change alignment to right");
        this.cmdRight.setButtonStyle(ButtonRenderer.ButtonStyle.OfficeXP);
        this.cmdRight.setColorHot(new Color(255, 255, 255));
        this.cmdRight.setColorNormal(new Color(255, 255, 255));
        this.cmdRight.setColorPressed(new Color(255, 255, 255));
        this.cmdRight.setFocusable(false);
        this.cmdRight.setHorizontalTextPosition(0);
        this.cmdRight.setIconHot(new ImageIcon(this.getClass().getResource("/Icons16/Right.png")));
        this.cmdRight.setIconPressed(new ImageIcon(this.getClass().getResource("/Icons16/Right.png")));
        this.cmdRight.setMaximumSize(new Dimension(30, 30));
        this.cmdRight.setMinimumSize(new Dimension(30, 30));
        this.cmdRight.setPreferredSize(new Dimension(30, 30));
        this.cmdRight.setVerticalTextPosition(3);
        this.cmdRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.cmdRightActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdRight);
        this.jScrollPane2.setDoubleBuffered(true);
        this.noteTextBox.setFont(new Font("Monospaced", 0, 18));
        this.noteTextBox.setDoubleBuffered(true);
        this.jScrollPane2.setViewportView(this.noteTextBox);
        this.jMenu1.setText("File");
        this.mnuSave.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.mnuSave.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Save.png")));
        this.mnuSave.setText("Save");
        this.mnuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.mnuSaveActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuSave);
        this.mnuExit.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.mnuExit.setText("Close");
        this.mnuExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.mnuExitActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuExit);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.mnuBold.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        this.mnuBold.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Bold.png")));
        this.mnuBold.setText("Bold Selected Text");
        this.mnuBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.mnuBoldActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuBold);
        this.mnuItalics.setAccelerator(KeyStroke.getKeyStroke(73, 128));
        this.mnuItalics.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Italics.png")));
        this.mnuItalics.setText("Italicize Selected Text");
        this.mnuItalics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.mnuItalicsActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuItalics);
        this.mnuUnderline.setAccelerator(KeyStroke.getKeyStroke(85, 128));
        this.mnuUnderline.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Underline.png")));
        this.mnuUnderline.setText("Underline Selected Text");
        this.jMenu2.add(this.mnuUnderline);
        this.mnuStrikethrough.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/Strikethrough.png")));
        this.mnuStrikethrough.setText("Strikethrough Selected Text");
        this.mnuStrikethrough.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.mnuStrikethroughActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuStrikethrough);
        this.mnuSuperscript.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.mnuSuperscript.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/superscript.png")));
        this.mnuSuperscript.setText("Superscript Selected Text");
        this.mnuSuperscript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.mnuSuperscriptActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuSuperscript);
        this.mnuSubscript.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        this.mnuSubscript.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/subscript.png")));
        this.mnuSubscript.setText("Subscript Selected Text");
        this.mnuSubscript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.mnuSubscriptActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuSubscript);
        this.mnuIncSize.setAccelerator(KeyStroke.getKeyStroke(107, 128));
        this.mnuIncSize.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/LargeA.png")));
        this.mnuIncSize.setText("Increase Selected Text Size");
        this.mnuIncSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.mnuIncSizeActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuIncSize);
        this.mnuDecSize.setAccelerator(KeyStroke.getKeyStroke(109, 128));
        this.mnuDecSize.setIcon(new ImageIcon(this.getClass().getResource("/Icons16/SmallA.png")));
        this.mnuDecSize.setText("Decrease Selected Text Size");
        this.mnuDecSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotePadWindow.this.mnuDecSizeActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuDecSize);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, 719, Short.MAX_VALUE).addComponent(this.jScrollPane2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.toolBar, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jScrollPane2, -1, 444, Short.MAX_VALUE)));
        this.pack();
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.mIsChanged = !this.SaveNote();
    }

    private void cmdFontColorActionPerformed(ActionEvent evt) {
        this.setFontColor();
    }

    private void cmdSelFontColorActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Select New Text Color", this.cmdFontColor.getColorCaptionNormal());
        if (newColor != null) {
            this.cmdFontColor.setColorCaptionNormal(newColor);
            this.cmdFontColor.setColorCaptionPressed(newColor);
            this.cmdFontColor.setColorCaptionHot(newColor);
            this.cmdBackColor.setColorCaptionNormal(newColor);
            this.cmdBackColor.setColorCaptionPressed(newColor);
            this.cmdBackColor.setColorCaptionHot(newColor);
            this.setFontColor();
        }
    }

    private void cmdBackColorActionPerformed(ActionEvent evt) {
        this.setFontBackColor();
    }

    private void cmdSelBackcolorActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Select New Text Color", this.cmdFontColor.getColorCaptionNormal());
        if (newColor != null) {
            this.cmdBackColor.setColorNormal(newColor);
            this.cmdBackColor.setColorPressed(newColor);
            this.cmdBackColor.setColorHot(newColor);
            this.setFontBackColor();
        }
    }

    private void cmdFontActionPerformed(ActionEvent evt) {
        JFontChooser fontChooser = new JFontChooser();
        int result = fontChooser.showDialog(this);
        if (result == 0) {
            Font font = fontChooser.getSelectedFont();
            this.noteTextBox.setFont(font);
        }
    }

    private void cmdFontSizeIncActionPerformed(ActionEvent evt) {
        this.FontSizeUp();
    }

    private void cmdFontSizeDecActionPerformed(ActionEvent evt) {
        this.FontSizeDown();
    }

    private void cmdStrikeThroughActionPerformed(ActionEvent evt) {
        this.Strikethrough();
    }

    private void cmdSuperscriptActionPerformed(ActionEvent evt) {
        this.superscript();
    }

    private void cmdSubscriptActionPerformed(ActionEvent evt) {
        this.subscript();
    }

    private void cmdBoldActionPerformed(ActionEvent evt) {
        this.Bold();
    }

    private void cmdItalicsActionPerformed(ActionEvent evt) {
        this.Italics();
    }

    private void cmdUnderlineActionPerformed(ActionEvent evt) {
        this.Underline();
    }

    private void cmdLeftActionPerformed(ActionEvent evt) {
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attribs, 0);
        this.noteTextBox.setParagraphAttributes(attribs, true);
    }

    private void cmdCenterActionPerformed(ActionEvent evt) {
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attribs, 1);
        this.noteTextBox.setParagraphAttributes(attribs, true);
    }

    private void cmdRightActionPerformed(ActionEvent evt) {
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attribs, 2);
        this.noteTextBox.setParagraphAttributes(attribs, true);
    }

    private void mnuItalicsActionPerformed(ActionEvent evt) {
        this.Italics();
    }

    private void mnuIncSizeActionPerformed(ActionEvent evt) {
        this.FontSizeUp();
    }

    private void mnuSuperscriptActionPerformed(ActionEvent evt) {
        this.superscript();
    }

    private void mnuSubscriptActionPerformed(ActionEvent evt) {
        this.subscript();
    }

    private void mnuBoldActionPerformed(ActionEvent evt) {
        this.Bold();
    }

    private void mnuStrikethroughActionPerformed(ActionEvent evt) {
        this.Strikethrough();
    }

    private void mnuDecSizeActionPerformed(ActionEvent evt) {
        this.FontSizeDown();
    }

    private void mnuSaveActionPerformed(ActionEvent evt) {
        this.mIsChanged = !this.SaveNote();
    }

    private void mnuExitActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.beforeClose();
    }

    public boolean close() {
        if (this.OkToClose()) {
            this.dispose();
            return true;
        }
        return false;
    }

    public abstract boolean SaveNote();

    public abstract boolean CloseWindow();

    private void setFontColor() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setForeground(asNew, this.cmdFontColor.getColorCaptionNormal());
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    private void setFontBackColor() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setBackground(asNew, this.cmdBackColor.getColorNormal());
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    private void FontSizeUp() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setFontSize(asNew, StyleConstants.getFontSize(as) + 1);
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    private void FontSizeDown() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setFontSize(asNew, StyleConstants.getFontSize(as) - 1);
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    private void Strikethrough() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setStrikeThrough(asNew, !StyleConstants.isStrikeThrough(as));
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    private void Bold() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setBold(asNew, !StyleConstants.isBold(as));
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    private void Italics() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setItalic(asNew, !StyleConstants.isItalic(as));
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    private void Underline() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setUnderline(asNew, !StyleConstants.isUnderline(as));
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    private void subscript() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setSubscript(asNew, !StyleConstants.isSubscript(as));
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    private void superscript() {
        int selectionEnd = this.noteTextBox.getSelectionEnd();
        int selectionStart = this.noteTextBox.getSelectionStart();
        if (selectionStart == selectionEnd) {
            return;
        }
        Element element = this.doc.getCharacterElement(selectionStart);
        AttributeSet as = element.getAttributes();
        SimpleAttributeSet asNew = new SimpleAttributeSet(as.copyAttributes());
        StyleConstants.setSuperscript(asNew, !StyleConstants.isSuperscript(as));
        this.doc.setCharacterAttributes(selectionStart, this.noteTextBox.getSelectedText().length(), asNew, true);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Metal".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(NotePadWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(NotePadWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(NotePadWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(NotePadWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

