/*
 * Decompiled with CFR 0.152.
 */
package Plugins;

import Plugins.Plugin;
import Plugins.PluginButton;
import Plugins.PluginCollection;
import Plugins.PluginMenu;
import Plugins.PluginMenuComponent;
import Plugins.PluginMenuItem;
import Plugins.PluginPackage;
import Plugins.PluginPackageMenu;
import Plugins.PluginsObject;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;

public class PluginLoader<T> {
    private String PLUGIN_DIR = "Plugins";
    private final Class<T> interfaceClass;
    private String filePrefix = null;

    public String getDir() {
        return this.PLUGIN_DIR;
    }

    public final void setFilePrefix(String prefix) {
        this.filePrefix = prefix != null && prefix.length() > 0 ? prefix.toLowerCase() : null;
    }

    public String getFilePrefix() {
        return this.filePrefix != null && this.filePrefix.length() > 0 ? this.filePrefix : null;
    }

    public final void setDir(String dir) {
        this.PLUGIN_DIR = dir;
    }

    public PluginLoader(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public PluginLoader(Class<T> interfaceClass, String dir) {
        this.interfaceClass = interfaceClass;
        this.setDir(dir);
    }

    public PluginLoader(Class<T> interfaceClass, String dir, String filePrefix) {
        this.interfaceClass = interfaceClass;
        this.setFilePrefix(filePrefix);
        this.setDir(dir);
    }

    public ArrayList<T> loadAllPlugins() {
        ArrayList plugins = new ArrayList();
        File jarDir = PluginLoader.getJarDirectory();
        if (jarDir == null) {
            return plugins;
        }
        File pluginsDir = new File(jarDir, this.PLUGIN_DIR);
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            return plugins;
        }
        File[] jars = pluginsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (jars == null) {
            return plugins;
        }
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        String prefix = this.getFilePrefix();
        for (File jar : jars) {
            try {
                if (prefix != null && !jar.getName().toLowerCase().startsWith(prefix)) continue;
                jarUrls.add(jar.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try (URLClassLoader classLoader = new URLClassLoader(jarUrls.toArray(new URL[0]), PluginLoader.class.getClassLoader());){
            for (File jar : jars) {
                try (JarFile jarFile = new JarFile(jar);){
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name2 = entry.getName();
                        if (!name2.endsWith(".class")) continue;
                        String className = name2.replace('/', '.').substring(0, name2.length() - 6);
                        try {
                            Class<?> clazz = classLoader.loadClass(className);
                            if (clazz.isInterface() || !this.interfaceClass.isAssignableFrom(clazz)) continue;
                            try {
                                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                plugins.add(instance);
                            }
                            catch (Throwable t) {
                                JOptionPane.showMessageDialog(null, "An error occured while loading plugin " + name2 + (t.getLocalizedMessage() != null ? ".  Error:\n" + t.getLocalizedMessage() : "."), "Plugin Load Error", 0, null);
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return plugins;
    }

    public ArrayList<PluginCollection> loadAllCollections() {
        ArrayList<PluginCollection> packages = new ArrayList<PluginCollection>();
        this.loadAllCollectionsTo(packages);
        return packages;
    }

    public void loadAllCollectionsTo(ArrayList<PluginCollection> dest) {
        File jarDir = PluginLoader.getJarDirectory();
        if (jarDir == null) {
            return;
        }
        File pluginsDir = new File(jarDir, this.PLUGIN_DIR);
        this.loadAllCollectionsFrom(pluginsDir, dest);
    }

    public void loadAllCollectionsFrom(String path, ArrayList<PluginCollection> dest) {
        File pluginsDir = new File(path);
        this.loadAllCollectionsFrom(pluginsDir, dest);
    }

    public void loadAllCollectionsFrom(File pluginsDir, ArrayList<PluginCollection> dest) {
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            return;
        }
        File[] jars = pluginsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (jars == null) {
            return;
        }
        String prefix = this.getFilePrefix();
        for (File jar : jars) {
            if (prefix != null && !jar.getName().toLowerCase().startsWith(prefix)) continue;
            this.loadPluginsCollectionFromFile(jar, dest);
        }
    }

    public ArrayList<T> loadPluginsFromFile(File jarFile) {
        ArrayList plugins = new ArrayList();
        this.loadPluginsFromFile(jarFile, plugins);
        return plugins;
    }

    public ArrayList<PluginCollection> loadPluginsCollectionFromFile(File jarFile) {
        ArrayList<PluginCollection> plugins = new ArrayList<PluginCollection>();
        this.loadPluginsCollectionFromFile(jarFile, plugins);
        return plugins;
    }

    private void loadPluginsFromFile(File jarFile, ArrayList<T> list) {
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, PluginLoader.class.getClassLoader());){
            this.loadPluginsFromFileInternal(jarFile, classLoader, list);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadPluginsCollectionFromFile(File jarFile, ArrayList<PluginCollection> dest) {
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, PluginLoader.class.getClassLoader());){
            this.loadPluginsCollectionFromFileInternal(jarFile, classLoader, dest);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadPluginsFromFileInternal(File jarFile, URLClassLoader classLoader, ArrayList<T> plugins) {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String className = name.replace('/', '.').substring(0, name.length() - 6);
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    if (clazz.isInterface() || !this.interfaceClass.isAssignableFrom(clazz)) continue;
                    try {
                        Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        plugins.add(instance);
                    }
                    catch (Throwable t) {
                        JOptionPane.showMessageDialog(null, "An error occured while loading plugin " + name + (t.getLocalizedMessage() != null ? ".  Error:\n" + t.getLocalizedMessage() : "."), "Plugin Load Error", 0, null);
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadPluginsCollectionFromFileInternal(File jarFile, URLClassLoader classLoader, ArrayList<PluginCollection> destArray) {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String className = name.replace('/', '.').substring(0, name.length() - 6);
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    if (clazz.isInterface() || !PluginCollection.class.isAssignableFrom(clazz)) continue;
                    try {
                        PluginCollection instance = (PluginCollection)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Plugin[] plugins = instance.getPlugins();
                        if (plugins == null || plugins.length <= 0 || plugins[0] == null || !this.interfaceClass.isAssignableFrom(plugins[0].getClass())) continue;
                        destArray.add(instance);
                    }
                    catch (Throwable t) {
                        JOptionPane.showMessageDialog(null, "An error occured while loading plugin " + name + (t.getLocalizedMessage() != null ? ".  Error:\n" + t.getLocalizedMessage() : "."), "Plugin Load Error", 0, null);
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ArrayList<PluginPackage> loadAllPackages() {
        ArrayList<PluginPackage> packages = new ArrayList<PluginPackage>();
        this.loadPackageFromFolder(packages);
        return packages;
    }

    public void loadPackageFromFolder(ArrayList<PluginPackage> dest) {
        File jarDir = PluginLoader.getJarDirectory();
        if (jarDir == null) {
            return;
        }
        File pluginsDir = new File(jarDir, this.PLUGIN_DIR);
        this.loadPackageFromFolder(pluginsDir, dest);
    }

    public void loadPackageFromFolder(String path, ArrayList<PluginPackage> dest) {
        File pluginsDir = new File(path);
        this.loadPackageFromFolder(pluginsDir, dest);
    }

    public void loadPackageFromFolder(File pluginsDir, ArrayList<PluginPackage> dest) {
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            return;
        }
        File[] jars = pluginsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (jars == null) {
            return;
        }
        String prefix = this.getFilePrefix();
        for (File jar : jars) {
            PluginPackage p;
            if (prefix != null && !jar.getName().toLowerCase().startsWith(prefix) || (p = this.loadPackageFromFile(jar)) == null) continue;
            dest.add(p);
        }
    }

    public PluginPackage loadPackageFromFile(File jarFile) {
        PluginPackage pluginPackage;
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, PluginLoader.class.getClassLoader());
        try {
            pluginPackage = this.loadAllItemsFromFile(jarFile, classLoader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    classLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                System.err.println(ex.getLocalizedMessage());
                return null;
            }
        }
        classLoader.close();
        return pluginPackage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginPackage loadAllItemsFromFile(File jarFile, URLClassLoader classLoader) {
        Iterator iterator;
        ArrayList<Plugin> foundPlugins = new ArrayList<Plugin>();
        ArrayList<Plugin> foundCollections = new ArrayList<Plugin>();
        try (JarFile jar2 = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar2.entries();
            while (entries.hasMoreElements()) {
                PluginsObject instance;
                Class<?> clazz;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String string = name.replace('/', '.').substring(0, name.length() - 6);
                try {
                    clazz = classLoader.loadClass(string);
                    if (clazz.isInterface() || !PluginsObject.class.isAssignableFrom(clazz)) continue;
                    if (Plugin.class.isAssignableFrom(clazz)) {
                        try {
                            instance = (Plugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (!this.isCompatible((Plugin)instance)) continue;
                            foundPlugins.add((Plugin)instance);
                        }
                        catch (Throwable t) {
                            JOptionPane.showMessageDialog(null, "An error occured while loading plugin " + name + (t.getLocalizedMessage() != null ? ".  Error:\n" + t.getLocalizedMessage() : "."), "Plugin Load Error", 0, null);
                        }
                        continue;
                    }
                    if (PluginPackage.class.isAssignableFrom(clazz)) {
                        try {
                            instance = (PluginPackage)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (!this.isCompatible((PluginPackage)instance)) continue;
                            PluginsObject pluginsObject = instance;
                            return pluginsObject;
                        }
                        catch (Throwable t) {
                            JOptionPane.showMessageDialog(null, "An error occured while loading PluginPackage " + name + (t.getLocalizedMessage() != null ? ".  Error:\n" + t.getLocalizedMessage() : "."), "Plugin Load Error", 0, null);
                        }
                    }
                }
                catch (Throwable throwable) {}
                continue;
                if (!PluginCollection.class.isAssignableFrom(clazz)) continue;
                try {
                    instance = (PluginCollection)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!this.isCompatible((PluginCollection)instance)) continue;
                    foundCollections.add((Plugin)instance);
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(null, "An error occured while loading a PluginCollection " + name + (t.getLocalizedMessage() != null ? ".  Error:\n" + t.getLocalizedMessage() : "."), "Plugin Load Error", 0, null);
                }
            }
        }
        catch (IOException jar2) {
            // empty catch block
        }
        String name = jarFile.getName();
        String prefix = this.getFilePrefix();
        if (prefix.length() > 0 && name.toLowerCase().startsWith(prefix)) {
            name = name.substring(prefix.length());
        }
        name = name.substring(0, name.length() - 4);
        PluginPackage p = new PluginPackage(name);
        p.setIcon(PluginPackage.defaultPackageIcon);
        p.setDescription("Loaded from file " + jarFile.getName());
        if (!foundCollections.isEmpty()) {
            iterator = foundCollections.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    p.collections.sort((Comparator<PluginCollection>)new Comparator<PluginsObject>(){

                        @Override
                        public int compare(PluginsObject o1, PluginsObject o2) {
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                    });
                    return p;
                }
                PluginCollection pluginCollection = (PluginCollection)iterator.next();
                p.addCollection(pluginCollection);
            }
        }
        iterator = foundPlugins.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                p.plugins.sort(new Comparator<PluginsObject>(){

                    @Override
                    public int compare(PluginsObject o1, PluginsObject o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                return p;
            }
            Plugin plugin = (Plugin)iterator.next();
            p.addPlugin(plugin);
        }
    }

    private boolean isCompatible(Plugin p) {
        return this.interfaceClass.isAssignableFrom(p.getClass()) && Plugin.class.isAssignableFrom(p.getClass());
    }

    private boolean isCompatible(PluginCollection c) {
        Plugin[] items = c.getPlugins();
        if (items != null && items.length > 0 && items[0] != null) {
            for (Plugin p : items) {
                if (!this.isCompatible(p)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCompatible(PluginPackage p) {
        Plugin[] pItems;
        PluginCollection[] items = p.getCollections();
        if (items != null && items.length > 0 && items[0] != null) {
            for (PluginCollection c : items) {
                if (!this.isCompatible(c)) continue;
                return true;
            }
        }
        if ((pItems = p.getPlugins()) != null && pItems.length > 0 && pItems[0] != null) {
            for (Plugin pl : pItems) {
                if (!this.isCompatible(pl)) continue;
                return true;
            }
        }
        return false;
    }

    private static File getJarDirectory() {
        try {
            File jarFile;
            File dir;
            CodeSource codeSource = PluginLoader.class.getProtectionDomain().getCodeSource();
            if (codeSource != null && (dir = (jarFile = new File(codeSource.getLocation().toURI().getPath())).getParentFile()) != null && dir.exists()) {
                return dir;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static JButton addPluginTo(Plugin p, JToolBar toolBar) {
        JButton pluginButton = PluginLoader.buttonFor(p);
        toolBar.add(pluginButton);
        toolBar.revalidate();
        toolBar.repaint();
        return pluginButton;
    }

    public static JButton buttonFor(Plugin p) {
        return PluginLoader.buttonFor(p, null);
    }

    public static JButton buttonFor(Plugin p, MouseListener l) {
        PluginButton pluginButton = new PluginButton(p);
        pluginButton.setIcon(p.getIcon() != null ? p.getIcon() : Plugin.defaultIcon);
        if (l != null) {
            pluginButton.addMouseListener(l);
        }
        return pluginButton;
    }

    public static JMenuItem menuItemFor(Plugin p) {
        return PluginLoader.menuItemFor(p, null);
    }

    public static JMenuItem menuItemFor(Plugin p, MouseListener l) {
        PluginMenuItem m = new PluginMenuItem(p);
        if (l != null) {
            m.addMouseListener(l);
        }
        return m;
    }

    public static JMenu menuItemFor(PluginCollection p) {
        return PluginLoader.menuItemFor(p, null);
    }

    public static JMenu menuItemFor(PluginCollection p, MouseListener l) {
        PluginMenu m = new PluginMenu(p);
        if (l != null) {
            m.addMouseListener(l);
        }
        return m;
    }

    public List<JMenuItem> addPluginPackageTo(PluginCollection p, JMenuItem parent) {
        ArrayList<JMenuItem> madeItems = new ArrayList<JMenuItem>();
        PluginPackageMenu pluginMenu = new PluginPackageMenu(p);
        Plugin[] plugins = p.getPlugins();
        if (plugins == null || plugins.length == 0) {
            return null;
        }
        for (Plugin plugin : plugins) {
            if (!this.interfaceClass.isAssignableFrom(plugin.getClass())) continue;
            PluginMenuItem item = new PluginMenuItem(plugin);
            pluginMenu.add(item);
            madeItems.add(item);
        }
        if (!madeItems.isEmpty()) {
            parent.add(pluginMenu);
            madeItems.add(pluginMenu);
        }
        return madeItems;
    }

    public List<JMenuItem> addPluginPackageTo(PluginCollection p, JMenuBar parent) {
        return this.addPluginPackageTo(p, parent, parent.getMenuCount());
    }

    public List<JMenuItem> addPluginPackageTo(PluginCollection p, JMenuBar parent, int index) {
        ArrayList<JMenuItem> madeItems = new ArrayList<JMenuItem>();
        PluginPackageMenu pluginMenu = new PluginPackageMenu(p);
        pluginMenu.setIcon(null);
        Plugin[] plugins = p.getPlugins();
        if (plugins == null || plugins.length == 0) {
            return null;
        }
        for (Plugin plugin : plugins) {
            if (!this.interfaceClass.isAssignableFrom(plugin.getClass())) continue;
            PluginMenuItem item = new PluginMenuItem(plugin);
            pluginMenu.add(item);
            madeItems.add(item);
        }
        if (!madeItems.isEmpty()) {
            parent.add((Component)pluginMenu, index >= 0 ? index : parent.getMenuCount() + index);
            madeItems.add(pluginMenu);
        }
        return madeItems;
    }

    public List<JButton> addPluginPackageTo(PluginCollection p, JToolBar parent) {
        ArrayList<JButton> madeItems = new ArrayList<JButton>();
        this.addPluginPackageTo(p, parent, madeItems);
        return madeItems;
    }

    private void addPluginPackageTo(PluginCollection p, JToolBar parent, ArrayList<JButton> madeItems) {
        Plugin[] plugins = p.getPlugins();
        if (plugins == null || plugins.length == 0) {
            return;
        }
        for (Plugin plugin : plugins) {
            if (!this.interfaceClass.isAssignableFrom(plugin.getClass())) continue;
            PluginButton item = new PluginButton(plugin);
            madeItems.add(item);
            parent.add(item);
        }
        if (p instanceof PluginPackage) {
            for (PluginCollection c : ((PluginPackage)p).collections) {
                if (c == null) continue;
                this.addPluginPackageTo(c, parent, madeItems);
            }
        }
    }

    public static void removePluginsFrom(JMenuBar parent) {
        Component[] components;
        for (Component menu : components = parent.getComponents()) {
            if (menu instanceof PluginMenuComponent && menu instanceof JMenu) {
                ((JMenu)menu).removeAll();
                parent.remove(menu);
                continue;
            }
            if (!(menu instanceof JMenu)) continue;
            PluginLoader.removePluginsFrom((JMenu)menu);
        }
        parent.revalidate();
        parent.repaint();
    }

    public static void removePluginsFrom(JMenu parent) {
        Component[] components;
        for (Component c : components = parent.getMenuComponents()) {
            if (c instanceof PluginMenuComponent && c instanceof JMenu) {
                ((JMenu)c).removeAll();
                parent.remove(c);
                continue;
            }
            if (c instanceof PluginPackageMenu) {
                ((PluginPackageMenu)c).removeAll();
                parent.remove(c);
                continue;
            }
            if (!(c instanceof PluginMenuItem)) continue;
            parent.remove(c);
        }
    }

    public static void removePluginsFrom(JToolBar parent) {
        Component[] components;
        for (Component c : components = parent.getComponents()) {
            if (!(c instanceof PluginButton)) continue;
            parent.remove(c);
        }
        parent.revalidate();
        parent.repaint();
    }

    public static void sortMenuBarMenusOnly(JMenuBar menuBar) {
        Component menu;
        int index;
        ArrayList<JMenu> items = new ArrayList<JMenu>();
        Component[] components = menuBar.getComponents();
        int firstIndex = components.length;
        for (index = 0; index < components.length; ++index) {
            menu = components[index];
            if (!(menu instanceof PluginMenu) && !(menu instanceof PluginPackageMenu)) continue;
            if (index < firstIndex) {
                firstIndex = index;
            }
            items.add((JMenu)menu);
        }
        if (items.size() > 1) {
            items.sort(new Comparator<JMenu>(){

                @Override
                public int compare(JMenu o1, JMenu o2) {
                    return o1.getText().compareToIgnoreCase(o2.getText());
                }
            });
            for (index = items.size() - 1; index >= 0; --index) {
                menu = (JMenu)items.get(index);
                menuBar.remove(menu);
                menuBar.add(menu, firstIndex);
            }
            menuBar.revalidate();
            menuBar.repaint();
        }
    }

    public static void sortMenus(JMenuBar menuBar) {
        Component menu;
        int index;
        ArrayList<JMenu> items = new ArrayList<JMenu>();
        Component[] components = menuBar.getComponents();
        int firstIndex = components.length;
        for (index = 0; index < components.length; ++index) {
            menu = components[index];
            if (!(menu instanceof PluginMenu) && !(menu instanceof PluginPackageMenu)) continue;
            if (index < firstIndex) {
                firstIndex = index;
            }
            PluginLoader.sortMenus((JMenu)menu);
            items.add((JMenu)menu);
        }
        if (items.size() > 1) {
            items.sort(new Comparator<JMenu>(){

                @Override
                public int compare(JMenu o1, JMenu o2) {
                    return o1.getText().compareToIgnoreCase(o2.getText());
                }
            });
            for (index = items.size() - 1; index >= 0; --index) {
                menu = (JMenu)items.get(index);
                menuBar.remove(menu);
                menuBar.add(menu, firstIndex);
            }
            menuBar.revalidate();
            menuBar.repaint();
        }
    }

    public static void sortMenus(JMenu menu) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null) continue;
            items.add(item);
        }
        Comparator<JMenuItem> c = new Comparator<JMenuItem>(){

            @Override
            public int compare(JMenuItem o1, JMenuItem o2) {
                if (o1 instanceof PluginMenuComponent && !(o2 instanceof PluginMenuComponent)) {
                    return 1;
                }
                if (o2 instanceof PluginMenuComponent && !(o1 instanceof PluginMenuComponent)) {
                    return -1;
                }
                if (o1 instanceof JMenu && !(o2 instanceof JMenu)) {
                    return -1;
                }
                if (o2 instanceof JMenu && !(o1 instanceof JMenu)) {
                    return 1;
                }
                return o1.getText().compareToIgnoreCase(o2.getText());
            }
        };
        items.sort(c);
        menu.removeAll();
        for (JMenuItem item : items) {
            if (item instanceof JMenu) {
                PluginLoader.sortMenus((JMenu)item);
            }
            menu.add(item);
        }
    }

    public ArrayList<T> loadPluginsFrom() {
        return this.loadPluginsFrom(null);
    }

    public ArrayList<T> loadPluginsFrom(Component parent) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Java Executable (*.jar)";
            }
        });
        fc.setMultiSelectionEnabled(true);
        fc.showOpenDialog(parent);
        File[] files = fc.getSelectedFiles();
        if (files != null) {
            ArrayList found = new ArrayList();
            for (File file : files) {
                this.loadPluginsFromFile(file, found);
            }
            return found;
        }
        return null;
    }

    public ArrayList<PluginCollection> loadPluginsCollectionFrom(Component parent) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Java Executable (*.jar)";
            }
        });
        fc.setMultiSelectionEnabled(true);
        fc.showOpenDialog(parent);
        File[] files = fc.getSelectedFiles();
        if (files != null) {
            ArrayList<PluginCollection> found = new ArrayList<PluginCollection>();
            for (File file : files) {
                this.loadPluginsCollectionFromFile(file, found);
            }
            return found;
        }
        return null;
    }

    public ArrayList<PluginPackage> loadPluginPackagesFrom(Component parent) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Java Executable (*.jar)";
            }
        });
        chooser.setMultiSelectionEnabled(true);
        if (parent instanceof Window) {
            JDialog dialog = new JDialog((Window)parent, "Select Plugin Files", Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.add(chooser);
            dialog.pack();
            chooser.addActionListener(e -> {
                if (e.getActionCommand().equals("ApproveSelection") || e.getActionCommand().equals("CancelSelection")) {
                    dialog.dispose();
                }
            });
            dialog.setLocationRelativeTo((Window)parent);
            dialog.setVisible(true);
        } else {
            chooser.showOpenDialog(parent);
        }
        File[] files = chooser.getSelectedFiles();
        if (files != null) {
            ArrayList<PluginPackage> found = new ArrayList<PluginPackage>();
            for (File file : files) {
                found.add(this.loadPackageFromFile(file));
            }
            return found;
        }
        return null;
    }

    public ArrayList<PluginCollection> loadPluginsCollections() {
        return this.loadPluginsCollections(null);
    }

    public ArrayList<PluginCollection> loadPluginsCollections(Component parent) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Java Executable (*.jar)";
            }
        });
        fc.setMultiSelectionEnabled(true);
        fc.showOpenDialog(parent);
        File[] files = fc.getSelectedFiles();
        if (files != null) {
            ArrayList<PluginCollection> found = new ArrayList<PluginCollection>();
            for (File file : files) {
                this.loadPluginsCollectionFromFile(file, found);
            }
            return found;
        }
        return null;
    }
}

