/*
 * Decompiled with CFR 0.152.
 */
package RegExpressions;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class StyledBioFilter
extends DefaultStyledDocument {
    public static final int DNA_ATGC = 0;
    public static final int DNA_ATGCN = 1;
    public static final int RNA_AUGC = 2;
    public static final int RNA_AUGCN = 3;
    public static final int AMINO_ACIDS = 4;
    public static final int NUMERIC = 5;
    public static final int FLOAT = 6;
    public static final int ALPHA_NUMERIC = 7;
    public static final int GENBANK_NAME_FILTER = 8;
    public static final int CUSTOM = 99;
    private static final String FILTER_LOWERCASE = "a-z";
    private static final String FILTER_UPPERCASE = "A-Z";
    private static final String FILTER_ALPHA = "a-zA-Z";
    private static final String FILTER_NUMERIC = "0-9";
    private static final String FILTER_FLOAT = "5\\.";
    private static final String FILTER_ALPHANUMERIC = "a-zA-Z0-9";
    private static final String FILTER_ATGC = "ATGCatgc";
    private static final String FILTER_ATGCN = "ATGCatgcNn";
    private static final String FILTER_AUGC = "AUGCaugc";
    private static final String FILTER_AUGCN = "AUGCaugcNn";
    private static final String FILTER_AMINO_ACIDS = "*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy";
    private static final String GENBANK_FILTER = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890_\\+'\\-";
    private String regexFilter = "";
    protected int charSet = 0;
    protected boolean negativeAccepted = false;
    protected boolean upperCaseText = false;

    public void forceUppercaseOutput(boolean uppercase) {
        this.upperCaseText = uppercase;
    }

    public StyledBioFilter() {
        this(0);
    }

    public StyledBioFilter(String allowedCharacters) {
        this.setAllowedCharacters(allowedCharacters);
    }

    public StyledBioFilter(int charset, boolean uppercase) {
        this(charset);
        this.forceUppercaseOutput(uppercase);
    }

    public StyledBioFilter(int charset) {
        this.setCharSet(charset);
    }

    public void setAllowedCharacters(String allowedCharacters) {
        this.charSet = 99;
        this.regexFilter = "[^" + this.formatRegex(allowedCharacters) + "]";
    }

    public void setNegativeAccepted(boolean negativeaccepted) {
        if (this.charSet == 5 || this.charSet == 6 || this.charSet == 7) {
            this.negativeAccepted = negativeaccepted;
            switch (this.charSet) {
                case 5: {
                    this.regexFilter = !this.negativeAccepted ? "[^0-9]" : "[^0-9\\-]";
                    break;
                }
                case 6: {
                    this.regexFilter = !this.negativeAccepted ? "[^a-zA-Z0-9]" : "[^a-zA-Z0-9\\-]";
                    break;
                }
                case 7: {
                    this.regexFilter = !this.negativeAccepted ? "[^a-zA-Z0-9]" : "[^a-zA-Z0-9\\-]";
                }
            }
        }
    }

    private void setCharSet(int charset) {
        switch (charset) {
            case 1: {
                this.regexFilter = "[^ATGCatgcNn]";
                break;
            }
            case 2: {
                this.regexFilter = "[^AUGCaugc]";
                break;
            }
            case 3: {
                this.regexFilter = "[^AUGCaugcNn]";
                break;
            }
            case 4: {
                this.regexFilter = "[^*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy]";
                break;
            }
            case 5: {
                this.regexFilter = "[^0-9]";
                break;
            }
            case 6: {
                this.regexFilter = "[^5\\.]";
                break;
            }
            case 7: {
                this.regexFilter = "[^a-zA-Z0-9]";
                break;
            }
            case 8: {
                this.regexFilter = "[^ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890_\\+'\\-]";
                break;
            }
            default: {
                this.regexFilter = "[^ATGCatgc]";
            }
        }
    }

    private String formatRegex(String allowedChars) {
        allowedChars = allowedChars.replaceAll("\\\\", "\\\\\\\\");
        allowedChars = allowedChars.replaceAll("\\.", "\\\\.");
        allowedChars = allowedChars.replaceAll("\\$", "\\\\$");
        allowedChars = allowedChars.replaceAll("\\|", "\\\\|");
        allowedChars = allowedChars.replaceAll("\\^", "\\\\^");
        allowedChars = allowedChars.replaceAll("\\[", "\\\\[");
        allowedChars = allowedChars.replaceAll("\\]", "\\\\]");
        allowedChars = allowedChars.replaceAll("\\?", "\\\\?");
        allowedChars = allowedChars.replaceAll("\\+", "\\\\+");
        allowedChars = allowedChars.replaceAll("\\-", "\\\\-");
        allowedChars = allowedChars.replaceAll("\\(", "\\\\(");
        allowedChars = allowedChars.replaceAll("\\)", "\\\\)");
        allowedChars = allowedChars.replaceAll("\\{", "\\\\{");
        allowedChars = allowedChars.replaceAll("\\}", "\\\\}");
        allowedChars = allowedChars.replaceAll("\\*", "\\\\*");
        allowedChars = allowedChars.replaceAll("\\'", "\\\\'");
        return allowedChars;
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (text == null) {
            return;
        }
        String string = text = this.upperCaseText ? text.replaceAll(this.regexFilter, "").toUpperCase() : text.replaceAll(this.regexFilter, "");
        if (text.length() > 0) {
            super.replace(offset, length, text, attrs);
        }
    }
}

