/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import Renderers.GradientRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public class GalaxyRenderer
extends GradientRenderer {
    static final Color borderColor = new Color(192, 192, 192);
    static final Color backColor1 = new Color(240, 240, 240);
    static final Color borderColorFocused = borderColor.darker();
    int borderWidth = 1;
    int ellipseWd = 8;

    public GalaxyRenderer(Component parent) {
        super(parent);
    }

    public GalaxyRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
    }

    public GalaxyRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
    }

    public GalaxyRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
    }

    public GalaxyRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(parent, rounded, paintIcon, paintCaption, paintBorder);
    }

    public GalaxyRenderer() {
    }

    public GalaxyRenderer(boolean rounded) {
        super(rounded);
    }

    public GalaxyRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
    }

    public GalaxyRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
    }

    public GalaxyRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        int wd;
        int ht;
        Shape clipShape;
        if (clip != null) {
            Rectangle bounds = clip.getBounds();
            clipShape = bounds;
            ht = bounds.height;
            wd = bounds.width;
        } else {
            clipShape = this.getShape(c);
            ht = c.getHeight();
            wd = c.getWidth();
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape oldClip = g2d.getClip();
        g2d.clip(clipShape);
        switch (state) {
            case 2: 
            case 4: {
                GalaxyRenderer.paintGradient(g2d, Color.WHITE, backColor1, clipShape, wd, ht, false);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                GalaxyRenderer.paintGradient(g2d, backColor1, Color.WHITE, clipShape, wd, ht, false);
                break;
            }
            case 5: {
                GalaxyRenderer.paintGradient(g2d, Color.WHITE, backColor1, clipShape, wd, ht, false);
                break;
            }
            default: {
                g2d.setColor(Color.white);
                g2d.fill(this.getShape(c));
            }
        }
        g2d.setClip(oldClip);
        g2d.dispose();
    }
}

