/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import Renderers.GradientRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;

public class GelRenderer
extends GradientRenderer {
    public GelRenderer(Component parent) {
        super(parent);
        this.setRoundedArc(3);
    }

    public GelRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
        this.setRoundedArc(3);
    }

    public GelRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
        this.setRoundedArc(3);
    }

    public GelRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
        this.setRoundedArc(3);
    }

    public GelRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(parent, rounded, paintIcon, paintCaption, paintBorder);
        this.setRoundedArc(3);
    }

    public GelRenderer() {
        this.setRoundedArc(3);
    }

    public GelRenderer(int orientation) {
        this.setRoundedArc(3);
        this.setOrientation(orientation);
    }

    public GelRenderer(boolean rounded) {
        super(rounded);
        this.setRoundedArc(3);
    }

    public GelRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
        this.setRoundedArc(3);
    }

    public GelRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
        this.setRoundedArc(3);
    }

    public GelRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
        this.setRoundedArc(3);
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        Color Color3;
        Color Color2;
        Color Color1;
        int wd;
        int ht;
        int left;
        int top;
        if (clip != null) {
            Rectangle bounds = clip.getBounds();
            top = bounds.y;
            left = bounds.x;
            ht = bounds.height;
            wd = bounds.width;
        } else {
            top = 0;
            left = 0;
            ht = c.getHeight();
            wd = c.getWidth();
        }
        int right = left + wd - 2;
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.rounded) {
            g2d.clip(new RoundRectangle2D.Double(left, top, wd, ht, this.ellipse, this.ellipse));
        } else {
            g2d.clip(new Rectangle(left, top, wd, ht));
        }
        switch (state) {
            case 2: 
            case 4: {
                Color1 = GelRenderer.shiftColor(Color.LIGHT_GRAY, 0.05f);
                Color2 = GelRenderer.shiftColor(Color.LIGHT_GRAY, -0.02f);
                Color3 = Color.LIGHT_GRAY;
                break;
            }
            case 5: {
                Color1 = this.getOverColor(c);
                Color2 = GelRenderer.shiftColor(Color1, -0.03f);
                Color3 = GelRenderer.shiftColor(Color1, 0.1f);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                Color1 = this.getDownColor(c);
                Color2 = GelRenderer.shiftColor(Color1, -0.09f);
                Color3 = GelRenderer.shiftColor(Color1, 0.1f);
                break;
            }
            default: {
                Color1 = this.getNormalColor(c);
                Color2 = GelRenderer.shiftColor(Color1, -0.02f);
                Color3 = GelRenderer.shiftColor(Color1, 0.2f);
            }
        }
        if (this.orientation == 5) {
            GelRenderer.paintGradient(g2d, Color.WHITE, Color1, left, top, right, 5, false);
            GelRenderer.paintGradient(g2d, Color2, Color3, 0, 6, right, ht, false);
        } else {
            GelRenderer.paintGradient(g2d, Color.WHITE, Color1, 0, 0, 5, ht, true);
            GelRenderer.paintGradient(g2d, Color2, Color3, 6, 0, right, ht, true);
        }
        g2d.setColor(c.hasFocus() ? GelRenderer.shiftColor(Color1, -0.1f).darker() : GelRenderer.shiftColor(Color1, -0.1f));
        g2d.setStroke(new BasicStroke(2.0f));
        if (this.rounded) {
            g2d.drawRoundRect(left, top, wd - 1, ht - 1, 3, 3);
        } else {
            g2d.drawRect(left, top, wd - 1, ht - 1);
        }
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.dispose();
    }
}

