/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import Renderers.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public class OfficeXPRenderer
extends Renderer {
    static final Color borderColor = new Color(0, 120, 215);

    public OfficeXPRenderer(Component parent) {
        super(parent);
    }

    public OfficeXPRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
    }

    public OfficeXPRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
    }

    public OfficeXPRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
    }

    public OfficeXPRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(parent, rounded, paintIcon, paintCaption, paintBorder);
    }

    public OfficeXPRenderer() {
    }

    public OfficeXPRenderer(boolean rounded) {
        super(rounded);
    }

    public OfficeXPRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
    }

    public OfficeXPRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
    }

    public OfficeXPRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        int wd;
        int ht;
        int left;
        int top;
        Shape clipShape;
        if (clip != null) {
            Rectangle bounds = clip.getBounds();
            clipShape = bounds;
            top = bounds.y;
            left = bounds.x;
            ht = bounds.height;
            wd = bounds.width;
        } else {
            clipShape = this.getShape(c);
            top = 1;
            left = 1;
            ht = c.getHeight();
            wd = c.getWidth();
        }
        int bottom = top + ht - 2;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape oldClip = g2d.getClip();
        g2d.clip(clipShape);
        switch (state) {
            case 2: 
            case 4: {
                g2d.setColor(c.getBackground());
                g2d.fillRect(left, top, wd, bottom);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                g2d.setColor(new Color(128, 187, 235));
                g2d.fillRect(left, top, wd, bottom);
                g2d.setColor(borderColor);
                g2d.drawRect(left, top, wd - 1, bottom - 1);
                break;
            }
            case 5: {
                g2d.setColor(new Color(176, 213, 242));
                g2d.fillRect(left, top, wd, bottom);
                g2d.setColor(borderColor);
                g2d.drawRect(left, top, wd - 1, bottom - 1);
                break;
            }
            default: {
                g2d.setColor(c.getBackground());
                g2d.fillRect(left, top, wd, bottom);
                if (!c.hasFocus()) break;
                g2d.setColor(borderColor);
                g2d.drawRect(left, top, wd - 1, bottom - 1);
            }
        }
        g2d.setClip(oldClip);
        g2d.dispose();
    }

    @Override
    public void paintBorder(Graphics g, Component parent, Shape border) {
    }
}

