/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import BaseClasses.RendererColors;
import JMConstants.Constants;
import Tools.UITools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public abstract class Renderer
implements Constants {
    boolean paintIcon = true;
    boolean paintCaption = true;
    boolean paintBorder = true;
    boolean shiftOnPress = true;
    int captionAlignH = 0;
    int captionAlignV = 0;
    int iconAlignH = 0;
    int iconAlignV = 0;
    RendererColors colors = new RendererColors();
    protected int minColorTypes = 3;
    protected int minColorStates = 7;
    protected Component parent;
    protected boolean rounded = false;
    protected int orientation = 0;
    Shape shape;
    int width = 0;
    int height = 0;
    int ellipse = 10;
    boolean showFocus = false;
    int shift;
    int deltaX = this.shift = 2;
    int deltaY = this.shift;
    int iconMarginRight = 0;
    int iconMarginBottom = 0;
    int iconMarginTop = 0;
    int iconMarginLeft = 0;
    int buttonMarginRight = 0;
    int buttonMarginBottom = 0;
    int buttonMarginTop = 0;
    int buttonMarginLeft = 0;

    public void cloneFrom(Renderer renderer) {
        this.colors = renderer.colors.clone();
        this.paintIcon = renderer.paintIcon;
        this.paintCaption = renderer.paintCaption;
        this.paintBorder = renderer.paintBorder;
        this.shiftOnPress = renderer.shiftOnPress;
        this.captionAlignH = renderer.captionAlignH;
        this.captionAlignV = renderer.captionAlignV;
        this.iconAlignH = renderer.iconAlignH;
        this.iconAlignV = renderer.iconAlignV;
    }

    public void cloneTo(Renderer renderer) {
        renderer.colors = this.colors.clone();
        renderer.paintIcon = this.paintIcon;
        renderer.paintCaption = this.paintCaption;
        renderer.paintBorder = this.paintBorder;
        renderer.shiftOnPress = this.shiftOnPress;
        renderer.captionAlignH = this.captionAlignH;
        renderer.captionAlignV = this.captionAlignV;
        renderer.iconAlignH = this.iconAlignH;
        renderer.iconAlignV = this.iconAlignV;
    }

    public Color getNormalColor(Component c) {
        return this.colors.getColor(1, 0);
    }

    public Color getDownColor(Component c) {
        return this.colors.getColor(1, 1);
    }

    public Color getOverColor(Component c) {
        return this.colors.getColor(1, 5);
    }

    public Color getDisabledColor(Component c) {
        return this.colors.getColor(1, 2);
    }

    public Color getSelectedColor(Component c) {
        return this.colors.getColor(1, 3);
    }

    public Color getNormalTextColor(Component c) {
        return this.colors.getColor(0, 0);
    }

    public Color getDownTextColor(Component c) {
        return this.colors.getColor(0, 1);
    }

    public Color getOverTextColor(Component c) {
        return this.colors.getColor(0, 5);
    }

    public Color getDisabledTextColor(Component c) {
        return this.colors.getColor(0, 2);
    }

    public void setActiveColors(int state) {
        this.colors.setActiveColors(state);
    }

    public void setActiveColors(Component c) {
        this.colors.setActiveColors(c);
    }

    Color getBorderColor(Component c) {
        int state = UITools.getState(c);
        return this.colors.getColor(c, 2, state);
    }

    public void setPaintIcon(boolean paint) {
        this.paintIcon = paint;
        if (this.parent != null && Renderer.isButton(this.parent)) {
            this.parent.repaint();
        }
    }

    public void setPaintCaption(boolean paint) {
        this.paintCaption = paint;
        if (this.parent != null && Renderer.isButton(this.parent)) {
            this.parent.repaint();
        }
    }

    public void setPaintBorder(boolean paint) {
        this.paintBorder = paint;
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public boolean isPaintIcon() {
        return this.paintIcon;
    }

    public boolean isPaintCaption() {
        return this.paintCaption;
    }

    public boolean isPaintBorder() {
        return this.paintBorder;
    }

    public RendererColors getColors() {
        return this.colors;
    }

    public void setColors(RendererColors colors) {
        if (colors != null) {
            this.colors = colors;
            this.colors.setMinimumTypesAndStates(this.minColorTypes, this.minColorStates);
        }
    }

    public void setColors(Color colorNormal, Color colorRollOver, Color colorPressed, Color colorBorder) {
        this.colors.setColor(1, 0, colorNormal);
        this.colors.setColor(1, 5, colorRollOver);
        this.colors.setColor(1, 1, colorPressed);
        this.colors.setColor(2, 0, colorBorder);
    }

    public void setColors(Color color) {
        this.colors.setColors(1, color);
    }

    public void setTextColors(Color colorNormal, Color colorRollOver, Color colorPressed) {
        this.colors.setColor(0, 0, colorNormal);
        this.colors.setColor(0, 5, colorRollOver);
        this.colors.setColor(0, 1, colorPressed);
    }

    public void setTextColors(Color colorNormal, Color colorRollOver, Color colorPressed, Color colorDisabled) {
        this.colors.setColor(0, 0, colorNormal);
        this.colors.setColor(0, 5, colorRollOver);
        this.colors.setColor(0, 1, colorPressed);
        this.colors.setColor(0, 2, colorDisabled);
    }

    public void setDisabledTextColor(Color color) {
        this.colors.setColor(0, 2, color);
    }

    public Color getDisabledTextColor() {
        return this.colors.getColor(0, 2);
    }

    public void setTextColors(Color color) {
        this.colors.setColors(0, color);
    }

    public void setColorRollover(Color color) {
        this.colors.setColor(1, 5, color);
    }

    public void setColorPressed(Color color) {
        this.colors.setColor(1, 1, color);
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public void setColorNormal(Color color) {
        this.colors.setColor(1, 0, color);
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public void setColorSelected(Color color) {
        this.colors.setColor(1, 3, color);
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public Color getColorRollover() {
        return this.colors.getColor(1, 5);
    }

    public Color getColorPressed() {
        return this.colors.getColor(1, 1);
    }

    public Color getColorSelected() {
        return this.colors.getColor(1, 3);
    }

    public Color getColorNormal() {
        return this.colors.getColor(1, 0);
    }

    public void setTextColor(Color color) {
        this.colors.setColor(0, 0, color);
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public Color getTextColor() {
        return this.colors.getColor(0, 0);
    }

    public void setHorizontalIconAlignment(int value) {
        this.iconAlignH = value;
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public int getHorizontalIconAlignment() {
        return this.iconAlignV;
    }

    public void setVerticalIconAlignment(int value) {
        this.iconAlignV = value;
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public int getVerticalIconAlignment() {
        return this.iconAlignV;
    }

    public void setVerticalTextAlignment(int value) {
        this.captionAlignV = value;
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public int getVerticalTextAlignment() {
        return this.captionAlignV;
    }

    public Renderer(Component parent) {
        this.parent = parent;
    }

    public Renderer(Component parent, boolean rounded) {
        this(parent);
        this.rounded = rounded;
    }

    public Renderer(Component parent, boolean rounded, boolean paintIcon) {
        this(parent, rounded);
        this.paintIcon = paintIcon;
    }

    public Renderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        this(parent, rounded, paintIcon);
        this.paintCaption = paintCaption;
    }

    public Renderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        this(parent, rounded, paintIcon, paintCaption);
        this.paintBorder = paintBorder;
    }

    public Renderer() {
    }

    public Renderer(boolean rounded) {
        this();
        this.rounded = rounded;
    }

    public Renderer(boolean rounded, boolean paintIcon) {
        this(rounded);
        this.paintIcon = paintIcon;
    }

    public Renderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        this(rounded, paintIcon);
        this.paintCaption = paintCaption;
    }

    public Renderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        this(rounded, paintIcon, paintCaption);
        this.paintBorder = paintBorder;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static boolean isButton(Component c) {
        return c instanceof AbstractButton;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void setBorderColor(Color color) {
        this.colors.setColor(2, 0, color);
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public void setBorderColors(Color color) {
        this.colors.setColors(2, color);
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public Color getBorderColor() {
        return this.colors.getColor(0, 0);
    }

    public void setRounded(boolean rounded) {
        this.rounded = rounded;
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public boolean isRounded() {
        return this.rounded;
    }

    public void setRoundedArc(int ellipse) {
        if (ellipse >= 0) {
            this.ellipse = ellipse;
            this.shape = null;
            if (this.parent != null) {
                this.parent.repaint();
            }
        }
    }

    public int getRoundedArc() {
        return this.ellipse;
    }

    public Shape getShape(Component c) {
        int wd = c.getWidth();
        int ht = c.getHeight();
        if (this.width != wd || this.height != ht) {
            this.width = wd;
            this.height = ht;
            this.shape = null;
        }
        if (this.shape == null) {
            this.shape = this.rounded ? new RoundRectangle2D.Double(0.0, 0.0, this.width, this.height, this.ellipse, this.ellipse) : new Rectangle(0, 0, this.width, this.height);
        }
        return this.shape;
    }

    public Shape getShape(Rectangle bounds) {
        if (bounds == null) {
            return null;
        }
        if (this.rounded) {
            return new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height, this.ellipse, this.ellipse);
        }
        return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Shape getShape(Shape cShape) {
        Rectangle bounds = cShape.getBounds();
        if (bounds == null) {
            return null;
        }
        if (this.rounded) {
            return new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height, this.ellipse, this.ellipse);
        }
        return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Shape getShape(int x, int y, int width, int height) {
        if (this.rounded) {
            return new RoundRectangle2D.Double(x, y, width, height, this.ellipse, this.ellipse);
        }
        return new Rectangle(x, y, width, height);
    }

    public void paint(Graphics g, Component c) {
        if (c != null) {
            this.paint(g, c, null, UITools.getState(c));
        }
    }

    public void paint(Graphics g, Component c, int state) {
        if (c != null) {
            this.paint(g, c, null, state);
        }
    }

    public void paint(Graphics g, Component c, Shape clip) {
        if (c != null) {
            this.paint(g, c, clip, UITools.getState(c));
        }
    }

    public void paint(Graphics g, Component c, Shape clip, int state) {
        if (c == null) {
            return;
        }
        int wd = c.getWidth();
        int ht = c.getHeight();
        if (this.width != wd || this.height != ht) {
            this.width = wd;
            this.height = ht;
            this.shape = null;
        }
        if (this.width > 0 && this.height > 0) {
            this.colors.setActiveColors(state);
            boolean contentFilled = c instanceof AbstractButton && ((AbstractButton)c).isContentAreaFilled();
            boolean opaque = c.isOpaque();
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (opaque || contentFilled && this.colors.getActiveColor(1) != null) {
                this.paintBackground(g2d, c, clip, state);
            }
            if (Renderer.isButton(c)) {
                this.paintCaptionAndIcon(g2d, c, state);
            }
            if (this.paintBorder && this.colors.getActiveColor(2) != null) {
                this.paintBorder(g2d, c, clip);
            }
            g2d.dispose();
        }
    }

    public void setShowFocus(boolean show) {
        this.showFocus = show;
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public final void paintBackground(Graphics g) {
        this.paintBackground(g, this.parent);
    }

    public final void paintBackground(Graphics g, Component c) {
        this.paintBackground(g, c, null, UITools.getState(c));
    }

    public final void paintBackground(Graphics g, Component c, Shape clip) {
        this.paintBackground(g, c, clip, UITools.getState(c));
    }

    public final void paintBackground(Graphics g, Component c, int state) {
        this.paintBackground(g, c, null, state);
    }

    public abstract void paintBackground(Graphics var1, Component var2, Shape var3, int var4);

    public final void paintBorder(Graphics g2d, Component c) {
        this.paintBorder(g2d, c, null);
    }

    public void paintBorder(Graphics g, Component c, Shape border) {
        Graphics2D g2d = (Graphics2D)g.create();
        Color color = this.getBorderColor(c);
        if (color != null) {
            Rectangle bounds;
            if (border != null) {
                bounds = new Rectangle(border.getBounds().x, border.getBounds().y, border.getBounds().width, border.getBounds().height);
            } else {
                bounds = this.getShape(c).getBounds();
                bounds = new Rectangle(bounds.getBounds().x, bounds.getBounds().y, bounds.getBounds().width, bounds.getBounds().height);
            }
            boolean focused = c.hasFocus();
            Shape oldClip = g2d.getClip();
            g2d.clip(bounds);
            if (this.showFocus && focused) {
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setColor(color.darker());
                if (this.rounded) {
                    g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.ellipse, this.ellipse);
                } else {
                    g2d.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                }
                g2d.setStroke(new BasicStroke(1.0f));
            } else {
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setColor(color);
                if (this.rounded) {
                    g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.ellipse, this.ellipse);
                } else {
                    g2d.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                }
            }
            g2d.setClip(oldClip);
            g2d.dispose();
        }
    }

    void paintCaptionAndIcon(Graphics2D g2d, Component c, int state) {
        int captionY;
        int iconY;
        int captionX;
        int iconX;
        boolean noText;
        AbstractButton button = (AbstractButton)c;
        this.captionAlignH = button.getHorizontalTextPosition();
        if (this.captionAlignH == 10 || this.captionAlignH == 11) {
            this.captionAlignH = 0;
        }
        this.deltaX = 0;
        this.deltaY = 0;
        Icon icon = this.getButtonIcon(button, state);
        String caption = button.getText();
        boolean noIcon = icon == null || !this.paintIcon;
        boolean bl = noText = caption == null || caption.length() == 0 || !this.paintCaption;
        if (noText && noIcon) {
            return;
        }
        if (noText) {
            this.paintIcon(g2d, c, icon, state);
            return;
        }
        if (noIcon) {
            this.paintCaption(g2d, c, caption, state);
            return;
        }
        if (this.captionAlignH != this.iconAlignH || this.captionAlignV != this.iconAlignV) {
            this.paintCaption(g2d, c, caption, state);
            this.paintIcon(g2d, c, icon, state);
            return;
        }
        g2d.setFont(c.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        int cWd = fm.stringWidth(caption);
        int cHt = fm.getAscent();
        int iWd = icon.getIconWidth();
        int iHt = icon.getIconHeight();
        int HtMax = Math.max(cHt, iHt);
        int tWd = cWd + iWd + this.iconMarginRight;
        int tHt = cHt + iHt + this.iconMarginTop;
        Dimension d = c.getSize();
        if (this.captionAlignH == 0 && this.captionAlignV == 0) {
            iconX = (d.width - iWd) / 2;
            captionX = this.deltaX + (d.width - cWd) / 2;
            iconY = (d.height - tHt) / 2;
            captionY = this.deltaY + iconY + iHt + cHt + this.iconMarginBottom;
        } else {
            switch (this.captionAlignH) {
                case 2: {
                    iconX = this.buttonMarginLeft;
                    captionX = this.deltaX + iconX + iWd + this.iconMarginRight;
                    break;
                }
                case 4: {
                    iconX = this.width - this.buttonMarginLeft - iWd;
                    captionX = this.deltaX + iconX - this.buttonMarginLeft - cWd;
                    break;
                }
                default: {
                    iconX = (d.width - tWd) / 2;
                    captionX = this.deltaX + iconX + this.iconMarginRight;
                }
            }
            switch (this.captionAlignV) {
                case 1: {
                    iconY = this.buttonMarginTop + (HtMax - iHt) / 2;
                    captionY = this.deltaY + this.iconMarginBottom + cHt + (HtMax - cHt) / 2;
                    break;
                }
                case 3: {
                    iconY = this.height - this.buttonMarginBottom - iHt + (HtMax - iHt) / 2;
                    captionY = this.deltaY + (this.height - this.buttonMarginBottom) - (HtMax - cHt) / 2;
                    break;
                }
                default: {
                    iconY = (d.height - iHt) / 2 + (HtMax - iHt) / 2;
                    captionY = this.deltaY + (d.height + iHt) / 2 - (HtMax - cHt) / 2;
                }
            }
        }
        Color captionColor = this.colors.getColor(0, state);
        g2d.setColor(captionColor);
        if (this.shiftOnPress && state == 1) {
            captionX += this.shift;
            captionY += this.shift;
            iconX += this.shift;
            iconY += this.shift;
        }
        Shape oldClip = g2d.getClip();
        if (this.shape == null) {
            this.shape = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        }
        g2d.clip(this.shape);
        g2d.drawString(caption, captionX, captionY);
        icon.paintIcon(c, g2d, iconX, iconY);
        g2d.setClip(oldClip);
    }

    protected Icon getButtonIcon(AbstractButton button, int state) {
        Icon icon = null;
        switch (state) {
            case 2: 
            case 4: {
                icon = button.getDisabledIcon();
                break;
            }
            case 6: {
                icon = button.getRolloverSelectedIcon();
                if (icon != null) break;
                icon = button.getRolloverIcon();
                break;
            }
            case 5: {
                icon = button.getRolloverIcon();
                break;
            }
            case 1: {
                icon = button.getPressedIcon();
                if (icon != null) break;
                icon = button.getSelectedIcon();
                break;
            }
            case 3: {
                icon = button.getSelectedIcon();
                if (icon != null) break;
                icon = button.getPressedIcon();
                break;
            }
        }
        return icon != null ? icon : button.getIcon();
    }

    void paintCaption(Graphics2D g2d, Component c, String caption, int state) {
        int captionY;
        int captionX;
        Color captionColor = this.colors.getColor(0, state);
        g2d.setFont(c.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        int wd = fm.stringWidth(caption);
        int ht = fm.getMaxAscent() - fm.getMaxDescent();
        switch (this.captionAlignH) {
            case 2: {
                captionX = this.deltaX + this.buttonMarginLeft;
                break;
            }
            case 4: {
                captionX = this.deltaX + (this.width - this.buttonMarginLeft - wd);
                break;
            }
            default: {
                captionX = this.deltaX + (this.width - wd) / 2;
            }
        }
        switch (this.captionAlignV) {
            case 1: {
                captionY = this.deltaY + this.buttonMarginTop + ht;
                break;
            }
            case 3: {
                captionY = this.deltaY + (this.height - this.buttonMarginBottom);
                break;
            }
            default: {
                captionY = this.deltaY + (this.height + ht) / 2;
            }
        }
        g2d.setColor(captionColor);
        if (this.shiftOnPress && state == 1) {
            ++captionX;
            ++captionY;
        }
        Shape oldClip = g2d.getClip();
        g2d.clip(this.getShape(c));
        g2d.drawString(caption, captionX, captionY);
        g2d.setClip(oldClip);
    }

    void paintIcon(Graphics2D g2d, Component c, Icon icon, int state) {
        int iconY;
        int iconX;
        if (icon == null) {
            return;
        }
        int wd = icon.getIconWidth();
        int ht = icon.getIconHeight();
        Dimension d = c.getSize();
        switch (this.iconAlignH) {
            case 2: {
                iconX = this.buttonMarginLeft;
                break;
            }
            case 4: {
                iconX = this.width - this.buttonMarginLeft - wd;
                break;
            }
            default: {
                iconX = (d.width - wd) / 2;
            }
        }
        switch (this.iconAlignV) {
            case 1: {
                iconY = this.buttonMarginTop;
                break;
            }
            case 3: {
                iconY = this.height - this.buttonMarginBottom - ht;
                break;
            }
            default: {
                iconY = (d.height - ht) / 2;
            }
        }
        if (this.shiftOnPress && state == 1) {
            ++iconX;
            ++iconY;
        }
        Shape oldClip = g2d.getClip();
        g2d.clip(this.getShape(c));
        icon.paintIcon(c, g2d, iconX, iconY);
        g2d.setClip(oldClip);
    }

    static class Point {
        int x = 0;
        int y = 0;

        public Point() {
        }

        public Point(int X, int Y) {
            this.x = X;
            this.y = Y;
        }

        public String toString() {
            return "x=" + this.x + ", y=" + this.y;
        }
    }
}

