/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import Renderers.GradientRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public class VistaRenderer
extends GradientRenderer {
    boolean useDefaultColors = true;
    private static final Color DEF_COLOR_DISABLED = new Color(232, 244, 255);
    private static final Color DEF_COLOR_COLORTOP = new Color(234, 246, 255);
    private static final Color DEF_COLOR_COLORBOT = new Color(213, 225, 242);
    private static final Color DEF_COLOR_BORDER = new Color(190, 172, 189);
    private static final Color DEF_COLOR_OVER_TOP = new Color(222, 245, 255);
    private static final Color DEF_COLOR_OVER_BOT = new Color(188, 231, 255);
    private static final Color DEF_TOP_OVER_SIDE = new Color(211, 241, 255);
    private static final Color DEF_BOT_OVER_SIDE = new Color(151, 218, 252);
    private static final Color DEF_COLOR_OVER_BORDER = new Color(50, 117, 167);
    private static final Color DEF_COLOR_PRESSED_COLORTOP = new Color(194, 228, 246);
    private static final Color DEF_COLOR_PRESSED_COLORBOT = new Color(154, 210, 240);
    private static final Color DEF_COLOR_PRESSED_COLORTOPSIDE = new Color(150, 205, 235);
    private static final Color DEF_COLOR_PRESSED_COLORBOTSIDE = new Color(83, 176, 255);
    private static final Color DEF_COLOR_PRESSED_COLORTOPG = new Color(113, 156, 179);
    private static final Color DEF_COLOR_PRESSED_COLORBORDER = new Color(29, 65, 92);
    boolean paintBorder2 = true;
    private Color borderColor;

    public VistaRenderer(Component parent) {
        super(parent);
        this.paintBorder = false;
    }

    public VistaRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
        this.paintBorder = false;
    }

    public VistaRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
        this.paintBorder = false;
    }

    public VistaRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean defaultColors) {
        super(parent, rounded, paintIcon, paintCaption);
        this.paintBorder = false;
        this.useDefaultColors = defaultColors;
    }

    public VistaRenderer() {
        this.paintBorder = false;
    }

    public VistaRenderer(boolean rounded) {
        super(rounded);
        this.paintBorder = false;
    }

    public VistaRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
        this.paintBorder = false;
    }

    public VistaRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean defaultColors) {
        super(rounded, paintIcon, paintCaption);
        this.paintBorder = false;
        this.useDefaultColors = defaultColors;
    }

    public void setUseDefaultColors(boolean useDefault) {
        this.useDefaultColors = useDefault;
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        int wd;
        int ht;
        int left;
        int top;
        Shape clipShape;
        if (clip != null) {
            Rectangle bounds = clip.getBounds();
            clipShape = bounds;
            top = bounds.y;
            left = bounds.x;
            ht = bounds.height - 1;
            wd = bounds.width - 1;
        } else {
            clipShape = this.getShape(c);
            top = 0;
            left = 0;
            ht = c.getHeight() - 1;
            wd = c.getWidth() - 1;
        }
        int right = left + wd - 1;
        int bottom = top + ht - 1;
        int halfHt = ht / 2;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape oldClip = g2d.getClip();
        g2d.clip(clipShape);
        Color ColorTopG = null;
        if (state == 5 || state == 1 || state == 3) {
            Color BotSide;
            Color TopSide;
            Color ColorBot;
            Color ColorTop;
            if (state == 5) {
                if (this.useDefaultColors) {
                    ColorTop = DEF_COLOR_OVER_TOP;
                    ColorBot = DEF_COLOR_OVER_BOT;
                    TopSide = DEF_TOP_OVER_SIDE;
                    BotSide = DEF_BOT_OVER_SIDE;
                    this.borderColor = DEF_COLOR_OVER_BORDER;
                } else {
                    ColorTop = VistaRenderer.shiftColor(c.getBackground(), 0.1f);
                    ColorBot = VistaRenderer.shiftColor(ColorTop, -0.3f);
                    TopSide = VistaRenderer.shiftColor(ColorTop, -0.2f);
                    BotSide = VistaRenderer.shiftColor(ColorBot, -0.1f);
                    this.borderColor = VistaRenderer.shiftColor(ColorBot, -0.3f);
                }
            } else if (this.useDefaultColors) {
                ColorTop = DEF_COLOR_PRESSED_COLORTOP;
                ColorBot = DEF_COLOR_PRESSED_COLORBOT;
                TopSide = DEF_COLOR_PRESSED_COLORTOPSIDE;
                BotSide = DEF_COLOR_PRESSED_COLORBOTSIDE;
                ColorTopG = DEF_COLOR_PRESSED_COLORTOPG;
                this.borderColor = DEF_COLOR_PRESSED_COLORBORDER;
            } else {
                ColorTop = VistaRenderer.shiftColor(c.getBackground(), -0.1f);
                ColorBot = VistaRenderer.shiftColor(ColorTop, -0.3f);
                TopSide = VistaRenderer.shiftColor(ColorTop, -0.1f);
                BotSide = VistaRenderer.shiftColor(ColorBot, -0.1f);
                ColorTopG = VistaRenderer.shiftColor(BotSide, -0.3f);
                this.borderColor = VistaRenderer.shiftColor(ColorBot, -0.3f);
            }
            g2d.setColor(ColorTop);
            g2d.fillRect(left, top, wd, halfHt + 1);
            g2d.setColor(ColorBot);
            g2d.fillRect(left, halfHt + 1, wd, halfHt);
            VistaRenderer.paintGradient(g2d, TopSide, ColorTop, 1, top + 3, 7, halfHt, true);
            VistaRenderer.paintGradient(g2d, BotSide, ColorBot, 1, halfHt + 1, right, ht, true);
            VistaRenderer.paintGradient(g2d, ColorTop, TopSide, right - 6, top + 3, right, halfHt, true);
            VistaRenderer.paintGradient(g2d, ColorBot, BotSide, right - 6, halfHt + 1, right, bottom, true);
            if (state == 1) {
                VistaRenderer.paintGradient(g2d, ColorTopG, ColorTop, 0, top, right, top + 4, false);
            }
        } else {
            Color ColorBot;
            Color ColorTop;
            if (state == 2) {
                ColorTop = this.useDefaultColors ? DEF_COLOR_DISABLED : Color.LIGHT_GRAY;
                ColorBot = Color.white;
                this.borderColor = DEF_COLOR_BORDER;
            } else if (this.useDefaultColors) {
                ColorTop = DEF_COLOR_COLORTOP;
                ColorBot = DEF_COLOR_COLORBOT;
                this.borderColor = DEF_COLOR_OVER_BORDER;
            } else {
                ColorTop = VistaRenderer.shiftColor(c.getBackground(), 0.5f);
                ColorBot = VistaRenderer.shiftColor(ColorTop, -0.2f);
                this.borderColor = VistaRenderer.shiftColor(ColorBot, -0.5f);
            }
            g2d.setColor(ColorTop);
            g2d.fillRect(left, top, wd, halfHt + 1);
            g2d.setColor(ColorBot);
            g2d.fillRect(left, halfHt + 1, wd, halfHt + 1);
        }
        g2d.setClip(oldClip);
        g2d.dispose();
    }

    @Override
    public void setPaintBorder(boolean paint) {
        this.paintBorder2 = paint;
    }

    @Override
    public boolean isPaintCaption() {
        return this.paintCaption;
    }

    @Override
    public boolean isPaintBorder() {
        return this.paintBorder2;
    }

    @Override
    public void paintBorder(Graphics g, Component c, Shape border) {
        Graphics2D g2d = (Graphics2D)g.create();
        Color color = this.borderColor;
        if (color != null) {
            Rectangle bounds;
            if (border != null) {
                bounds = new Rectangle(border.getBounds().x, border.getBounds().y, border.getBounds().width, border.getBounds().height);
            } else {
                bounds = this.getShape(c).getBounds();
                bounds = new Rectangle(bounds.getBounds().x, bounds.getBounds().y, bounds.getBounds().width, bounds.getBounds().height);
            }
            boolean focused = c.hasFocus();
            Shape oldClip = g2d.getClip();
            g2d.clip(bounds);
            if (this.showFocus && focused) {
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setColor(color.darker());
                if (this.rounded) {
                    g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.ellipse, this.ellipse);
                } else {
                    g2d.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                }
                g2d.setStroke(new BasicStroke(1.0f));
            } else {
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setColor(color);
                if (this.rounded) {
                    g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.ellipse, this.ellipse);
                } else {
                    g2d.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                }
            }
            g2d.setClip(oldClip);
            g2d.dispose();
        }
    }
}

