/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import Renderers.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class WindowsRenderer
extends Renderer {
    private static final Color COLOR1 = new Color(200, 224, 243);
    private static final Color COLOR2 = new Color(0, 120, 215);
    private static final Color COLOR3 = new Color(229, 241, 251);
    private static final Color COLOR4 = new Color(0, 120, 215);

    public WindowsRenderer(Component parent) {
        super(parent);
        this.initColors();
    }

    public WindowsRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
        this.initColors();
    }

    public WindowsRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
        this.initColors();
    }

    public WindowsRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
        this.initColors();
    }

    public WindowsRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(parent, rounded, paintIcon, paintCaption, paintBorder);
        this.initColors();
    }

    public WindowsRenderer() {
        this.initColors();
    }

    public WindowsRenderer(boolean rounded) {
        super(rounded);
        this.initColors();
    }

    public WindowsRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
        this.initColors();
    }

    public WindowsRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
        this.initColors();
    }

    public WindowsRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
        this.initColors();
    }

    private void initColors() {
        this.colors.setColors(1, null, COLOR1, null, COLOR1, null, COLOR3, COLOR3);
        this.colors.setColors(2, null, COLOR2, null, COLOR2, null, COLOR4, COLOR4);
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        int width = c.getWidth();
        int height = c.getHeight();
        RectangularShape shape = this.rounded ? new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, this.ellipse, this.ellipse) : new Rectangle(0, 0, width - 1, height - 1);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color bColor = this.colors.getActiveColor(1);
        if (bColor != null) {
            g2d.setColor(bColor);
            g2d.fill(shape);
        }
        g2d.dispose();
    }

    @Override
    public void paintBorder(Graphics g, Component parent, Shape border) {
        RectangularShape shape = this.rounded ? new RoundRectangle2D.Double(0.0, 0.0, this.width - 1, this.height - 1, this.ellipse, this.ellipse) : new Rectangle(0, 0, this.width - 1, this.height - 1);
        Color lColor = this.colors.getActiveColor(2);
        if (lColor != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(lColor);
            g2d.draw(shape);
            g2d.dispose();
        }
    }
}

