/*
 * Decompiled with CFR 0.152.
 */
package SequenceEditorPanels;

import GenbankFileReader.Annotation;
import GenbankFileReader.GenBankFile;
import GenbankFileReader.Locus;
import GenbankFileReader.Qualifier;
import ProteinTools.AminoAcids;
import ProteinTools.CodonTable;
import SequenceEditorPanels.Base;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.ExtensibleArrayValidator;
import SequenceEditorPanels.ROI;
import SequenceEditorPanels.SequenceDocument;
import Sequences.DNA;
import Sequences.SequenceExportFormat;
import UndoRedo.ChangeEvent;
import java.beans.BeanProperty;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class DNASequenceDocument
extends SequenceDocument<Base> {
    public static final int PROPERTY_ROI_ADDED = 101;
    public static final int PROPERTY_ROI_REMOVED = 102;
    public static final int PROPERTY_LAST_PROPERTY = 102;
    protected final ExtensibleArray<Base> sequence = new ExtensibleArray<Base>(Base.class);
    protected final ExtensibleArray<ROI> features = new ExtensibleArray<ROI>(ROI.class);
    protected CodonTable codonTable = new CodonTable();
    protected boolean locked = false;
    protected int baseOffset = 1;
    protected String accession = ".";
    protected String organism = ".";
    protected String source = ".";
    protected String notes = "";
    private static final ExtensibleArrayValidator roiValidator = new ExtensibleArrayValidator<ROI>(){

        @Override
        public boolean isValid(ROI item) {
            return item.hasSequence();
        }
    };

    protected AminoAcids getAminoAcids() {
        return this.codonTable.getAminoAcids();
    }

    public int length() {
        return this.sequence != null ? this.sequence.length : 0;
    }

    public boolean isValidBp(int bp) {
        return bp > 0 && bp <= this.sequence.length;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String text) {
        this.notes = text != null ? text : "";
        this.fireEvents(10);
    }

    public DNASequenceDocument() {
        this.sequence.clear();
    }

    public DNASequenceDocument(String sequence) {
        this.setSequence(sequence);
    }

    public void setBaseOffset(int offset) {
        this.baseOffset = offset;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public int getFeatureCount() {
        return this.features.length;
    }

    public CodonTable getCodonTable() {
        return this.codonTable;
    }

    public void setCodonTable(CodonTable codonTable) {
        if (codonTable != null && this.codonTable != codonTable) {
            String oldOrg = this.codonTable.getOrganismName();
            String newOrg = codonTable.getOrganismName();
            this.codonTable = codonTable;
            this.fireEvents(new ChangeEvent(5, oldOrg, newOrg), new ChangeEvent(10));
        }
    }

    protected ExtensibleArray<ROI> getFeaturesArray() {
        return this.features;
    }

    public String getAccession() {
        return this.accession;
    }

    public void setAccession(String accession) {
        String oldValue = this.accession;
        if (this.main_setAccession(accession)) {
            this.fireEvents(new ChangeEvent(3, oldValue, this.accession), new ChangeEvent(10));
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        String oldValue = this.source;
        if (this.main_setSrc(source)) {
            this.fireEvents(new ChangeEvent(2, oldValue, this.source), new ChangeEvent(10));
        }
    }

    public String getOrganism() {
        return this.organism;
    }

    public void setOrganism(String organism) {
        String oldValue = this.organism;
        this.organism = organism;
        this.fireEvents(new ChangeEvent(1, oldValue, this.organism), new ChangeEvent(10));
    }

    public int getCodonTableIndex() {
        return this.codonTable.getOrganismIndex();
    }

    public void setCodonTable(String organism) {
        if (organism != null && organism.length() > 0) {
            this.setCodonTable(CodonTable.getOrganismIndex(organism));
        }
    }

    public void setCodonTable(int organism) {
        if (this.main_setCodonTable(organism)) {
            this.fireEvents(new ChangeEvent(5), new ChangeEvent(10));
        }
    }

    public boolean setAASequence(String seq) {
        if (seq == null || seq.length() == 0) {
            return false;
        }
        String fseq = CodonTable.filterAA(seq);
        if (fseq.length() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < fseq.length(); ++x) {
                String codon = this.codonTable.getHighestCodon(fseq.charAt(x));
                sb.append(codon);
            }
            return this.setSequence(sb.toString());
        }
        return false;
    }

    public boolean setSequence(String newSeq) {
        if (this.main_setSeq(newSeq)) {
            this.features.clear();
            this.fireEvents(new ChangeEvent(4), new ChangeEvent(10));
            return true;
        }
        return false;
    }

    public void setSequence(SequenceExportFormat data) {
        this.main_setSeq(data.sequence);
        this.name = data.name;
        this.circular = data.circular;
        this.features.clear();
        if (data.annotations != null) {
            for (ROI roi : data.annotations) {
                this.features.add(roi);
            }
        }
        this.fireEvents(new ChangeEvent(4));
    }

    public boolean setOrigin(int position) {
        if (this.main_setOrigin(position)) {
            this.fireEvents(new ChangeEvent(4));
            return true;
        }
        return false;
    }

    public String getSequence(int start, int stop) {
        return this.getSequenceMain(start - 1, stop - 1, false);
    }

    public String getSequence(int start, int stop, boolean antisense) {
        return this.getSequenceMain(start - 1, stop - 1, antisense);
    }

    public String getSequence() {
        return this.getSequenceMain(0, this.sequence.length - 1, false);
    }

    @BeanProperty(hidden=true)
    public String getTranslation(int start, int stop) {
        char[] tSeq;
        block11: {
            int tIndex;
            block10: {
                int x;
                int bpLen;
                if (this.sequence.length == 0) {
                    return "";
                }
                int n = bpLen = stop < start ? this.sequence.length - start + stop + 1 : stop - start + 1;
                if (start < 1) {
                    start = 1;
                } else if (start > this.sequence.length) {
                    start = this.sequence.length;
                }
                if (stop < 1) {
                    stop = 1;
                } else if (stop > this.sequence.length) {
                    stop = this.sequence.length;
                }
                int tLen = bpLen / 3;
                tSeq = new char[tLen];
                tIndex = 0;
                if (--stop >= --start) break block10;
                for (x = start; x < this.sequence.length - 2; x += 3) {
                    tSeq[tIndex] = ((Base[])this.sequence.items)[x].AA.abbr1;
                    ++tIndex;
                }
                int start2 = 1;
                if (x != this.sequence.length - 2) break block11;
                for (x = start2; x < stop; x += 3) {
                    tSeq[tIndex] = ((Base[])this.sequence.items)[x].AA.abbr1;
                    ++tIndex;
                }
                break block11;
            }
            int wIndex = 0;
            while (wIndex < tSeq.length) {
                tSeq[tIndex] = ((Base[])this.sequence.items)[start].AA.abbr1;
                ++tIndex;
                ++wIndex;
                start += 3;
            }
        }
        return String.valueOf(tSeq);
    }

    String getSequenceMain(int start, int stop, boolean antisense) {
        char[] chars = this.getSequenceChar(start, stop);
        if (chars == null) {
            return "";
        }
        if (!antisense) {
            return String.valueOf(chars);
        }
        return DNA.getAntisense(chars);
    }

    public char[] getSequenceChar(int start, int stop) {
        if (this.sequence == null || this.sequence.length == 0) {
            return null;
        }
        if (start < 0) {
            start = 0;
        } else if (start > this.sequence.length - 1) {
            start = this.sequence.length - 1;
        }
        if (stop < 0) {
            stop = 0;
        } else if (stop > this.sequence.length - 1) {
            stop = this.sequence.length - 1;
        }
        int bpLen = stop < start ? this.sequence.length - start + stop + 1 : stop - start + 1;
        char[] chars = new char[bpLen];
        int wIndex = 0;
        if (start > stop) {
            int x;
            for (x = start; x <= this.sequence.length - 1; ++x) {
                chars[wIndex] = ((Base[])this.sequence.items)[x].base;
                ++wIndex;
            }
            for (x = 0; x <= stop; ++x) {
                chars[wIndex] = ((Base[])this.sequence.items)[x].base;
                ++wIndex;
            }
        } else {
            for (int x = start; x <= stop; ++x) {
                chars[wIndex] = ((Base[])this.sequence.items)[x].base;
                ++wIndex;
            }
        }
        return chars;
    }

    protected static boolean main_AntisenseSeq(ExtensibleArray<Base> sequence) {
        if (sequence == null || sequence.length == 0) {
            return false;
        }
        int mid = sequence.length / 2;
        int lastIndex = sequence.length - 1;
        for (int i = 0; i <= mid; ++i) {
            Base c2;
            int i2 = lastIndex - i;
            Base c1 = ((Base[])sequence.items)[i];
            ((Base[])sequence.items)[i] = c2 = ((Base[])sequence.items)[i2];
            c2.complement();
            if (i == i2) break;
            ((Base[])sequence.items)[i2] = c1;
            c1.complement();
        }
        return true;
    }

    public static boolean main_AntisenseFeatures(ExtensibleArray<ROI> features, int seqLen) {
        if (features.length > 0) {
            for (ROI roi : features) {
                roi.antisense(seqLen);
            }
            return true;
        }
        return false;
    }

    public boolean main_setOrigin(int newStart) {
        if (this.sequence.rotateTo(newStart - 1)) {
            if (this.features.length > 0) {
                for (ROI roi : this.features) {
                    roi.rotateOrigin(newStart, this.sequence.length);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean main_setSeq(String seq) {
        if (seq == null) {
            seq = "";
        }
        int seqLen = seq.length();
        this.sequence.length = 0;
        this.sequence.items = new Base[seqLen + this.sequence.getBufferSize()];
        if (seqLen > 0) {
            int x;
            for (x = 0; x < seqLen; ++x) {
                Base base;
                ((Base[])this.sequence.items)[x] = base = new Base(seq.charAt(x));
            }
            this.sequence.length = seqLen;
            for (x = 0; x < this.sequence.length; ++x) {
                this.genAA(x);
            }
            return true;
        }
        return false;
    }

    protected boolean main_setAccession(String accession) {
        if (accession != null && !this.accession.equals(accession)) {
            this.accession = accession;
            return true;
        }
        return false;
    }

    protected boolean main_setSrc(String source) {
        if (source != null && !this.source.equals(source)) {
            this.source = source;
            return true;
        }
        return false;
    }

    protected boolean main_setCodonTable(int index) {
        this.codonTable.setOrganism(index);
        if (this.sequence != null && this.sequence.length > 0) {
            for (int x = 0; x < this.sequence.length; ++x) {
                if (((Base[])this.sequence.items)[x] == null) {
                    return true;
                }
                this.genAA(x);
            }
        }
        return true;
    }

    protected boolean main_setCodonTable(String orgName) {
        this.codonTable.setOrganism(orgName);
        if (this.sequence != null && this.sequence.length > 0) {
            for (int x = 0; x < this.sequence.length; ++x) {
                if (((Base[])this.sequence.items)[x] == null) {
                    return true;
                }
                this.genAA(x);
            }
        }
        return true;
    }

    protected static boolean main_uppercase(ExtensibleArray<Base> sequence, int first, int last) {
        if (first < 1 || last < 1 || first > sequence.length || last > sequence.length) {
            return false;
        }
        boolean retVal = false;
        if (first > last) {
            int index;
            for (index = first - 1; index < sequence.length; ++index) {
                if (((Base[])sequence.items)[index].base <= '`' && ((Base[])sequence.items)[index].base >= '{') continue;
                ((Base[])sequence.items)[index].uppercase();
                retVal = true;
            }
            for (index = 0; index < last; ++index) {
                if (((Base[])sequence.items)[index].base <= '`' && ((Base[])sequence.items)[index].base >= '{') continue;
                ((Base[])sequence.items)[index].uppercase();
                retVal = true;
            }
        } else {
            for (int index = first - 1; index < last; ++index) {
                if (((Base[])sequence.items)[index].base <= '`' && ((Base[])sequence.items)[index].base >= '{') continue;
                ((Base[])sequence.items)[index].uppercase();
                retVal = true;
            }
        }
        return retVal;
    }

    public static boolean main_lowercase(ExtensibleArray<Base> sequence, int first, int last) {
        if (first < 1 || last < 1 || first > sequence.length || last > sequence.length) {
            return false;
        }
        boolean retVal = false;
        if (first > last) {
            int index;
            for (index = first - 1; index < sequence.length; ++index) {
                if (((Base[])sequence.items)[index].base <= '@' && ((Base[])sequence.items)[index].base >= '[') continue;
                ((Base[])sequence.items)[index].lowercase();
                retVal = true;
            }
            for (index = 0; index < last; ++index) {
                if (((Base[])sequence.items)[index].base <= '@' && ((Base[])sequence.items)[index].base >= '[') continue;
                ((Base[])sequence.items)[index].lowercase();
                retVal = true;
            }
        } else {
            for (int index = first - 1; index < last; ++index) {
                if (((Base[])sequence.items)[index].base <= '@' && ((Base[])sequence.items)[index].base >= '[') continue;
                ((Base[])sequence.items)[index].lowercase();
                retVal = true;
            }
        }
        return retVal;
    }

    public void addROI(ROI ... roi) {
        if (this.features.add((ROI[])roi)) {
            this.fireEvents(new ChangeEvent(101, this.features.length - roi.length, this.features.length - 1), new ChangeEvent(10));
        }
    }

    public ROI getROI(int index) {
        return this.features.isIndexValid(index) ? ((ROI[])this.features.items)[index] : null;
    }

    public void addROI(ROI roi) {
        if (this.features.add(roi)) {
            this.fireEvents(new ChangeEvent(101, this.features.length, this.features.length - 1), new ChangeEvent(10));
        }
    }

    public void insertROI(ROI roi, int index) {
        if (this.features.insert(roi, index)) {
            this.fireEvents(new ChangeEvent(101, this.features.length, this.features.length - 1), new ChangeEvent(10));
        }
    }

    public void removeROI(ROI roi) {
        int index = this.features.indexOf(roi);
        if (index > -1) {
            this.removeROI(index);
        }
    }

    public void removeROI(int index) {
        if (this.features.remove(index)) {
            this.fireEvents(new ChangeEvent(102, index, index), new ChangeEvent(10));
        }
    }

    public void unannotateSelection(int start, int stop) {
        int length = stop - start + 1;
        boolean changed = false;
        if (!this.features.isEmpty() && length > 0) {
            boolean deletedROI = false;
            for (ROI roi : this.features) {
                if (!this.ROIcontains(roi, start, stop)) continue;
                DNASequenceDocument.unannotateROI(this, roi, start, stop);
                deletedROI |= !roi.isValid();
                changed = true;
            }
            if (changed) {
                if (deletedROI) {
                    this.features.removeInvalid(roiValidator);
                    this.fireEvents(new ChangeEvent(102));
                }
                this.fireEvents(new ChangeEvent(102, start, stop), new ChangeEvent(10));
            }
        }
    }

    private static void unannotateROI(DNASequenceDocument doc, ROI roi, int first, int last) {
        if (roi.getStop() < roi.getStart()) {
            if (first <= roi.getStop()) {
                first += doc.sequence.length;
            }
            roi.setStop(roi.getStop() + doc.sequence.length);
            if (last < roi.getStart()) {
                last += doc.sequence.length;
            }
        }
        if (roi.getStart() >= first && roi.getStop() <= last) {
            roi.invalidate();
        } else if (roi.getStop() >= first && roi.getStart() >= last) {
            roi.setStop(first - 1);
            roi.setStart(last + 1);
        } else if (roi.getStart() < first && roi.getStop() > last) {
            ROI newROI = roi.clone();
            roi.setStop(first - 1);
            newROI.setStart(last == doc.sequence.length ? 0 : last);
            if (newROI.getStart() > doc.sequence.length) {
                newROI.setStart(newROI.getStart() - doc.sequence.length);
            }
            if (newROI.getStop() > doc.sequence.length) {
                newROI.setStop(newROI.getStop() - doc.sequence.length);
            }
            doc.addROI(newROI);
        } else if (roi.getStart() < first && roi.getStop() <= last) {
            roi.setStop(first - 1);
        } else if (roi.getStart() >= first && roi.getStart() <= last) {
            roi.setStart(last + 1);
        }
        if (roi.getStart() > doc.sequence.length) {
            roi.setStart(roi.getStart() - doc.sequence.length);
        }
        if (roi.getStop() > doc.sequence.length) {
            roi.setStop(roi.getStop() - doc.sequence.length);
        }
    }

    private boolean ROIcontains(ROI roi, int first, int last) {
        if (!roi.isValid()) {
            return false;
        }
        if (roi.getStart() > roi.getStop()) {
            return first > last || first <= roi.getStop() || last >= roi.getStart();
        }
        if (first > last) {
            return last >= roi.getStart() || first <= roi.getStop();
        }
        return first <= roi.getStart() && last >= roi.getStart() || last >= roi.getStart() && last <= roi.getStop() || first <= roi.getStop() && last >= roi.getStop();
    }

    public static DNASequenceDocument fromGenbank(GenBankFile src) {
        DNASequenceDocument dest = new DNASequenceDocument();
        DNASequenceDocument.fromGenbankFile(src, dest);
        return dest;
    }

    private static void fromGenbankFile(GenBankFile src, DNASequenceDocument dest) {
        if (src != null) {
            String seq = DNA.filterSequence(src.getSequence()).toUpperCase();
            int seqLen = seq.length();
            if (seqLen == 0) {
                return;
            }
            dest.name = src.getName();
            dest.circular = src.isCircular();
            dest.setSequence(seq);
            if (src.header.qualifiers != null && src.header.qualifiers.length > 0) {
                for (int x = 0; x < src.header.qualifiers.length; ++x) {
                    if (!src.header.qualifiers[x].key.equalsIgnoreCase("codon_table")) continue;
                    dest.setCodonTable(src.header.qualifiers[x].value);
                    break;
                }
            }
            for (Annotation feature : src.features) {
                if (feature.getStart() <= 0 || feature.getStop() > seqLen) continue;
                ROI roi = ROI.fromAnnotation(feature);
                if (roi.getName().length() == 0) {
                    roi.setName("ROI " + (dest.features.length + 1));
                }
                dest.features.add(roi);
            }
        }
    }

    public static GenBankFile toGenbank(DNASequenceDocument src) {
        GenBankFile dest = new GenBankFile();
        DNASequenceDocument.toGenbankFile(src, dest);
        return dest;
    }

    public boolean antisense() {
        if (DNASequenceDocument.main_AntisenseSeq(this.sequence)) {
            DNASequenceDocument.main_AntisenseFeatures(this.features, this.sequence.length);
            this.fireEvents(4, 10);
            return true;
        }
        return false;
    }

    public boolean antisense(int start, int stop) {
        SequenceExportFormat selection = this.getSEF(start, stop);
        selection.antisense();
        this.delete(start, stop);
        this.insert(start, selection);
        return true;
    }

    private static void toGenbankFile(DNASequenceDocument src, GenBankFile dest) {
        if (src != null) {
            int seqLen = src.length();
            if (seqLen == 0) {
                return;
            }
            String seq = src.getSequence();
            dest.header.name = src.getName();
            dest.header.circular = src.isCircular();
            dest.sequence = seq;
            for (ROI roi : src.features) {
                dest.features.add(ROI.toAnnotation(roi));
            }
        }
    }

    public boolean insert(int index, String seq) {
        if (seq == null || seq.length() == 0) {
            return false;
        }
        return this.insert(index, seq.toCharArray());
    }

    public boolean insert(int index, SequenceExportFormat sef) {
        if (sef == null || sef.sequence.length() == 0) {
            return false;
        }
        if (this.insertFiltered(index, sef.sequence.toCharArray())) {
            for (ROI roi : sef.annotations) {
                roi.setStart(roi.getStart() + index);
                roi.setStop(roi.getStop() + index);
                this.features.add(roi);
            }
            return true;
        }
        return false;
    }

    public boolean insert(int index, char[] seq) {
        Base[] insBases = Base.toBaseArray(seq);
        return insBases == null ? false : this.insert(index, insBases);
    }

    protected boolean insertFiltered(int index, char[] seq) {
        if (seq.length == 0) {
            return false;
        }
        Base[] insBases = new Base[seq.length];
        for (int x = 0; x < seq.length; ++x) {
            insBases[x] = new Base(seq[x]);
        }
        return this.insert(index, insBases);
    }

    public boolean insert(int index, Base ... seq) {
        boolean adjustROI = true;
        if (index < 0 || index > this.sequence.length) {
            index = this.sequence.length;
            adjustROI = false;
        } else {
            --index;
        }
        if (this.sequence.insert(index, (Base[])seq)) {
            for (int x = index; x < this.sequence.length; ++x) {
                this.genAA(x);
            }
            if (index > 0) {
                this.genAA(index - 1);
                if (index > 1) {
                    this.genAA(index - 2);
                }
            }
            if (adjustROI) {
                ++index;
                for (ROI roi : this.features) {
                    if (!roi.isValid()) continue;
                    this.ROIinsert(roi, index, seq.length);
                }
            }
            this.fireEvents(new ChangeEvent(10, true, true));
            return true;
        }
        return false;
    }

    public boolean append(char base) {
        return Base.isCharValid(base) ? this.append(new Base(base)) : false;
    }

    public boolean append(Base base) {
        if (this.sequence.add(base)) {
            if (this.sequence.length > 1) {
                this.genAA(this.sequence.length - 1);
                if (this.sequence.length > 2) {
                    this.genAA(this.sequence.length - 2);
                }
            }
            this.fireEvents(new ChangeEvent(10, true, true));
            return true;
        }
        return false;
    }

    public boolean delete(int bp) {
        if (this.sequence.remove(--bp)) {
            for (int x = bp; x < this.sequence.length; ++x) {
                this.genAA(x);
            }
            if (bp > 0) {
                this.genAA(bp - 1);
                if (bp > 1) {
                    this.genAA(bp - 2);
                }
            }
            ++bp;
            boolean deletedROI = false;
            for (ROI roi : this.features) {
                if (!roi.isValid()) continue;
                deletedROI |= this.ROIdelRange(roi, bp, bp, this.sequence.length);
            }
            if (deletedROI) {
                this.features.removeInvalid(roiValidator);
                this.fireEvents(new ChangeEvent(102));
            }
            this.fireEvents(new ChangeEvent(4), new ChangeEvent(10));
            return true;
        }
        return false;
    }

    public boolean delete(int start, int stop) {
        if (this.sequence.remove(--start, --stop)) {
            for (int index = stop + 1; index < this.sequence.length; ++index) {
                this.genAA(index);
            }
            if (start > 0) {
                this.genAA(start - 1);
                if (start > 1) {
                    this.genAA(start - 2);
                }
            }
            ++start;
            ++stop;
            boolean deletedROI = false;
            for (ROI roi : this.features) {
                if (!roi.isValid()) continue;
                deletedROI |= this.ROIdelRange(roi, start, stop, this.sequence.length);
            }
            if (deletedROI) {
                this.features.removeInvalid(roiValidator);
                this.fireEvents(new ChangeEvent(102));
            }
            this.fireEvents(new ChangeEvent(4), new ChangeEvent(10));
            return true;
        }
        return false;
    }

    public boolean replace(int index, char base) {
        return Base.isCharValid(base) ? this.replace(index, new Base(base)) : false;
    }

    public boolean replace(int index, Base newBase) {
        if (this.sequence.isIndexValid(--index)) {
            ((Base[])this.sequence.items)[index] = newBase;
            if (index < this.sequence.length - 3) {
                this.genAA(index);
            }
            if (index > 0) {
                this.genAA(index - 1);
                if (index > 1) {
                    this.genAA(index - 2);
                }
            }
            this.fireEvents(new ChangeEvent(4), new ChangeEvent(10));
            return true;
        }
        return false;
    }

    public boolean replace(int repStart, int repLength, String replacement) {
        String filtered = DNA.filterSequence(replacement);
        Base[] insBases = Base.toBaseArray(filtered.toCharArray());
        return this.replace(repStart, repLength, insBases);
    }

    public boolean replace(int repStart, int repLength, Base ... replacementBases) {
        boolean adjustROI;
        boolean deletedROI = false;
        boolean bl = adjustROI = repStart < this.sequence.length;
        if (this.sequence.replace(--repStart, repLength, (Base[])replacementBases)) {
            int repBaseLen = replacementBases != null ? replacementBases.length : 0;
            for (int x = repStart; x < this.sequence.length; ++x) {
                this.genAA(x);
            }
            if (repStart > 0) {
                this.genAA(repStart - 1);
                if (repStart > 1) {
                    this.genAA(repStart - 2);
                }
            }
            if (adjustROI) {
                int replaceEnd = repStart + repLength;
                ++repStart;
                for (ROI roi : this.features) {
                    if (!roi.isValid()) continue;
                    if (repLength > 0 && this.ROIdelRange(roi, repStart, replaceEnd, this.sequence.length)) {
                        deletedROI = true;
                    }
                    if (repBaseLen <= 0) continue;
                    this.ROIinsert(roi, repStart, repBaseLen);
                }
            }
            if (deletedROI) {
                this.features.removeInvalid(roiValidator);
                this.fireEvents(new ChangeEvent(102), new ChangeEvent(4), new ChangeEvent(10));
            } else {
                this.fireEvents(new ChangeEvent(4), new ChangeEvent(10));
            }
            return true;
        }
        return false;
    }

    protected void genAA(int cIndex) {
        if (cIndex < this.sequence.length - 2 && ((Base[])this.sequence.items)[cIndex] != null && ((Base[])this.sequence.items)[cIndex + 1] != null && ((Base[])this.sequence.items)[cIndex + 2] != null) {
            ((Base[])this.sequence.items)[cIndex].AA = this.codonTable.translateCodonX(((Base[])this.sequence.items)[cIndex].base, ((Base[])this.sequence.items)[cIndex + 1].base, ((Base[])this.sequence.items)[cIndex + 2].base);
        } else if (((Base[])this.sequence.items)[cIndex] != null) {
            ((Base[])this.sequence.items)[cIndex].AA = null;
        }
        if (cIndex > 1 && ((Base[])this.sequence.items)[cIndex] != null && ((Base[])this.sequence.items)[cIndex - 1] != null && ((Base[])this.sequence.items)[cIndex - 2] != null) {
            ((Base[])this.sequence.items)[cIndex].aAA = this.codonTable.translateCodonX(((Base[])this.sequence.items)[cIndex].aBase, ((Base[])this.sequence.items)[cIndex - 1].aBase, ((Base[])this.sequence.items)[cIndex - 2].aBase);
        } else if (((Base[])this.sequence.items)[cIndex] != null) {
            ((Base[])this.sequence.items)[cIndex].aAA = null;
        }
    }

    public String getGenbankHeader() {
        String dataType = "dsDNA";
        StringBuilder sb = new StringBuilder();
        String date = new SimpleDateFormat("MM-dd-yyyy").format(new Date(System.currentTimeMillis()));
        sb.append("LOCUS        ").append(this.name).append("        ").append(this.sequence.length).append(" bp       ").append(dataType).append("        ").append(this.circular ? "circular      " : "linear      ").append(date).append("\nACCESSION    ").append(this.accession != null && this.accession.length() > 0 ? this.accession : ".").append("\nSOURCE       ").append(this.source).append("\nORGANISM     ").append(this.organism).append("\nCOMMENT Project Codon Table = ").append(this.codonTable.getOrganismName());
        return sb.toString();
    }

    public String getGenbankAnnotations() {
        StringBuilder sb = new StringBuilder();
        sb.append("FEATURES             Location/Qualifiers");
        if (this.features.length > 0) {
            for (ROI roi : this.features) {
                if (roi == null) continue;
                sb.append("\n").append(roi.toGBString());
            }
        }
        return sb.toString();
    }

    public String getGenbankSequence() {
        StringBuilder sb = new StringBuilder();
        sb.append("ORIGIN\n");
        sb.append(DNA.getFormattedSequence(this.getSequence(), 10));
        sb.append("//");
        return sb.toString();
    }

    private boolean ROIdelRange(Locus locus, int delStart, int delStop, int parentSeqLen) {
        int stop;
        if (!locus.isValid()) {
            return false;
        }
        int delLen = delStop - delStart + 1;
        int start = locus.getStart();
        if (start > (stop = locus.getStop())) {
            if (delStart <= delStop) {
                if (delStart >= start) {
                    return false;
                }
                if (delStart < start && delStop < start) {
                    locus.setStart(locus.getStart() - delLen);
                } else if (delStart < start && delStop >= start) {
                    if (delStop == this.sequence.length - 1) {
                        locus.setStart(0);
                    } else {
                        locus.setStart(delStart);
                    }
                }
                if (delStart <= stop && delStop >= stop) {
                    if (delStart == 0) {
                        locus.setStop(this.sequence.length - 1);
                    } else {
                        locus.setStop(delStart - 1);
                    }
                } else if (delStart <= stop && delStop <= stop) {
                    locus.setStop(delStart);
                } else if (delStart <= stop && delStop >= start) {
                    locus.setStart(delStart);
                    locus.setStop(delStart - 1);
                }
            } else if (delStart > delStop) {
                if (delStart <= start && delStop >= stop) {
                    locus.invalidate();
                } else if (delStart <= start && delStop < stop) {
                    locus.setStart(1);
                    locus.setStop(stop - delStop);
                } else if (delStop < stop) {
                    locus.setStop(stop - delStop);
                } else if (delStop >= stop) {
                    locus.setStop(parentSeqLen);
                }
            }
        } else if (delStart >= start && delStop < stop) {
            locus.setStop(stop - delLen);
        } else if (delStart <= start) {
            if (delStop < start) {
                locus.setStart(start - delLen);
                locus.setStop(stop - delLen);
            } else {
                if (delStop >= stop) {
                    locus.invalidate();
                    return true;
                }
                if (delStop < stop) {
                    locus.setStart(delStart);
                    locus.setStop(stop - delLen);
                }
            }
        } else if (delStart <= stop) {
            if (delStop >= stop) {
                locus.setStop(delStart - 1);
            } else {
                locus.setStop(stop - delLen);
            }
        }
        return false;
    }

    private void ROIinsert(ROI roi, int insStart, int insLen) {
        if (roi.isValid()) {
            int start = roi.getStart();
            int stop = roi.getStop();
            if (start >= insStart) {
                roi.setStart(start + insLen);
            }
            if (stop >= insStart) {
                roi.setStop(stop + insLen);
            }
        }
    }

    public boolean uppercase() {
        return DNASequenceDocument.main_uppercase(this.sequence, 1, this.sequence.length);
    }

    public boolean uppercase(int first, int last) {
        return DNASequenceDocument.main_uppercase(this.sequence, first, last);
    }

    public boolean lowercase() {
        return DNASequenceDocument.main_uppercase(this.sequence, 1, this.sequence.length);
    }

    public boolean lowercase(int first, int last) {
        return DNASequenceDocument.main_lowercase(this.sequence, first, last);
    }

    public SequenceExportFormat getSEF(int first, int last) {
        if (first < 1 || first > this.sequence.length + 1 || last < 1 || last > this.sequence.length + 1) {
            return null;
        }
        String seq = this.getSequenceMain(first - 1, last - 1, false);
        SequenceExportFormat fSel = new SequenceExportFormat(seq);
        fSel.qualifiers = this.genSEFQualifiers();
        fSel.name = this.name;
        fSel.circular = this.circular;
        fSel.annotations = first == 1 && last == this.sequence.length ? this.getAnnotations() : this.getAnnotations(first, last);
        return fSel;
    }

    protected Qualifier[] genSEFQualifiers() {
        return new Qualifier[]{new Qualifier("source", this.source), new Qualifier("organism", this.organism), new Qualifier("codon_table", this.codonTable.getOrganismName())};
    }

    private ROI[] getAnnotations(int start, int stop) {
        if (this.features.isEmpty()) {
            return null;
        }
        ArrayList<ROI> list = new ArrayList<ROI>();
        Locus selection = new Locus(start, stop, true);
        for (ROI f : this.features) {
            if (f == null) break;
            int fstart = f.getStart();
            int fstop = f.getStop();
            if (start > stop && fstart > selection.getStart() && fstart < selection.getStop() && fstop > selection.getStart() && fstop < selection.getStop()) {
                ROI roi = f.clone();
                roi.setStart(selection.getStart());
                Locus.adjustForSelection(roi, selection);
                list.add(roi);
                roi = f.clone();
                roi.setStop(selection.getStop());
                Locus.adjustForSelection(roi, selection);
                list.add(roi);
                continue;
            }
            if (!selection.intersects(f)) continue;
            ROI newSEF = f.clone();
            Locus.adjustForSelection(newSEF, selection);
            list.add(newSEF);
        }
        if (list.isEmpty()) {
            return null;
        }
        ROI[] outArray = new ROI[list.size()];
        int x = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ROI f;
            outArray[x] = f = (ROI)iterator.next();
            ++x;
        }
        return outArray;
    }

    private ROI[] getAnnotations() {
        if (this.features.isEmpty()) {
            return null;
        }
        ArrayList<ROI> list = new ArrayList<ROI>();
        for (ROI f : this.features) {
            if (f == null) break;
            ROI newSEF = f.clone();
            list.add(newSEF);
        }
        if (list.isEmpty()) {
            return null;
        }
        ROI[] outArray = new ROI[list.size()];
        int x = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ROI f;
            outArray[x] = f = (ROI)iterator.next();
            ++x;
        }
        return outArray;
    }

    protected Base[] getSequenceBaseArray() {
        return (Base[])this.sequence.items;
    }

    protected void regenAA() {
        for (int x = 0; x < this.sequence.length; ++x) {
            this.genAA(x);
        }
    }
}

