/*
 * Decompiled with CFR 0.152.
 */
package SequenceEditorPanels;

import SequenceEditorPanels.ExtensibleArrayValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public class ExtensibleArray<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int BUFFERSIZE = 250;
    protected int length = 0;
    protected T[] items;
    private Class<T> arrayClass;

    public int getFreeBufferSize() {
        return this.items.length - this.length;
    }

    public int getBufferSize() {
        return this.BUFFERSIZE;
    }

    public void setBufferSize(int size) {
        if (size > 0) {
            this.BUFFERSIZE = size;
        }
    }

    public int size() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public ExtensibleArray<T> clone() {
        ExtensibleArray<T> clone = new ExtensibleArray<T>(this.arrayClass);
        clone.length = this.length;
        if (this.length > 0) {
            clone.items = (Object[])Array.newInstance(this.arrayClass, this.length);
            System.arraycopy(this.items, 0, clone.items, 0, this.length);
        }
        return clone;
    }

    public void copyFrom(ExtensibleArray<T> src) {
        this.length = src.length;
        if (this.length > 0) {
            this.items = (Object[])Array.newInstance(this.arrayClass, this.length);
            System.arraycopy(src.items, 0, this.items, 0, this.length);
        } else {
            this.items = (Object[])Array.newInstance(this.arrayClass, this.BUFFERSIZE);
        }
    }

    public ExtensibleArray(Class<T> arrayClass) {
        this.arrayClass = arrayClass;
        this.items = (Object[])Array.newInstance(arrayClass, this.BUFFERSIZE);
    }

    public void clear() {
        this.items = (Object[])Array.newInstance(this.arrayClass, this.BUFFERSIZE);
        this.length = 0;
    }

    public boolean add(T item) {
        if (this.length + 1 >= this.items.length) {
            this.incArray(this.BUFFERSIZE);
        }
        this.items[this.length] = item;
        ++this.length;
        return true;
    }

    public boolean add(T ... item) {
        if (this.length + item.length >= this.items.length) {
            this.incArray(this.BUFFERSIZE + item.length);
        }
        System.arraycopy(item, 0, this.items, this.length, item.length);
        this.length += item.length;
        return true;
    }

    public boolean insert(T item, int index) {
        if (this.length == 0 || index == this.length) {
            this.add(item);
            return true;
        }
        this.shiftRight(index, 1);
        this.items[index] = item;
        return true;
    }

    public boolean replace(T item, int index) {
        if (index >= 0 && index < this.length) {
            this.items[index] = item;
            return true;
        }
        return false;
    }

    public boolean remove(T obj) {
        for (int x = 0; x < this.items.length; ++x) {
            if (this.items[x] != obj) continue;
            return this.remove(x);
        }
        return false;
    }

    public boolean remove(int index) {
        if (!this.isIndexValidToDelete(index)) {
            return false;
        }
        this.shiftLeft(index + 1, 1);
        return true;
    }

    public boolean remove(int start, int stop) {
        if (!this.isIndexValidToDelete(start, stop)) {
            return false;
        }
        this.shiftLeft(stop + 1, stop - start + 1);
        return true;
    }

    public T get(int index) {
        return this.isIndexValid(index) ? (T)this.items[index] : null;
    }

    public boolean replace(int replaceStart, int replacedLength, T[] replacementArray) {
        if (replacementArray == null || replacementArray.length == 0) {
            return this.remove(replaceStart, replacedLength);
        }
        int lenChange = replacementArray.length - replacedLength;
        if (replaceStart <= this.length && lenChange > 0) {
            if (!this.shiftRight(replaceStart, lenChange)) {
                return false;
            }
            System.arraycopy(replacementArray, 0, this.items, replaceStart, replacementArray.length);
            return true;
        }
        if (this.length + lenChange >= this.items.length) {
            this.incArray(lenChange + this.BUFFERSIZE);
            System.arraycopy(replacementArray, 0, this.items, replaceStart, replacementArray.length);
            return true;
        }
        if (lenChange < 0) {
            int oldEnd = replaceStart + replacedLength;
            this.shiftLeft(oldEnd, -lenChange);
            System.arraycopy(replacementArray, 0, this.items, replaceStart, replacementArray.length);
            return true;
        }
        if (lenChange == 0) {
            System.arraycopy(replacementArray, 0, this.items, replaceStart, replacementArray.length);
            return true;
        }
        return false;
    }

    boolean isIndexValid(int index) {
        return !this.isEmpty() && index > -1 && index < this.length && this.items[index] != null;
    }

    boolean isIndexValidToDelete(int index) {
        return this.length > 0 && index >= 0 && index < this.length && this.items != null && this.items[index] != null;
    }

    boolean isIndexValidToDelete(int start, int stop) {
        return this.length > 0 && start >= 0 && start < this.length && this.items != null && this.items[start] != null && stop >= 0 && stop < this.length && this.items[stop] != null;
    }

    public boolean insert(int index, T[] objects) {
        if (objects == null || objects.length == 0) {
            return false;
        }
        if (this.shiftRight(index, objects.length)) {
            System.arraycopy(objects, 0, this.items, index, objects.length);
        }
        return true;
    }

    protected boolean shiftRight(int index, int shiftCount) {
        if (shiftCount == 0) {
            return false;
        }
        int newStart = index + shiftCount;
        if (this.items.length > this.length + shiftCount) {
            if (this.length > 0) {
                System.arraycopy(this.items, index, this.items, newStart, this.length - index);
            }
            for (int x = index; x < newStart; ++x) {
                this.items[x] = null;
            }
        } else {
            Object[] tmp = (Object[])Array.newInstance(this.arrayClass, this.items.length + shiftCount);
            if (this.length > 0) {
                System.arraycopy(this.items, 0, tmp, 0, index);
                System.arraycopy(this.items, index, tmp, newStart, this.length - index);
            }
            this.items = tmp;
        }
        this.length += shiftCount;
        return true;
    }

    public boolean rotateTo(int index) {
        if (index < 1 || index > this.length - 1) {
            return false;
        }
        Object[] tmp = (Object[])Array.newInstance(this.arrayClass, this.items.length);
        System.arraycopy(this.items, index, tmp, 0, this.length - index);
        System.arraycopy(this.items, 0, tmp, this.length - index, index);
        this.items = tmp;
        return true;
    }

    protected boolean shiftLeft(int index, int shiftCount) {
        if (shiftCount == 0) {
            return false;
        }
        int newStop = this.length - shiftCount;
        System.arraycopy(this.items, index, this.items, index - shiftCount, this.length - index);
        for (int x = newStop; x < this.length; ++x) {
            this.items[x] = null;
        }
        this.length -= shiftCount;
        return true;
    }

    protected void incArray(int addedLength) {
        Object[] tmp = (Object[])Array.newInstance(this.arrayClass, this.items.length + addedLength);
        System.arraycopy(this.items, 0, tmp, 0, this.items.length);
        this.items = tmp;
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public void sort(Comparator c) {
        if (this.length > 1) {
            Arrays.sort(this.items, 0, this.length, c);
        }
    }

    public void removeInvalid(ExtensibleArrayValidator validator) {
        this.removeInvalid(0, validator);
    }

    public void removeInvalid(int startIndex, ExtensibleArrayValidator validator) {
        if (startIndex < 0 || startIndex > this.length || this.length == 0) {
            return;
        }
        int wIndex = 0;
        for (int rIndex = 0; rIndex < this.length; ++rIndex) {
            if (this.items[rIndex] != null && validator.isValid(this.items[rIndex])) {
                if (rIndex > wIndex) {
                    this.items[wIndex] = this.items[rIndex];
                    this.items[rIndex] = null;
                }
                ++wIndex;
                continue;
            }
            this.items[rIndex] = null;
        }
        this.length = wIndex;
    }

    public boolean contains(T obj) {
        return this.indexOf(obj) > -1;
    }

    public int indexOf(T obj) {
        for (int x = 0; x < this.length; ++x) {
            if (this.items[x] != obj) continue;
            return x;
        }
        return -1;
    }

    public synchronized T[] toArray() {
        return Arrays.copyOf(this.items, this.length);
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    public String toString() {
        return super.toString() + ", size: " + this.length;
    }

    public boolean swap(int index1, int index2) {
        if (index1 < 0 || index2 < 0 || index1 >= this.length || index2 >= this.length || index1 == index2) {
            return false;
        }
        T r1 = this.items[index1];
        this.items[index1] = this.items[index2];
        this.items[index2] = r1;
        return true;
    }

    public void squeeze() {
        if (this.length == 0) {
            this.clear();
        } else if (this.items.length > this.length + this.BUFFERSIZE) {
            Object[] newArray = (Object[])Array.newInstance(this.arrayClass, this.length + this.BUFFERSIZE);
            System.arraycopy(this.items, 0, newArray, 0, this.length);
            this.items = newArray;
        }
    }

    public void constrict() {
        if (this.length > 0) {
            Object[] newArray = (Object[])Array.newInstance(this.arrayClass, this.length);
            System.arraycopy(this.items, 0, newArray, 0, this.length);
            this.items = newArray;
        }
    }

    public void relax() {
        if (this.items.length < this.length + this.BUFFERSIZE) {
            Object[] newArray = (Object[])Array.newInstance(this.arrayClass, this.length + this.BUFFERSIZE);
            System.arraycopy(this.items, 0, newArray, 0, this.length);
            this.items = newArray;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int x = 0; x < this.length; ++x) {
            s.writeObject(this.items[x]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.clear();
        s.defaultReadObject();
        if (this.length > 0) {
            this.items = (Object[])Array.newInstance(this.arrayClass, this.length);
            for (int x = 0; x < this.length; ++x) {
                this.items[x] = s.readObject();
            }
        }
    }

    private class Itr
    implements Iterator<T> {
        int index = -1;

        @Override
        public boolean hasNext() {
            return ExtensibleArray.this.isIndexValid(this.index + 1);
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                return null;
            }
            ++this.index;
            return ExtensibleArray.this.items[this.index];
        }

        @Override
        public void remove() {
            if (this.index >= 0 && this.index < ExtensibleArray.this.length) {
                ExtensibleArray.this.remove(this.index);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            int cursor = this.index;
            Objects.requireNonNull(action);
            if (ExtensibleArray.this.isIndexValid(cursor)) {
                while (ExtensibleArray.this.isIndexValid(cursor)) {
                    action.accept(ExtensibleArray.this.items[++cursor]);
                }
            }
        }
    }
}

