/*
 * Decompiled with CFR 0.152.
 */
package SequenceEditorPanels;

import Sequences.SequenceExportFormat;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public abstract class FileSeqDandDHandler
extends TransferHandler {
    public boolean acceptFiles = true;
    public boolean acceptSeqs = true;
    Component donor;

    public FileSeqDandDHandler(Component donor) {
        this.donor = donor;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (this.acceptFiles && support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || this.acceptSeqs && support.isDataFlavorSupported(SequenceExportFormat.copiedSequenceFlavor)) {
            support.setShowDropLocation(true);
            return true;
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            if (this.acceptFiles && support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                this.droppedFiles(fileList, support.getDropLocation().getDropPoint().x, support.getDropLocation().getDropPoint().y);
                return true;
            }
            if (this.acceptSeqs && support.isDataFlavorSupported(SequenceExportFormat.copiedSequenceFlavor)) {
                SequenceExportFormat sequence = (SequenceExportFormat)support.getTransferable().getTransferData(SequenceExportFormat.copiedSequenceFlavor);
                this.droppedSequence(sequence, support.getDropLocation().getDropPoint().x, support.getDropLocation().getDropPoint().y);
                return true;
            }
            return false;
        }
        catch (UnsupportedFlavorException | IOException ex) {
            return false;
        }
    }

    public abstract void droppedFiles(List<File> var1, int var2, int var3);

    public abstract void droppedSequence(SequenceExportFormat var1, int var2, int var3);

    public static String getExtension(File file) {
        return FileSeqDandDHandler.getExtension(file.getName());
    }

    public static String getExtension(String filename) {
        int lestPer = filename.lastIndexOf(".");
        if (lestPer > -1) {
            return filename.substring(lestPer);
        }
        return "";
    }
}

