/*
 * Decompiled with CFR 0.152.
 */
package SequenceEditorPanels;

import JMScrollBars.JMScrollBar;
import ProteinTools.AminoAcid;
import ProteinTools.CodonTable;
import ScrollPanels.ScrollPanel;
import Sequences.DNA;
import ToolTip.BasicTextToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.beans.BeanProperty;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ProteinEditorPanel
extends ScrollPanel {
    public static boolean defShowFrame1 = true;
    public static boolean defShowFrame2 = true;
    public static boolean defShowFrame3 = true;
    public static boolean defShowAntisense = false;
    BasicTextToolTip toolTip;
    int org = 0;
    int offsetX = 0;
    int offsetY = 0;
    boolean changed = false;
    boolean showFrame1 = defShowFrame1;
    boolean showFrame2 = defShowFrame2;
    boolean showFrame3 = defShowFrame3;
    boolean showAntisense = defShowAntisense;
    boolean allowAAPopup = true;
    boolean allowCodonPopup = true;
    boolean showNumbers = false;
    char[] validChars = new char[127];
    boolean editable = true;
    int firstCodonNum = 1;
    final JPopupMenu aaMenu = new JPopupMenu();
    final JPopupMenu menu = new JPopupMenu();
    JMScrollBar hScroll;
    JMScrollBar vScroll;
    Font fontPlain;
    Font fontBold;
    Font menuFontPlain;
    Font menuFontBold;
    static final int CHAR_BUFFER_SIZE = 200;
    boolean insert = false;
    BufferedImage buffer;
    Graphics2D bufferGraphics;
    BufferedImage charBuffer;
    Graphics2D charGraphics;
    Color highlightColor = Color.BLUE;
    Color textColor = Color.BLACK;
    int buffersize = 2;
    int columns;
    int tmpColumns = this.columns = 20;
    boolean singleRow = false;
    int left = 0;
    int right = 0;
    int top = 0;
    int rows = 0;
    int charHt = 0;
    int charWd = 0;
    int charHt34 = 0;
    int boundWd = 0;
    int boundHt = 0;
    Codon current = null;
    int currentPos = 0;
    int currentIndex = -1;
    Codon[] codons = null;
    int codonCount = 0;
    CodonTable codonTable = new CodonTable();
    Color backColor;
    int panelHeight = 0;
    int panelWidth = 0;
    int bpOffset = 1;

    public ProteinEditorPanel() {
        this.hScroll = this.getHScrollBar();
        this.vScroll = this.getVScrollBar();
        this.init();
        this.setDNASequence("");
    }

    private void init() {
        this.fontPlain = new Font("Monospaced", 0, 18);
        this.fontBold = this.fontPlain.deriveFont(1);
        this.menuFontPlain = this.aaMenu.getFont().deriveFont(0);
        this.menuFontBold = this.menuFontPlain.deriveFont(1);
        this.setCharsValid("ATGCatgc");
        this.populateAAMenu();
        this.displayPanel.setBackground(this.getBackground());
        this.toolTip = new BasicTextToolTip((Component)this.displayPanel, "");
        this.toolTip.setShowOnPress(true);
        this.toolTip.setHideOnDrag(false);
        this.toolTip.setOpacity(0.95f);
        this.toolTip.setFadeIn(true);
        this.toolTip.setFadeStep(0.05f);
    }

    public void setToolTipRounded(boolean rounded) {
        this.toolTip.setRounded(rounded);
    }

    public boolean isToolTipRounded() {
        return this.toolTip.isRounded();
    }

    @BeanProperty(hidden=true)
    public void setDNASequence(String seq) {
        this.genCodons(DNA.filterSequence(seq));
        this.current = this.codons[0];
        this.currentIndex = 0;
        this.charWd = 0;
        this.buffer = null;
        this.repaint();
    }

    @BeanProperty(hidden=true)
    public void setDNASequence(DNA seq) {
        this.genCodons(DNA.filterSequence(seq.getSequence()));
        this.current = this.codons[0];
        this.currentIndex = 0;
        this.charWd = 0;
        this.buffer = null;
        this.repaint();
    }

    public CodonTable getCodonTable() {
        return this.codonTable;
    }

    @BeanProperty(hidden=true)
    public void setAASequence(String seq) {
        String fseq = CodonTable.filterAA(seq);
        if (fseq.length() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < fseq.length(); ++x) {
                String codon = this.codonTable.getHighestCodon(fseq.charAt(x));
                sb.append(codon);
            }
            this.setDNASequence(sb.toString());
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setSpaceCodons(boolean space) {
        this.buffersize = space ? 2 : 0;
        this.charWd = 0;
        this.reDraw();
    }

    public boolean isSpaceCodons() {
        return this.buffersize > 0;
    }

    @BeanProperty(hidden=true)
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @BeanProperty(hidden=true)
    public void setOrganism(int org) {
        this.org = org;
        this.codonTable.setOrganism(org);
        this.populateAAMenu();
        if (this.codons != null && this.codonCount > 0) {
            for (int x = 0; x < this.codonCount; ++x) {
                if (this.codons[x] == null) {
                    return;
                }
                this.genAA(x);
            }
            this.reDraw();
        }
    }

    public int getCodonCount() {
        if (this.codons != null && this.codons.length > 0 && this.codons[0] != null) {
            return this.codonCount;
        }
        return 0;
    }

    public int getSelected() {
        return this.currentIndex;
    }

    @BeanProperty(hidden=true)
    public void setSelected(int index) {
        if (this.isIndexValid(index)) {
            this.setCurrentCodon(index, 0, 0, -1);
        }
    }

    @BeanProperty(hidden=true)
    public void setSelectedBp(int index) {
        this.setSelected(DNA.bpNumToCodonNumber(index));
    }

    public void showNumbers(boolean show) {
        this.showNumbers = show;
        this.charWd = 0;
        this.buffer = null;
        this.repaint();
    }

    @BeanProperty(hidden=true)
    public void setCharValid(char chr) {
        if (chr > '\u0000' && chr < this.validChars.length) {
            this.validChars[chr] = '\u0001';
        }
    }

    @BeanProperty(hidden=true)
    public void setCharInvalid(char chr) {
        if (chr > '\u0000' && chr < this.validChars.length) {
            this.validChars[chr] = '\u0000';
        }
    }

    public void setCharsValid(String chars) {
        for (int x = 0; x < chars.length(); ++x) {
            this.setCharValid(chars.charAt(x));
        }
    }

    public void setCharsInvalid(String chars) {
        for (int x = 0; x < chars.length(); ++x) {
            this.setCharInvalid(chars.charAt(x));
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setSingleRow(boolean singleRowOnly) {
        if (this.singleRow == singleRowOnly) {
            return;
        }
        this.singleRow = singleRowOnly;
        this.charWd = 0;
        this.buffer = null;
        if (this.singleRow) {
            this.tmpColumns = this.columns;
            this.columns = this.codonCount;
        } else {
            this.columns = this.tmpColumns;
        }
        this.reDraw();
    }

    public boolean getSingleRow() {
        return this.singleRow;
    }

    public void setColumnCount(int count) {
        if (count < 1) {
            return;
        }
        this.singleRow = false;
        if (this.columns != count) {
            this.columns = count;
            this.charWd = 0;
            this.buffer = null;
            this.calcScrollBars();
            this.reDraw();
        }
    }

    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public void setForeground(Color color) {
        this.textColor = color;
        this.buffer = null;
        super.setForeground(color);
    }

    @Override
    public Color getBackground() {
        return this.backColor;
    }

    @Override
    public void setBackground(Color color) {
        this.buffer = null;
        this.backColor = color;
        super.setBackground(color);
    }

    public void setActiveCodonColor(Color color) {
        this.highlightColor = color;
        this.repaint();
    }

    public Color getActiveCodonColor() {
        return this.highlightColor;
    }

    public void setShowFrame1(boolean show) {
        this.showFrame1 = show;
        this.charWd = 0;
        this.reDraw();
    }

    public void setShowFrame2(boolean show) {
        this.showFrame2 = show;
        this.charWd = 0;
        this.reDraw();
    }

    public void setShowFrame3(boolean show) {
        this.showFrame3 = show;
        this.charWd = 0;
        this.reDraw();
    }

    public void setShowAntisense(boolean show) {
        this.showAntisense = show;
        this.charWd = 0;
        this.reDraw();
    }

    public void setShowNumbers(boolean show) {
        this.showNumbers = show;
        this.charWd = 0;
        this.reDraw();
    }

    public boolean isShowFrame1() {
        return this.showFrame1;
    }

    public boolean isShowFrame2() {
        return this.showFrame2;
    }

    public boolean isShowFrame3() {
        return this.showFrame3;
    }

    public boolean isShowAntisense() {
        return this.showAntisense;
    }

    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    public String getDNASequence() {
        if (this.codons == null || this.codonCount == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (Codon codon : this.codons) {
            if (codon == null) continue;
            if (codon.codon[0] != '\u0000') {
                outSequence.append(codon.codon[0]);
            }
            if (codon.codon[1] != '\u0000') {
                outSequence.append(codon.codon[1]);
            }
            if (codon.codon[2] == '\u0000') continue;
            outSequence.append(codon.codon[2]);
        }
        return outSequence.toString();
    }

    public String getAASequence() {
        if (this.codons == null || this.codonCount == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (Codon codon : this.codons) {
            if (codon == null || codon.AA == null) continue;
            outSequence.append(codon.AA.getAbbr1());
        }
        return outSequence.toString();
    }

    public String getAASequence2() {
        if (this.codons == null || this.codonCount == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (Codon codon : this.codons) {
            if (codon == null || codon.AA == null) continue;
            outSequence.append(codon.AA.getAbbr1()).append("  ");
        }
        return outSequence.toString();
    }

    public String getAAASequence() {
        if (this.codons == null || this.codonCount == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (Codon codon : this.codons) {
            if (codon == null || codon.AA == null) continue;
            outSequence.append(codon.AA.getAbbr3());
        }
        return outSequence.toString();
    }

    private int getRow() {
        if (this.current != null) {
            return Math.min(Math.max((this.current.boundingRect.y - this.top + this.offsetY) / this.boundHt, 0), this.rows - 1);
        }
        return -1;
    }

    private int getCol() {
        if (this.current != null) {
            return Math.min(Math.max((this.current.boundingRect.x - this.left + this.offsetX) / this.boundWd, 0), this.columns - 1);
        }
        return -1;
    }

    private int getRow(int y) {
        return Math.min(Math.max((y - this.top + this.offsetY) / this.boundHt, 0), this.rows - 1);
    }

    private int getCol(int x) {
        return Math.min(Math.max((x - this.left + this.offsetX) / this.boundWd, 0), this.columns - 1);
    }

    private int getCodonIndex(int x, int y) {
        int index = this.getCol(x) + this.getRow(y) * this.columns;
        return Math.max(Math.min(index, this.codonCount), 0);
    }

    private Position getCodonXY(int codonIndex) {
        int row = codonIndex / this.columns;
        int col = codonIndex - row * this.columns;
        return new Position(this.left + col * this.boundWd, this.top + row * this.boundHt);
    }

    private void setCodonDimensions(int codonIndex) {
        int row = codonIndex / this.columns;
        int col = codonIndex - row * this.columns;
        this.codons[codonIndex].boundingRect.x = this.left + col * this.boundWd;
        this.codons[codonIndex].boundingRect.y = this.top + row * this.boundHt;
        this.codons[codonIndex].boundingRect.width = this.boundWd;
        this.codons[codonIndex].boundingRect.height = this.boundHt;
    }

    void populateAAMenu() {
        this.aaMenu.removeAll();
        for (int cIndex = 0; cIndex < AminoAcid.Abbr1.length; ++cIndex) {
            this.aaMenu.add(this.getMenuForAA(AminoAcid.Abbr1[cIndex], "Set AA to " + AminoAcid.Abbr3[cIndex] + " (" + AminoAcid.Abbr1[cIndex] + ")"));
        }
    }

    JMenu getMenuForAA(char aa, String title) {
        String[] altCodons = this.codonTable.getCodonsForAA(aa);
        JMenu menu = new JMenu(title);
        if (altCodons != null && altCodons.length > 0) {
            for (int cIndex = 0; cIndex < altCodons.length; ++cIndex) {
                JMenuItem item = new JMenuItem(altCodons[cIndex] + " (" + this.codonTable.getCodonFrequency(altCodons[cIndex]) + "%)");
                item.addActionListener(new AAActionListener(altCodons[cIndex]));
                menu.add(item);
            }
        }
        return menu;
    }

    @Override
    public void displayPanelMouseWheelMoved(MouseWheelEvent e) {
        if (!e.isControlDown() && this.vScroll.isVisible()) {
            if (e.getWheelRotation() > 0) {
                this.vScroll.setValue(Math.min(this.vScroll.getValue() + (long)this.boundHt, this.vScroll.getMaximum()));
            } else {
                this.vScroll.setValue(Math.max(this.vScroll.getValue() - (long)this.boundHt, this.vScroll.getMinimum()));
            }
        } else if (this.hScroll.isVisible()) {
            if (e.getWheelRotation() > 0) {
                this.hScroll.setValue(Math.min(this.hScroll.getValue() + (long)this.boundWd, this.hScroll.getMaximum()));
            } else {
                this.hScroll.setValue(Math.max(this.hScroll.getValue() - (long)this.boundWd, this.hScroll.getMinimum()));
            }
        }
    }

    @Override
    public void displayPanelMouseDragged(MouseEvent e) {
        this.setCurrentCodon(e.getX(), e.getY(), 1);
    }

    @Override
    public void displayPanelMouseMoved(MouseEvent e) {
    }

    @Override
    public void displayPanelMousePressed(MouseEvent e) {
        this.requestFocus();
        this.setCurrentCodon(e.getX(), e.getY(), e.getButton());
    }

    @Override
    public void displayPanelResized(int width, int height) {
        this.calcScrollBars();
    }

    @Override
    public boolean displayPanelKeyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 155: {
                boolean bl = this.insert = !this.insert;
                if (this.current != null) {
                    this.current.draw((Graphics2D)this.displayPanel.getGraphics(), true);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean displayPanelKeyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                if (e.isControlDown()) {
                    this.shiftCodon(-1, 0);
                    break;
                }
                if (this.currentPos == 0) {
                    this.shiftCodon(-1, 2);
                    break;
                }
                --this.currentPos;
                if (this.checkVisibility()) break;
                this.repaint();
                break;
            }
            case 39: {
                if (e.isControlDown() || this.currentPos == 2) {
                    this.shiftCodon(1, 0);
                    break;
                }
                if (this.current.codon[this.currentPos] <= '\u0000') break;
                ++this.currentPos;
                if (this.checkVisibility()) break;
                this.repaint();
                break;
            }
            case 38: {
                this.shiftCodon(-this.columns, this.currentPos);
                break;
            }
            case 40: {
                this.shiftCodon(this.columns, this.currentPos);
                break;
            }
            case 33: {
                this.shiftCodon(Math.max(this.columns * (-this.panelHeight / this.boundHt), -this.currentIndex), this.currentPos);
                break;
            }
            case 34: {
                this.shiftCodon(Math.min(this.columns * (this.panelHeight / this.boundHt), this.codonCount - this.currentIndex), this.currentPos);
                break;
            }
            case 36: {
                if (e.isControlDown() || e.isMetaDown()) {
                    this.currentIndex = 0;
                    this.current = this.codons[this.currentIndex];
                    this.currentPos = 0;
                    if (this.checkVisibility()) break;
                    this.repaint();
                    break;
                }
                this.setCurrentCodon(-this.offsetX, this.current.boundingRect.y - this.offsetY, 0);
                break;
            }
            case 35: {
                if (e.isControlDown() || e.isMetaDown()) {
                    this.currentIndex = this.codonCount - 1;
                    this.current = this.codons[this.currentIndex];
                    this.currentPos = this.codons[this.currentIndex].getLastCodonPos() + 1;
                    if (this.checkVisibility()) break;
                    this.repaint();
                    break;
                }
                this.setCurrentCodon((int)((long)this.panelWidth + this.hScroll.getMaximum()), this.current.boundingRect.y - this.offsetY, 0);
                break;
            }
            case 127: {
                if (this.currentIndex == this.codonCount - 1 && this.current.codon[this.currentPos] == '\u0000') break;
                this.delNt();
                this.changed = true;
                this.reDraw();
                break;
            }
            case 8: {
                if (this.currentIndex == 0 && this.currentPos == 0) break;
                if (this.currentPos == 0) {
                    --this.currentIndex;
                    this.current = this.codons[this.currentIndex];
                    this.currentPos = 2;
                } else {
                    --this.currentPos;
                }
                this.delNt();
                this.changed = true;
                this.reDraw();
                break;
            }
            default: {
                if (this.current == null || e.isControlDown() || e.isAltGraphDown() || e.isMetaDown()) break;
                return this.current.keyPressed(e.getKeyChar());
            }
        }
        return false;
    }

    @Override
    public void hScrollValueChanged(long newValue) {
        this.offsetX = (int)newValue;
        this.reDraw();
    }

    @Override
    public void vScrollValueChanged(long newValue) {
        this.offsetY = (int)newValue;
        this.reDraw();
    }

    ProteinEditorPanel me() {
        return this;
    }

    @BeanProperty(preferred=true, description="The background color of the main display panel.")
    public void setDisplayPanelBackground(Color color) {
        this.backColor = color;
        if (this.displayPanel != null) {
            this.displayPanel.setBackground(color);
        }
    }

    @Override
    public void customDisplayPaint(Graphics g, int width, int height) {
        if (this.buffer == null || width != this.panelWidth || height != this.panelHeight) {
            this.panelHeight = height;
            this.panelWidth = width;
            this.buffer = new BufferedImage(width, height, 6);
            this.bufferGraphics = (Graphics2D)this.buffer.getGraphics();
            this.bufferGraphics.setColor(this.backColor);
            this.bufferGraphics.fillRect(0, 0, this.panelWidth, this.panelHeight);
            this.bufferGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.bufferGraphics.setFont(this.fontPlain);
            if (this.charWd == 0) {
                FontMetrics fm = this.bufferGraphics.getFontMetrics();
                this.charWd = fm.charWidth(' ');
                this.boundWd = this.buffersize * 2 + this.charWd * 3;
                this.charHt = fm.getAscent() + fm.getDescent() + fm.getLeading();
                this.charHt34 = this.charHt * 3 / 4;
                this.boundHt = this.buffersize * 2 + this.charHt;
                if (this.showFrame1) {
                    this.boundHt += this.charHt34;
                }
                if (this.showFrame2) {
                    this.boundHt += this.charHt34;
                }
                if (this.showFrame3) {
                    this.boundHt += this.charHt34;
                }
                if (this.showAntisense) {
                    this.boundHt += this.charHt34;
                }
                this.left = this.showNumbers ? this.boundWd * 2 : this.boundWd;
                this.right = this.left + this.boundWd * this.columns;
                this.top = this.boundWd / 2;
                this.charBuffer = new BufferedImage(this.boundWd, this.boundHt, 6);
                this.charGraphics = (Graphics2D)this.charBuffer.getGraphics();
                this.charGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                if (this.codons != null) {
                    for (int cIndex = 0; cIndex < this.codonCount; ++cIndex) {
                        if (this.codons[cIndex] == null) continue;
                        this.setCodonDimensions(cIndex);
                    }
                    this.calcScrollBars();
                }
            }
            this.charGraphics.setFont(this.fontPlain);
            int startIndex = this.getCodonIndex(0, 0);
            int stopIndex = Math.min(this.getCodonIndex(this.panelWidth, this.panelHeight), this.codonCount - 1);
            if (this.codons != null && this.bufferGraphics != null) {
                for (int cIndex = startIndex; cIndex <= stopIndex; ++cIndex) {
                    if (this.codons[cIndex] == null) continue;
                    this.codons[cIndex].draw(this.bufferGraphics);
                }
            }
        }
        Graphics2D g2d = (Graphics2D)g;
        g.drawImage(this.buffer, 0, 0, this);
        if (this.current != null) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.current.draw(g2d, true);
        }
    }

    private boolean isCharValid(char chr) {
        return chr > '\u0000' && chr < this.validChars.length && this.validChars[chr] == '\u0001';
    }

    private void delNt() {
        int srcIndex = this.currentIndex;
        if (this.currentPos == 1) {
            this.current.codon[1] = this.current.codon[2];
            if (!this.isIndexValid(this.currentIndex + 1)) {
                this.current.codon[2] = '\u0000';
                this.genAA(srcIndex);
                if (srcIndex > 0) {
                    this.genAA(srcIndex - 1);
                }
                return;
            }
            this.current.codon[2] = this.codons[this.currentIndex + 1].codon[0];
            this.genAA(srcIndex);
            ++srcIndex;
        } else if (this.currentPos == 2) {
            if (this.currentIndex + 1 >= this.codonCount || this.codons[this.currentIndex + 1] == null) {
                this.current.codon[2] = '\u0000';
                return;
            }
            this.current.codon[2] = this.codons[this.currentIndex + 1].codon[0];
            this.genAA(srcIndex);
            ++srcIndex;
        }
        for (int x = srcIndex; x < this.codonCount; ++x) {
            this.codons[x].codon[0] = this.codons[x].codon[1];
            this.codons[x].codon[1] = this.codons[x].codon[2];
            if (x + 1 < this.codonCount && this.codons[x + 1] != null) {
                this.codons[x].codon[2] = this.codons[x + 1].codon[0];
                this.genAA(x);
                continue;
            }
            this.codons[x].codon[2] = '\u0000';
            this.genAA(x);
        }
        if (this.currentIndex > 0) {
            this.genAA(this.currentIndex - 1);
        }
        if (this.codonCount > 2 && this.codons[this.codonCount - 2].getLastCodonPos() < 2) {
            this.codons[this.codonCount - 1] = null;
            --this.codonCount;
            if (this.singleRow) {
                this.columns = this.codonCount;
            }
        }
        this.calcScrollBars();
    }

    private void insNt(char chr) {
        if (this.codons[this.codonCount - 1].codon[2] > '\u0000') {
            this.append(new Codon());
        }
        for (int x = this.codonCount - 1; x > this.currentIndex; --x) {
            this.codons[x].codon[2] = this.codons[x].codon[1];
            this.codons[x].codon[1] = this.codons[x].codon[0];
            this.codons[x].codon[0] = this.codons[x - 1].codon[2];
            this.genAA(x);
        }
        switch (this.currentPos) {
            case 0: {
                this.current.codon[2] = this.current.codon[1];
                this.current.codon[1] = this.current.codon[0];
                this.current.codon[0] = chr;
                break;
            }
            case 1: {
                this.current.codon[2] = this.current.codon[1];
                this.current.codon[1] = chr;
                break;
            }
            case 2: {
                this.current.codon[2] = chr;
            }
        }
        this.genAA(this.currentIndex);
        if (this.currentIndex > 0) {
            this.genAA(this.currentIndex - 1);
        }
        this.verifyTerminalCodon();
        this.calcScrollBars();
    }

    private void verifyTerminalCodon() {
        if (this.codons == null) {
            this.reset();
        }
        if (this.codonCount == 0 || this.codons.length > 0 && this.codons[this.codonCount - 1].getLastCodonPos() == 2) {
            this.append(new Codon());
        }
    }

    private Codon append() {
        Codon codon = new Codon();
        this.append(codon);
        return codon;
    }

    private Codon append(Codon codon) {
        if (this.codonCount >= this.codons.length) {
            Codon[] tmp = new Codon[this.codons.length + 200];
            System.arraycopy(this.codons, 0, tmp, 0, this.codons.length);
            this.codons = tmp;
        }
        this.codons[this.codonCount] = codon;
        this.setCodonDimensions(this.codonCount);
        ++this.codonCount;
        if (this.singleRow) {
            this.columns = this.codonCount;
            this.calcScrollBars();
        }
        return codon;
    }

    private void shiftCodon(int shift) {
        this.shiftCodon(shift, this.currentPos);
    }

    private void shiftCodon(int shift, int codonPos) {
        if (this.currentIndex + shift >= this.codonCount) {
            if (this.codons[this.codonCount - 1].getLastCodonPos() == 2) {
                this.append(new Codon());
                this.setCodonDimensions(this.codonCount - 1);
                this.currentIndex = this.codonCount - 1;
                this.current = this.codons[this.currentIndex];
                this.currentPos = 0;
            } else {
                this.currentIndex = this.codonCount - 1;
                this.current = this.codons[this.currentIndex];
                this.currentPos = this.codons[this.codonCount - 1].getLastCodonPos() + 1;
            }
        } else {
            this.currentIndex += shift;
            if (this.currentIndex < 0) {
                this.currentIndex = 0;
                this.currentPos = 0;
            } else {
                this.current = this.codons[this.currentIndex];
            }
            this.currentPos = Math.max(Math.min(codonPos, this.codons[this.currentIndex].getLastCodonPos()), 0);
        }
        if (!this.checkVisibility()) {
            this.repaint();
        }
    }

    boolean checkVisibility() {
        boolean retVal = false;
        if (this.current != null) {
            if ((long)this.current.boundingRect.y < this.vScroll.getValue()) {
                this.vScroll.setValue(this.current.boundingRect.y);
                retVal = true;
            } else if (this.current.boundingRect.y + this.current.boundingRect.height > this.offsetY + this.panelHeight) {
                int newVal = this.current.boundingRect.y + this.current.boundingRect.height - this.panelHeight;
                this.vScroll.setValue(newVal);
                retVal = true;
            }
            if ((long)this.current.boundingRect.x < this.hScroll.getValue()) {
                this.hScroll.setValue(this.current.boundingRect.x);
                retVal = true;
            } else if (this.current.boundingRect.x + this.current.boundingRect.width > this.offsetX + this.panelWidth) {
                this.hScroll.setValue(this.current.boundingRect.x + this.current.boundingRect.width - this.panelWidth);
                retVal = true;
            }
        }
        return retVal;
    }

    void genAA(int cIndex) {
        this.codons[cIndex].AA = this.codonTable.translateCodon(this.codons[cIndex].codon[0], this.codons[cIndex].codon[1], this.codons[cIndex].codon[2]);
        if (cIndex < this.codonCount - 1) {
            AminoAcid tmpF2 = this.codonTable.translateCodon(this.codons[cIndex].codon[1], this.codons[cIndex].codon[2], this.codons[cIndex + 1].codon[0]);
            AminoAcid tmpF3 = this.codonTable.translateCodon(this.codons[cIndex].codon[2], this.codons[cIndex + 1].codon[0], this.codons[cIndex + 1].codon[1]);
            this.codons[cIndex].AA_Frame2 = tmpF2 != null ? tmpF2.abbr1 : (char)'\u0000';
            this.codons[cIndex].AA_Frame3 = tmpF3 != null ? tmpF3.abbr1 : (char)'\u0000';
        } else {
            this.codons[cIndex].AA_Frame2 = '\u0000';
            this.codons[cIndex].AA_Frame3 = '\u0000';
        }
    }

    void setCodon(int cIndex, String newCodon) {
        if (newCodon.length() == 3) {
            char chr0 = newCodon.charAt(0);
            char chr1 = newCodon.charAt(1);
            char chr2 = newCodon.charAt(2);
            this.codons[cIndex].codon[0] = chr0;
            this.codons[cIndex].codon[1] = chr1;
            this.codons[cIndex].codon[2] = chr2;
        }
        this.genAA(cIndex);
        Graphics2D g2d = this.bufferGraphics;
        if (cIndex > 0) {
            this.genAA(cIndex - 1);
            this.codons[cIndex - 1].draw(this.bufferGraphics, false);
            this.codons[cIndex - 1].draw(g2d, false);
        }
        this.codons[cIndex].draw(this.bufferGraphics, false);
        this.codons[cIndex].draw(g2d, true);
    }

    boolean isIndexValid(int index) {
        return this.codonCount > 0 && index >= 0 && index < this.codonCount && this.codons != null && this.codons[index] != null;
    }

    boolean isBpIndexValid(int index) {
        int cIndex = index / 3;
        return this.codonCount > 0 && cIndex >= 0 && cIndex < this.codonCount && this.codons != null && this.codons[cIndex] != null;
    }

    public void uppercaseCodon(int index) {
        if (this.isIndexValid(index)) {
            this.codons[index].codon[0] = this.ucaseChar(this.codons[index].codon[0]);
            this.codons[index].codon[1] = this.ucaseChar(this.codons[index].codon[1]);
            this.codons[index].codon[2] = this.ucaseChar(this.codons[index].codon[2]);
            this.codons[index].draw(this.bufferGraphics);
            this.codons[index].draw(this.charGraphics, true);
            this.repaint();
        }
    }

    public void lowercaseCodon(int index) {
        if (this.isIndexValid(index)) {
            this.codons[index].codon[0] = this.lcaseChar(this.codons[index].codon[0]);
            this.codons[index].codon[1] = this.lcaseChar(this.codons[index].codon[1]);
            this.codons[index].codon[2] = this.lcaseChar(this.codons[index].codon[2]);
            this.codons[index].draw(this.bufferGraphics);
            this.codons[index].draw(this.charGraphics, true);
            this.repaint();
        }
    }

    public void uppercaseAll() {
        if (this.codonCount == 0) {
            return;
        }
        for (int index = 0; index < this.codonCount; ++index) {
            this.codons[index].codon[0] = this.ucaseChar(this.codons[index].codon[0]);
            this.codons[index].codon[1] = this.ucaseChar(this.codons[index].codon[1]);
            this.codons[index].codon[2] = this.ucaseChar(this.codons[index].codon[2]);
        }
        this.reDraw();
    }

    public void lowercaseAll() {
        if (this.codonCount == 0) {
            return;
        }
        for (int index = 0; index < this.codonCount; ++index) {
            this.codons[index].codon[0] = this.lcaseChar(this.codons[index].codon[0]);
            this.codons[index].codon[1] = this.lcaseChar(this.codons[index].codon[1]);
            this.codons[index].codon[2] = this.lcaseChar(this.codons[index].codon[2]);
        }
        this.reDraw();
    }

    private char ucaseChar(char chr) {
        return (char)(chr > 96 && chr < 123 ? chr - 32 : chr);
    }

    private char lcaseChar(char chr) {
        return (char)(chr > 64 && chr < 91 ? chr + 32 : chr);
    }

    private void reset() {
        this.current = null;
        this.codons = null;
        this.currentPos = 0;
        this.currentIndex = -1;
        this.codonCount = 0;
        this.codons = new Codon[200];
        if (this.toolTip != null) {
            this.toolTip.setText("");
        }
        this.hScroll.setValue(0);
        this.vScroll.setValue(0);
        this.hScroll.setMaximum(0L);
        this.vScroll.setMaximum(0L);
    }

    private void genCodons(String seq) {
        this.reset();
        int seqLen = seq.length();
        if (seqLen > 0) {
            int x;
            for (x = 0; x < seqLen; x += 3) {
                Codon codon = this.append();
                if (x < seqLen) {
                    codon.codon[0] = seq.charAt(x);
                }
                if (x + 1 < seqLen) {
                    codon.codon[1] = seq.charAt(x + 1);
                }
                if (x + 2 < seqLen) {
                    codon.codon[2] = seq.charAt(x + 2);
                }
                codon.aCodon[0] = this.complement(codon.codon[0]);
                codon.aCodon[1] = this.complement(codon.codon[1]);
                codon.aCodon[2] = this.complement(codon.codon[2]);
            }
            for (x = 0; x < this.codonCount; ++x) {
                this.genAA(x);
            }
            this.changed = false;
        }
        this.verifyTerminalCodon();
    }

    public void insert(String seq) {
        this.insert(seq, this.getCurrentBp());
    }

    public void insert(String seq, int bpPos) {
        String curSeq = this.getDNASequence();
        String fSeq = DNA.filterSequence(seq);
        if (fSeq.length() == 0) {
            return;
        }
        curSeq = curSeq == null || curSeq.length() == 0 ? fSeq : (bpPos < 2 ? fSeq + curSeq : (bpPos > curSeq.length() ? curSeq + fSeq : curSeq.substring(0, bpPos - 1) + fSeq + curSeq.substring(bpPos - 1)));
        int oldCIndex = this.currentIndex;
        int oldPos = this.currentPos;
        this.genCodons(curSeq);
        this.currentIndex = oldCIndex;
        this.current = this.codons[this.currentIndex];
        this.currentPos = oldPos;
        this.shiftBp(fSeq.length());
        this.charWd = 0;
        this.buffer = null;
        this.repaint();
    }

    private void shiftBp(int bpShift) {
        int bpCount = bpShift - 1;
        this.currentIndex += bpCount / 3;
        this.currentPos += bpCount % 3 + 1;
        if (this.currentPos > 2) {
            ++this.currentIndex;
            this.currentPos -= 3;
        }
        if (this.currentIndex >= this.codonCount) {
            this.currentIndex = this.codonCount - 1;
        }
        this.current = this.codons[this.currentIndex];
    }

    private int getCurrentBp() {
        if (this.codonCount == 0) {
            return -1;
        }
        return this.currentIndex * 3 + (this.currentPos + 1);
    }

    private String getCurrentToolTip() {
        String retVal = "";
        if (this.current != null) {
            if (this.current.codon[this.currentPos] == '\u0000') {
                return null;
            }
            if (this.current.AA == null || this.current.AA.abbr1 == '*') {
                return "Codon #" + (this.currentIndex + 1) + " (bp " + this.getBp() + ")";
            }
        }
        return retVal;
    }

    private int getBp() {
        return this.currentIndex * 3 + this.currentPos + 1;
    }

    private void setCurrentCodon(int clickX, int clickY, int button) {
        if (this.codons == null || this.codons.length == 0) {
            return;
        }
        this.setCurrentCodon(this.getCodonIndex(clickX, clickY), clickX, clickY, button);
    }

    private void setCurrentCodon(int index, int clickX, int clickY, int button) {
        if (index > -1) {
            if (this.codons[index] != null) {
                this.current = this.codons[index];
                this.currentIndex = index;
                if (button != -1 && clickX > -1 && clickY > -1) {
                    this.current.clicked(clickX + this.offsetX, clickY + this.offsetY, button);
                } else {
                    this.currentPos = 0;
                }
            }
            if (!this.checkVisibility()) {
                this.repaint();
            }
            if (button == 1) {
                String s = this.getCurrentToolTip();
                this.toolTip.setText(s);
                if (s != null) {
                    this.toolTip.show(clickX, clickY);
                }
            }
        }
    }

    public void reDraw() {
        this.buffer = null;
        this.bufferGraphics = null;
        this.repaint();
    }

    void calcScrollBars() {
        this.rows = this.codonCount / this.columns + 1;
        int vMax = this.rows * this.boundHt + this.top + this.hScroll.getHeight() - this.panelHeight;
        int hMax = this.columns * this.boundWd + this.left + this.boundWd + this.vScroll.getWidth() - this.panelWidth;
        if (hMax > 0 && vMax > 0) {
            this.setScrollBars(2);
            this.hScroll.setMaximum(hMax);
            this.hScroll.setBlockIncrement(this.boundHt);
            this.vScroll.setMaximum(vMax);
            this.vScroll.setBlockIncrement(this.boundWd);
            this.offsetY = (int)Math.min((long)this.offsetY, this.vScroll.getValue());
            this.offsetX = (int)Math.min((long)this.offsetX, this.hScroll.getValue());
        } else if (hMax > 0) {
            this.setScrollBars(0);
            if (this.vScroll.getValue() > 0L) {
                this.vScroll.setValue(0);
            }
            this.offsetY = 0;
            this.hScroll.setMaximum(hMax);
            this.hScroll.setBlockIncrement(this.boundHt);
            this.offsetX = (int)Math.min((long)this.offsetX, this.hScroll.getValue());
        } else if (vMax > 0) {
            this.setScrollBars(1);
            if (this.hScroll.getValue() > 0L) {
                this.hScroll.setValue(0);
            }
            this.offsetX = 0;
            this.vScroll.setMaximum(vMax);
            this.vScroll.setBlockIncrement(this.boundWd);
            this.offsetY = (int)Math.min((long)this.offsetY, this.vScroll.getValue());
        } else {
            this.setScrollBars(-1);
            if (this.vScroll.getValue() > 0L) {
                this.vScroll.setValue(0);
            }
            if (this.hScroll.getValue() > 0L) {
                this.hScroll.setValue(0);
            }
            this.offsetX = 0;
            this.offsetY = 0;
        }
    }

    char complement(char chr) {
        switch (chr) {
            case 'A': {
                return 'T';
            }
            case 'T': 
            case 'U': {
                return 'A';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'a': {
                return 't';
            }
            case 't': 
            case 'u': {
                return 'a';
            }
            case 'c': {
                return 'g';
            }
            case 'g': {
                return 'c';
            }
        }
        return '\u0000';
    }

    boolean compare(char chr1, char chr2) {
        return (chr1 > 96 && chr1 < 123 ? chr1 - 32 : chr1) == (chr2 > 96 && chr2 < 123 ? chr2 - 32 : chr2);
    }

    public String getDisplayedSequence() {
        String f1 = null;
        String f2 = null;
        String f3 = null;
        String as = null;
        String sense = this.getDNASequence2();
        if (!(this.showFrame1 || this.showFrame2 || this.showFrame3 || this.showAntisense)) {
            return sense;
        }
        if (this.showFrame1 || this.showFrame2 || this.showFrame3) {
            for (int x = 0; x < this.codonCount; ++x) {
                this.genAA(x);
            }
        }
        StringBuilder retVal = new StringBuilder();
        String tSeq = this.getDNASequence();
        if (this.showFrame1) {
            f1 = this.getAASeqF1();
        }
        if (this.showFrame2) {
            f2 = this.getAASeqF2();
        }
        if (this.showFrame3) {
            f3 = this.getAASeqF3();
        }
        if (this.showAntisense) {
            as = this.getCompSequence();
        }
        int charLen = this.buffersize > 0 ? this.columns * 4 : this.columns * 3;
        int maxlen = sense.length();
        for (int x = 0; x < sense.length() - charLen; x += charLen) {
            int start = Math.min(x, maxlen);
            int stop = Math.min(x + charLen, maxlen);
            if (x > 0) {
                retVal.append("\n\n");
            }
            retVal.append(sense.substring(start, stop));
            if (f1 != null) {
                retVal.append("\n").append(f1.substring(start, stop));
            }
            if (f2 != null) {
                retVal.append("\n").append(f2.substring(start, stop));
            }
            if (f3 != null) {
                retVal.append("\n").append(f3.substring(start, stop));
            }
            if (as == null) continue;
            retVal.append("\n").append(as.substring(start, stop));
        }
        return retVal.toString();
    }

    private String getAASeqF1() {
        if (this.codons == null || this.codonCount == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (Codon codon : this.codons) {
            if (codon == null || codon.AA == null) continue;
            if (this.buffersize > 0) {
                outSequence.append(codon.AA.abbr1).append("   ");
                continue;
            }
            outSequence.append(codon.AA.abbr1).append("  ");
        }
        return outSequence.toString();
    }

    private String getAASeqF2() {
        if (this.codons == null || this.codonCount == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (Codon codon : this.codons) {
            if (codon == null || codon.AA_Frame2 <= '\u0000') continue;
            if (this.buffersize > 0) {
                outSequence.append(" ").append(codon.AA_Frame2).append("  ");
                continue;
            }
            outSequence.append(" ").append(codon.AA_Frame2).append("  ");
        }
        return outSequence.toString();
    }

    private String getAASeqF3() {
        if (this.codons == null || this.codonCount == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (Codon codon : this.codons) {
            if (codon == null || codon.AA_Frame3 <= '\u0000') continue;
            if (this.buffersize > 0) {
                outSequence.append("  ").append(codon.AA_Frame3).append(" ");
                continue;
            }
            outSequence.append("  ").append(codon.AA_Frame3);
        }
        return outSequence.toString();
    }

    private String getDNASequence2() {
        if (this.codons == null || this.codonCount == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (Codon codon : this.codons) {
            if (codon == null) continue;
            if (codon.codon[0] != '\u0000') {
                outSequence.append(codon.codon[0]);
            }
            if (codon.codon[1] != '\u0000') {
                outSequence.append(codon.codon[1]);
            }
            if (codon.codon[2] == '\u0000') continue;
            outSequence.append(codon.codon[2]);
            if (this.buffersize <= 0) continue;
            outSequence.append(" ");
        }
        return outSequence.toString();
    }

    private String getCompSequence() {
        if (this.codons == null || this.codonCount == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (Codon codon : this.codons) {
            if (codon == null) continue;
            if (codon.codon[0] != '\u0000') {
                outSequence.append(this.complement(codon.codon[0]));
            }
            if (codon.codon[1] != '\u0000') {
                outSequence.append(this.complement(codon.codon[1]));
            }
            if (codon.codon[2] == '\u0000') continue;
            outSequence.append(this.complement(codon.codon[2]));
            if (this.buffersize <= 0) continue;
            outSequence.append(" ");
        }
        return outSequence.toString();
    }

    public void codonOptimize() {
        int x;
        for (x = 0; x < this.codonCount; ++x) {
            if (this.codons[x].AA == null) continue;
            String newCodon = this.codonTable.getHighestCodon(this.codons[x].AA.abbr1);
            this.codons[x].codon[0] = newCodon.charAt(0);
            this.codons[x].codon[1] = newCodon.charAt(1);
            this.codons[x].codon[2] = newCodon.charAt(2);
        }
        for (x = 0; x < this.codonCount; ++x) {
            this.genAA(x);
        }
        this.charWd = 0;
        this.reDraw();
    }

    class Codon {
        char[] codon = new char[]{'\u0000', '\u0000', '\u0000'};
        char[] aCodon = new char[]{'\u0000', '\u0000', '\u0000'};
        boolean translate1 = true;
        AminoAcid AA = null;
        char AA_Frame2 = '\u0000';
        char AA_Frame3 = '\u0000';
        final Rectangle boundingRect = new Rectangle();

        Codon() {
        }

        void draw(Graphics2D g) {
            this.draw(g, false);
        }

        void draw(Graphics2D g, boolean highlight) {
            int drawX = ProteinEditorPanel.this.buffersize;
            int drawY = ProteinEditorPanel.this.buffersize + ProteinEditorPanel.this.charHt34;
            ProteinEditorPanel.this.charGraphics.setColor(ProteinEditorPanel.this.backColor);
            ProteinEditorPanel.this.charGraphics.fillRect(0, 0, this.boundingRect.width, this.boundingRect.height);
            if (this.AA != null && this.AA.color != null) {
                ProteinEditorPanel.this.charGraphics.setColor(this.AA.color);
                ProteinEditorPanel.this.charGraphics.fillRect(0, 0, this.boundingRect.width, this.boundingRect.height);
            }
            ProteinEditorPanel.this.charGraphics.setColor(highlight ? ProteinEditorPanel.this.highlightColor : ProteinEditorPanel.this.textColor);
            ProteinEditorPanel.this.charGraphics.setFont(ProteinEditorPanel.this.fontPlain);
            int y = ProteinEditorPanel.this.buffersize + ProteinEditorPanel.this.charHt34;
            ProteinEditorPanel.this.charGraphics.drawChars(this.codon, 0, 3, ProteinEditorPanel.this.buffersize, y);
            ProteinEditorPanel.this.charGraphics.setFont(ProteinEditorPanel.this.fontBold);
            if (ProteinEditorPanel.this.showFrame1) {
                y += ProteinEditorPanel.this.charHt34;
                if (this.AA != null) {
                    ProteinEditorPanel.this.charGraphics.drawString("" + this.AA.abbr1, ProteinEditorPanel.this.buffersize, y);
                }
            }
            if (ProteinEditorPanel.this.showFrame2) {
                y += ProteinEditorPanel.this.charHt34;
                if (this.AA_Frame2 > '\u0000') {
                    ProteinEditorPanel.this.charGraphics.drawString("" + this.AA_Frame2, ProteinEditorPanel.this.buffersize + ProteinEditorPanel.this.charWd, y);
                }
            }
            if (ProteinEditorPanel.this.showFrame3) {
                y += ProteinEditorPanel.this.charHt34;
                if (this.AA_Frame3 > '\u0000') {
                    ProteinEditorPanel.this.charGraphics.drawString("" + this.AA_Frame3, ProteinEditorPanel.this.buffersize + ProteinEditorPanel.this.charWd + ProteinEditorPanel.this.charWd, y);
                }
            }
            if (ProteinEditorPanel.this.showAntisense) {
                this.aCodon[0] = ProteinEditorPanel.this.complement(this.codon[0]);
                this.aCodon[1] = ProteinEditorPanel.this.complement(this.codon[1]);
                this.aCodon[2] = ProteinEditorPanel.this.complement(this.codon[2]);
                ProteinEditorPanel.this.charGraphics.setFont(ProteinEditorPanel.this.fontPlain);
                ProteinEditorPanel.this.charGraphics.drawChars(this.aCodon, 0, 3, ProteinEditorPanel.this.buffersize, y += ProteinEditorPanel.this.charHt34);
            }
            if (highlight) {
                ProteinEditorPanel.this.charGraphics.setColor(ProteinEditorPanel.this.highlightColor);
                int uLineX = 0;
                switch (ProteinEditorPanel.this.currentPos) {
                    case 0: {
                        uLineX = drawX;
                        break;
                    }
                    case 1: {
                        uLineX = drawX + ProteinEditorPanel.this.charWd;
                        break;
                    }
                    case 2: {
                        uLineX = drawX + ProteinEditorPanel.this.charWd * 2;
                    }
                }
                int top = drawY + 2 - ProteinEditorPanel.this.charHt34;
                int bot = y + 2;
                if (!ProteinEditorPanel.this.insert) {
                    ProteinEditorPanel.this.charGraphics.drawRect(uLineX, top, ProteinEditorPanel.this.charWd, bot);
                } else {
                    ProteinEditorPanel.this.charGraphics.drawLine(uLineX, top, uLineX, bot);
                }
            }
            try {
                g.drawImage((Image)ProteinEditorPanel.this.charBuffer, this.boundingRect.x - ProteinEditorPanel.this.offsetX, this.boundingRect.y - ProteinEditorPanel.this.offsetY, null);
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
            }
        }

        void clicked(int x, int y, int button) {
            ProteinEditorPanel.this.current = this;
            ProteinEditorPanel.this.currentPos = x < this.boundingRect.x + ProteinEditorPanel.this.charWd + ProteinEditorPanel.this.buffersize || this.codon[0] == '\u0000' ? 0 : (x < this.boundingRect.x + ProteinEditorPanel.this.buffersize + ProteinEditorPanel.this.charWd * 2 || this.codon[1] == '\u0000' ? 1 : 2);
            ProteinEditorPanel.this.repaint();
            if (this.boundingRect.contains(x, y) && button == 3) {
                if (ProteinEditorPanel.this.allowAAPopup && (y > this.boundingRect.y + ProteinEditorPanel.this.charHt + ProteinEditorPanel.this.buffersize || this.AA == null)) {
                    ProteinEditorPanel.this.aaMenu.show(ProteinEditorPanel.this.me(), x - ProteinEditorPanel.this.offsetX, y - ProteinEditorPanel.this.offsetY);
                } else if (this.AA != null && this.AA.abbr1 != '\u0000') {
                    String[] altCodons = ProteinEditorPanel.this.codonTable.getCodonsForAA(this.AA.abbr1);
                    ProteinEditorPanel.this.menu.removeAll();
                    if (altCodons != null && altCodons.length > 1) {
                        for (int cIndex = 0; cIndex < altCodons.length; ++cIndex) {
                            JMenuItem item = new JMenuItem("Set codon to " + altCodons[cIndex] + " (" + ProteinEditorPanel.this.codonTable.getCodonFrequency(altCodons[cIndex]) + "%)");
                            item.addActionListener(new CodonActionListener(altCodons[cIndex]));
                            if (ProteinEditorPanel.this.compare(altCodons[cIndex].charAt(0), this.codon[0]) && ProteinEditorPanel.this.compare(altCodons[cIndex].charAt(1), this.codon[1]) && ProteinEditorPanel.this.compare(altCodons[cIndex].charAt(2), this.codon[2])) {
                                item.setFont(ProteinEditorPanel.this.menuFontBold);
                            } else {
                                item.setFont(ProteinEditorPanel.this.menuFontPlain);
                            }
                            ProteinEditorPanel.this.menu.add(item);
                        }
                        ProteinEditorPanel.this.menu.show(ProteinEditorPanel.this.me(), x - ProteinEditorPanel.this.offsetX, y - ProteinEditorPanel.this.offsetY);
                    }
                }
            }
        }

        boolean keyPressed(char chr) {
            if (!ProteinEditorPanel.this.editable) {
                return false;
            }
            ProteinEditorPanel.this.changed = true;
            if (ProteinEditorPanel.this.insert) {
                if (ProteinEditorPanel.this.isCharValid(chr)) {
                    ProteinEditorPanel.this.insNt(chr);
                    if (ProteinEditorPanel.this.currentPos == 2) {
                        ProteinEditorPanel.this.shiftCodon(1, 0);
                    } else {
                        ++ProteinEditorPanel.this.currentPos;
                    }
                    ProteinEditorPanel.this.reDraw();
                    return true;
                }
            } else if (ProteinEditorPanel.this.isCharValid(chr)) {
                if (this.codon[ProteinEditorPanel.this.currentPos] != chr) {
                    this.codon[ProteinEditorPanel.this.currentPos] = chr;
                    this.aCodon[ProteinEditorPanel.this.currentPos] = ProteinEditorPanel.this.complement(chr);
                    ProteinEditorPanel.this.genAA(ProteinEditorPanel.this.currentIndex);
                    if (ProteinEditorPanel.this.currentPos < 2 && ProteinEditorPanel.this.currentIndex > 0) {
                        ProteinEditorPanel.this.genAA(ProteinEditorPanel.this.currentIndex - 1);
                        ProteinEditorPanel.this.codons[ProteinEditorPanel.this.currentIndex - 1].draw(ProteinEditorPanel.this.bufferGraphics);
                        ProteinEditorPanel.this.codons[ProteinEditorPanel.this.currentIndex - 1].draw(ProteinEditorPanel.this.charGraphics);
                    }
                }
                this.draw(ProteinEditorPanel.this.bufferGraphics, false);
                if (ProteinEditorPanel.this.currentPos == 2) {
                    ProteinEditorPanel.this.shiftCodon(1, 0);
                } else {
                    ++ProteinEditorPanel.this.currentPos;
                }
                ProteinEditorPanel.this.repaint();
                return true;
            }
            return false;
        }

        public int getLastCodonPos() {
            if (this.codon[2] > '\u0000') {
                return 2;
            }
            if (this.codon[1] > '\u0000') {
                return 1;
            }
            if (this.codon[0] > '\u0000') {
                return 0;
            }
            return -1;
        }
    }

    class Position {
        int y = 0;
        int x = 0;

        public Position(int col, int row) {
            this.y = row;
            this.x = col;
        }
    }

    class AAActionListener
    implements ActionListener {
        public Codon target;
        public String newCodon;

        public AAActionListener(String newCodon) {
            this.newCodon = newCodon;
            ProteinEditorPanel.this.verifyTerminalCodon();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProteinEditorPanel.this.setCodon(ProteinEditorPanel.this.currentIndex, this.newCodon);
            ProteinEditorPanel.this.verifyTerminalCodon();
        }
    }

    class CodonActionListener
    implements ActionListener {
        public String newCodon;

        public CodonActionListener(String newCodon) {
            this.newCodon = newCodon;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProteinEditorPanel.this.setCodon(ProteinEditorPanel.this.currentIndex, this.newCodon);
        }
    }
}

