/*
 * Decompiled with CFR 0.152.
 */
package SequenceEditorPanels;

import Constants.MolBioConstants;
import DNATools.TmCalculator;
import GenbankFileReader.GenBankFile;
import JMScrollBars.JMScrollBar;
import ProteinTools.AminoAcid;
import ProteinTools.CodonTable;
import ScrollPanels.ScrollPanel;
import SequenceEditorPanels.AnnotationEditor;
import SequenceEditorPanels.Base;
import SequenceEditorPanels.CursorSelectionChangeListener;
import SequenceEditorPanels.DNASequenceDocument;
import SequenceEditorPanels.FrmROIEditor;
import SequenceEditorPanels.ROI;
import SequenceEditorPanels.SeqDragListener;
import SequenceEditorPanels.SequenceDocumentChangeListener;
import Sequences.DNA;
import Sequences.SequenceExportFormat;
import ToolTip.BasicTextToolTip;
import UndoRedo.ChangeEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.BeanProperty;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class SequenceEditorPanel
extends ScrollPanel
implements MolBioConstants,
SequenceDocumentChangeListener {
    public static boolean defShowFrame1 = true;
    public static boolean defShowFrame2 = true;
    public static boolean defShowFrame3 = true;
    public static boolean defShowFrameA1 = false;
    public static boolean defShowFrameA2 = false;
    public static boolean defShowFrameA3 = false;
    public static boolean defShowAntisense = false;
    private Base endBase = new Base();
    private DNASequenceDocument doc;
    private SeqDragListener dragListener;
    private int tmCalcType = 0;
    private CursorSelectionChangeListener listener = null;
    private Icon backIcon;
    HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
    VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    final SelectionCursor selection = new SelectionCursor(Color.cyan, 0, 0);
    BasicTextToolTip toolTip;
    private boolean autoColumnCount = false;
    private boolean showToolTip = true;
    int offsetX = 0;
    int offsetY = 0;
    boolean showFrame1 = defShowFrame1;
    boolean showFrame2 = defShowFrame2;
    boolean showFrame3 = defShowFrame3;
    boolean showFrameA1 = defShowFrameA1;
    boolean showFrameA2 = defShowFrameA2;
    boolean showFrameA3 = defShowFrameA3;
    boolean showAntisense = defShowAntisense;
    boolean allowAAPopup = true;
    boolean showNumbers = false;
    char[] validChars = new char[127];
    boolean editable = true;
    boolean draggable = true;
    final JPopupMenu aaMenu = new JPopupMenu();
    final JPopupMenu menu = new JPopupMenu();
    JMScrollBar hScroll;
    JMScrollBar vScroll;
    Font fontPlain;
    Font fontBold;
    Font fontBoldItalic;
    Font menuFontPlain;
    Font menuFontBold;
    boolean insert = true;
    BufferedImage buffer;
    Graphics2D bufferGraphics;
    BufferedImage bufferIcon;
    Graphics2D iconGraphics;
    BufferedImage charBuffer;
    Graphics2D charGraphics;
    Color highlightColor = Color.BLUE;
    Color textColor = Color.BLACK;
    int buffersize = 1;
    int columns;
    int oColumns = this.columns = 60;
    boolean singleRow = false;
    int left = 0;
    int right = 0;
    int top = 0;
    int rows = 0;
    int charHt = 0;
    int charWd = 0;
    int charHt34 = 0;
    int boundWd = 0;
    int boundWdHalf = 0;
    int boundHt = 0;
    int hScrollHt = 0;
    int vMax = 0;
    int hMax = 0;
    private boolean haveFocus = false;
    private boolean hideCursor = false;
    Color backColor;
    private boolean isCursorShowing = true;
    private final Timer blinkTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SequenceEditorPanel.this.selection.length() == 0 && SequenceEditorPanel.this.isCurorVisible()) {
                SequenceEditorPanel.this.isCursorShowing = !SequenceEditorPanel.this.isCursorShowing;
                SequenceEditorPanel.this.repaint();
            }
        }
    });
    private boolean overlapColors = true;
    private int colorOffset = 1;
    private int charBufferLeft = 0;
    private int charBufferTop = this.colorOffset;
    private int charBufferRight = this.boundWd - 1;
    private int charBufferBot = this.boundHt - this.colorOffset;
    private int charBufferHt = this.charBufferBot - this.charBufferTop;
    final int STYLE_UNDERLINE = 0;
    final int STYLE_BOX_LONG = 1;
    final int STYLE_BOX_SHORT = 2;
    final int STYLE_LINE_LONG = 3;
    final int STYLE_LINE_SHORT = 4;
    final int STYLE_UNDERLINE_MID = 5;
    final int STYLE_UNDERLINE_MID_FILLED = 6;
    final int STYLE_BOX_SHORT_FILLED = 7;
    final int STYLE_BOX_LONG_FILLED = 8;
    private int insertCursorStyle = 3;
    private int overwriteCursorStyle = 1;
    private boolean showSelection = false;
    private boolean moveToSelection = false;
    int maxNumLen = 0;
    int maxNumCharCount = 0;
    int panelHeight = 0;
    int panelWidth = 0;
    boolean recalculate = true;

    @Override
    public void setFont(Font font) {
        this.fontPlain = font;
        double shear = 0.1;
        AffineTransform transform = new AffineTransform();
        transform.setToShear(-shear, 0.0);
        this.fontBold = this.fontPlain.deriveFont(1, transform);
        transform = new AffineTransform();
        transform.setToShear(shear, 0.0);
        this.fontBoldItalic = this.fontBold.deriveFont(transform);
        this.charWd = 0;
        super.setFont(font);
        this.reDraw(true);
    }

    public boolean insert(SequenceExportFormat data, int index) {
        if (data.sequence.length() == 0) {
            return false;
        }
        this.select(index);
        this.setSelectionFiltered(data.sequence, this.selection.getFirst(), this.selection.length(), true);
        if (this.doc.getName() == null || this.doc.getName().length() == 0) {
            this.doc.setName(data.name != null && data.name.length() > 0 ? data.name : "New Sequence");
        }
        if (data.annotations != null && data.annotations.length > 0) {
            for (ROI annotation : data.annotations) {
                annotation.setStart(annotation.getStart() + index);
                annotation.setStop(annotation.getStop() + index);
            }
            this.doc.addROI(data.annotations);
        }
        this.doc.setSeqChanged(true);
        this.reDraw(true);
        return true;
    }

    @Override
    public void propertyChanged(ChangeEvent ... events) {
        block3: for (ChangeEvent event : events) {
            switch (event.propertyID) {
                case 4: {
                    if (this.calcScrollBars()) continue block3;
                    this.reDraw(true);
                }
            }
        }
    }

    private static Color blend(Color c0, Color c1) {
        double totalAlpha = c0.getAlpha() + c1.getAlpha();
        double weight0 = (double)c0.getAlpha() / totalAlpha;
        double weight1 = (double)c1.getAlpha() / totalAlpha;
        double r = weight0 * (double)c0.getRed() + weight1 * (double)c1.getRed();
        double g = weight0 * (double)c0.getGreen() + weight1 * (double)c1.getGreen();
        double b = weight0 * (double)c0.getBlue() + weight1 * (double)c1.getBlue();
        double a = Math.max(c0.getAlpha(), c1.getAlpha());
        return new Color((int)r, (int)g, (int)b, (int)a);
    }

    private static Color getForecolor(Color color) {
        double r = (double)color.getRed() / 255.0;
        double g = (double)color.getGreen() / 255.0;
        double b = (double)color.getBlue() / 255.0;
        r = r <= 0.03928 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        g = r <= 0.03928 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
        b = r <= 0.03928 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b > 0.179 ? Color.black : Color.white;
    }

    public DNASequenceDocument getDocument() {
        return this.doc;
    }

    @BeanProperty(hidden=true)
    public void setDocument(GenBankFile gbFile) {
        this.setDocument(DNASequenceDocument.fromGenbank(gbFile));
    }

    @BeanProperty(hidden=true)
    public void setDocument(DNASequenceDocument doc) {
        if (this.doc != null) {
            this.doc.removeListener(this);
        }
        if (doc == null) {
            doc = new DNASequenceDocument();
        }
        this.doc = doc;
        doc.addListener(this);
        if (!this.calcScrollBars()) {
            this.reDraw(true);
        }
    }

    public void antisense() {
        this.doc.antisense();
        this.reDraw();
    }

    public void pasteFromClipboard() {
        SequenceExportFormat data;
        block6: {
            try {
                if (Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(SequenceExportFormat.copiedSequenceFlavor)) {
                    data = (SequenceExportFormat)Toolkit.getDefaultToolkit().getSystemClipboard().getData(SequenceExportFormat.copiedSequenceFlavor);
                    if (data == null || data.sequence.length() == 0) {
                        return;
                    }
                    break block6;
                }
                if (Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    String seq = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    if (seq == null || seq.length() == 0) {
                        return;
                    }
                    data = new SequenceExportFormat();
                    data.sequence = DNA.filterSequence(seq);
                    break block6;
                }
                return;
            }
            catch (UnsupportedFlavorException | IOException ex) {
                return;
            }
        }
        this.setSelection(data);
    }

    public void setSelection(SequenceExportFormat data) {
        this.setSelection(data, this.selection.getFirst() + 1, this.selection.length());
    }

    public void setSelection(SequenceExportFormat data, int repStart, int repLen) {
        --repStart;
        if (this.doc.sequence.length == 0) {
            this.doc.setCircular(data.circular);
        }
        this.setSelectionFiltered(data.sequence, repStart, repLen, false);
        if (this.doc.getName() == null || this.doc.getName().length() == 0) {
            this.doc.setName(data.name != null && data.name.length() > 0 ? data.name : "New Sequence");
        }
        if (data.annotations != null && data.annotations.length > 0) {
            for (ROI annotation : data.annotations) {
                annotation.setStart(annotation.getStart() + repStart);
                annotation.setStop(annotation.getStop() + repStart);
            }
            this.doc.addROI(data.annotations);
        }
        this.doc.setSeqChanged(true);
        if (!this.calcScrollBars()) {
            this.reDraw(true);
        }
    }

    public SequenceEditorPanel() {
        Color selColor;
        Color efColor;
        Color ebColor = UIManager.getColor("SequenceEditor.background");
        if (ebColor != null) {
            this.setBackground(ebColor);
        }
        if ((efColor = UIManager.getColor("SequenceEditor.foreground")) != null) {
            this.setForeground(efColor);
        }
        if ((selColor = UIManager.getColor("SequenceEditor.selectioncolor")) == null) {
            selColor = Color.cyan;
        }
        this.setSelectionColor(new Color(selColor.getRed(), selColor.getGreen(), selColor.getBlue(), 100));
        Color selBColor = UIManager.getColor("SequenceEditor.selectionbordercolor");
        if (selBColor != null) {
            this.setSelectionBorderColor(selBColor);
        }
        Color bColor = UIManager.getColor("SequenceEditor.bordercolor");
        Border border = UIManager.getBorder("SequenceEditor.border");
        if (border != null) {
            this.setBorder(border);
        } else if (bColor != null) {
            this.setBorder(new LineBorder(bColor, 1));
        }
        this.setDocument(new DNASequenceDocument());
        this.dragListener = new SeqDragListener(this.displayPanel){

            @Override
            public SequenceExportFormat[] getSEF() {
                return new SequenceExportFormat[]{SequenceEditorPanel.this.doc.getSEF(SequenceEditorPanel.this.selection.getFirst() + 1, SequenceEditorPanel.this.selection.getLast() + 1)};
            }
        };
        this.hScroll = this.getHScrollBar();
        this.vScroll = this.getVScrollBar();
        this.init();
    }

    private void genCharSizes() {
        if (this.fontPlain != null) {
            FontMetrics fm;
            if (this.bufferGraphics != null) {
                fm = this.bufferGraphics.getFontMetrics(this.fontPlain);
            } else {
                BufferedImage bi = new BufferedImage(1, 1, 6);
                Graphics2D biG = (Graphics2D)bi.getGraphics();
                fm = biG.getFontMetrics(this.fontPlain);
            }
            this.charWd = fm.charWidth(' ');
            this.boundWd = this.buffersize * 2 + this.charWd;
            this.boundWdHalf = this.boundWd / 2;
            this.charHt = fm.getAscent() + fm.getDescent() + fm.getLeading();
            this.charHt34 = this.charHt * 3 / 4;
        }
    }

    private void updateCharHt() {
        this.boundHt = this.buffersize * 2 + this.charHt;
        if (this.showFrame1) {
            this.boundHt += this.charHt34;
        }
        if (this.showFrame2) {
            this.boundHt += this.charHt34;
        }
        if (this.showFrame3) {
            this.boundHt += this.charHt34;
        }
        if (this.showFrameA1) {
            this.boundHt += this.charHt34;
        }
        if (this.showFrameA2) {
            this.boundHt += this.charHt34;
        }
        if (this.showFrameA3) {
            this.boundHt += this.charHt34;
        }
        if (this.showAntisense) {
            this.boundHt += this.charHt34;
        }
        if (this.showNumbers) {
            this.maxNumCharCount = ("" + (this.doc.length() + this.doc.getBaseOffset() + this.columns)).length();
            this.maxNumLen = this.maxNumCharCount * this.charWd;
            this.left = this.boundWd * 2 + this.maxNumLen;
        } else {
            this.maxNumLen = 0;
            this.left = this.boundWd / 2;
        }
        this.top = this.boundWd / 2;
        if (this.autoColumnCount) {
            this.right = this.panelWidth - this.left;
            this.columns = Math.max((this.right - this.left + 1) / this.boundWd, 10);
        } else {
            if (this.singleRow) {
                this.columns = this.doc.length();
            }
            this.right = this.left + this.boundWd * this.columns;
        }
        this.charBufferLeft = 0;
        this.charBufferTop = this.colorOffset;
        this.charBufferRight = this.boundWd - 1;
        this.charBufferBot = this.boundHt - this.colorOffset;
        this.charBufferHt = this.charBufferBot - this.charBufferTop;
    }

    private void init() {
        this.hScrollHt = this.hScroll.getPreferredSize().height;
        this.setHandleMouseMotion(true);
        this.setFont(new Font("Monospaced", 0, 18));
        this.menuFontPlain = this.aaMenu.getFont().deriveFont(0);
        this.menuFontBold = this.menuFontPlain.deriveFont(1);
        this.genCharSizes();
        this.setCharsValid("ATGCatgc");
        this.populateAAMenu();
        this.displayPanel.setFocusable(true);
        this.displayPanel.setBackground(this.getBackground());
        this.toolTip = new BasicTextToolTip((Component)this.displayPanel, "");
        this.toolTip.setShowOnPress(false);
        this.toolTip.setHideOnDrag(false);
        this.toolTip.setOpacity(0.95f);
        this.toolTip.setFadeIn(true);
        this.toolTip.setFadeStep(0.05f);
    }

    public boolean isDragEnabled() {
        return this.draggable;
    }

    public void setDragEnabled(boolean enabled) {
        this.draggable = enabled;
    }

    public void setSelectionChangeListener(CursorSelectionChangeListener listener) {
        this.listener = listener;
    }

    public void gotoSelection(boolean update) {
        this.moveToSelection = true;
        if (update) {
            this.reDraw(true);
        }
    }

    public ROI addROI(String name, int start, int end, Color color) {
        return this.addROI(name, start, end, false, color, null);
    }

    public ROI addROI(ROI roi) {
        this.doc.addROI(roi);
        return roi;
    }

    public boolean containsROI(ROI roi) {
        return roi != null && this.doc.features.contains(roi);
    }

    public ROI addROI(String name, int start, int end, Color color, Object obj) {
        return this.addROI(name, start, end, false, color, obj);
    }

    public ROI addROI(String name, int start, int end, boolean antisense, Color color) {
        return this.addROI(name, start, end, antisense, color, null);
    }

    public ROI addROI(String name, int start, int end, boolean antisense, Color color, Object obj) {
        ROI roi = new ROI(name, start, end, antisense, color, obj);
        this.doc.addROI(roi);
        return roi;
    }

    public boolean isCircular() {
        return this.doc.isCircular();
    }

    @BeanProperty(preferred=true, description="Whether the sequence in the editor is considered circular by default.")
    public void setCircular(boolean circular) {
        this.doc.setCircular(circular);
        this.reDraw(false);
    }

    @BeanProperty(hidden=true)
    public void setBaseOffset(int offset) {
        this.doc.setBaseOffset(offset);
        this.reDraw(true);
    }

    public int getBaseOffset() {
        return this.doc.getBaseOffset();
    }

    @BeanProperty(hidden=true)
    public SequenceExportFormat getSelection() {
        return this.doc.getSEF(this.selection.getFirst() + 1, this.selection.getLast() + 1);
    }

    @BeanProperty(hidden=true)
    public SequenceExportFormat getSelection(int start, int stop) {
        return this.doc.getSEF(start, stop);
    }

    public void copySelectionToClipboard() {
        if (this.selection.length() > 0) {
            this.copyToClipBoard(this.selection.getFirst() + 1, this.selection.getLast() + 1);
        }
    }

    public void setSelectionFromAA(String aminoAcids) {
        if (aminoAcids == null || aminoAcids.length() == 0) {
            return;
        }
        String seq = this.doc.getCodonTable().AA_To_DNA(aminoAcids);
        if (seq != null && seq.length() > 0) {
            this.setSelection(seq);
        }
    }

    @BeanProperty(hidden=true)
    public void setSelection(String sequence) {
        this.setSelectionFiltered(sequence.replaceAll("[^ACGTacgt]", ""), this.selection.getFirst(), this.selection.length(), true);
    }

    private void setSelectionFiltered(String filteredSeq, int replaceStart, int replacedLength, boolean redraw) {
        int insLen = filteredSeq.length();
        if (insLen == 0) {
            return;
        }
        Base[] bases = new Base[insLen];
        for (int x = 0; x < insLen; ++x) {
            bases[x] = new Base(filteredSeq.charAt(x));
        }
        if (this.doc.replace(replaceStart + 1, replacedLength, bases)) {
            this.selection.select(replaceStart, replaceStart + insLen);
            this.doc.setSeqChanged(true);
            if (redraw) {
                this.reDraw(true);
            }
        }
    }

    public boolean isHideCursorOnFocusOut() {
        return this.hideCursor;
    }

    @BeanProperty(preferred=true, description="If true, the cursor is hidden when focus is lost.")
    public void setHideCursorOnFocusOut(boolean hide) {
        this.hideCursor = hide;
    }

    public Color getSelectionColor() {
        return this.selection.color;
    }

    @BeanProperty(preferred=true, description="The background color used to highlight selected base calls in the editor.")
    public void setSelectionColor(Color color) {
        this.selection.color = color;
        if (this.selection.length() > 0) {
            this.repaint();
        }
    }

    public Color getSelectionBorderColor() {
        return this.selection.borderColor;
    }

    @BeanProperty(preferred=true, description="The border color used to highlight selected base calls in the editor.")
    public void setSelectionBorderColor(Color color) {
        this.selection.borderColor = color;
        if (this.selection.length() > 0) {
            this.repaint();
        }
    }

    public void setToolTipRounded(boolean rounded) {
        this.toolTip.setRounded(rounded);
    }

    public boolean isToolTipRounded() {
        return this.toolTip.isRounded();
    }

    @BeanProperty(hidden=true)
    public void setDNASequence(String seq) {
        this.doc.setSequence(DNA.filterSequence(seq));
        this.selection.select(0);
        this.reDraw(true);
    }

    @BeanProperty(hidden=true)
    public void setDNASequence(DNA seq, int first, int last) {
        this.setDNASequence(seq, first, last, false);
    }

    @BeanProperty(hidden=true)
    public void setDNASequence(DNA seq, int first, int last, boolean antisense) {
        this.doc.setSequence(seq.getSequence(first, last, antisense));
        this.doc.setName(seq.getName());
        this.selection.select(0);
        this.reDraw(true);
    }

    @BeanProperty(hidden=true)
    public void setDNASequence(DNA seq) {
        this.doc.setSequence(seq.getSequence());
        this.doc.setName(seq.getName());
        this.selection.select(0);
        this.reDraw(true);
    }

    public void clear() {
        this.setDNASequence("");
        this.doc.setName("Unnamed Sequence");
    }

    @BeanProperty(hidden=true)
    public void setAASequence(String seq) {
        if (this.doc.setAASequence(seq)) {
            this.selection.select(0);
            this.reDraw(true);
        }
    }

    public boolean isChanged() {
        return this.doc.isChanged();
    }

    @BeanProperty(hidden=true)
    public void setSpaceCodons(boolean space) {
        this.buffersize = space ? 2 : 0;
        this.reDraw(true);
    }

    public boolean isSpaceCodons() {
        return this.buffersize > 0;
    }

    @BeanProperty(hidden=true)
    public void setChanged(boolean changed) {
        this.doc.setChanged(changed);
        if (!changed) {
            this.doc.setSeqChanged(false);
        }
    }

    @BeanProperty(hidden=true)
    public void setOrganism(String orgName) {
        this.setOrganism(CodonTable.getOrganismIndex(orgName));
    }

    public int getOrganism() {
        return this.doc.getCodonTable().getOrganismIndex();
    }

    @BeanProperty(preferred=true, enumerationValues={"HUMAN", "RAT", "MOUSE", "E_COLI", "S_CEREVISIAE", "PAN_TROGLODYTES_TROGLODYTES", "ARABIDOPSIS_THALIANA", "VERTEBRATE_MITOCHONDRIA", "INVERTEBRATE_MITOCHONDRIA", "EUBACTERIAL", "STANDARD", "YEAST", "CAENORHABDITIS_ELEGANS", "DROSOPHILA_MELANOGASTER", "INSECT", "PIG", "STREPTOMYCES", "PICHIA_PASTORIS", "CHINESE_HAMSTER", "NICOTIANA_TABACUM", "ZEAMAYS"}, description="Set the default organism for translation.")
    public void setOrganism(int org) {
        this.doc.setCodonTable(org);
        this.populateAAMenu();
        this.reDraw(false);
    }

    @BeanProperty(hidden=true)
    public int length() {
        return this.doc.length();
    }

    @BeanProperty(hidden=true)
    public int getSelectionStart() {
        return this.selection.getFirst() + 1;
    }

    @BeanProperty(hidden=true)
    public int getSelectionLength() {
        return this.selection.length();
    }

    @BeanProperty(hidden=true)
    public void setSelectionLength(int length) {
        this.selection.setLength(length);
    }

    @BeanProperty(hidden=true)
    public int getSelectionStop() {
        return this.selection.getLast() + 1;
    }

    @BeanProperty(hidden=true)
    public void select(int start) {
        this.select(start, start);
    }

    @BeanProperty(hidden=true)
    public void select(int start, int stop) {
        if (start < 1) {
            start = 1;
        } else if (start > this.doc.length() + 1) {
            start = this.doc.length() + 1;
        }
        if (stop < start) {
            stop = start;
        } else if (stop > this.doc.length()) {
            stop = this.doc.length();
        }
        this.selection.moveTo(start - 1);
        this.selection.extendTo(stop);
        if (this.isVisible() && !this.recalculate) {
            this.checkVisible(true);
        } else {
            this.moveToSelection = true;
        }
    }

    public void gotoSelection() {
        this.moveToSelection = true;
        this.reDraw(true);
    }

    @BeanProperty(hidden=true)
    public void selectCodon(int codonNum) {
        int bpStart = DNA.codonNumberToBpStart(codonNum);
        this.select(bpStart, bpStart + 2);
    }

    public void showNumbers(boolean show) {
        this.showNumbers = show;
        this.reDraw(true);
    }

    @BeanProperty(hidden=true)
    public void setCharValid(char chr) {
        if (chr > '\u0000' && chr < this.validChars.length) {
            this.validChars[chr] = '\u0001';
        }
    }

    @BeanProperty(hidden=true)
    public void setCharInvalid(char chr) {
        if (chr > '\u0000' && chr < this.validChars.length) {
            this.validChars[chr] = '\u0000';
        }
    }

    @BeanProperty(hidden=true)
    public void setCharsValid(String chars) {
        for (int x = 0; x < chars.length(); ++x) {
            this.setCharValid(chars.charAt(x));
        }
    }

    @BeanProperty(preferred=false, description="A String indicating which characters ARE filtered out as invalid.")
    public void setCharsInvalid(String chars) {
        for (int x = 0; x < chars.length(); ++x) {
            this.setCharInvalid(chars.charAt(x));
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    @BeanProperty(preferred=true, description="Indicates whether the sequence can be edited by keystrokes.")
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @BeanProperty(preferred=true, description="If true, the characters will appear on only one line.  Otherwise, characters can occupy multiple rows.  This has no effect if AutoColumnCount is true")
    public void setSingleRow(boolean singleRowOnly) {
        if (this.singleRow == singleRowOnly) {
            return;
        }
        this.singleRow = singleRowOnly;
        if (this.singleRow) {
            if (!this.autoColumnCount) {
                this.oColumns = this.columns;
            }
            this.columns = this.doc.length();
        } else {
            this.columns = this.oColumns;
        }
        this.reDraw(true);
    }

    public boolean isSingleRow() {
        return this.singleRow;
    }

    @BeanProperty(preferred=true, description="If true, characters will automatically wrap around the editor when the right edge is reached. If false, characters will occupy the specified number of columns, regardless of editor dimensions")
    public void setAutoColumnCount(boolean autoColumnCount) {
        if (this.autoColumnCount != autoColumnCount) {
            if (!this.autoColumnCount) {
                if (!this.singleRow) {
                    this.oColumns = this.columns;
                }
            } else {
                this.columns = this.oColumns;
            }
            this.autoColumnCount = autoColumnCount;
            this.reDraw(true);
        }
    }

    public boolean isAutoColumnCount() {
        return this.autoColumnCount;
    }

    @BeanProperty(preferred=true, description="If AutoColumnCount is false, this number indicates the maximum characters per row.")
    public void setColumnCount(int count) {
        if (count < 0) {
            return;
        }
        this.singleRow = false;
        if (this.columns > 0) {
            this.columns = count;
            this.reDraw(true);
        }
    }

    public int getColumnCount() {
        return this.columns;
    }

    @Override
    @BeanProperty(preferred=true, description="Default Color for text.")
    public void setForeground(Color color) {
        this.textColor = color;
        this.buffer = null;
        super.setForeground(color);
    }

    @Override
    public Color getBackground() {
        return this.backColor;
    }

    @BeanProperty(preferred=true, description="The background color of the main display panel.")
    public void setDisplayPanelBackground(Color color) {
        this.backColor = color;
        if (this.displayPanel != null) {
            this.displayPanel.setBackground(color);
        }
    }

    public Color getDisplayPanelBackground() {
        return this.displayPanel.getBackground();
    }

    @Override
    @BeanProperty(preferred=true, description="The default background Color for text lacking annotations.")
    public void setBackground(Color color) {
        this.buffer = null;
        this.backColor = color;
        super.setBackground(color);
    }

    @BeanProperty(preferred=true, description="Default Color for cursor.")
    public void setCursorColor(Color color) {
        this.highlightColor = color;
        this.repaint();
    }

    public Color getCursorColor() {
        return this.highlightColor;
    }

    @BeanProperty(hidden=true)
    public void setShow(DISPLAY_OPTIONS option, boolean show) {
        switch (option) {
            case ReadingFrame_1: {
                if (this.showFrame1 == show) {
                    return;
                }
                this.showFrame1 = show;
                break;
            }
            case ReadingFrame_2: {
                if (this.showFrame2 == show) {
                    return;
                }
                this.showFrame2 = show;
                break;
            }
            case ReadingFrame_3: {
                if (this.showFrame3 == show) {
                    return;
                }
                this.showFrame3 = show;
                break;
            }
            case ReadingFrame_4: {
                if (this.showFrameA1 == show) {
                    return;
                }
                this.showFrameA1 = show;
                break;
            }
            case ReadingFrame_5: {
                if (this.showFrameA2 == show) {
                    return;
                }
                this.showFrameA2 = show;
                break;
            }
            case ReadingFrame_6: {
                if (this.showFrameA3 == show) {
                    return;
                }
                this.showFrameA3 = show;
                break;
            }
            case AntisenseStrand: {
                if (this.showAntisense == show) {
                    return;
                }
                this.showAntisense = show;
                break;
            }
            case Line_Numbers: {
                if (this.showNumbers == show) {
                    return;
                }
                this.showNumbers = show;
                break;
            }
            default: {
                return;
            }
        }
        this.charWd = 0;
        this.reDraw(true);
    }

    @BeanProperty(hidden=true)
    public boolean isShowing(DISPLAY_OPTIONS option) {
        switch (option) {
            case ReadingFrame_1: {
                return this.showFrame1;
            }
            case ReadingFrame_2: {
                return this.showFrame2;
            }
            case ReadingFrame_3: {
                return this.showFrame3;
            }
            case ReadingFrame_4: {
                return this.showFrameA1;
            }
            case ReadingFrame_5: {
                return this.showFrameA2;
            }
            case ReadingFrame_6: {
                return this.showFrameA3;
            }
            case AntisenseStrand: {
                return this.showAntisense;
            }
            case Line_Numbers: {
                return this.showNumbers;
            }
        }
        return false;
    }

    @BeanProperty(preferred=true, description="Indicates whether reading frame 1 translation shown by default.")
    public void setShowFrame1(boolean show) {
        this.setShow(DISPLAY_OPTIONS.ReadingFrame_1, show);
    }

    @BeanProperty(preferred=true, description="Indicates whether reading frame 2 translation is shown by default.")
    public void setShowFrame2(boolean show) {
        this.setShow(DISPLAY_OPTIONS.ReadingFrame_2, show);
    }

    @BeanProperty(preferred=true, description="Indicates whether reading frame 3 translation is shown by default.")
    public void setShowFrame3(boolean show) {
        this.setShow(DISPLAY_OPTIONS.ReadingFrame_3, show);
    }

    @BeanProperty(preferred=true, description="Indicates whether antisense reading frame 1 translation shown by default.")
    public void setShowFrameA1(boolean show) {
        this.setShow(DISPLAY_OPTIONS.ReadingFrame_4, show);
    }

    @BeanProperty(preferred=true, description="Indicates whether antisense reading frame 2 translation is shown by default.")
    public void setShowFrameA2(boolean show) {
        this.setShow(DISPLAY_OPTIONS.ReadingFrame_5, show);
    }

    @BeanProperty(preferred=true, description="Indicates whether antisense reading frame 3 translation is shown by default.")
    public void setShowFrameA3(boolean show) {
        this.setShow(DISPLAY_OPTIONS.ReadingFrame_6, show);
    }

    @BeanProperty(preferred=true, description="Indicates whether the antisense sequence is shown by default.")
    public void setShowAntisense(boolean show) {
        this.setShow(DISPLAY_OPTIONS.AntisenseStrand, show);
    }

    @BeanProperty(preferred=true, description="Indicates whether the base positions of the start and end of each row is shown by default.")
    public void setShowNumbers(boolean show) {
        this.setShow(DISPLAY_OPTIONS.Line_Numbers, show);
    }

    public boolean isShowFrame1() {
        return this.isShowing(DISPLAY_OPTIONS.ReadingFrame_1);
    }

    public boolean isShowFrame2() {
        return this.isShowing(DISPLAY_OPTIONS.ReadingFrame_2);
    }

    public boolean isShowFrame3() {
        return this.isShowing(DISPLAY_OPTIONS.ReadingFrame_3);
    }

    public boolean isShowFrameA1() {
        return this.isShowing(DISPLAY_OPTIONS.ReadingFrame_4);
    }

    public boolean isShowFrameA2() {
        return this.isShowing(DISPLAY_OPTIONS.ReadingFrame_5);
    }

    public boolean isShowFrameA3() {
        return this.isShowing(DISPLAY_OPTIONS.ReadingFrame_6);
    }

    public boolean isShowAntisense() {
        return this.isShowing(DISPLAY_OPTIONS.AntisenseStrand);
    }

    public boolean isShowNumbers() {
        return this.isShowing(DISPLAY_OPTIONS.Line_Numbers);
    }

    @BeanProperty(hidden=true)
    public String getSequence() {
        if (this.selection.length() == 0) {
            return this.doc.getSequence();
        }
        return this.doc.getSequence(this.selection.getFirst() + 1, this.selection.getLast() + 1);
    }

    @BeanProperty(hidden=true)
    public String getSequence(int start, int stop) {
        return this.doc.getSequence(start, stop);
    }

    @BeanProperty(hidden=true)
    public String getTranslation() {
        if (this.selection.length() == 0) {
            return this.doc.getTranslation(1, this.doc.length());
        }
        return this.doc.getTranslation(this.selection.getFirst() + 1, this.selection.getLast() + 1);
    }

    @BeanProperty(hidden=true)
    public String getTranslation(int start, int stop) {
        return this.doc.getTranslation(start, stop);
    }

    @BeanProperty(hidden=true)
    public String getTranslation2() {
        if (this.selection.length() == 0) {
            return this.getTranslation2(1, this.doc.length());
        }
        return this.getTranslation2(this.selection.getFirst() + 1, this.selection.getLast() + 1);
    }

    @BeanProperty(hidden=true)
    public String getTranslation2(int start, int stop) {
        if (this.doc.length() == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (int x = start - 1; x < stop; x += 3) {
            if (((Base[])this.doc.sequence.items)[x] == null || ((Base[])this.doc.sequence.items)[x].AA == null) continue;
            outSequence.append(((Base[])this.doc.sequence.items)[x].AA.getAbbr1()).append("  ");
        }
        return outSequence.toString();
    }

    @BeanProperty(hidden=true)
    public String getTranslation3() {
        if (this.selection.length() == 0) {
            return this.getTranslation3(0, this.doc.sequence.length - 1);
        }
        return this.getTranslation3(this.selection.getFirst(), this.selection.getLast());
    }

    @BeanProperty(hidden=true)
    public String getTranslation3(int start, int stop) {
        if (this.doc.length() == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (int x = start - 1; x < stop; x += 3) {
            if (((Base[])this.doc.sequence.items)[x] == null || ((Base[])this.doc.sequence.items)[x] == null) continue;
            outSequence.append(((Base[])this.doc.sequence.items)[x].AA.getAbbr3());
        }
        return outSequence.toString();
    }

    private int constrain(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    int getBaseY(int index) {
        return this.top + index / this.columns * this.boundHt;
    }

    int getBaseX(int index) {
        return this.left + (index - index / this.columns * this.columns) * this.boundWd;
    }

    private void getBaseXY(int index, Point dst) {
        int row = index / this.columns;
        int col = index - row * this.columns;
        dst.x = this.left + col * this.boundWd;
        dst.y = this.top + row * this.boundHt;
    }

    public boolean mutateBase(int pos, char newResidue) {
        if (!this.isIndexValid(--pos) || !this.isCharValid(newResidue)) {
            return false;
        }
        ((Base[])this.doc.sequence.items)[pos].setBase(newResidue);
        this.doc.genAA(pos);
        this.draw(pos, this.bufferGraphics, false);
        if (pos > 0) {
            this.doc.genAA(pos - 1);
            this.draw(pos - 1, this.bufferGraphics, false);
        }
        if (pos > 1) {
            this.doc.genAA(pos - 2);
            this.draw(pos - 2, this.bufferGraphics, false);
        }
        this.selection.select(this.selection.getFirst() + 1);
        this.repaint();
        return true;
    }

    public boolean mutateAA(int codonNum, char newResidue) {
        int cNum = DNA.codonNumberToBpStart(codonNum) - 1;
        if (!this.isIndexValid(cNum)) {
            return false;
        }
        String newCodon = this.doc.getCodonTable().getHighestCodon(newResidue);
        if (newCodon.length() == 0) {
            return false;
        }
        this.setCodon(cNum, newCodon, false);
        return true;
    }

    void populateAAMenu() {
        this.aaMenu.removeAll();
        for (int cIndex = 0; cIndex < AminoAcid.Abbr1.length; ++cIndex) {
            this.aaMenu.add(this.getMenuForAA(AminoAcid.Abbr1[cIndex], "Set AA to " + AminoAcid.Abbr3[cIndex] + " (" + AminoAcid.Abbr1[cIndex] + ")"));
        }
    }

    JMenu getMenuForAA(char aa, String title) {
        String[] altCodons = this.doc.codonTable.getCodonsForAA(aa);
        JMenu menu = new JMenu(title);
        if (altCodons != null && altCodons.length > 0) {
            for (int cIndex = 0; cIndex < altCodons.length; ++cIndex) {
                JMenuItem item = new JMenuItem(altCodons[cIndex] + " (" + this.doc.codonTable.getCodonFrequency(altCodons[cIndex]) + "%)");
                item.addActionListener(new AAActionListener(altCodons[cIndex]));
                menu.add(item);
            }
        }
        return menu;
    }

    @Override
    public void displayPanelMouseWheelMoved(MouseWheelEvent e) {
        if (!e.isControlDown() && this.vScroll.isVisible()) {
            if (e.getWheelRotation() > 0) {
                this.vScroll.setValue(this.vScroll.getValue() + (long)this.boundHt);
            } else {
                this.vScroll.setValue(this.vScroll.getValue() - (long)this.boundHt);
            }
        } else if (this.hScroll.isVisible()) {
            if (e.getWheelRotation() > 0) {
                this.hScroll.setValue(this.hScroll.getValue() + (long)this.boundWd);
            } else {
                this.hScroll.setValue(this.hScroll.getValue() - (long)this.boundWd);
            }
        }
    }

    @Override
    public void displayPanelMouseDragged(MouseEvent e) {
        if (!this.dragListener.enabled && SwingUtilities.isLeftMouseButton(e)) {
            int x = e.getX();
            int y = e.getY();
            this.selection.extendTo(x, y);
            if (this.showToolTip) {
                String s = this.getCurrentToolTip();
                if (s == null) {
                    this.toolTip.setText(null);
                    this.toolTip.hide();
                } else {
                    this.toolTip.setText(s);
                    this.toolTip.show(x, y);
                }
            }
        }
    }

    @Override
    public void displayPanelMouseMoved(MouseEvent e) {
    }

    public boolean baseContains(int baseIndex, int x, int y) {
        return this.baseContains(this.getBaseX(baseIndex), this.getBaseY(baseIndex), x, y);
    }

    public boolean baseContains(int baseLeft, int baseTop, int x, int y) {
        if ((this.boundWd | this.boundHt) < 0 || x < baseLeft || y < baseTop) {
            return false;
        }
        int rt = this.boundWd + baseLeft;
        int bt = this.boundHt + baseTop;
        return !(rt >= baseLeft && rt <= x || bt >= baseTop && bt <= y);
    }

    @Override
    public void displayPanelMouseReleased(MouseEvent e) {
        if (this.dragListener.enabled && e.getButton() == 1) {
            this.dragListener.enabled = false;
            if (this.selection.length() > 0 && this.selection.contains(this.selection.getCurrent())) {
                this.selection.moveTo(e.getX(), e.getY(), e.isShiftDown());
            }
        } else if (e.isPopupTrigger()) {
            JPopupMenu selMenu;
            this.dragListener.enabled = false;
            int x = e.getX();
            int y = e.getY();
            if (this.selection.length() == 0) {
                JPopupMenu selMenu2 = this.getPopupMenu(x + this.offsetX, y + this.offsetY);
                if (selMenu2 != null) {
                    selMenu2.show(this, x, y);
                }
            } else if (this.selection.contains(this.selection.getCurrent()) && (selMenu = this.getSelectionMenu(this.selection.getFirst() + 1, this.selection.getLast() + 1)) != null) {
                selMenu.show(this, x, y);
            }
        }
    }

    public JPopupMenu getPopupMenu(int x, int y) {
        int cBaseIndex = this.selection.getCurrent();
        Base base = ((Base[])this.doc.sequence.items)[cBaseIndex];
        if (base == null) {
            return null;
        }
        int baseTop = this.getBaseY(cBaseIndex);
        int baseLeft = this.getBaseX(cBaseIndex);
        if (this.editable && this.baseContains(baseLeft, baseTop, x, y)) {
            if (this.allowAAPopup && (y > baseTop + this.charHt + this.buffersize || base.AA == null || base.AA.abbr1 == 'X')) {
                return this.aaMenu;
            }
            if (base.AA != null && base.AA.abbr1 != '\u0000') {
                String[] altCodons = this.doc.codonTable.getCodonsForAA(base.AA.abbr1);
                this.menu.removeAll();
                if (altCodons != null && altCodons.length > 0) {
                    for (int cIndex = 0; cIndex < altCodons.length; ++cIndex) {
                        JMenuItem item = new JMenuItem("Set codon to " + altCodons[cIndex] + " (" + this.doc.codonTable.getCodonFrequency(altCodons[cIndex]) + "%)");
                        item.addActionListener(new CodonActionListener(altCodons[cIndex]));
                        if (this.compare(altCodons[cIndex].charAt(0), ((Base[])this.doc.sequence.items)[cBaseIndex].base) && this.compare(altCodons[cIndex].charAt(1), ((Base[])this.doc.sequence.items)[cBaseIndex + 1].base) && this.compare(altCodons[cIndex].charAt(2), ((Base[])this.doc.sequence.items)[cBaseIndex + 2].base)) {
                            item.setFont(this.menuFontBold);
                        } else {
                            item.setFont(this.menuFontPlain);
                        }
                        this.menu.add(item);
                    }
                    return this.menu;
                }
            }
        }
        return null;
    }

    public JPopupMenu.Separator genMenuSeparator(String text) {
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        sep.setToolTipText(text);
        return sep;
    }

    public JMenuItem genMenuItem(String text, String tooltiptext, ActionListener l) {
        JMenuItem item = new JMenuItem();
        if (text != null) {
            item.setText(text);
        }
        if (l != null) {
            item.addActionListener(l);
        }
        if (tooltiptext != null) {
            item.setToolTipText(tooltiptext);
        }
        return item;
    }

    public JMenu genMenu(String text, String tooltiptext, ActionListener l) {
        JMenu item = new JMenu();
        if (text != null) {
            item.setText(text);
        }
        if (l != null) {
            item.addActionListener(l);
        }
        if (tooltiptext != null) {
            item.setToolTipText(tooltiptext);
        }
        return item;
    }

    private JMenu genMenu(String text, String toolTipText) {
        return this.genMenu(text, toolTipText, null);
    }

    public JPopupMenu getSelectionMenu(int selStart, int selStop) {
        this.menu.removeAll();
        if (this.editable) {
            this.menu.add(this.genMenuItem("Add as new feature", "Add selection as a new feature.", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ROI roi;
                    ROI roiIn = new ROI();
                    roiIn.setStart(SequenceEditorPanel.this.selection.getFirst() + 1);
                    roiIn.setStop(SequenceEditorPanel.this.selection.getLast() + 1);
                    AnnotationEditor f = SequenceEditorPanel.this.showROIEditor(roiIn, ((SequenceEditorPanel)SequenceEditorPanel.this).doc.sequence.length);
                    if (f != null && (roi = f.getROI()) != null) {
                        SequenceEditorPanel.this.doc.addROI(roi);
                        SequenceEditorPanel.this.reDraw(false);
                    }
                }
            }));
            this.menu.add(this.genMenuSeparator("Annotation Tools"));
            JMenu mnuEditROI = this.genMenu("Edit an annotation in this selection", "Edit an annotation present in the selection.");
            this.menu.add(mnuEditROI);
            JMenu mnuUnannotate = this.genMenu("Unannotate from selection", "Removes the selected sequence from an annotation present in the selection.");
            this.menu.add(mnuUnannotate);
            JMenu mnuExtendAnnotate = this.genMenu("Extend an annotation to selection", "Extends an annotation present in the selected sequence to encompas the selection.");
            this.menu.add(mnuExtendAnnotate);
            JMenu mnuRemAnnotation = this.genMenu("Remove an annotation", "Removes an annotation present in the selected sequence.");
            this.menu.add(mnuRemAnnotation);
            int annotations = 0;
            int extannotations = 0;
            for (ROI roi : this.doc.features) {
                if (!this.ROIcontains(roi, selStart, selStop)) continue;
                mnuUnannotate.add(this.genMenuItem(roi.getName(), "Unannotate from selection.", new UnannotationActionListener(roi, selStart, selStop)));
                mnuEditROI.add(this.genMenuItem(roi.getName(), "Edit this annotation.", new ROIEditActionListener(roi)));
                if (roi.getStart() >= selStart || roi.getStop() <= selStop) {
                    mnuExtendAnnotate.add(this.genMenuItem(roi.getName(), "Extend annotation.", new ExtendAnnotationActionListener(roi, selStart, selStop)));
                    ++extannotations;
                }
                mnuRemAnnotation.add(this.genMenuItem(roi.getName(), "Remove annotation.", new ROIRemActionListener(roi)));
                ++annotations;
            }
            mnuUnannotate.setEnabled(annotations > 0);
            mnuExtendAnnotate.setEnabled(extannotations > 0);
            if (annotations > 1) {
                mnuUnannotate.add((Component)this.genMenuItem("All items", "Unannotate all items from the selection.", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        SequenceEditorPanel.this.doc.unannotateSelection(SequenceEditorPanel.this.selection.getFirst() + 1, SequenceEditorPanel.this.selection.getLast() + 1);
                    }
                }), 0);
                mnuUnannotate.add((Component)this.genMenuSeparator("Selected Items"), 1);
            }
            this.menu.add(this.genMenuSeparator("Reverse/complement"));
            this.menu.add(this.genMenuItem("Reverse/complement selection", "Reverse/complement selected region.", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (SequenceEditorPanel.this.selection.length() > 0) {
                        SequenceExportFormat selection = SequenceEditorPanel.this.getSelection();
                        selection.antisense();
                        SequenceEditorPanel.this.setSelection(selection);
                    }
                }
            }));
        }
        this.menu.add(this.genMenuSeparator("Copy Options"));
        this.menu.add(this.genMenuItem("Copy selection", "Copy selection", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SequenceEditorPanel.this.copySelectionToClipboard();
            }
        }));
        this.menu.add(this.genMenuItem("Copy selection as antisense", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SequenceExportFormat selection = SequenceEditorPanel.this.getSelection();
                DNA.antisense(selection);
                SequenceExportFormat.SequenceTransferable transferable = SequenceExportFormat.createTransferable(selection);
                if (transferable != null) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
                }
            }
        }));
        this.menu.add(this.genMenuItem("Copy selection translation", "", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String seq = SequenceEditorPanel.this.getAASeq(SequenceEditorPanel.this.selection.getFirst(), SequenceEditorPanel.this.selection.getLast(), false);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(seq), null);
            }
        }));
        if (this.editable) {
            this.menu.add(this.genMenuSeparator("Cut/Delete"));
            this.menu.add(this.genMenuItem("Cut selection", "Cut selected region", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SequenceEditorPanel.this.copyToClipBoard(SequenceEditorPanel.this.selection.getFirst() + 1, SequenceEditorPanel.this.selection.getLast() + 1);
                    SequenceEditorPanel.this.setSelection("");
                }
            }));
            this.menu.add(this.genMenuItem("Delete selection", "Delete selected region", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SequenceEditorPanel.this.setSelection("");
                }
            }));
            this.menu.add(this.genMenuSeparator("Case Options"));
            this.menu.add(this.genMenuItem("Uppercase selection", "Uppercase selected sequence", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SequenceEditorPanel.this.uppercase();
                }
            }));
            this.menu.add(this.genMenuItem("Lowercase selection", "Lowercase selected sequence", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SequenceEditorPanel.this.lowercase();
                }
            }));
        }
        return this.menu;
    }

    private void copyToClipBoard(int first, int last) {
        SequenceExportFormat.SequenceTransferable transferable = SequenceExportFormat.createTransferable(this.doc.getSEF(first, last));
        if (transferable != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
        }
    }

    public AnnotationEditor showROIEditor(ROI roi, int length) {
        FrmROIEditor f = new FrmROIEditor(null, true);
        f.setLength(length);
        f.setROI(roi);
        f.setLocationRelativeTo(this);
        f.setVisible(true);
        return f;
    }

    public AnnotationEditor showROIEditor() {
        return this.showROIEditor(new ROI("New Feature", this.selection.getFirst(), this.selection.getLast(), Color.cyan, false), this.doc.sequence.length);
    }

    @Override
    public void displayPanelMousePressed(MouseEvent e) {
        this.requestFocus();
        if (e.getButton() == 1 || e.isShiftDown() || this.selection.length() == 0 || !this.selection.contains(e.getX(), e.getY())) {
            int x = e.getX();
            int y = e.getY();
            if (this.selection.length() > 0 && this.selection.contains(e.getX(), e.getY())) {
                this.dragListener.enabled = this.draggable;
            } else {
                this.dragListener.enabled = false;
                this.selection.moveTo(x, y, e.isShiftDown());
                if (this.showToolTip && e.getButton() == 1) {
                    String s = this.getCurrentToolTip();
                    this.toolTip.setText(s);
                    if (s != null) {
                        this.toolTip.show(x, y);
                    }
                }
            }
        }
        this.repaint();
    }

    @Override
    public void displayPanelResized(int width, int height) {
        this.calcScrollBars();
        this.reDraw(true);
        this.ensureVisible();
    }

    @Override
    public boolean displayPanelKeyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 155: {
                boolean bl = this.insert = !this.insert;
                if (((Base[])this.doc.sequence.items)[this.selection.dot] != null) {
                    this.draw(this.selection.dot, (Graphics2D)this.displayPanel.getGraphics(), true);
                }
                return true;
            }
            case 27: {
                if (this.selection.length() <= 0) break;
                this.selection.setLength(0);
                this.repaint();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean displayPanelKeyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 155: {
                return false;
            }
            case 37: {
                if (e.isControlDown() || e.isMetaDown()) {
                    this.selection.moveTo(this.selection.getIndexFirstInRow(this.getBaseY(this.selection.dot) - this.offsetY), e.isShiftDown());
                } else {
                    this.selection.moveTo(this.selection.length() > 0 && !e.isShiftDown() ? this.selection.getFirst() : this.selection.dot - 1, e.isShiftDown());
                }
                return true;
            }
            case 39: {
                if (e.isControlDown() || e.isMetaDown()) {
                    this.selection.moveTo(this.selection.getIndexLastInRow(this.getBaseY(this.selection.dot) - this.offsetY), e.isShiftDown());
                } else {
                    this.selection.moveTo(this.selection.length() > 0 && !e.isShiftDown() ? this.selection.getLast() + 1 : this.selection.dot + 1, e.isShiftDown());
                }
                return true;
            }
            case 38: {
                this.selection.moveTo(this.selection.length() > 0 && !e.isShiftDown() ? this.selection.getFirst() : this.selection.dot - this.columns, e.isShiftDown());
                return true;
            }
            case 40: {
                this.selection.moveTo(this.selection.length() > 0 && !e.isShiftDown() ? this.selection.getLast() + 1 : this.selection.dot + this.columns, e.isShiftDown());
                return true;
            }
            case 33: {
                this.selection.moveTo(this.selection.dot - this.columns * this.panelHeight / this.boundHt, e.isShiftDown());
                return true;
            }
            case 34: {
                this.selection.moveTo(this.selection.dot + this.columns * this.panelHeight / this.boundHt, e.isShiftDown());
                return true;
            }
            case 36: {
                if (e.isControlDown() || e.isMetaDown()) {
                    this.selection.moveTo(0, e.isShiftDown());
                } else {
                    this.selection.moveTo(this.selection.getIndexFirstInRow(this.getBaseY(this.selection.dot) - this.offsetY), e.isShiftDown());
                }
                return true;
            }
            case 35: {
                if (e.isControlDown() || e.isMetaDown()) {
                    this.selection.moveTo(this.doc.sequence.length, e.isShiftDown());
                } else {
                    this.selection.moveTo(this.selection.getIndexLastInRow(this.getBaseY(this.selection.dot) - this.offsetY) + (e.isShiftDown() ? 1 : 0), e.isShiftDown());
                }
                return true;
            }
            case 127: {
                if (!this.editable) {
                    return false;
                }
                if (this.selection.length() < 1) {
                    if (this.delNt(this.selection.dot)) {
                        this.doc.seqChanged = true;
                    }
                } else if (this.delNt(this.selection.getFirst(), this.selection.getLast())) {
                    this.doc.seqChanged = true;
                }
                this.selection.moveTo(this.selection.getFirst());
                this.reDraw(false);
                return true;
            }
            case 8: {
                if (!this.editable) {
                    return false;
                }
                if (this.selection.length() == 0) {
                    if (this.delNt(this.selection.dot - 1)) {
                        this.selection.select(this.selection.getFirst() - 1);
                        this.doc.seqChanged = true;
                        this.reDraw(false);
                    }
                } else if (this.delNt(this.selection.getFirst(), this.selection.getLast())) {
                    this.doc.seqChanged = true;
                    this.selection.select(this.selection.getFirst());
                    this.reDraw(false);
                }
                return true;
            }
        }
        if (this.editable && !e.isControlDown() && !e.isAltGraphDown() && !e.isMetaDown()) {
            return this.keyPressed(this.selection.dot, e.getKeyChar());
        }
        return false;
    }

    @BeanProperty(hidden=true)
    public void setBlinking(boolean blink, int rate) {
        this.setBlinkRate(rate);
        this.setBlinking(blink);
    }

    @BeanProperty(preferred=true, description="Sets whether the cursor should blink by default.")
    public void setBlinking(boolean blink) {
        this.isCursorShowing = true;
        if (blink && this.blinkTimer.getDelay() > 0 && this.hasFocus()) {
            this.blinkTimer.start();
        } else {
            this.blinkTimer.stop();
        }
    }

    public boolean isBlinking() {
        return this.blinkTimer.isRunning();
    }

    @BeanProperty(preferred=true, description="Sets blinking speed of the cursor.")
    public void setBlinkRate(int rate) {
        this.blinkTimer.setDelay(rate);
    }

    public int getBlinkRate() {
        return this.blinkTimer.getDelay();
    }

    public boolean isBlendROIColors() {
        return this.overlapColors;
    }

    public void setBlendROIColors(boolean overlapColors) {
        if (this.overlapColors != overlapColors) {
            this.overlapColors = overlapColors;
            this.reDraw();
        }
    }

    public void setColorYOffset(int offset) {
        if (offset >= 0 && offset < this.boundHt / 2) {
            this.colorOffset = offset;
            this.reDraw(true);
        }
    }

    public int getColorYOffset() {
        return this.colorOffset;
    }

    private void draw(int index, Graphics2D g, boolean currentBase) {
        Base base;
        if (index < 0 || index >= this.doc.sequence.length || ((Base[])this.doc.sequence.items)[index] == null) {
            base = this.endBase;
            index = this.doc.sequence.length;
        } else {
            base = ((Base[])this.doc.sequence.items)[index];
        }
        int left = this.getBaseX(index);
        int top = this.getBaseY(index);
        if (this.backIcon != null) {
            this.charGraphics.drawImage(this.bufferIcon, 0, 0, this.boundWd, this.boundHt, left - this.offsetX, top - this.offsetY, left - this.offsetX + this.boundWd, top - this.offsetY + this.boundHt, null, null);
        } else {
            this.charGraphics.setColor(this.backColor);
            this.charGraphics.fillRect(0, 0, this.boundWd, this.boundHt);
        }
        Color forecolor = this.textColor;
        if (base.base > '\u0000') {
            Color bColor = new Color(this.backColor.getRed(), this.backColor.getGreen(), this.backColor.getBlue(), 0);
            if (base.AA != null && base.AA.color != null) {
                bColor = this.overlapColors ? SequenceEditorPanel.blend(bColor, base.AA.color) : base.AA.color;
            } else if (this.doc.features != null && this.doc.features.length > 0) {
                if (this.overlapColors) {
                    for (int roiIndex = this.doc.features.length - 1; roiIndex >= 0; --roiIndex) {
                        ROI roi = this.doc.features.get(roiIndex);
                        if (roi.colorTrans == null || !roi.intersects(index + 1)) continue;
                        bColor = this.overlapColors ? SequenceEditorPanel.blend(bColor, roi.colorTrans) : roi.colorTrans;
                    }
                } else {
                    for (ROI roi : this.doc.features) {
                        if (roi.colorTrans == null || !roi.intersects(index + 1)) continue;
                        bColor = roi.colorTrans;
                        break;
                    }
                }
            }
            this.charGraphics.setColor(bColor);
            this.charGraphics.fillRect(this.charBufferLeft, this.charBufferTop, this.boundWd, this.charBufferHt);
            if (this.showSelection && this.selection.contains(index)) {
                if (this.selection.color != null) {
                    this.charGraphics.setColor(this.backIcon == null ? this.selection.color : this.selection.colorTrans);
                    this.charGraphics.fillRect(this.charBufferLeft, this.charBufferTop, this.boundWd, this.charBufferHt);
                }
                if (this.selection.borderColor != null) {
                    this.charGraphics.setColor(this.selection.borderColor);
                    if (index == this.selection.getFirst()) {
                        this.charGraphics.drawLine(this.charBufferLeft, this.charBufferTop, this.charBufferLeft, this.charBufferBot - 1);
                    }
                    if (index == this.selection.getLast()) {
                        this.charGraphics.drawLine(this.charBufferRight, this.charBufferTop, this.charBufferRight, this.charBufferBot - 1);
                    }
                    this.charGraphics.drawLine(this.charBufferLeft, this.charBufferTop, this.charBufferRight, this.charBufferTop);
                    this.charGraphics.drawLine(this.charBufferLeft, this.charBufferBot - 1, this.charBufferRight, this.charBufferBot - 1);
                }
            }
            Color color = forecolor = this.textColor == null ? SequenceEditorPanel.getForecolor(bColor) : this.textColor;
        }
        if (this.isCursorShowing && currentBase && (this.haveFocus || !this.hideCursor) && this.selection.length() == 0) {
            if (!this.insert) {
                this.drawCursor(this.charGraphics, Color.RED, this.overwriteCursorStyle);
            } else {
                this.drawCursor(this.charGraphics, this.highlightColor, this.insertCursorStyle);
            }
        }
        this.charGraphics.setColor(forecolor);
        this.charGraphics.setFont(this.fontPlain);
        int y = this.buffersize + this.charHt34;
        this.charGraphics.drawString("" + base.base, this.buffersize, y);
        this.charGraphics.setFont(this.fontBold);
        int frame = index % 3;
        if (this.showFrame1) {
            y += this.charHt34;
            if (frame == 0 && base.AA != null) {
                this.charGraphics.drawString("" + base.AA.abbr1, this.buffersize, y);
            }
        }
        if (this.showFrame2) {
            y += this.charHt34;
            if (frame == 1 && base.AA != null) {
                this.charGraphics.drawString("" + base.AA.abbr1, this.buffersize, y);
            }
        }
        if (this.showFrame3) {
            y += this.charHt34;
            if (frame == 2 && base.AA != null) {
                this.charGraphics.drawString("" + base.AA.abbr1, this.buffersize, y);
            }
        }
        this.charGraphics.setFont(this.fontBoldItalic);
        if (this.showFrameA3) {
            y += this.charHt34;
            if (frame == 0 && base.aAA != null) {
                this.charGraphics.drawString("" + base.aAA.abbr1, this.buffersize, y);
            }
        }
        if (this.showFrameA2) {
            y += this.charHt34;
            if (frame == 1 && base.aAA != null) {
                this.charGraphics.drawString("" + base.aAA.abbr1, this.buffersize, y);
            }
        }
        if (this.showFrameA1) {
            y += this.charHt34;
            if (frame == 2 && base.aAA != null) {
                this.charGraphics.drawString("" + base.aAA.abbr1, this.buffersize, y);
            }
        }
        this.charGraphics.setFont(this.fontPlain);
        if (this.showAntisense) {
            this.charGraphics.drawString("" + base.aBase, this.buffersize, y += this.charHt34);
        }
        g.drawImage(this.charBuffer, left - this.offsetX, top - this.offsetY, null, null);
    }

    public void setInsertCursorStyle(int style) {
        this.insertCursorStyle = style;
    }

    public int getInsertCursorStyle() {
        return this.insertCursorStyle;
    }

    public void setOverwriteCursorStyle(int style) {
        this.overwriteCursorStyle = style;
    }

    public int getOverwriteCursorStyle() {
        return this.overwriteCursorStyle;
    }

    private void drawCursor(Graphics2D g, Color color, int style) {
        g.setColor(color);
        int top = this.buffersize + 1;
        switch (style) {
            case 0: {
                g.fillRect(0, this.buffersize + this.charHt34 + 1, this.charWd, 2);
                break;
            }
            case 7: {
                g.fillRect(0, top, this.charWd, this.buffersize + this.charHt34 + 2);
                break;
            }
            case 5: {
                g.drawRect(0, this.buffersize + this.charHt / 2 + 1, this.charWd, this.charHt / 4);
                break;
            }
            case 6: {
                g.fillRect(0, this.buffersize + this.charHt / 2 + 1, this.charWd, this.charHt / 4);
                break;
            }
            case 1: {
                g.drawRect(0, top, this.charWd, this.boundHt - top * 2);
                break;
            }
            case 8: {
                g.fillRect(0, top, this.charWd, this.boundHt - top * 2);
                break;
            }
            case 2: {
                g.drawRect(0, top, this.charWd, this.buffersize + this.charHt34 + 2);
                break;
            }
            case 4: {
                g.drawLine(0, top, 0, this.buffersize + this.charHt34 + 2);
                break;
            }
            default: {
                g.drawLine(0, top, 0, this.boundHt - 2 * top);
            }
        }
    }

    private boolean keyPressed(int index, char chr) {
        if (index > this.doc.sequence.length || !this.isCharValid(chr)) {
            return false;
        }
        this.doc.seqChanged = true;
        int currentIndex = this.selection.getFirst();
        if (this.selection.length() > 0) {
            this.delNt(currentIndex, this.selection.getLast());
        }
        if (this.insert || index == this.doc.sequence.length) {
            this.insNt(chr, this.selection.getFirst());
            this.selection.select(this.selection.getFirst() + 1);
            this.reDraw(true);
            return true;
        }
        Base base = ((Base[])this.doc.sequence.items)[index];
        if (base.base != chr) {
            base.setBase(chr);
            this.doc.genAA(currentIndex);
            if (currentIndex > 0) {
                this.doc.genAA(currentIndex - 1);
                this.draw(currentIndex - 1, this.bufferGraphics, false);
                this.draw(currentIndex - 1, this.charGraphics, false);
            }
            if (currentIndex > 1) {
                this.doc.genAA(currentIndex - 2);
                this.draw(currentIndex - 2, this.bufferGraphics, false);
                this.draw(currentIndex - 2, this.charGraphics, false);
            }
        }
        this.draw(index, this.bufferGraphics, false);
        this.selection.select(this.selection.getFirst() + 1);
        this.repaint();
        return true;
    }

    @Override
    public void hScrollValueChanged(long newValue) {
        this.offsetX = (int)newValue;
        if (this.hScroll.isVisible()) {
            this.reDraw(false);
        }
    }

    @Override
    public void vScrollValueChanged(long newValue) {
        this.offsetY = (int)newValue;
        if (this.vScroll.isVisible()) {
            this.reDraw(false);
        }
    }

    @Override
    public void customDisplayPaint(Graphics g, int width, int height) {
        int stopIndex;
        int startIndex;
        if (g == null) {
            return;
        }
        if (this.buffer == null || width != this.panelWidth || height != this.panelHeight || this.charWd == 0) {
            this.panelHeight = height;
            this.panelWidth = width;
            this.buffer = new BufferedImage(width, height, 6);
            this.bufferGraphics = (Graphics2D)this.buffer.getGraphics();
            if (this.recalculate || this.charWd == 0 || this.charGraphics == null) {
                if (this.charWd == 0 || this.charGraphics == null) {
                    this.genCharSizes();
                    this.updateCharHt();
                    this.charBuffer = new BufferedImage(this.boundWd, this.boundHt, 6);
                    this.charGraphics = (Graphics2D)this.charBuffer.getGraphics();
                    this.charGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    this.updateCharHt();
                }
                if (this.calcScrollBars()) {
                    return;
                }
            }
            if (this.backIcon != null) {
                this.bufferIcon = new BufferedImage(width, height, 6);
                this.iconGraphics = (Graphics2D)this.bufferIcon.getGraphics();
                this.iconGraphics.setColor(this.backColor);
                this.iconGraphics.fillRect(0, 0, this.panelWidth, this.panelHeight);
                int left = 0;
                int top = 0;
                int x2 = 0;
                int y2 = 0;
                int wd = this.backIcon.getIconWidth();
                int ht = this.backIcon.getIconHeight();
                switch (this.horizontalAlignment) {
                    case CENTER: {
                        x2 = left = (this.panelWidth - wd) / 2;
                        break;
                    }
                    case RIGHT: {
                        x2 = left = this.panelWidth - wd;
                        break;
                    }
                    case TILED: {
                        x2 = this.panelWidth;
                    }
                }
                switch (this.verticalAlignment) {
                    case BOTTOM: {
                        y2 = top = this.panelHeight - ht;
                        break;
                    }
                    case CENTER: {
                        y2 = top = (this.panelHeight - ht) / 2;
                        break;
                    }
                    case TILED: {
                        y2 = this.panelHeight;
                    }
                }
                for (int w = left; w <= x2; w += wd) {
                    for (int z = top; z <= y2; z += ht) {
                        this.backIcon.paintIcon(this, this.iconGraphics, w, z);
                    }
                }
                this.bufferGraphics.drawImage((Image)this.bufferIcon, 0, 0, null);
            } else {
                this.bufferGraphics.setColor(this.backColor);
                this.bufferGraphics.fillRect(0, 0, this.panelWidth, this.panelHeight);
            }
            this.bufferGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.bufferGraphics.setFont(this.fontPlain);
            this.recalculate = false;
            startIndex = this.selection.getBaseIndex(0, 0);
            stopIndex = Math.min(this.selection.getBaseIndex(width, height), this.doc.sequence.length - 1);
            this.charGraphics.setFont(this.fontPlain);
            if (this.doc.sequence.length > 0 && this.bufferGraphics != null) {
                for (int cIndex = startIndex; cIndex <= stopIndex; ++cIndex) {
                    int numLen;
                    if (((Base[])this.doc.sequence.items)[cIndex] == null || ((Base[])this.doc.sequence.items)[cIndex].base <= '\u0000') continue;
                    this.draw(cIndex, this.bufferGraphics, false);
                    if (!this.showNumbers) continue;
                    this.bufferGraphics.setColor(this.textColor);
                    int dstX = this.getBaseX(cIndex) - this.offsetX;
                    int dstY = this.getBaseY(cIndex) - this.offsetY;
                    if (cIndex == 0) {
                        String num = "" + (cIndex + this.doc.baseOffset);
                        numLen = num.length();
                        if (numLen < this.maxNumCharCount) {
                            num = SequenceEditorPanel.repeat(' ', this.maxNumCharCount - numLen) + num;
                        }
                        this.bufferGraphics.drawString(num, this.boundWd - this.offsetX, dstY + this.charHt34);
                        continue;
                    }
                    if (cIndex > 1 && (cIndex - 1) % this.columns == 0) {
                        String num = "" + (cIndex + this.doc.baseOffset - 1);
                        numLen = num.length();
                        if (numLen < this.maxNumCharCount) {
                            num = SequenceEditorPanel.repeat(' ', this.maxNumCharCount - numLen) + num;
                        }
                        this.bufferGraphics.drawString(num, this.boundWd - this.offsetX, dstY + this.charHt34);
                        continue;
                    }
                    if (cIndex != this.doc.sequence.length && (cIndex + 1) % this.columns != 0) continue;
                    this.bufferGraphics.drawString(" " + (cIndex + this.doc.baseOffset), dstX + this.boundWd, dstY + this.charHt34);
                }
            }
        } else {
            startIndex = this.selection.getBaseIndex(0, 0);
            stopIndex = Math.min(this.selection.getBaseIndex(width, height), this.doc.sequence.length - 1);
        }
        if (this.moveToSelection) {
            this.moveToSelection = false;
            this.checkVisible(true);
        }
        Graphics2D g2d = (Graphics2D)g;
        g.drawImage(this.buffer, 0, 0, this);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.selection.length() > 0) {
            int start = Math.max(this.selection.getFirst(), startIndex);
            int end = Math.min(this.selection.getLast(), stopIndex);
            this.showSelection = true;
            for (int cIndex = start; cIndex <= end; ++cIndex) {
                if (((Base[])this.doc.sequence.items)[cIndex] == null) continue;
                this.draw(cIndex, g2d, false);
            }
            this.showSelection = false;
        } else {
            this.draw(this.selection.dot, g2d, true);
        }
    }

    @Override
    public void displayPanelFocusGained() {
        this.haveFocus = true;
        if (this.hideCursor) {
            this.repaint();
        }
        if (this.blinkTimer.getDelay() > 0) {
            this.blinkTimer.start();
        }
    }

    @Override
    public void displayPanelFocusLost() {
        this.toolTip.hide();
        this.haveFocus = false;
        if (this.blinkTimer.getDelay() > 0) {
            this.blinkTimer.stop();
        }
        this.isCursorShowing = true;
        this.repaint();
    }

    private boolean isCharValid(char chr) {
        return chr > '\u0000' && chr < this.validChars.length && this.validChars[chr] == '\u0001';
    }

    private boolean delNt(int index) {
        if (this.doc.delete(index + 1)) {
            if (this.singleRow) {
                this.columns = this.doc.length();
            }
            this.calcScrollBars();
            return true;
        }
        return false;
    }

    private void insNt(char chr, int index) {
        this.doc.insert(index + 1, new Base(chr));
    }

    private boolean delNt(int start, int stop) {
        if (this.doc.delete(start + 1, stop + 1)) {
            this.calcScrollBars();
            return true;
        }
        return false;
    }

    private boolean isCurorVisible() {
        int index = this.selection.dot;
        Base current = this.doc.sequence.get(index);
        if (current != null) {
            int cTop = this.getBaseY(index);
            int cLeft = this.getBaseX(index);
            if (cTop + this.boundHt < this.offsetY || cTop > this.offsetY + this.panelHeight || cLeft < this.offsetX || cLeft + this.boundWd > this.offsetX + this.panelWidth) {
                return false;
            }
        }
        return true;
    }

    private boolean checkVisible(int index, boolean update) {
        boolean retVal = false;
        int baseTop = this.getBaseY(index);
        int baseLeft = this.getBaseX(index);
        if (baseTop < this.offsetY) {
            this.vScroll.setValue(baseTop, update);
            retVal = true;
        } else if (baseTop + this.boundHt > this.offsetY + this.panelHeight) {
            int newVal = this.panelHeight >= this.boundHt ? baseTop + this.boundHt - this.panelHeight : baseTop - this.panelHeight;
            boolean bl = retVal = newVal != this.offsetY;
            if (newVal != this.offsetY) {
                this.vScroll.setValue(newVal, update);
            }
        }
        if (baseLeft < this.offsetX) {
            this.hScroll.setValue(baseLeft, update);
            retVal = true;
        } else if (baseLeft + this.boundWd > this.offsetX + this.panelWidth) {
            this.hScroll.setValue(baseLeft + this.boundWd - this.panelWidth, update);
            retVal = true;
        }
        return retVal;
    }

    private boolean checkVisible(boolean update) {
        return this.checkVisible(this.selection.dot, update);
    }

    public boolean ensureVisible(int position) {
        if (--position <= 0 || position > this.doc.sequence.length) {
            return false;
        }
        return this.checkVisible(position, true);
    }

    public boolean ensureVisible() {
        return this.ensureVisible(this.selection.dot + 1);
    }

    void setCodon(int cIndex, String newCodon, boolean select) {
        if (newCodon.length() != 3) {
            return;
        }
        char chr0 = newCodon.charAt(0);
        char chr1 = newCodon.charAt(1);
        char chr2 = newCodon.charAt(2);
        int length = this.doc.length();
        if (cIndex >= length) {
            this.doc.sequence.add(new Base());
        }
        if (cIndex + 1 >= length) {
            this.doc.sequence.add(new Base());
            if (cIndex + 2 >= length) {
                this.doc.sequence.add(new Base());
                if (cIndex + 3 >= length) {
                    this.doc.sequence.add(new Base());
                }
            }
        }
        ((Base[])this.doc.sequence.items)[cIndex].setBase(chr0);
        ((Base[])this.doc.sequence.items)[cIndex + 1].setBase(chr1);
        ((Base[])this.doc.sequence.items)[cIndex + 2].setBase(chr2);
        this.doc.genAA(cIndex);
        this.doc.genAA(cIndex + 1);
        this.doc.genAA(cIndex + 2);
        Graphics2D g2d = (Graphics2D)this.displayPanel.getGraphics();
        if (cIndex > 1) {
            this.doc.genAA(cIndex - 2);
            this.draw(cIndex - 2, this.bufferGraphics, false);
            this.draw(cIndex - 2, g2d, false);
        }
        if (cIndex > 0) {
            this.doc.genAA(cIndex - 1);
            this.draw(cIndex - 1, this.bufferGraphics, false);
            this.draw(cIndex - 1, g2d, false);
        }
        this.draw(cIndex, this.bufferGraphics, false);
        this.draw(cIndex + 1, this.bufferGraphics, false);
        this.draw(cIndex + 2, this.bufferGraphics, false);
        this.draw(cIndex, g2d, true);
        this.draw(cIndex + 1, g2d, false);
        this.draw(cIndex + 2, g2d, false);
        if (select) {
            this.selection.select(cIndex + 3);
        }
    }

    boolean isIndexValid(int index) {
        return this.doc.length() > 0 && index >= 0 && index <= this.doc.length();
    }

    private void uppercase(int first, int last) {
        if (this.isIndexValid(first) && this.isIndexValid(last)) {
            boolean repaint = false;
            boolean changed = false;
            int baseFirst = this.getBaseIndex(0, 0);
            int baseLast = this.getBaseIndex(this.panelWidth, this.panelHeight);
            for (int index = first; index <= last; ++index) {
                if (!((Base[])this.doc.sequence.items)[index].uppercase()) continue;
                changed = true;
                if (index < baseFirst || index > baseLast) continue;
                repaint = true;
            }
            if (changed && repaint) {
                this.doc.changed = true;
                this.reDraw();
            }
        }
    }

    private void lowercase(int first, int last) {
        if (this.isIndexValid(first) && this.isIndexValid(last)) {
            boolean repaint = false;
            boolean changed = false;
            int baseFirst = this.getBaseIndex(0, 0);
            int baseLast = this.getBaseIndex(this.panelWidth, this.panelHeight);
            for (int index = first; index <= last; ++index) {
                if (!((Base[])this.doc.sequence.items)[index].lowercase()) continue;
                changed = true;
                if (index < baseFirst || index > baseLast) continue;
                repaint = true;
            }
            if (changed && repaint) {
                this.doc.changed = true;
                this.reDraw();
            }
        }
    }

    public void uppercase() {
        if (this.selection.length() > 0) {
            int first = this.selection.getFirst();
            int last = this.selection.getLast();
            this.uppercase(first, last);
        } else {
            int index = this.selection.getCurrent();
            this.uppercase(index, index);
        }
    }

    public void lowercase() {
        if (this.selection.length() > 0) {
            int first = this.selection.getFirst();
            int last = this.selection.getLast();
            this.lowercase(first, last);
        } else {
            int index = this.selection.getCurrent();
            this.lowercase(index, index);
        }
    }

    public void uppercase(int index) {
        this.uppercase(index, index);
    }

    public void lowercase(int index) {
        this.lowercase(index, index);
    }

    public void uppercaseAll() {
        this.uppercase(0, this.doc.length());
    }

    public void lowercaseAll() {
        this.lowercase(0, this.doc.length());
        this.doc.lowercase();
    }

    @BeanProperty(hidden=true)
    public String getCurrentToolTip() {
        return this.getCurrentToolTip("<br> -");
    }

    @BeanProperty(hidden=true)
    public String getSelectionToolTip() {
        return this.getCurrentToolTip(", ");
    }

    @BeanProperty(hidden=true)
    public void setTmCalculation(int type) {
        if (TmCalculator.isTypeValid(type) && this.tmCalcType != type) {
            this.tmCalcType = type;
        }
    }

    public int getTmCalculation() {
        return this.tmCalcType;
    }

    private String getCurrentToolTip(String separator) {
        if (this.doc.length() == 0) {
            return "";
        }
        int pos = this.selection.getCurrent();
        int first = this.selection.getFirst();
        int last = Math.min(this.selection.getLast(), this.doc.length() - 1);
        int selLen = this.selection.length();
        String retVal = "<html>";
        if (selLen > 1) {
            retVal = retVal + "bps " + (first + 1) + " - " + (last + 1) + " (" + this.selection.length() + "bps)";
            if (selLen > 5 && selLen < 100) {
                retVal = retVal + " Tm = " + TmCalculator.getTm(this.selection.getSequence(), this.tmCalcType) + "C";
            }
        } else {
            if (pos == this.doc.length()) {
                return null;
            }
            retVal = retVal + "bp " + (pos + 1);
        }
        for (ROI roi : this.doc.features) {
            if (!this.ROIcontains(roi, pos)) continue;
            retVal = retVal + separator + " bp " + this.getROIRelativePos(roi, pos) + " of " + roi.getName();
            if (!roi.isAntisense()) continue;
            retVal = retVal + " (complement)";
        }
        return retVal + "</html>";
    }

    private boolean ROIcontains(ROI roi, int index) {
        if (!roi.isValid()) {
            return false;
        }
        ++index;
        if (this.doc.circular && roi.getStart() > roi.getStop()) {
            return index <= roi.getStop() || index >= roi.getStart();
        }
        return roi.getStart() <= index && roi.getStop() >= index;
    }

    private boolean ROIcontains(ROI roi, int first, int last) {
        if (!roi.isValid()) {
            return false;
        }
        if (roi.getStart() > roi.getStop()) {
            return first > last || first <= roi.getStop() || last >= roi.getStart();
        }
        if (first > last) {
            return last >= roi.getStart() || first <= roi.getStop();
        }
        return first <= roi.getStart() && last >= roi.getStart() || last >= roi.getStart() && last <= roi.getStop() || first <= roi.getStop() && last >= roi.getStop();
    }

    private int getROIRelativePos(ROI roi, int index) {
        ++index;
        int fEnd = roi.getStop();
        if (roi.getStart() > roi.getStop()) {
            fEnd += this.doc.sequence.length - 1;
        }
        if (roi.getStart() > index) {
            index += this.doc.sequence.length - 1;
        }
        int pos = index - roi.getStart() + 1;
        if (!roi.isAntisense()) {
            return pos;
        }
        return fEnd - roi.getStart() + 1 - pos + 1;
    }

    private void unannotateROI(ROI roi, int first, int last) {
        if (roi.getStop() < roi.getStart()) {
            if (first <= roi.getStop()) {
                first += this.doc.sequence.length;
            }
            roi.setStop(roi.getStop() + this.doc.sequence.length);
            if (last < roi.getStart()) {
                last += this.doc.sequence.length;
            }
        }
        if (roi.getStart() >= first && roi.getStop() <= last) {
            roi.setStart(-1);
            roi.setStop(-1);
        } else if (roi.getStop() < roi.getStart() && roi.getStop() >= first && roi.getStart() >= last) {
            roi.setStop(first - 1);
            roi.setStart(last - 1);
        } else if (roi.getStart() < first && roi.getStop() > last) {
            ROI newROI = roi.clone();
            roi.setStop(first - 1);
            newROI.setStart(last == this.doc.sequence.length ? 0 : last);
            if (newROI.getStart() > this.doc.sequence.length) {
                newROI.setStart(newROI.getStart() - this.doc.sequence.length);
            }
            if (newROI.getStop() > this.doc.sequence.length) {
                newROI.setStop(newROI.getStop() - this.doc.sequence.length);
            }
            this.doc.addROI(newROI);
        } else if (roi.getStart() < first && roi.getStop() <= last) {
            roi.setStop(first - 1);
        } else if (roi.getStart() >= first && roi.getStart() <= last) {
            roi.setStart(last + 1);
        }
        if (roi.getStart() > this.doc.sequence.length) {
            roi.setStart(roi.getStart() - this.doc.sequence.length);
        }
        if (roi.getStop() > this.doc.sequence.length) {
            roi.setStop(roi.getStop() - this.doc.sequence.length);
        }
    }

    public void reDraw() {
        this.reDraw(false);
    }

    private void reDraw(boolean recalculate) {
        if (recalculate) {
            this.recalculate = true;
        }
        if (this.bufferGraphics != null) {
            this.bufferGraphics.dispose();
            this.buffer = null;
            this.bufferGraphics = null;
        }
        if (this.bufferIcon != null) {
            this.iconGraphics.dispose();
            this.iconGraphics = null;
            this.bufferIcon = null;
        }
        this.repaint();
    }

    boolean calcScrollBars() {
        if (this.hScroll == null || this.vScroll == null) {
            return false;
        }
        boolean retVal = false;
        if (this.doc.length() == 0) {
            boolean bl = retVal = this.hScroll.isVisible() || this.vScroll.isVisible();
            if (retVal) {
                this.setScrollBars(-1);
            }
            if (this.vScroll.getValue() > 0L) {
                this.vScroll.setValue(0L, false);
            }
            if (this.hScroll.getValue() > 0L) {
                this.hScroll.setValue(0L, false);
            }
            this.offsetX = 0;
            this.offsetY = 0;
            return retVal;
        }
        this.rows = this.doc.length() / this.columns + 1;
        this.vMax = Math.max(this.rows * this.boundHt + this.top + this.hScrollHt - this.panelHeight, 0);
        this.hMax = Math.max(this.right + this.maxNumLen - this.panelWidth, 0);
        if (this.hMax > 0 && this.vMax > 0 && !this.autoColumnCount) {
            boolean bl = retVal = !this.hScroll.isVisible() || !this.vScroll.isVisible();
            if (retVal) {
                this.setScrollBars(2);
            }
            this.hScroll.setMaximum(this.hMax + this.boundWd + this.maxNumLen, false);
            this.hScroll.setBlockIncrements(this.boundWd);
            this.vScroll.setMaximum(this.vMax + this.boundHt, false);
            this.vScroll.setBlockIncrements(this.boundHt);
            this.offsetY = (int)Math.min((long)this.offsetY, this.vScroll.getValue());
            this.offsetX = (int)Math.min((long)this.offsetX, this.hScroll.getValue());
        } else if (this.hMax > 0 && !this.autoColumnCount) {
            boolean bl = retVal = !this.hScroll.isVisible() || this.vScroll.isVisible();
            if (retVal) {
                this.setScrollBars(0);
            }
            if (this.vScroll.getValue() > 0L) {
                this.vScroll.setValue(0L, false);
            }
            this.offsetY = 0;
            this.hScroll.setMaximum(this.hMax + this.boundWd + this.maxNumLen, false);
            this.hScroll.setBlockIncrements(this.boundWd);
            this.offsetX = (int)Math.min((long)this.offsetX, this.hScroll.getValue());
        } else if (this.vMax > 0) {
            boolean bl = retVal = this.hScroll.isVisible() || !this.vScroll.isVisible();
            if (retVal) {
                this.setScrollBars(1);
            }
            if (this.hScroll.getValue() > 0L) {
                this.hScroll.setValue(0L, false);
            }
            this.offsetX = 0;
            this.vScroll.setMaximum(this.vMax + this.boundHt, false);
            this.vScroll.setBlockIncrements(this.boundHt);
            this.offsetY = (int)Math.min((long)this.offsetY, this.vScroll.getValue());
        } else {
            boolean bl = retVal = this.hScroll.isVisible() || this.vScroll.isVisible();
            if (retVal) {
                this.setScrollBars(-1);
            }
            if (this.vScroll.getValue() > 0L) {
                this.vScroll.setValue(0L, false);
            }
            if (this.hScroll.getValue() > 0L) {
                this.hScroll.setValue(0L, false);
            }
            this.offsetX = 0;
            this.offsetY = 0;
        }
        return retVal;
    }

    boolean compare(char chr1, char chr2) {
        return (chr1 > 96 && chr1 < 123 ? chr1 - 32 : chr1) == (chr2 > 96 && chr2 < 123 ? chr2 - 32 : chr2);
    }

    @BeanProperty(hidden=true)
    public String getDisplayedSequence() {
        if (this.selection.length() == 0) {
            return this.pGetDisplayedSequence(0, this.doc.length() - 1);
        }
        return this.pGetDisplayedSequence(this.selection.getFirst(), this.selection.getLast());
    }

    private static String repeat(char chr, int num) {
        char[] chars = new char[num];
        Arrays.fill(chars, chr);
        return new String(chars);
    }

    public String getDisplayedSequence(int start, int stop) {
        return this.pGetDisplayedSequence(start - 1, stop - 1);
    }

    public String pGetDisplayedSequence(int start, int stop) {
        String f1 = null;
        String f2 = null;
        String f3 = null;
        String as = null;
        String sense = this.getDNASequence2(start, stop);
        if (!(this.showFrame1 || this.showFrame2 || this.showFrame3 || this.showFrameA1 || this.showFrameA2 || this.showFrameA3 || this.showAntisense)) {
            return sense;
        }
        StringBuilder retVal = new StringBuilder();
        if (this.showFrame1) {
            f1 = this.getAASeq(start, stop, true);
            if (sense.length() > f1.length()) {
                f1 = f1 + SequenceEditorPanel.repeat(' ', sense.length() - f1.length());
            }
        }
        if (this.showFrame2) {
            f2 = " " + this.getAASeq(start + 1, stop, true);
            if (sense.length() > f2.length()) {
                f2 = f2 + SequenceEditorPanel.repeat(' ', sense.length() - f2.length());
            }
        }
        if (this.showFrame3) {
            f3 = "  " + this.getAASeq(start + 2, stop, true);
            if (sense.length() > f3.length()) {
                f3 = f3 + SequenceEditorPanel.repeat(' ', sense.length() - f3.length());
            }
        }
        if (this.showAntisense) {
            as = this.getCompSequence(start, stop);
        }
        int maxLen = sense.length();
        for (int x = 0; x < maxLen; x += this.columns) {
            int startIndex = Math.min(x, maxLen);
            int stopIndex = Math.min(x + this.columns, maxLen);
            if (x > 0) {
                retVal.append("\n\n");
            }
            retVal.append(sense.substring(startIndex, stopIndex));
            if (f1 != null) {
                retVal.append("\n").append(f1.substring(startIndex, stopIndex));
            }
            if (f2 != null) {
                retVal.append("\n").append(f2.substring(startIndex, stopIndex));
            }
            if (f3 != null) {
                retVal.append("\n").append(f3.substring(startIndex, stopIndex));
            }
            if (as == null) continue;
            retVal.append("\n").append(as.substring(startIndex, stopIndex));
        }
        return retVal.toString();
    }

    private String getAASeq(int start, int stop, boolean space) {
        if (this.doc.length() == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (int x = start; x <= stop; x += 3) {
            if (((Base[])this.doc.sequence.items)[x] == null || ((Base[])this.doc.sequence.items)[x].AA == null) continue;
            outSequence.append(((Base[])this.doc.sequence.items)[x].AA.abbr1);
            if (!space) continue;
            outSequence.append("  ");
        }
        return outSequence.toString();
    }

    private String getDNASequence2(int start, int stop) {
        if (this.doc.length() == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (int x = start; x <= stop; ++x) {
            if (((Base[])this.doc.sequence.items)[x] == null || ((Base[])this.doc.sequence.items)[x].base == '\u0000') continue;
            outSequence.append(((Base[])this.doc.sequence.items)[x].base);
        }
        return outSequence.toString();
    }

    private String getCompSequence(int start, int stop) {
        if (this.doc.length() == 0) {
            return "";
        }
        StringBuilder outSequence = new StringBuilder();
        for (int x = start; x <= stop; ++x) {
            if (((Base[])this.doc.sequence.items)[x] == null || ((Base[])this.doc.sequence.items)[x].aBase == '\u0000') continue;
            outSequence.append(((Base[])this.doc.sequence.items)[x].aBase);
        }
        return outSequence.toString();
    }

    public void codonOptimize(int start) {
        int x;
        int length = this.doc.length();
        for (x = start = this.constrain(start, 0, length - 1); x < length; x += 3) {
            if (((Base[])this.doc.sequence.items)[x].AA == null || ((Base[])this.doc.sequence.items)[x].AA.abbr1 == 'X') continue;
            String newCodon = this.doc.codonTable.getHighestCodon(((Base[])this.doc.sequence.items)[x].AA.abbr1);
            ((Base[])this.doc.sequence.items)[x].setBase(newCodon.charAt(0));
            ((Base[])this.doc.sequence.items)[x + 1].setBase(newCodon.charAt(1));
            ((Base[])this.doc.sequence.items)[x + 2].setBase(newCodon.charAt(2));
        }
        for (x = start; x < length; ++x) {
            this.doc.genAA(x);
        }
        this.reDraw(true);
    }

    public void codonOptimizeSelection() {
        int x;
        int start = this.selection.getFirst();
        int stop = this.selection.getLast();
        for (x = start; x < stop; x += 3) {
            if (((Base[])this.doc.sequence.items)[x].AA == null || ((Base[])this.doc.sequence.items)[x].AA.abbr1 == 'X') continue;
            String newCodon = this.doc.codonTable.getHighestCodon(((Base[])this.doc.sequence.items)[x].AA.abbr1);
            ((Base[])this.doc.sequence.items)[x].setBase(newCodon.charAt(0));
            ((Base[])this.doc.sequence.items)[x + 1].setBase(newCodon.charAt(1));
            ((Base[])this.doc.sequence.items)[x + 2].setBase(newCodon.charAt(2));
        }
        for (x = start; x < this.doc.length(); ++x) {
            this.doc.genAA(x);
        }
        this.reDraw(true);
    }

    public void selectAll() {
        this.selection.mark = 0;
        this.selection.moveTo(this.doc.length(), true);
    }

    public void hideToolTip() {
        if (this.toolTip != null) {
            this.toolTip.hide();
        }
    }

    public int getBaseIndex(int x, int y) {
        return this.constrain(this.selection.getBaseIndex(x, y) + 1, 1, this.doc.length() + 1);
    }

    @BeanProperty(preferred=true, description="The optional background picture.")
    public void setIcon(Icon icon) {
        this.backIcon = icon;
        this.reDraw(true);
    }

    public Icon getIcon() {
        return this.backIcon;
    }

    @BeanProperty(preferred=true, description="The horizontal alignment of the optional background picture.")
    public void setHorizontalIconAlignment(HorizontalAlignment alignment) {
        if (alignment.equals((Object)this.horizontalAlignment)) {
            return;
        }
        this.horizontalAlignment = alignment;
        this.repaint();
    }

    public HorizontalAlignment getHorizontalIconAlignment() {
        return this.horizontalAlignment;
    }

    @BeanProperty(preferred=true, description="The vertical alignment of the optional background picture.")
    public void setVerticalIconAlignment(VerticalAlignment alignment) {
        if (alignment == this.verticalAlignment) {
            return;
        }
        this.verticalAlignment = alignment;
        this.repaint();
    }

    public VerticalAlignment getVerticalIconAlignment() {
        return this.verticalAlignment;
    }

    class SelectionCursor {
        private Color colorTrans;
        private Color color;
        private Color borderColor = Color.black;
        private int dot = 0;
        static final int iconAlpha = 100;
        private int mark = 0;

        public SelectionCursor(Color color, int start, int end) {
            this.setColor(color);
            this.dot = start;
            this.mark = end;
        }

        public void setColor(Color color) {
            if (color != null) {
                this.color = color;
                this.colorTrans = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
            }
        }

        public boolean contains(int index) {
            return this.length() > 0 && Math.min(this.dot, this.mark) <= index && Math.max(this.dot, this.mark) >= index;
        }

        public boolean contains(int x, int y) {
            return this.contains(this.getBaseIndex(x, y));
        }

        public int getCurrent() {
            int len = this.length();
            switch (len) {
                case 0: {
                    return this.dot;
                }
                case 1: {
                    return Math.min(this.dot, this.mark);
                }
            }
            return this.dot < this.mark ? this.dot : this.dot - 1;
        }

        public int getFirst() {
            return this.dot < this.mark ? this.dot : this.mark;
        }

        public int getLast() {
            if (this.length() < 2) {
                return Math.min(this.dot, this.mark);
            }
            return this.dot > this.mark ? this.dot - 1 : this.mark - 1;
        }

        public void setLength(int newLen) {
            this.dot = SequenceEditorPanel.this.constrain(this.mark + newLen, 0, SequenceEditorPanel.this.doc.length());
        }

        private void moveTo(int x, int y) {
            this.moveTo(this.getBaseIndex(x, y), false);
        }

        private void moveTo(int x, int y, boolean extend) {
            this.moveTo(this.getBaseIndex(x, y), extend);
        }

        private void moveTo(int index) {
            this.moveTo(index, false);
        }

        private void moveTo(int index, boolean extend) {
            this.dot = SequenceEditorPanel.this.constrain(index, 0, SequenceEditorPanel.this.doc.length());
            if (!extend) {
                this.mark = this.dot;
            }
            if (SequenceEditorPanel.this.blinkTimer.getDelay() > 0) {
                SequenceEditorPanel.this.isCursorShowing = true;
            }
            if (!SequenceEditorPanel.this.checkVisible(true)) {
                SequenceEditorPanel.this.repaint();
            }
            if (SequenceEditorPanel.this.listener != null) {
                SequenceEditorPanel.this.listener.selectionChanged(this.getFirst() + 1, this.getLast() + 1, this.length());
            }
        }

        private void extendTo(int x, int y) {
            this.extendTo(this.getBaseIndex(x, y));
        }

        private void extendTo(int index) {
            SequenceEditorPanel.this.selection.dot = SequenceEditorPanel.this.constrain(index, 0, SequenceEditorPanel.this.doc.length());
            if (SequenceEditorPanel.this.blinkTimer.getDelay() > 0) {
                SequenceEditorPanel.this.isCursorShowing = true;
            }
            if (!SequenceEditorPanel.this.checkVisible(true)) {
                SequenceEditorPanel.this.repaint();
            }
            if (SequenceEditorPanel.this.listener != null) {
                SequenceEditorPanel.this.listener.selectionChanged(this.getFirst() + 1, this.getLast() + 1, this.length());
            }
        }

        private int getRow(int y) {
            return SequenceEditorPanel.this.constrain((y - SequenceEditorPanel.this.top + SequenceEditorPanel.this.offsetY) / SequenceEditorPanel.this.boundHt, 0, SequenceEditorPanel.this.rows - 1);
        }

        private int getCol(int x) {
            return SequenceEditorPanel.this.constrain((x - SequenceEditorPanel.this.left + SequenceEditorPanel.this.offsetX + SequenceEditorPanel.this.boundWdHalf) / SequenceEditorPanel.this.boundWd, 0, SequenceEditorPanel.this.columns);
        }

        private int getBaseIndex(int x, int y) {
            int index = Math.max(Math.min(this.getCol(x) + this.getRow(y) * SequenceEditorPanel.this.columns, this.getIndexLastInRow(y) + 1), this.getIndexFirstInRow(y));
            if (index > SequenceEditorPanel.this.doc.length()) {
                index = SequenceEditorPanel.this.doc.length();
            }
            if (index < 0) {
                index = 0;
            }
            return index;
        }

        private int getIndexFirstInRow(int y) {
            return Math.max(Math.min(this.getCol(0) + this.getRow(y) * SequenceEditorPanel.this.columns, SequenceEditorPanel.this.doc.length()), 0);
        }

        private int getIndexLastInRow(int y) {
            return Math.max(Math.min(SequenceEditorPanel.this.columns - 1 + this.getRow(y) * SequenceEditorPanel.this.columns, SequenceEditorPanel.this.doc.length()), 0);
        }

        public int length() {
            return Math.abs(this.dot - this.mark);
        }

        public void select(int selStart, int selEnd) {
            this.mark = SequenceEditorPanel.this.constrain(selStart, 0, SequenceEditorPanel.this.doc.length());
            this.dot = SequenceEditorPanel.this.constrain(selEnd, 0, SequenceEditorPanel.this.doc.length());
            if (SequenceEditorPanel.this.listener != null) {
                SequenceEditorPanel.this.listener.selectionChanged(this.getFirst() + 1, this.getLast() + 1, this.length());
            }
        }

        public void select(int selStart) {
            this.mark = this.dot = SequenceEditorPanel.this.constrain(selStart, 0, SequenceEditorPanel.this.doc.length());
            if (SequenceEditorPanel.this.listener != null) {
                SequenceEditorPanel.this.listener.selectionChanged(this.getFirst() + 1, this.getLast() + 1, this.length());
            }
        }

        public void clear() {
            this.dot = 0;
            this.mark = 0;
        }

        private String getSequence() {
            if (SequenceEditorPanel.this.doc.length() == 0) {
                return "";
            }
            String outVal = "";
            int first = this.getFirst();
            int last = this.getLast();
            for (int x = first; x <= last; ++x) {
                if (((Base[])((SequenceEditorPanel)SequenceEditorPanel.this).doc.sequence.items)[x] == null) continue;
                outVal = outVal + ((Base[])((SequenceEditorPanel)SequenceEditorPanel.this).doc.sequence.items)[x].base;
            }
            return outVal;
        }
    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT,
        TILED;

    }

    public static enum VerticalAlignment {
        TOP,
        CENTER,
        BOTTOM,
        TILED;

    }

    public static enum DISPLAY_OPTIONS {
        ReadingFrame_1,
        ReadingFrame_2,
        ReadingFrame_3,
        ReadingFrame_4,
        ReadingFrame_5,
        ReadingFrame_6,
        AntisenseStrand,
        Line_Numbers;

    }

    class AAActionListener
    implements ActionListener {
        public Base target;
        public String newCodon;

        public AAActionListener(String newCodon) {
            this.newCodon = newCodon;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SequenceEditorPanel.this.setCodon(SequenceEditorPanel.this.selection.dot, this.newCodon, true);
        }
    }

    class CodonActionListener
    implements ActionListener {
        public String newCodon;

        public CodonActionListener(String codon) {
            this.newCodon = codon;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SequenceEditorPanel.this.setCodon(SequenceEditorPanel.this.selection.dot, this.newCodon, true);
        }
    }

    class UnannotationActionListener
    implements ActionListener {
        ROI roi = null;
        int start = -1;
        int end = -1;

        public UnannotationActionListener(ROI roi, int start, int end) {
            this.roi = roi;
            this.start = start;
            this.end = end;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SequenceEditorPanel.this.unannotateROI(this.roi, this.start, this.end);
            SequenceEditorPanel.this.setChanged(true);
            SequenceEditorPanel.this.reDraw(false);
        }
    }

    class ROIEditActionListener
    implements ActionListener {
        ROI roi = null;

        public ROIEditActionListener(ROI roi) {
            this.roi = roi;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AnnotationEditor f = SequenceEditorPanel.this.showROIEditor(this.roi, SequenceEditorPanel.this.doc.length());
            ROI retROI = f.getROI();
            if (retROI != null) {
                this.roi.cloneFrom(retROI);
                SequenceEditorPanel.this.setChanged(true);
                SequenceEditorPanel.this.reDraw(false);
            }
        }
    }

    class ExtendAnnotationActionListener
    implements ActionListener {
        ROI roi = null;
        int start = 0;
        int end = 0;

        public ExtendAnnotationActionListener(ROI roi, int start, int end) {
            this.roi = roi;
            this.start = start;
            this.end = end;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.roi.getStart() > this.start) {
                this.roi.setStart(this.start);
            }
            if (this.roi.getStop() < this.end) {
                this.roi.setStop(this.end);
            }
            SequenceEditorPanel.this.setChanged(true);
            SequenceEditorPanel.this.reDraw(false);
        }
    }

    class ROIRemActionListener
    implements ActionListener {
        ROI roi = null;

        public ROIRemActionListener(ROI roi) {
            this.roi = roi;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SequenceEditorPanel.this.doc.removeROI(this.roi);
            SequenceEditorPanel.this.setChanged(true);
            SequenceEditorPanel.this.reDraw(false);
        }
    }
}

