/*
 * Decompiled with CFR 0.152.
 */
package SimpleArrayLists;

import java.util.Comparator;

public class SimpleArrayList<T> {
    private int BUFFERSIZE = 250;
    private int length = 0;
    private boolean throwError = true;
    Node<T>[] items = new Node[this.BUFFERSIZE];

    public void setThrowErrors(boolean throwError) {
        this.throwError = throwError;
    }

    public boolean isThrowErrors() {
        return this.throwError;
    }

    public int size() {
        return this.length;
    }

    public void clear() {
        this.items = new Node[this.BUFFERSIZE];
        this.length = 0;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public T get(int index) {
        if (this.length > 0 && index > -1 && index < this.length && this.items[index] != null) {
            return this.items[index].obj;
        }
        if (this.throwError) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " is out of bounds.");
        }
        return null;
    }

    public void add(T f) {
        if (this.length + 1 >= this.items.length) {
            Node[] items2 = new Node[this.items.length + this.BUFFERSIZE];
            System.arraycopy(this.items, 0, items2, 0, this.items.length);
            this.items = items2;
        }
        this.items[this.length] = new Node();
        this.items[this.length].obj = f;
        ++this.length;
    }

    void remove(int index) {
        if (index >= 0 && index < this.length) {
            System.arraycopy(this.items, index + 1, this.items, index, this.items.length - index);
            this.items[this.length] = null;
            --this.length;
        } else if (this.throwError) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " is out of bounds.");
        }
    }

    public void removeEmpty() {
        this.removeEmpty(0);
    }

    public void removeEmpty(int start) {
        if (this.length > start) {
            int wIndex = start;
            for (int rIndex = start; rIndex < this.length; ++rIndex) {
                if (this.items[rIndex] == null) continue;
                if (rIndex > wIndex) {
                    this.items[wIndex] = this.items[rIndex];
                    this.items[rIndex] = null;
                }
                ++wIndex;
            }
            this.length = wIndex;
        }
    }

    public void sort(Comparator c) {
        if (this.length > 2) {
            for (int x = 0; x < this.length - 1; ++x) {
                Object f2;
                int highIndex = x;
                for (int y = x + 1; y < this.length; ++y) {
                    if (c.compare(this.items[highIndex].obj, this.items[y].obj) <= 0) continue;
                    highIndex = y;
                }
                if (highIndex == x) continue;
                Object f1 = this.items[x].obj;
                this.items[x].obj = f2 = this.items[highIndex].obj;
                this.items[highIndex].obj = f1;
            }
        }
    }

    public boolean isIndexValid(int index) {
        return this.length > 0 && index > -1 && index < this.length && this.items[index] != null;
    }

    private class Node<T> {
        T obj;

        private Node() {
        }
    }
}

