/*
 * Decompiled with CFR 0.152.
 */
package SnapGeneFileReader;

import SnapGeneFileReader.XMLAttribute;
import SnapGeneFileReader.XMLConstants;
import SnapGeneFileReader.XMLElement;
import SnapGeneFileReader.XMLParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;

class XMLDocument
implements XMLConstants {
    static String error = "";
    private XMLElement root = new XMLElement("root");
    private static final String spacerAdd = "  ";

    public XMLDocument() {
    }

    public XMLDocument(String xmlDataString) {
        this.loadXMLString(xmlDataString);
    }

    public void loadXMLString(String xmlDataString) {
        XMLParser parser = new XMLParser(xmlDataString);
        this.root = parser.parse();
    }

    static XMLElement makeRoot(String xmlDataString) {
        XMLParser parser = new XMLParser(xmlDataString);
        XMLElement root = parser.parse();
        return root;
    }

    public static XMLDocument loadXML(String xmlDataString) {
        XMLDocument doc = new XMLDocument();
        doc.loadXMLString(xmlDataString);
        return doc;
    }

    public static XMLDocument loadXML(File file) {
        if (!file.exists()) {
            error = "file does not exist";
            return null;
        }
        if (!file.isFile()) {
            error = "specified path is not a file.";
            return null;
        }
        if (!file.canRead()) {
            error = "file does not have read permission";
            return null;
        }
        error = "";
        try {
            String xmlDataString = Files.readString(file.toPath());
            return XMLDocument.loadXML(xmlDataString);
        }
        catch (IOException ex) {
            error = "Error reading file contents";
            return null;
        }
    }

    public boolean loadXMLFile(File file) {
        if (!file.exists()) {
            error = "file does not exist";
            return false;
        }
        if (!file.isFile()) {
            error = "specified path is not a file.";
            return false;
        }
        if (!file.canRead()) {
            error = "file does not have read permission";
            return false;
        }
        error = "";
        try {
            String xmlDataString = Files.readString(file.toPath());
            this.loadXMLString(xmlDataString);
            return true;
        }
        catch (IOException ex) {
            error = "Error reading file contents";
            return false;
        }
    }

    public boolean write(File file) {
        if (file.exists()) {
            if (!file.isFile()) {
                error = "specified path is not a file.";
                return false;
            }
            if (!file.canWrite()) {
                error = "file does not have write permission";
                return false;
            }
        }
        error = "";
        try {
            Files.write(file.toPath(), this.root.exportToString(0).getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException ex) {
            error = ex.getMessage();
            return false;
        }
    }

    public static String getError() {
        return error;
    }

    public String toString() {
        return super.toString() + ", root=" + this.root.toString();
    }

    public void addElement(XMLElement element) {
        this.root.addElement(element);
    }

    public int getElementCount() {
        if (this.root.elements == null) {
            return 0;
        }
        return this.root.elements.size();
    }

    public XMLElement getElement(int index) {
        if (this.root.elements != null && this.root.elements.size() > index) {
            return this.root.elements.get(index);
        }
        return null;
    }

    public void removeElement(int index) {
        if (this.root.elements != null && this.root.elements.size() > index) {
            this.root.elements.remove(index);
        }
    }

    public XMLElement getRoot() {
        return this.root;
    }

    public String serialize() {
        return this.root.serialize();
    }

    public static String repeat(char chr, int num) {
        char[] chars = new char[num];
        Arrays.fill(chars, chr);
        return new String(chars);
    }

    public static String repeat(String string, int count) {
        int copied;
        if (count < 0) {
            throw new IllegalArgumentException("count is negative: " + count);
        }
        if (count == 1) {
            return string;
        }
        byte[] value = string.getBytes();
        int coder = 0;
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, value[0]);
            return new String(single, coder);
        }
        if (Integer.MAX_VALUE / count < len) {
            throw new OutOfMemoryError("Repeating " + len + " bytes String " + count + " times will produce a String exceeding maximum size.");
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple, coder);
    }

    public static void printElement(XMLElement element) {
        XMLDocument.printElement(element, "");
    }

    private static void printElement(XMLElement element, String spacer) {
        System.out.println(spacer + " - element: " + element.getName());
        if (element.attributes != null && !element.attributes.isEmpty()) {
            for (XMLAttribute xMLAttribute : element.attributes) {
                System.out.println(spacer + spacerAdd + " - attribute key: " + xMLAttribute.keyWord + ", value: " + xMLAttribute.value);
            }
        }
        System.out.println(spacer + spacerAdd + " - Body text: " + element.getText());
        if (element.elements != null && !element.elements.isEmpty()) {
            for (XMLElement xMLElement : element.elements) {
                XMLDocument.printElement(xMLElement, spacer + spacerAdd);
            }
        }
    }
}

