/*
 * Decompiled with CFR 0.152.
 */
package ToolTip;

import ToolTip.TextToolTip;
import java.awt.Component;
import java.awt.event.MouseEvent;

public class BasicTextToolTip
extends TextToolTip {
    boolean showOnPress = true;
    boolean showOnRelease = false;
    boolean showOnDrag = false;
    boolean showOnMove = false;
    boolean hideOnPress = false;
    boolean hideOnRelease = true;
    boolean hideOnDrag = true;
    boolean hideOnMove = true;
    boolean hideOnFocusLost = true;

    public BasicTextToolTip(Component owner) {
        super(owner);
        this.init();
    }

    public BasicTextToolTip(Component owner, String text) {
        super(owner, text);
        this.init();
    }

    public BasicTextToolTip(Component owner, String text, int x, int y) {
        super(owner, text, x, y);
        this.init();
    }

    void init() {
        this.owner.addMouseListener(this);
        this.owner.addMouseMotionListener(this);
        this.owner.addFocusListener(this);
    }

    public boolean getHideOnFocusLost() {
        return this.hideOnFocusLost;
    }

    public boolean getHideOnDrag() {
        return this.hideOnDrag;
    }

    public boolean getHideOnRelease() {
        return this.hideOnRelease;
    }

    public boolean getHideOnMove() {
        return this.hideOnMove;
    }

    public boolean getHideOnPress() {
        return this.hideOnPress;
    }

    public boolean getShowOnDrag() {
        return this.showOnDrag;
    }

    public boolean getShowOnRelease() {
        return this.showOnRelease;
    }

    public boolean getShowOnMove() {
        return this.showOnMove;
    }

    public boolean getShowOnPress() {
        return this.showOnPress;
    }

    public void setHideOnFocusLost(boolean hide) {
        this.hideOnFocusLost = hide;
        if (this.owner != null && hide && !this.owner.hasFocus()) {
            this.hide();
        }
    }

    public void setShowOnDrag(boolean show) {
        this.showOnDrag = show;
        if (show) {
            this.hideOnDrag = false;
        }
    }

    public void setShowOnRelease(boolean show) {
        this.showOnRelease = show;
        if (show) {
            this.hideOnRelease = false;
        }
    }

    public void setShowOnMove(boolean show) {
        this.hideOnMove = show;
        if (show) {
            this.hideOnMove = false;
        }
    }

    public void setShowOnPress(boolean show) {
        this.showOnPress = show;
        if (show) {
            this.hideOnPress = false;
        }
    }

    public void setHideOnDrag(boolean show) {
        this.hideOnDrag = show;
        if (show) {
            this.showOnDrag = false;
        }
    }

    public void setHideOnRelease(boolean show) {
        this.hideOnRelease = show;
        if (show) {
            this.showOnRelease = false;
        }
    }

    public void setHideOnMove(boolean show) {
        this.hideOnMove = show;
        if (show) {
            this.showOnMove = false;
        }
    }

    public void setHideOnPress(boolean show) {
        this.hideOnPress = show;
        if (show) {
            this.showOnPress = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.visible && this.showOnPress && this.haveText) {
            this.show(e.getX(), e.getY());
        } else if (this.visible && this.hideOnPress || !this.haveText) {
            this.hide();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.visible && this.showOnRelease && this.haveText) {
            this.show(e.getX(), e.getY());
        } else if (this.visible && this.hideOnRelease || !this.haveText) {
            this.hide();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hide();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.visible) {
            if (this.hideOnDrag || !this.haveText) {
                this.hide();
            } else {
                this.setLocation(e.getX(), e.getY());
            }
        } else if (this.showOnDrag) {
            this.show(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.visible) {
            if (this.hideOnMove || !this.haveText) {
                this.hide();
            } else {
                this.setLocation(e.getX(), e.getY());
            }
        } else if (this.showOnMove && this.haveText) {
            this.show(e.getX(), e.getY());
        }
    }

    @Override
    public void show() {
        if (!this.visible && this.w != null) {
            this.owner.addMouseMotionListener(this);
            super.show();
        }
    }

    @Override
    public void hide() {
        super.hide();
        this.owner.removeMouseMotionListener(this);
    }
}

