/*
 * Decompiled with CFR 0.152.
 */
package ToolTip;

import ToolTip.TextToolTip;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public class DelayedToolTip
extends TextToolTip {
    Timer delayTimer = null;
    int displayDelay = 500;
    ActionListener showActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DelayedToolTip.this.delayTimer.stop();
            DelayedToolTip.this.show();
        }
    };

    public void setInitialDelay(int delay) {
        this.delayTimer.stop();
        this.displayDelay = delay;
        this.delayTimer = new Timer(this.displayDelay, this.showActionListener);
    }

    public DelayedToolTip(Component owner) {
        super(owner);
        this.init();
    }

    public DelayedToolTip(Component owner, String text) {
        super(owner, text);
        this.init();
    }

    public DelayedToolTip(Component owner, String text, int x, int y) {
        super(owner, text, x, y);
        this.init();
    }

    void init() {
        this.delayTimer = new Timer(this.displayDelay, this.showActionListener);
        this.owner.addMouseListener(this);
        this.owner.addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.delayTimer.stop();
        this.hide();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.haveText) {
            this.delayTimer.start();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.delayTimer.start();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.delayTimer.stop();
        this.hide();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        this.resetTimer();
    }

    void resetTimer() {
        this.delayTimer.stop();
        this.hide();
        if (this.haveText) {
            this.delayTimer.start();
        }
    }
}

