/*
 * Decompiled with CFR 0.152.
 */
package TransparentDisplayFrames;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class TransparentDisplayFrame
extends JFrame {
    private Point restoredLocation = new Point();
    private int minWd = 50;
    private int minHt = 50;
    private int restoredWd = 0;
    private int restoredHt = 0;
    private int alpha = 180;
    private boolean maximized = false;
    boolean movable = true;
    private Color backColor = Color.BLUE;
    private BufferedImage buffer = null;
    private Graphics2D bufferG = null;
    private int bufferHt = 0;
    private int bufferWd = 0;
    private final Cursor moveCursor = new Cursor(13);
    private Cursor defCursor = new Cursor(0);
    private JPanel panel;
    private Dimension snapSize = new Dimension(10, 10);
    private int direction = -1;
    private Point pressed;
    private Rectangle bounds;
    protected static final int NORTH = 1;
    protected static final int WEST = 2;
    protected static final int SOUTH = 4;
    protected static final int EAST = 8;
    private static Map<Integer, Integer> cursors = new HashMap<Integer, Integer>();

    private TransparentDisplayFrame me() {
        return this;
    }

    public JPanel getContentPanel() {
        return this.panel;
    }

    public void setDefaultCursor(int cursor) {
        boolean swapNow = this.getCursor().equals(this.defCursor);
        this.defCursor = new Cursor(cursor);
        if (swapNow) {
            this.setCursor(this.defCursor);
        }
    }

    public Cursor getDefaultCursor() {
        return this.defCursor;
    }

    public void setMovable(boolean b) {
        this.movable = b;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public TransparentDisplayFrame() {
        cursors.put(1, 8);
        cursors.put(2, 10);
        cursors.put(4, 9);
        cursors.put(8, 11);
        cursors.put(3, 6);
        cursors.put(9, 7);
        cursors.put(6, 4);
        cursors.put(12, 5);
        this.init();
    }

    public TransparentDisplayFrame(Frame owner) {
        cursors.put(1, 8);
        cursors.put(2, 10);
        cursors.put(4, 9);
        cursors.put(8, 11);
        cursors.put(3, 6);
        cursors.put(9, 7);
        cursors.put(6, 4);
        cursors.put(12, 5);
        this.init();
    }

    private void setCursor(int x, int y) {
        this.direction = 0;
        int borderLen = 10;
        if (x < borderLen) {
            this.direction += 2;
        } else if (x > this.panel.getWidth() - borderLen) {
            this.direction += 8;
        }
        if (y < borderLen) {
            ++this.direction;
        } else if (y > this.panel.getHeight() - borderLen) {
            this.direction += 4;
        }
        if (this.direction == 0) {
            this.panel.setCursor(this.moveCursor);
        } else {
            this.panel.setCursor(Cursor.getPredefinedCursor(cursors.get(this.direction)));
        }
    }

    protected void changeBounds(int direction, Rectangle bounds, Point mouse) {
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        int deltaX = mouse.x - this.pressed.x;
        int deltaY = mouse.y - this.pressed.y;
        if (deltaX != 0) {
            int newWd;
            if (2 == (direction & 2)) {
                newWd = width - deltaX;
                if (newWd % this.snapSize.width == 0 && newWd >= 50) {
                    width = newWd;
                    x += deltaX;
                    this.pressed.x = mouse.x;
                }
            } else if (8 == (direction & 8) && (newWd = width + deltaX) % this.snapSize.width == 0 && newWd >= 50) {
                width = newWd;
                this.pressed.x = mouse.x;
            }
        }
        if (deltaY != 0) {
            int newHt;
            if (1 == (direction & 1)) {
                newHt = height - deltaY;
                if (newHt % this.snapSize.height == 0 && newHt >= 50) {
                    height = newHt;
                    y += deltaY;
                    this.pressed.y = mouse.y;
                }
            } else if (4 == (direction & 4) && (newHt = height + deltaY) % this.snapSize.height == 0 && newHt >= 50) {
                height = newHt;
                this.pressed.y = mouse.y;
            }
        }
        if (width != bounds.width || height != bounds.height) {
            bounds.width = width;
            bounds.height = height;
            bounds.x = x;
            bounds.y = y;
            this.setBounds(x, y, width, height);
            this.validate();
        }
    }

    public void setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            return;
        }
        this.alpha = alpha;
        this.updateBackColor(this.backColor);
    }

    public void updateBackColor(Color color) {
        if (color != null) {
            this.backColor = new Color(this.backColor.getRed(), this.backColor.getGreen(), this.backColor.getBlue(), this.alpha);
            this.refresh();
        } else {
            this.backColor = null;
        }
    }

    public void refresh() {
        this.buffer = null;
        this.bufferG = null;
        this.setBackground(new Color(0, true));
    }

    public void paintCanvas(Graphics2D g) {
    }

    public Graphics2D getBufferGraphics() {
        return this.bufferG;
    }

    private void init() {
        this.setUndecorated(true);
        this.setBackground(new Color(0, true));
        this.panel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                if (TransparentDisplayFrame.this.buffer == null) {
                    TransparentDisplayFrame.this.bufferWd = this.getWidth();
                    TransparentDisplayFrame.this.bufferHt = this.getHeight();
                    TransparentDisplayFrame.this.buffer = new BufferedImage(TransparentDisplayFrame.this.bufferWd, TransparentDisplayFrame.this.bufferHt, 2);
                    TransparentDisplayFrame.this.bufferG = (Graphics2D)TransparentDisplayFrame.this.buffer.getGraphics();
                    if (TransparentDisplayFrame.this.backColor != null) {
                        TransparentDisplayFrame.this.bufferG.setColor(TransparentDisplayFrame.this.backColor);
                        TransparentDisplayFrame.this.bufferG.fillRect(0, 0, TransparentDisplayFrame.this.bufferWd, TransparentDisplayFrame.this.bufferHt);
                    }
                }
                TransparentDisplayFrame.this.paintCanvas(TransparentDisplayFrame.this.bufferG);
                g.drawImage(TransparentDisplayFrame.this.buffer, 0, 0, this);
            }
        };
        this.add(this.panel);
        this.setBounds(0, 0, 250, 250);
        this.panel.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.panel.setVisible(true);
        this.backColor = new Color(this.backColor.getRed(), this.backColor.getGreen(), this.backColor.getBlue(), this.alpha);
        this.panel.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                TransparentDisplayFrame.this.me().keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                TransparentDisplayFrame.this.me().keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TransparentDisplayFrame.this.me().keyReleased(e);
            }
        });
        this.panel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                TransparentDisplayFrame.this.me().mouseWheelMoved(e);
            }
        });
        this.panel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TransparentDisplayFrame.this.me().mouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TransparentDisplayFrame.this.panel.requestFocusInWindow();
                if (TransparentDisplayFrame.this.movable && TransparentDisplayFrame.this.direction != -1) {
                    TransparentDisplayFrame.this.pressed = e.getPoint();
                    if (!TransparentDisplayFrame.this.maximized && e.isControlDown()) {
                        if (TransparentDisplayFrame.this.direction == 0 && !TransparentDisplayFrame.this.moveStarted() || TransparentDisplayFrame.this.direction > 0 && !TransparentDisplayFrame.this.resizeStarted()) {
                            TransparentDisplayFrame.this.direction = -1;
                        }
                        if (TransparentDisplayFrame.this.direction == -1) {
                            TransparentDisplayFrame.this.setCursor(((TransparentDisplayFrame)TransparentDisplayFrame.this).pressed.x, ((TransparentDisplayFrame)TransparentDisplayFrame.this).pressed.y);
                        }
                        if (TransparentDisplayFrame.this.direction != 0) {
                            SwingUtilities.convertPointToScreen(TransparentDisplayFrame.this.pressed, TransparentDisplayFrame.this.panel);
                            TransparentDisplayFrame.this.bounds = TransparentDisplayFrame.this.getBounds();
                        }
                    }
                } else {
                    TransparentDisplayFrame.this.me().mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!TransparentDisplayFrame.this.maximized && TransparentDisplayFrame.this.direction != -1) {
                    TransparentDisplayFrame.this.panel.setCursor(TransparentDisplayFrame.this.defCursor);
                    TransparentDisplayFrame.this.direction = -1;
                    TransparentDisplayFrame.this.resizeFinished();
                } else {
                    TransparentDisplayFrame.this.me().mouseReleased(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TransparentDisplayFrame.this.me().mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TransparentDisplayFrame.this.me().mouseExited(e);
            }
        });
        this.panel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TransparentDisplayFrame.this.movable && !TransparentDisplayFrame.this.maximized && TransparentDisplayFrame.this.direction > -1) {
                    if (TransparentDisplayFrame.this.direction == 0) {
                        TransparentDisplayFrame.this.restoredLocation = TransparentDisplayFrame.this.getLocation(TransparentDisplayFrame.this.restoredLocation);
                        TransparentDisplayFrame.this.setLocation(((TransparentDisplayFrame)TransparentDisplayFrame.this).restoredLocation.x - ((TransparentDisplayFrame)TransparentDisplayFrame.this).pressed.x + e.getX(), ((TransparentDisplayFrame)TransparentDisplayFrame.this).restoredLocation.y - ((TransparentDisplayFrame)TransparentDisplayFrame.this).pressed.y + e.getY());
                    } else {
                        Point dragged = e.getPoint();
                        SwingUtilities.convertPointToScreen(dragged, TransparentDisplayFrame.this.panel);
                        TransparentDisplayFrame.this.changeBounds(TransparentDisplayFrame.this.direction, TransparentDisplayFrame.this.bounds, dragged);
                    }
                } else {
                    TransparentDisplayFrame.this.me().mouseDragged(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (TransparentDisplayFrame.this.panel.hasFocus() && TransparentDisplayFrame.this.movable && e.isControlDown()) {
                    TransparentDisplayFrame.this.setCursor(e.getX(), e.getY());
                } else {
                    TransparentDisplayFrame.this.me().mouseMoved(e);
                }
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                TransparentDisplayFrame.this.panel.setBounds(0, 0, TransparentDisplayFrame.this.getWidth(), TransparentDisplayFrame.this.getHeight());
                TransparentDisplayFrame.this.refresh();
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }
        });
        this.panel.setCursor(this.defCursor);
        this.setMaximized(false);
        this.setBackground(new Color(0, true));
        this.setVisible(true);
    }

    public void setMaximized(boolean maximize) {
        this.maximized = maximize;
        if (this.maximized) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            double width = screenSize.getWidth();
            double height = screenSize.getHeight();
            Rectangle cScreenBounds = this.getGraphicsConfiguration().getBounds();
            this.setBounds(cScreenBounds.x, cScreenBounds.y, (int)width, (int)height);
        } else {
            this.setBounds(this.restoredLocation.x, this.restoredLocation.y, Math.max(this.restoredWd, this.minWd), Math.max(this.restoredHt, this.minHt));
        }
    }

    public void setMaximizedMulti(boolean maximize) {
        this.maximized = maximize;
        if (this.maximized) {
            GraphicsDevice[] gs;
            Rectangle totalSize = new Rectangle();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice curGs : gs = ge.getScreenDevices()) {
                GraphicsConfiguration[] gc;
                for (GraphicsConfiguration curGc : gc = curGs.getConfigurations()) {
                    totalSize.add(curGc.getBounds());
                }
            }
            this.setBounds(totalSize.x, totalSize.y, totalSize.width, totalSize.height);
            this.panel.setBounds(totalSize.x, totalSize.y, totalSize.width, totalSize.height);
        } else {
            this.setBounds(this.restoredLocation.x, this.restoredLocation.y, Math.max(this.restoredWd, this.minWd), Math.max(this.restoredHt, this.minHt));
            this.panel.setBounds(this.restoredLocation.x, this.restoredLocation.y, Math.max(this.restoredWd, this.minWd), Math.max(this.restoredHt, this.minHt));
        }
    }

    public void close() {
        this.dispose();
    }

    public boolean resizeStarted() {
        return true;
    }

    public boolean moveStarted() {
        return true;
    }

    public void resizeFinished() {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        new TransparentDisplayFrame().setVisible(true);
    }
}

