/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class GhostTextAreaUI
extends BasicTextAreaUI {
    private Color ghostTextColor = Color.LIGHT_GRAY;
    private JTextComponent editor;

    public static ComponentUI createUI(JComponent c) {
        return new GhostTextAreaUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.editor = (JTextComponent)c;
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.editor = null;
    }

    @Override
    protected void paintBackground(Graphics g) {
        String gText;
        super.paintBackground(g);
        String text = this.editor.getText();
        if ((text == null || text.length() == 0) && (gText = this.editor.getToolTipText()) != null && gText.length() > 0) {
            int hgt = g.getFontMetrics(g.getFont()).getHeight();
            int top = hgt - 4;
            g.setColor(this.ghostTextColor);
            g.drawString(gText, 5, top);
        }
    }
}

