/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import IconRenderers.FlatFileViewDirectoryIcon;
import Tools.SystemInfo;
import Tools.UITools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import javax.swing.table.TableCellRenderer;
import plaf.UIUtilities;

public class RenderedFileChooserUI
extends MetalFileChooserUI {
    private static JToggleButton[] addedPreShortCuts = null;
    private static JToggleButton[] addedPostShortCuts = null;
    private final FlatFileView fileView = new FlatFileView();
    private FlatShortcutsPanel shortcutsPanel;
    JPanel topButtonPanel;
    JPanel bottomButtonPanel;
    private static ButtonUI shortcutButtonUI;

    public static void setAddedPreShortCuts(JToggleButton ... buttons) {
        addedPreShortCuts = buttons;
    }

    public static void setAddedPostShortCuts(JToggleButton ... buttons) {
        addedPostShortCuts = buttons;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedFileChooserUI((JFileChooser)c);
    }

    public RenderedFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        FlatShortcutsPanel panel;
        super.installComponents(fc);
        this.patchUI(fc);
        if (!UIManager.getBoolean("FileChooser.noPlacesBar") && (panel = this.createShortcutsPanel(fc)).getComponentCount() > 0) {
            this.shortcutsPanel = panel;
            this.shortcutsPanel.setBorder(null);
            fc.add((Component)this.shortcutsPanel, "Before");
            fc.addPropertyChangeListener(this.shortcutsPanel);
        }
        UIUtilities.setContainerTransparent(fc);
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        super.uninstallComponents(fc);
        if (this.shortcutsPanel != null) {
            fc.removePropertyChangeListener(this.shortcutsPanel);
            this.shortcutsPanel = null;
        }
    }

    public JPanel getTopButtonPanel() {
        return this.topButtonPanel;
    }

    private void patchUI(JFileChooser fc) {
        Component topButtonPanel;
        Component topPanel = fc.getComponent(0);
        if (topPanel instanceof JPanel && ((JPanel)topPanel).getLayout() instanceof BorderLayout && (topButtonPanel = ((JPanel)topPanel).getComponent(0)) instanceof JPanel && ((JPanel)topButtonPanel).getLayout() instanceof BoxLayout) {
            Insets margin2 = UIManager.getInsets("Button.margin");
            Component[] comps = ((JPanel)topButtonPanel).getComponents();
            for (int i = comps.length - 1; i >= 0; --i) {
                Component c = comps[i];
                if (c instanceof JButton || c instanceof JToggleButton) {
                    AbstractButton b = (AbstractButton)c;
                    b.putClientProperty("JButton.buttonType", "toolBarButton");
                    b.setMargin(margin2);
                    b.setFocusable(false);
                    continue;
                }
                if (!(c instanceof Box.Filler)) continue;
                ((JPanel)topButtonPanel).remove(i);
            }
        }
        try {
            int maximumRowCount;
            Component directoryComboBox = ((JPanel)topPanel).getComponent(2);
            if (directoryComboBox instanceof JComboBox && (maximumRowCount = UIManager.getInt("ComboBox.maximumRowCount")) > 0) {
                ((JComboBox)directoryComboBox).setMaximumRowCount(maximumRowCount);
            }
        }
        catch (ArrayIndexOutOfBoundsException directoryComboBox) {
            // empty catch block
        }
        LayoutManager layout = fc.getLayout();
        if (layout instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)layout;
            borderLayout.setHgap(8);
            Component north = borderLayout.getLayoutComponent("North");
            Component lineEnd = borderLayout.getLayoutComponent("After");
            Component center = borderLayout.getLayoutComponent("Center");
            Component south = borderLayout.getLayoutComponent("South");
            if (north instanceof JPanel) {
                this.topButtonPanel = (JPanel)north;
            }
            if (south instanceof JPanel) {
                this.bottomButtonPanel = (JPanel)north;
            }
            if (north != null && lineEnd != null && center != null && south != null) {
                JPanel p = new JPanel(new BorderLayout(0, 11));
                p.add(north, "North");
                p.add(lineEnd, "After");
                p.add(center, "Center");
                p.add(south, "South");
                fc.add((Component)p, "Center");
            }
        }
    }

    @Override
    protected JPanel createDetailsView(JFileChooser fc) {
        JPanel p = super.createDetailsView(fc);
        if (!UITools.isWindows()) {
            return p;
        }
        JScrollPane scrollPane = null;
        for (Component c : p.getComponents()) {
            if (!(c instanceof JScrollPane)) continue;
            scrollPane = (JScrollPane)c;
            break;
        }
        if (scrollPane == null) {
            return p;
        }
        Component view = scrollPane.getViewport().getView();
        if (!(view instanceof JTable)) {
            return p;
        }
        JTable table = (JTable)view;
        final TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        table.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof String && ((String)value).startsWith("\u200e")) {
                    String str = (String)value;
                    char[] buf = new char[str.length()];
                    int j = 0;
                    for (int i = 0; i < buf.length; ++i) {
                        char ch = str.charAt(i);
                        if (ch == '\u200e' || ch == '\u200f') continue;
                        buf[j++] = ch;
                    }
                    value = new String(buf, 0, j);
                }
                return defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        return p;
    }

    protected FlatShortcutsPanel createShortcutsPanel(JFileChooser fc) {
        return new FlatShortcutsPanel(fc);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension prefSize = super.getPreferredSize(c);
        Dimension minSize = this.getMinimumSize(c);
        int shortcutsPanelWidth = this.shortcutsPanel != null ? this.shortcutsPanel.getPreferredSize().width : 0;
        return new Dimension(Math.max(prefSize.width, minSize.width + shortcutsPanelWidth), Math.max(prefSize.height, minSize.height));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return RenderedFileChooserUI.doNotUseSystemIcons() ? super.getFileView(fc) : this.fileView;
    }

    @Override
    public void clearIconCache() {
        if (RenderedFileChooserUI.doNotUseSystemIcons()) {
            super.clearIconCache();
        } else {
            this.fileView.clearIconCache();
        }
    }

    private static boolean doNotUseSystemIcons() {
        return SystemInfo.isWindows && SystemInfo.isX86 && SystemInfo.isJava_17_orLater && SystemInfo.javaVersion < SystemInfo.toVersion(17, 0, 3, 0);
    }

    public void removeShortcut(JToggleButton button) {
        this.shortcutsPanel.removeShortcut(button);
    }

    public void addShortcut(JToggleButton button) {
        this.addShortcut(button, this.shortcutsPanel.buttonGroup.getButtonCount());
    }

    public void addShortcut(JToggleButton button, int index) {
        this.shortcutsPanel.add((Component)button, index);
        this.shortcutsPanel.buttonGroup.add(button);
        this.shortcutsPanel.setLayout(new GridLayout(this.shortcutsPanel.buttonGroup.getButtonCount(), 0));
    }

    public static File[] getChooserShortcutPanelFiles(FileSystemView fsv) {
        try {
            if (SystemInfo.isJava_12_orLater) {
                Method m = fsv.getClass().getMethod("getChooserShortcutPanelFiles", new Class[0]);
                File[] files = (File[])m.invoke((Object)fsv, new Object[0]);
                if (files.length == 1 && files[0].equals(new File(System.getProperty("user.home")))) {
                    files = new File[]{};
                }
                return files;
            }
            if (SystemInfo.isWindows) {
                Class<?> cls = Class.forName("sun.awt.shell.ShellFolder");
                Method m = cls.getMethod("get", String.class);
                return (File[])m.invoke(null, "fileChooserShortcutPanelFolders");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static void setShortcutButtonUI(ButtonUI ui) {
        shortcutButtonUI = ui;
    }

    public static ButtonUI getShortcutButtonUI() {
        return shortcutButtonUI;
    }

    private class FlatFileView
    extends BasicFileChooserUI.BasicFileView {
        private FlatFileView() {
            super(RenderedFileChooserUI.this);
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            if (f != null) {
                try {
                    icon = RenderedFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (icon != null) {
                    this.cacheIcon(f, icon);
                    return icon;
                }
            }
            if ((icon = super.getIcon(f)) instanceof ImageIcon) {
                this.cacheIcon(f, icon);
            }
            return icon;
        }
    }

    public static class FlatShortcutsPanel
    extends JPanel
    implements PropertyChangeListener {
        private final JFileChooser fc;
        private final Dimension buttonSize;
        private final Dimension iconSize;
        private final Function<File[], File[]> filesFunction;
        private final Function<File, String> displayNameFunction;
        private final Function<File, Icon> iconFunction;
        protected final File[] files;
        protected final JToggleButton[] buttons;
        protected final ButtonGroup buttonGroup = new ButtonGroup();

        /*
         * WARNING - void declaration
         */
        public FlatShortcutsPanel(JFileChooser fc) {
            this.setOpaque(false);
            this.fc = fc;
            this.buttonSize = this.getUIDimension("FileChooser.shortcuts.buttonSize", 84, 64);
            this.iconSize = this.getUIDimension("FileChooser.shortcuts.iconSize", 32, 32);
            this.filesFunction = (Function)UIManager.get("FileChooser.shortcuts.filesFunction");
            this.displayNameFunction = (Function)UIManager.get("FileChooser.shortcuts.displayNameFunction");
            this.iconFunction = (Function)UIManager.get("FileChooser.shortcuts.iconFunction");
            FileSystemView fsv = fc.getFileSystemView();
            File[] files = RenderedFileChooserUI.getChooserShortcutPanelFiles(fsv);
            if (this.filesFunction != null) {
                files = this.filesFunction.apply(files);
            }
            ArrayList<void> filesList = new ArrayList<void>();
            ArrayList<JToggleButton> buttonsList = new ArrayList<JToggleButton>();
            for (File file : files) {
                void var9_11;
                if (file == null) continue;
                if (fsv.isFileSystemRoot(file)) {
                    File file2 = fsv.createFileObject(file.getAbsolutePath());
                }
                String name = this.getDisplayName(fsv, (File)var9_11);
                Icon icon = this.getIcon(fsv, (File)var9_11);
                if (name == null) continue;
                int lastSepIndex = name.lastIndexOf(File.separatorChar);
                if (lastSepIndex >= 0 && lastSepIndex < name.length() - 1) {
                    name = name.substring(lastSepIndex + 1);
                }
                if (!(icon instanceof ImageIcon) && icon != null) {
                    icon = new ShortcutIcon(icon, this.iconSize.width, this.iconSize.height);
                }
                JToggleButton button = this.createButton(name, icon);
                void f = var9_11;
                button.addActionListener(arg_0 -> FlatShortcutsPanel.lambda$new$0(fc, (File)f, arg_0));
                this.add(button);
                this.buttonGroup.add(button);
                filesList.add(var9_11);
                buttonsList.add(button);
            }
            if (addedPostShortCuts != null && addedPostShortCuts.length > 0) {
                for (Serializable serializable : addedPostShortCuts) {
                    if (serializable == null) continue;
                    this.addShortcut((JToggleButton)serializable);
                }
            }
            if (addedPreShortCuts != null && addedPreShortCuts.length > 0) {
                void var9_17;
                int index = 0;
                JToggleButton[] jToggleButtonArray = addedPreShortCuts;
                int n = jToggleButtonArray.length;
                boolean bl = false;
                while (var9_17 < n) {
                    JToggleButton button = jToggleButtonArray[var9_17];
                    if (button != null) {
                        this.addShortcut(button, index);
                        ++index;
                    }
                    ++var9_17;
                }
            }
            this.updateLayout();
            this.files = filesList.toArray(new File[filesList.size()]);
            this.buttons = buttonsList.toArray(new JToggleButton[buttonsList.size()]);
            this.directoryChanged(fc.getCurrentDirectory());
        }

        public void updateLayout() {
            if (this.buttonGroup.getButtonCount() > 0) {
                this.setLayout(new GridLayout(this.buttonGroup.getButtonCount(), 0));
            }
        }

        public void addShortcut(JToggleButton button) {
            this.addShortcut(button, this.buttonGroup.getButtonCount());
        }

        public void addShortcut(JToggleButton button, int index) {
            button.setOpaque(false);
            button.setContentAreaFilled(false);
            button.setBorder(null);
            if (shortcutButtonUI != null) {
                button.setUI(shortcutButtonUI);
            }
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
            button.setAlignmentX(0.5f);
            button.setIconTextGap(0);
            button.setPreferredSize(this.buttonSize);
            button.setMaximumSize(this.buttonSize);
            this.add((Component)button, index);
            this.buttonGroup.add(button);
            this.setLayout(new GridLayout(this.buttonGroup.getButtonCount(), 0));
        }

        private Dimension getUIDimension(String key, int defaultWidth, int defaultHeight) {
            Dimension size = UIManager.getDimension(key);
            if (size == null) {
                size = new Dimension(defaultWidth, defaultHeight);
            }
            return size;
        }

        protected JToggleButton createButton(String name, Icon icon) {
            JToggleButton button = new JToggleButton(name, icon);
            button.setOpaque(false);
            button.setContentAreaFilled(false);
            button.setBorder(null);
            if (shortcutButtonUI != null) {
                button.setUI(shortcutButtonUI);
            }
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
            button.setAlignmentX(0.5f);
            button.setIconTextGap(0);
            button.setPreferredSize(this.buttonSize);
            button.setMaximumSize(this.buttonSize);
            return button;
        }

        protected String getDisplayName(FileSystemView fsv, File file) {
            String name;
            if (this.displayNameFunction != null && (name = this.displayNameFunction.apply(file)) != null) {
                return name;
            }
            return fsv.getSystemDisplayName(file);
        }

        protected Icon getIcon(FileSystemView fsv, File file) {
            Icon icon;
            if (this.iconFunction != null && (icon = this.iconFunction.apply(file)) != null) {
                return icon;
            }
            try {
                try {
                    Class<?> cls;
                    if (SystemInfo.isJava_17_orLater) {
                        Method m = fsv.getClass().getMethod("getSystemIcon", File.class, Integer.TYPE, Integer.TYPE);
                        return (Icon)m.invoke((Object)fsv, file, this.iconSize.width, this.iconSize.height);
                    }
                    if ((this.iconSize.width > 16 || this.iconSize.height > 16) && (cls = Class.forName("sun.awt.shell.ShellFolder")).isInstance(file)) {
                        Method m = file.getClass().getMethod("getIcon", Boolean.TYPE);
                        m.setAccessible(true);
                        Image image = (Image)m.invoke((Object)file, true);
                        if (image != null) {
                            return new ImageIcon(image);
                        }
                    }
                }
                catch (Exception cls) {
                    // empty catch block
                }
                return fsv.getSystemIcon(file);
            }
            catch (NullPointerException ex) {
                return new FlatFileViewDirectoryIcon();
            }
        }

        protected void directoryChanged(File file) {
            if (file != null) {
                String absolutePath = file.getAbsolutePath();
                for (int i = 0; i < this.files.length; ++i) {
                    if (!this.files[i].equals(file) && !this.files[i].getAbsolutePath().equals(absolutePath)) continue;
                    this.buttons[i].setSelected(true);
                    return;
                }
            }
            this.buttonGroup.clearSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            switch (e.getPropertyName()) {
                case "directoryChanged": {
                    this.directoryChanged(this.fc.getCurrentDirectory());
                }
            }
        }

        private void removeShortcut(JToggleButton button) {
            this.remove(button);
            this.updateLayout();
        }
    }

    class RecentFilesView
    extends FileSystemView {
        RecentFilesView() {
        }

        @Override
        public File getParentDirectory(File dir) {
            if (this.isShortcuts(dir)) {
                return null;
            }
            return super.getParentDirectory(dir);
        }

        @Override
        public File createNewFolder(File containingDir) throws IOException {
            return null;
        }

        private boolean isShortcuts(File current) {
            return current.getAbsoluteFile().equals("Shortcuts:Recent");
        }

        @Override
        public File[] getFiles(File dir, boolean useFileHiding) {
            if (this.isShortcuts(dir)) {
                ArrayList<File> files = new ArrayList<File>();
                files.add(new File("Test shortcut1.plt"));
                files.add(new File("Test shortcut2.plt"));
                files.add(new File("Test shortcut3.plt"));
                files.add(new File("Test shortcut4.plt"));
                files.add(new File("Test shortcut5.plt"));
                return files.toArray(new File[files.size()]);
            }
            return super.getFiles(dir, useFileHiding);
        }
    }

    private static class ShortcutIcon
    implements Icon {
        private final Icon icon;
        private final int iconWidth;
        private final int iconHeight;

        ShortcutIcon(Icon icon, int iconWidth, int iconHeight) {
            this.icon = icon;
            this.iconWidth = iconWidth;
            this.iconHeight = iconHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                double scaleW1 = this.getIconWidth();
                double scaleW2 = this.icon.getIconWidth();
                if (scaleW1 != scaleW2) {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    double scale = scaleW1 / scaleW2;
                    g2.translate(x, y);
                    g2.scale(scale, scale);
                }
                this.icon.paintIcon(c, g2, 0, 0);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }
    }
}

