/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.BasicGradientRenderer;
import Renderers.Renderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class RenderedMenuItemUI
extends BasicMenuItemUI {
    static Renderer defaultRenderer = new BasicGradientRenderer();
    private Renderer renderer;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedMenuItemUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Object val = UIManager.get("RenderedUI.MenuItem.opaque");
        if (val instanceof Boolean) {
            this.menuItem.setOpaque((Boolean)val);
        }
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        this.getActiveRenderer().paintBackground(g, menuItem);
        if (this.getActiveRenderer().isPaintBorder()) {
            this.getActiveRenderer().paintBorder(g, menuItem);
        }
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel m = menuItem.getModel();
        if (!m.isEnabled()) {
            g.setColor(this.getActiveRenderer().getDisabledColor(menuItem));
        } else if (m.isArmed()) {
            g.setColor(this.getActiveRenderer().getDownTextColor(menuItem));
        } else {
            g.setColor(this.getActiveRenderer().getNormalTextColor(menuItem));
        }
        super.paintText(g, menuItem, textRect, text);
    }
}

