/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.BasicGradientRenderer;
import Renderers.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class RenderedMenuUI
extends BasicMenuUI {
    static Renderer defaultRenderer = new BasicGradientRenderer();
    private Renderer renderer;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedMenuUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Object val = UIManager.get("Menu.opaque");
        if (val instanceof Boolean) {
            this.menuItem.setOpaque((Boolean)val);
        }
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel m = menuItem.getModel();
        if (m.isArmed() && m.isEnabled()) {
            g.setColor(this.getActiveRenderer().getDownTextColor(menuItem));
        }
        if (!m.isEnabled()) {
            g.setColor(this.getActiveRenderer().getDisabledColor(menuItem));
        } else {
            g.setColor(this.getActiveRenderer().getNormalTextColor(menuItem));
        }
        super.paintText(g, menuItem, textRect, text);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque() || model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            ButtonModel m;
            this.getActiveRenderer().paintBackground(g, (Component)menuItem, new Rectangle(0, 0, menuWidth, menuHeight));
            if (this.getActiveRenderer().isPaintBorder() && (m = menuItem.getModel()).isArmed() && m.isEnabled()) {
                this.getActiveRenderer().paintBorder(g, menuItem);
            }
            g.setColor(oldColor);
        }
    }
}

