/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import JMScrollBars.RawValueRenderer;
import JMScrollBars.ValueRenderer;
import Renderers.BasicRenderer;
import Renderers.MetalRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedScrollBarUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class RenderedProgressBarUI
extends BasicProgressBarUI {
    private static ValueRenderer defaultValueRenderer = new RawValueRenderer();
    private static Renderer defaultTrackRenderer = new BasicRenderer();
    private static Renderer defaultThumbRenderer = new MetalRenderer();
    private Renderer thumbRenderer = null;
    private ValueRenderer valueRenderer = null;
    private Renderer renderer = null;

    public static ValueRenderer getDefaultValueRenderer() {
        return defaultValueRenderer;
    }

    public static void setDefaultValueRenderer(ValueRenderer renderer) {
        if (renderer != null) {
            defaultValueRenderer = renderer;
        }
    }

    public static Renderer getDefaultTrackRenderer() {
        return defaultTrackRenderer != null ? defaultTrackRenderer : RenderedScrollBarUI.getDefaultTrackRenderer();
    }

    public static void setDefaultTrackRenderer(Renderer renderer) {
        defaultTrackRenderer = renderer;
    }

    public static Renderer getDefaultThumb() {
        return defaultThumbRenderer;
    }

    public static void setDefaultThumbRenderer(Renderer renderer) {
        defaultThumbRenderer = renderer;
    }

    public static Renderer getDefaultThumbRenderer() {
        return defaultThumbRenderer != null ? defaultThumbRenderer : RenderedScrollBarUI.getDefaultThumbRenderer();
    }

    public ValueRenderer getActiveValueRenderer() {
        return this.valueRenderer != null ? this.valueRenderer : RenderedProgressBarUI.getDefaultValueRenderer();
    }

    public Renderer getActiveThumbRenderer() {
        return this.thumbRenderer != null ? this.thumbRenderer : RenderedProgressBarUI.getDefaultThumbRenderer();
    }

    public Renderer getActiveTrackRenderer() {
        return this.renderer != null ? this.renderer : RenderedProgressBarUI.getDefaultTrackRenderer();
    }

    public void setThumbRenderer(Renderer thumbRenderer) {
        this.thumbRenderer = thumbRenderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public void setValueRenderer(ValueRenderer valueRenderer) {
        this.valueRenderer = valueRenderer;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.progressBar.getForeground());
        Renderer renderer = this.getActiveTrackRenderer();
        Renderer thumbBenderer = this.getActiveThumbRenderer();
        if (this.progressBar.getOrientation() == 0) {
            renderer.setOrientation(0);
            thumbBenderer.setOrientation(0);
            renderer.paint(g, (Component)c, 0);
            thumbBenderer.paint(g, c, new Rectangle(0, 0, amountFull, c.getHeight()), 1);
        } else {
            renderer.setOrientation(1);
            thumbBenderer.setOrientation(1);
            renderer.paint(g, (Component)c, 0);
            thumbBenderer.paint(g, c, new Rectangle(0, 0, c.getWidth(), amountFull), 1);
        }
        if (this.progressBar.isStringPainted()) {
            this.getActiveValueRenderer().paint(g2, this.progressBar, new Rectangle(b.left, b.top, barRectWidth, barRectHeight), 0);
        }
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        super.paintIndeterminate(g, c);
    }
}

