/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import BaseClasses.FrameBorder;
import Renderers.BasicGradientRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedTitlePane;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import plaf.BaseRootPaneUI;

public class RenderedRootPaneUI
extends BaseRootPaneUI {
    static Renderer defaultRenderer = new BasicGradientRenderer();
    private Renderer renderer;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedRootPaneUI();
    }

    @Override
    public JComponent createTitlePane(JRootPane root) {
        RenderedTitlePane tp = new RenderedTitlePane(root, this);
        Border tpBorder = UIManager.getBorder("TitlePane.border");
        if (tpBorder != null) {
            tp.setBorder(tpBorder);
        } else {
            Color activeBorderColor = UIManager.getColor("WindowBorderColor");
            Color inactiveBorderColor = UIManager.getColor("WindowInactiveBorderColor");
            tp.setBorder(new FrameBorder(activeBorderColor, inactiveBorderColor, 2, false));
        }
        return tp;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            this.getActiveRenderer().paintBackground(g, c);
        } else {
            super.paint(g, c);
        }
    }
}

