/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import IconRenderers.CloseButtonIconRenderer;
import IconRenderers.ControlButtonRenderer;
import IconRenderers.MinButtonIconRenderer;
import IconRenderers.RestoreButtonIconRenderer;
import Renderers.BasicGradientRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedRootPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import plaf.BaseRootPaneUI;
import plaf.BaseTitlePane;
import plaf.RenderedTitleButton;
import plaf.UIUtilities;

public class RenderedTitlePane
extends BaseTitlePane {
    private static Renderer defaultRenderer = null;
    private int titlePaneHeight = 0;
    private int spacingH = 0;
    private int spacingV = 0;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer != null ? defaultRenderer : RenderedRootPaneUI.getDefaultRenderer();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? RenderedTitlePane.getDefaultRenderer() : this.renderer;
    }

    public RenderedTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
        int titlePaneHt = UIManager.getInt("RenderedUI.TitlePane.height");
        if (titlePaneHt > 0) {
            this.titlePaneHeight = titlePaneHt;
        }
        this.spacingH = UIManager.getInt("RenderedUI.TitlePane.horizontalspacing");
        this.spacingV = UIManager.getInt("RenderedUI.TitlePane.verticalspacing");
        if (defaultRenderer == null) {
            Object defR = UIManager.get("RenderedUI.TitlePaneRenderer");
            defaultRenderer = defR != null && defR instanceof Renderer ? (Renderer)defR : new BasicGradientRenderer();
        }
    }

    @Override
    public void paintBackground(Graphics g) {
        Renderer renderer = this.getActiveRenderer();
        if (this.isActive()) {
            renderer.paintBackground(g, (Component)this, 0);
        } else {
            renderer.paintBackground(g, (Component)this, 2);
        }
    }

    @Override
    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    @Override
    protected int getHorSpacing() {
        return this.spacingH;
    }

    @Override
    protected int getVerSpacing() {
        return this.spacingV;
    }

    @Override
    protected Color getWindowTitleForegroundColor() {
        return this.getActiveRenderer().getColors().getColor(0, 0);
    }

    @Override
    protected Color getWindowInactiveTitleForegroundColor() {
        return this.getActiveRenderer().getColors().getColor(0, 2);
    }

    @Override
    public void createButtons() {
        this.iconifyButton = new RenderedTitleButton(this.iconifyAction, "Iconify", this.iconifyIcon, 1.0f){

            @Override
            public boolean isWindowActive() {
                return RenderedTitlePane.this.isActive();
            }
        };
        Object uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.iconify.renderer");
        if (uiRenderer instanceof ControlButtonRenderer) {
            this.iconifyButton.setRenderer((ControlButtonRenderer)uiRenderer);
        } else {
            this.iconifyButton.setRenderer(new MinButtonIconRenderer());
        }
        this.maxButton = new RenderedTitleButton(this.maxRestoreAction, "Maximize", this.maximizeIcon, 1.0f){

            @Override
            public boolean isWindowActive() {
                return RenderedTitlePane.this.isActive();
            }
        };
        uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.maximize.renderer");
        if (uiRenderer instanceof ControlButtonRenderer) {
            this.maxButton.setRenderer((ControlButtonRenderer)uiRenderer);
        } else {
            this.maxButton.setRenderer(new RestoreButtonIconRenderer());
        }
        this.closeButton = new RenderedTitleButton(this.closeAction, "Close", this.closeIcon, 1.0f){

            @Override
            public boolean isWindowActive() {
                return RenderedTitlePane.this.isActive();
            }
        };
        uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.close.renderer");
        if (uiRenderer instanceof ControlButtonRenderer) {
            this.closeButton.setRenderer((ControlButtonRenderer)uiRenderer);
        } else {
            this.closeButton.setRenderer(new CloseButtonIconRenderer());
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        protected int computeHeight() {
            return RenderedTitlePane.this.titlePaneHeight > 0 ? RenderedTitlePane.this.titlePaneHeight : UIUtilities.getFontMetrics(RenderedTitlePane.this, null, RenderedTitlePane.this.getFont()).getHeight() + 5;
        }

        @Override
        public void layoutContainer(Container c) {
            if (UIManager.getBoolean("isMacStyleWindowDecorationOn")) {
                this.layoutMacStyle(c);
            } else {
                this.layoutDefault(c);
            }
        }

        public void layoutDefault(Container c) {
            boolean leftToRight = RenderedTitlePane.this.isLeftToRight();
            int spacing = RenderedTitlePane.this.getHorSpacing();
            int w = RenderedTitlePane.this.getWidth();
            int h = RenderedTitlePane.this.getHeight();
            int btnHeight = h - RenderedTitlePane.this.getVerSpacing();
            int btnWidth = btnHeight + 10;
            if (RenderedTitlePane.this.menuBar != null) {
                int mw = ((RenderedTitlePane)RenderedTitlePane.this).menuBar.getPreferredSize().width;
                int mh = ((RenderedTitlePane)RenderedTitlePane.this).menuBar.getPreferredSize().height;
                if (leftToRight) {
                    RenderedTitlePane.this.menuBar.setBounds(2, (h - mh) / 2, mw, mh);
                } else {
                    RenderedTitlePane.this.menuBar.setBounds(RenderedTitlePane.this.getWidth() - mw, (h - mh) / 2, mw, mh);
                }
            }
            int x = leftToRight ? w - spacing : 0;
            int y = Math.max(0, (h - btnHeight) / 2 - 1);
            if (RenderedTitlePane.this.closeButton != null) {
                RenderedTitlePane.this.closeButton.setBounds(x += leftToRight ? -btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (RenderedTitlePane.this.maxButton != null && RenderedTitlePane.this.maxButton.getParent() != null && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                RenderedTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (RenderedTitlePane.this.iconifyButton != null && RenderedTitlePane.this.iconifyButton.getParent() != null) {
                RenderedTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            RenderedTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
            if (RenderedTitlePane.this.customTitlePanel != null) {
                int maxWidth = w - RenderedTitlePane.this.buttonsWidth - spacing - 20;
                if (RenderedTitlePane.this.menuBar != null) {
                    maxWidth -= ((RenderedTitlePane)RenderedTitlePane.this).menuBar.getPreferredSize().width;
                    maxWidth -= spacing;
                }
                int cpw = Math.min(maxWidth, ((RenderedTitlePane)RenderedTitlePane.this).customTitlePanel.getPreferredSize().width);
                int cph = h;
                int cpx = leftToRight ? w - RenderedTitlePane.this.buttonsWidth - cpw : RenderedTitlePane.this.buttonsWidth;
                int cpy = 0;
                RenderedTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                RenderedTitlePane.this.buttonsWidth += ((RenderedTitlePane)RenderedTitlePane.this).customTitlePanel.getPreferredSize().width;
            }
        }

        private void layoutMacStyle(Container c) {
            int btnHeight;
            int spacing = RenderedTitlePane.this.getHorSpacing();
            int h = RenderedTitlePane.this.getHeight();
            int btnWidth = btnHeight = h - RenderedTitlePane.this.getVerSpacing();
            int x = 0;
            int y = 0;
            if (RenderedTitlePane.this.closeButton != null) {
                RenderedTitlePane.this.closeButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (RenderedTitlePane.this.iconifyButton != null && RenderedTitlePane.this.iconifyButton.getParent() != null) {
                RenderedTitlePane.this.iconifyButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (RenderedTitlePane.this.maxButton != null && RenderedTitlePane.this.maxButton.getParent() != null && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                RenderedTitlePane.this.maxButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            RenderedTitlePane.this.buttonsWidth = x;
            if (RenderedTitlePane.this.customTitlePanel != null) {
                int cpx = RenderedTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((RenderedTitlePane)RenderedTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h;
                RenderedTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                RenderedTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }
}

