/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import IconRenderers.AlwaysOnTopButtonIconRenderer;
import IconRenderers.CloseButtonIconRenderer;
import IconRenderers.ControlButtonRenderer;
import IconRenderers.MinButtonIconRenderer;
import IconRenderers.RestoreButtonIconRenderer;
import IconRenderers.VHSizeIconRenderer;
import UIRenderers.RenderedTitlePane;
import UIRenderers.TitlePane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import plaf.AbstractLookAndFeel;
import plaf.BaseTitlePane;
import plaf.RenderedTitleButton;
import plaf.UIUtilities;

public class BaseRootPaneUI
extends BasicRootPaneUI {
    public static final int NONE = 0;
    public static final int FRAME = 1;
    public static final int PLAIN_DIALOG = 2;
    public static final int INFORMATION_DIALOG = 3;
    public static final int ERROR_DIALOG = 4;
    public static final int COLOR_CHOOSER_DIALOG = 5;
    public static final int FILE_CHOOSER_DIALOG = 6;
    public static final int QUESTION_DIALOG = 7;
    public static final int WARNING_DIALOG = 8;
    public static final int MAXIMIZED_HORIZ = 2;
    public static final int MAXIMIZED_VERT = 4;
    public static final int MAXIMIZED_BOTH = 6;
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final Dimension MINIMUM_SIZE = new Dimension(120, 80);
    private static final Dimension MAXIMUM_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private JComponent titlePane;
    private MouseInputListener mouseInputListener;
    private WindowListener windowListener;
    private PropertyChangeListener propertyChangeListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    protected JRootPane root;
    private Cursor savedCursor = null;
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent c) {
        return new BaseRootPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.root = (JRootPane)c;
        if (this.root.getWindowDecorationStyle() != 0) {
            this.installClientDecorations(this.root);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    @Override
    protected void installListeners(JRootPane root) {
        super.installListeners(root);
        if (root.getWindowDecorationStyle() == 0) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("ancestor".equals(evt.getPropertyName()) && BaseRootPaneUI.this.getRootPane() != null && BaseRootPaneUI.this.getRootPane().getParent() instanceof Window) {
                        BaseRootPaneUI.this.window = (Window)BaseRootPaneUI.this.getRootPane().getParent();
                        BaseRootPaneUI.this.windowListener = new WindowAdapter(){

                            @Override
                            public void windowActivated(WindowEvent e) {
                                if (BaseRootPaneUI.this.getRootPane() != null) {
                                    BaseRootPaneUI.this.getRootPane().repaint();
                                }
                            }

                            @Override
                            public void windowDeactivated(WindowEvent e) {
                                if (BaseRootPaneUI.this.getRootPane() != null) {
                                    BaseRootPaneUI.this.getRootPane().repaint();
                                }
                            }
                        };
                        BaseRootPaneUI.this.window.addWindowListener(BaseRootPaneUI.this.windowListener);
                    }
                }
            };
            root.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    protected void uninstallListeners(JRootPane root) {
        super.uninstallListeners(root);
        if (root.getWindowDecorationStyle() == 0) {
            if (root.getParent() instanceof Window && this.windowListener != null) {
                this.window = (Window)root.getParent();
                this.window.removeWindowListener(this.windowListener);
            }
            root.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, borderKeys[style]);
        }
    }

    public void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    public void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(root);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    public void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    public void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    public void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    public void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        if (this.titlePane == null) {
            this.setTitlePane(root, this.createTitlePane(root));
        }
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    public void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null && this.savedCursor != null) {
            this.window.setCursor(this.savedCursor);
            this.savedCursor = null;
        }
        this.window = null;
    }

    public JComponent createTitlePane(JRootPane root) {
        return new BaseTitlePane(root, this);
    }

    public MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    public LayoutManager createLayoutManager() {
        return new BaseRootLayout();
    }

    public void setTitlePane(JRootPane root, JComponent titlePane) {
        JComponent oldTitlePane = this.internalGetTitlePane();
        if (oldTitlePane == null && titlePane == null || oldTitlePane != null && oldTitlePane.equals(titlePane)) {
            return;
        }
        JLayeredPane layeredPane = root.getLayeredPane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    public BaseTitlePane getTitlePane() {
        if (this.titlePane instanceof BaseTitlePane) {
            return (BaseTitlePane)this.titlePane;
        }
        return null;
    }

    public static BaseTitlePane getTitlePane(JFrame parentFrame) {
        if (!BaseRootPaneUI.hasBaseRootPane(parentFrame)) {
            return null;
        }
        return (BaseTitlePane)((BaseRootPaneUI)parentFrame.getRootPane().getUI()).titlePane;
    }

    private JComponent internalGetTitlePane() {
        return this.titlePane;
    }

    public JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        JRootPane rp = (JRootPane)e.getSource();
        if ("windowDecorationStyle".equals(propertyName)) {
            int style = rp.getWindowDecorationStyle();
            this.uninstallClientDecorations(rp);
            if (style != 0) {
                this.installClientDecorations(rp);
            }
        } else if ("ancestor".equals(propertyName)) {
            this.uninstallWindowListeners(rp);
            if (rp.getWindowDecorationStyle() != 0) {
                this.installWindowListeners(rp, rp.getParent());
            }
        }
    }

    private boolean isDynamicLayout() {
        return AbstractLookAndFeel.getTheme().isDynamicLayout();
    }

    public void setCustomizedTitlePanel(JPanel panel) {
        this.getTitlePane().setCustomizedTitlePanel(panel);
    }

    public JPanel getCustomizedTitlePanel() {
        return this.getTitlePane().getCustomizedTitlePanel();
    }

    public static boolean hasBaseRootPane(JFrame parentFrame) {
        JRootPane rootPane = parentFrame.getRootPane();
        return rootPane != null && rootPane.getUI() != null && rootPane.getUI() instanceof BaseRootPaneUI;
    }

    public static boolean hasBaseRootPane(JDialog parentFrame) {
        JRootPane rootPane = parentFrame.getRootPane();
        return rootPane != null && rootPane.getUI() != null && rootPane.getUI() instanceof BaseRootPaneUI;
    }

    public static int getDialogState(JDialog parentFrame) {
        JRootPane rootPane = parentFrame.getRootPane();
        return rootPane != null && rootPane.getUI() != null && rootPane.getUI() instanceof BaseRootPaneUI ? ((BaseRootPaneUI)rootPane.getUI()).getTitlePane().state : 0;
    }

    public static void setTitleBarButtons(JFrame parentFrame, RenderedTitleButton ... buttons) {
        RenderedTitleBar titlebarPanel;
        if (!BaseRootPaneUI.hasBaseRootPane(parentFrame)) {
            return;
        }
        JPanel currentTP = ((BaseRootPaneUI)parentFrame.getRootPane().getUI()).getCustomizedTitlePanel();
        if (currentTP != null && currentTP instanceof RenderedTitleBar) {
            titlebarPanel = (RenderedTitleBar)currentTP;
        } else {
            titlebarPanel = new RenderedTitleBar();
            ((BaseRootPaneUI)parentFrame.getRootPane().getUI()).setCustomizedTitlePanel(titlebarPanel);
        }
        for (RenderedTitleButton button : buttons) {
            if (button == null) continue;
            titlebarPanel.addButton(button);
        }
    }

    public static void setTitleBarButtons(JDialog dialog, RenderedTitleButton ... buttons) {
        RenderedTitleBar titlebarPanel;
        if (!BaseRootPaneUI.hasBaseRootPane(dialog)) {
            return;
        }
        JPanel currentTP = ((BaseRootPaneUI)dialog.getRootPane().getUI()).getCustomizedTitlePanel();
        if (currentTP != null && currentTP instanceof RenderedTitleBar) {
            titlebarPanel = (RenderedTitleBar)currentTP;
        } else {
            titlebarPanel = new RenderedTitleBar();
            ((BaseRootPaneUI)dialog.getRootPane().getUI()).setCustomizedTitlePanel(titlebarPanel);
        }
        for (RenderedTitleButton button : buttons) {
            if (button == null) continue;
            titlebarPanel.addButton(button);
        }
    }

    public static void setTitleBarButtons(JFrame frame, int ... buttons) {
        if (!BaseRootPaneUI.hasBaseRootPane(frame)) {
            return;
        }
        RenderedTitlePane tp = (RenderedTitlePane)((BaseRootPaneUI)frame.getRootPane().getUI()).getTitlePane();
        BaseRootPaneUI.setTitleBarButtons(frame, BaseRootPaneUI.genTitleBarButtons(tp, buttons));
    }

    public static void setTitleBarButtons(JDialog frame, int ... buttons) {
        if (!BaseRootPaneUI.hasBaseRootPane(frame)) {
            return;
        }
        RenderedTitlePane tp = (RenderedTitlePane)((BaseRootPaneUI)frame.getRootPane().getUI()).getTitlePane();
        BaseRootPaneUI.setTitleBarButtons(frame, BaseRootPaneUI.genTitleBarButtons(tp, buttons));
    }

    static RenderedTitleButton[] genTitleBarButtons(final RenderedTitlePane tp, int ... buttons) {
        RenderedTitleButton[] outButtons = new RenderedTitleButton[buttons.length];
        for (int index = 0; index < buttons.length; ++index) {
            Object uiRenderer;
            int button = buttons[index];
            if (button == 2) {
                outButtons[index] = new RenderedTitleButton(tp.iconifyAction, "Iconify", tp.iconifyIcon, 1.0f){

                    @Override
                    public boolean isWindowActive() {
                        return tp.isActive();
                    }
                };
                uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.iconify.renderer");
                if (uiRenderer instanceof ControlButtonRenderer) {
                    outButtons[index].setRenderer((ControlButtonRenderer)uiRenderer);
                } else {
                    outButtons[index].setRenderer(new MinButtonIconRenderer());
                }
                outButtons[index].setButtonName("Iconify");
            }
            if (button == 1) {
                outButtons[index] = new RenderedTitleButton(tp.maxRestoreAction, "Maximize", tp.maximizeIcon, 1.0f){

                    @Override
                    public boolean isWindowActive() {
                        return tp.isActive();
                    }
                };
                uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.maximize.renderer");
                if (uiRenderer instanceof ControlButtonRenderer) {
                    outButtons[index].setRenderer((ControlButtonRenderer)uiRenderer);
                } else {
                    outButtons[index].setRenderer(new RestoreButtonIconRenderer());
                }
                outButtons[index].setButtonName("Maximize");
            }
            if (button != 0) continue;
            outButtons[index] = new RenderedTitleButton(tp.closeAction, "Close", tp.closeIcon, 1.0f){

                @Override
                public boolean isWindowActive() {
                    return tp.isActive();
                }
            };
            uiRenderer = UIManager.get("RenderedUI.TitlePaneButton.close.renderer");
            if (uiRenderer instanceof ControlButtonRenderer) {
                outButtons[index].setRenderer((ControlButtonRenderer)uiRenderer);
            } else {
                outButtons[index].setRenderer(new CloseButtonIconRenderer());
            }
            outButtons[index].setButtonName("Close");
        }
        return outButtons;
    }

    public static RenderedTitleButton genAoTButton(final JFrame parentFrame, MouseListener mouseListener) {
        final RenderedTitleButton cmdAoT = new RenderedTitleButton();
        cmdAoT.setRenderer(new AlwaysOnTopButtonIconRenderer());
        cmdAoT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                parentFrame.setAlwaysOnTop(!parentFrame.isAlwaysOnTop());
            }
        });
        cmdAoT.setToolTipText("Toggle window always on top.");
        cmdAoT.setButtonName("alwaysontop");
        if (mouseListener != null) {
            cmdAoT.addMouseListener(mouseListener);
        }
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("alwaysOnTop")) {
                    cmdAoT.repaint();
                }
            }
        };
        parentFrame.addPropertyChangeListener(l);
        return cmdAoT;
    }

    public static RenderedTitleButton genHSizeButton(JFrame parentFrame, MouseListener mouseListener) {
        return BaseRootPaneUI.genVHSizeButton(parentFrame, mouseListener, 0);
    }

    public static RenderedTitleButton genVSizeButton(JFrame parentFrame, MouseListener mouseListener) {
        return BaseRootPaneUI.genVHSizeButton(parentFrame, mouseListener, 1);
    }

    private static RenderedTitleButton genVHSizeButton(final JFrame parentFrame, MouseListener mouseListener, int orientation) {
        RenderedTitleButton button = new RenderedTitleButton();
        button.setRenderer(new VHSizeIconRenderer(orientation));
        if (orientation == 0) {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Rectangle screen = UIUtilities.calculateMaxBounds(parentFrame);
                    parentFrame.setLocation(screen.x, parentFrame.getLocation().y);
                    parentFrame.setSize(screen.width, parentFrame.getSize().height);
                }
            });
            button.setToolTipText("Fit to screen width");
        } else {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Rectangle screen = UIUtilities.calculateMaxBounds(parentFrame);
                    parentFrame.setLocation(parentFrame.getLocation().x, screen.y);
                    parentFrame.setSize(parentFrame.getSize().width, screen.height);
                }
            });
            button.setToolTipText("Fit to screen height");
        }
        button.setButtonName(orientation == 0 ? "hfit" : "vfit");
        if (mouseListener != null) {
            button.addMouseListener(mouseListener);
        }
        return button;
    }

    public static RenderedTitleButton addAlwaysOnTop(JFrame parentFrame) {
        return BaseRootPaneUI.addAlwaysOnTop(parentFrame, null);
    }

    public static RenderedTitleButton addAlwaysOnTop(JFrame parentFrame, MouseListener mouseListener) {
        if (BaseRootPaneUI.hasBaseRootPane(parentFrame)) {
            RenderedTitleButton cmdAoT = BaseRootPaneUI.genAoTButton(parentFrame, mouseListener);
            BaseRootPaneUI.setTitleBarButtons(parentFrame, cmdAoT);
            return cmdAoT;
        }
        return null;
    }

    public static void setTitleFont(JFrame parentFrame, Font font) {
        BaseTitlePane titlePane = BaseRootPaneUI.getTitlePane(parentFrame);
        if (titlePane != null) {
            titlePane.setFont(font);
        }
    }

    public static Font getTitleFont(JFrame parentFrame) {
        BaseTitlePane titlePane = BaseRootPaneUI.getTitlePane(parentFrame);
        return titlePane != null ? titlePane.getFont() : null;
    }

    public static RenderedTitleButton addHorizontalSizer(JFrame parentFrame) {
        return BaseRootPaneUI.addHorizontalSizer(parentFrame, null);
    }

    public static RenderedTitleButton addHorizontalSizer(JFrame parentFrame, MouseListener mouseListener) {
        if (BaseRootPaneUI.hasBaseRootPane(parentFrame)) {
            RenderedTitleButton button = BaseRootPaneUI.genHSizeButton(parentFrame, mouseListener);
            BaseRootPaneUI.setTitleBarButtons(parentFrame, button);
            return button;
        }
        return null;
    }

    public static RenderedTitleButton addVerticalSizer(JFrame parentFrame) {
        return BaseRootPaneUI.addVerticalSizer(parentFrame, null);
    }

    public static RenderedTitleButton addVerticalSizer(JFrame parentFrame, MouseListener mouseListener) {
        if (BaseRootPaneUI.hasBaseRootPane(parentFrame)) {
            RenderedTitleButton button = BaseRootPaneUI.genVSizeButton(parentFrame, mouseListener);
            BaseRootPaneUI.setTitleBarButtons(parentFrame, button);
            return button;
        }
        return null;
    }

    public JButton getControlButton(int button) {
        if (this.titlePane != null && this.titlePane instanceof BaseTitlePane) {
            return ((BaseTitlePane)this.titlePane).getControlButton(button);
        }
        return null;
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private boolean isResizingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private Container savedContentPane = null;
        private ResizingPanel resizingPanel = null;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            block15: {
                int frameState;
                Dialog d;
                Frame f;
                Point dragWindowOffset;
                Window w;
                block16: {
                    w = (Window)ev.getSource();
                    if (!(w instanceof Window)) break block15;
                    JRootPane root = BaseRootPaneUI.this.getRootPane();
                    if (root.getWindowDecorationStyle() == 0) {
                        return;
                    }
                    w.toFront();
                    dragWindowOffset = ev.getPoint();
                    Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, BaseRootPaneUI.this.internalGetTitlePane());
                    f = null;
                    d = null;
                    if (w instanceof Frame) {
                        f = (Frame)w;
                    } else if (w instanceof Dialog) {
                        d = (Dialog)w;
                    }
                    int n = frameState = f != null ? f.getExtendedState() : 0;
                    if (BaseRootPaneUI.this.internalGetTitlePane() == null || !BaseRootPaneUI.this.internalGetTitlePane().contains(convertedDragWindowOffset) || (f == null || (frameState & 6) != 0) && d == null || dragWindowOffset.y < 5 || dragWindowOffset.x < 5 || dragWindowOffset.x >= w.getWidth() - 5) break block16;
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                    if (BaseRootPaneUI.this.window instanceof JFrame) {
                        JFrame frame = (JFrame)BaseRootPaneUI.this.window;
                        for (PropertyChangeListener pcl : frame.getPropertyChangeListeners()) {
                            pcl.propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowMoving", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                    if (!(BaseRootPaneUI.this.window instanceof JDialog)) break block15;
                    JDialog dialog = (JDialog)BaseRootPaneUI.this.window;
                    for (PropertyChangeListener pcl : dialog.getPropertyChangeListeners()) {
                        pcl.propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowMoving", Boolean.FALSE, Boolean.FALSE));
                    }
                    break block15;
                }
                if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                    this.isResizingWindow = true;
                    if (!BaseRootPaneUI.this.isDynamicLayout()) {
                        this.savedContentPane = BaseRootPaneUI.this.getRootPane().getContentPane();
                        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                        int wd = this.savedContentPane.getWidth();
                        int ht = this.savedContentPane.getHeight();
                        if (wd > 0 && ht > 0) {
                            BufferedImage bi = gc.createCompatibleImage(wd, ht);
                            this.savedContentPane.paint(bi.getGraphics());
                            this.resizingPanel = new ResizingPanel(bi);
                            BaseRootPaneUI.this.getRootPane().setContentPane(this.resizingPanel);
                        } else {
                            return;
                        }
                    }
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                    this.dragWidth = w.getWidth();
                    this.dragHeight = w.getHeight();
                    this.dragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
                    if (BaseRootPaneUI.this.window instanceof JFrame) {
                        JFrame frame = (JFrame)BaseRootPaneUI.this.window;
                        for (PropertyChangeListener pcl : frame.getPropertyChangeListeners()) {
                            pcl.propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowResizing", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                    if (BaseRootPaneUI.this.window instanceof JDialog) {
                        JDialog dialog = (JDialog)BaseRootPaneUI.this.window;
                        for (PropertyChangeListener pcl : dialog.getPropertyChangeListeners()) {
                            pcl.propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowResizing", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.getSource() instanceof Window) {
                Window w = (Window)ev.getSource();
                if (w != null) {
                    if (!BaseRootPaneUI.this.isDynamicLayout() && this.isResizingWindow) {
                        BaseRootPaneUI.this.getRootPane().setContentPane(this.savedContentPane);
                        BaseRootPaneUI.this.getRootPane().updateUI();
                        this.resizingPanel = null;
                    } else if (this.dragCursor != 0 && !BaseRootPaneUI.this.window.isValid()) {
                        w.validate();
                        BaseRootPaneUI.this.getRootPane().repaint();
                    }
                    if (BaseRootPaneUI.this.window instanceof JFrame) {
                        JFrame frame = (JFrame)BaseRootPaneUI.this.window;
                        for (PropertyChangeListener pcl : frame.getPropertyChangeListeners()) {
                            if (this.isMovingWindow) {
                                pcl.propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowMoved", Boolean.FALSE, Boolean.FALSE));
                                continue;
                            }
                            pcl.propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowResized", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                    if (BaseRootPaneUI.this.window instanceof JDialog) {
                        JDialog dialog = (JDialog)BaseRootPaneUI.this.window;
                        for (PropertyChangeListener pcl : dialog.getPropertyChangeListeners()) {
                            if (this.isMovingWindow) {
                                pcl.propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowMoved", Boolean.FALSE, Boolean.FALSE));
                                continue;
                            }
                            pcl.propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowResized", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                }
                this.isMovingWindow = false;
                this.isResizingWindow = false;
                this.dragCursor = 0;
            }
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            if (ev.getSource() instanceof Window) {
                JRootPane root = BaseRootPaneUI.this.getRootPane();
                if (root.getWindowDecorationStyle() == 0) {
                    return;
                }
                Window w = (Window)ev.getSource();
                Frame f = null;
                Dialog d = null;
                if (w instanceof Frame) {
                    f = (Frame)w;
                } else if (w instanceof Dialog) {
                    d = (Dialog)w;
                }
                int cursor = this.getCursor(this.calculateCorner(w, ev.getX(), ev.getY()));
                if (!this.isMovingWindow && cursor != 0 && (f != null && f.isResizable() && (f.getExtendedState() & 6) == 0 || d != null && d.isResizable())) {
                    if (BaseRootPaneUI.this.savedCursor == null) {
                        BaseRootPaneUI.this.savedCursor = w.getCursor();
                    }
                    w.setCursor(Cursor.getPredefinedCursor(cursor));
                } else if (BaseRootPaneUI.this.savedCursor != null) {
                    w.setCursor(BaseRootPaneUI.this.savedCursor);
                    BaseRootPaneUI.this.savedCursor = null;
                }
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        private int getMinScreenY() {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = ge.getScreenDevices();
            GraphicsDevice gd = devices[0];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            int minScreenY = gc.getBounds().y + Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)gc).top;
            if (devices.length > 1) {
                for (int i = 1; i < devices.length; ++i) {
                    gd = devices[i];
                    gc = gd.getDefaultConfiguration();
                    minScreenY = Math.min(minScreenY, gc.getBounds().y + Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)gc).top);
                }
            }
            return minScreenY;
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            if (ev.getSource() instanceof Window) {
                Window w = (Window)ev.getSource();
                if (!w.isShowing()) {
                    return;
                }
                if ((w instanceof Frame && ((Frame)w).getExtendedState() == 6 || w instanceof JDialog && ((BaseTitlePane)BaseRootPaneUI.this.internalGetTitlePane()).getState() == 6) && BaseRootPaneUI.this.internalGetTitlePane() instanceof TitlePane) {
                    Point pt = ev.getPoint();
                    Point dragWindowOffset = ev.getPoint();
                    Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, BaseRootPaneUI.this.internalGetTitlePane());
                    if (BaseRootPaneUI.this.internalGetTitlePane().contains(convertedDragWindowOffset)) {
                        int ow = w.getWidth();
                        ((TitlePane)((Object)BaseRootPaneUI.this.internalGetTitlePane())).restore();
                        int nw = w.getWidth();
                        int nx = pt.x * nw / ow;
                        int ny = pt.y;
                        w.setLocation(nx, ny);
                        this.dragOffsetX = nx;
                        this.dragOffsetY = ny;
                        this.isMovingWindow = true;
                        for (PropertyChangeListener pcl : w.getPropertyChangeListeners()) {
                            pcl.propertyChange(new PropertyChangeEvent(BaseRootPaneUI.this.window, "windowMoving", Boolean.FALSE, Boolean.FALSE));
                        }
                    }
                }
                int minScreenY = this.getMinScreenY();
                if (this.isMovingWindow) {
                    Point location = ev.getLocationOnScreen();
                    location.x -= this.dragOffsetX;
                    location.y = Math.max(minScreenY, location.y - this.dragOffsetY);
                    w.setLocation(location);
                } else if (this.dragCursor != 0) {
                    Point pt = ev.getPoint();
                    Rectangle bounds = w.getBounds();
                    Rectangle startBounds = new Rectangle(bounds);
                    Dimension min = MINIMUM_SIZE;
                    switch (this.dragCursor) {
                        case 11: {
                            this.adjust(bounds, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - bounds.width, 0);
                            break;
                        }
                        case 9: {
                            this.adjust(bounds, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - bounds.height);
                            break;
                        }
                        case 8: {
                            this.adjust(bounds, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                            break;
                        }
                        case 10: {
                            this.adjust(bounds, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                            break;
                        }
                        case 7: {
                            this.adjust(bounds, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - bounds.width, -(pt.y - this.dragOffsetY));
                            break;
                        }
                        case 5: {
                            this.adjust(bounds, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - bounds.width, pt.y + (this.dragHeight - this.dragOffsetY) - bounds.height);
                            break;
                        }
                        case 6: {
                            this.adjust(bounds, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                            break;
                        }
                        case 4: {
                            this.adjust(bounds, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - bounds.height);
                            break;
                        }
                    }
                    if (!bounds.equals(startBounds)) {
                        if (bounds.y < minScreenY) {
                            int delta = minScreenY - bounds.y;
                            bounds.y = minScreenY;
                            bounds.height -= delta;
                        }
                        w.setBounds(bounds);
                        w.validate();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            this.mouseMoved(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            if (ev.getSource() instanceof Window && BaseRootPaneUI.this.savedCursor != null) {
                Window w = (Window)ev.getSource();
                w.setCursor(BaseRootPaneUI.this.savedCursor);
                BaseRootPaneUI.this.savedCursor = null;
            }
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            if (ev.getSource() instanceof Window) {
                Window window = (Window)ev.getSource();
                if (window instanceof Frame) {
                    Frame frame = (Frame)window;
                    Point convertedPoint = SwingUtilities.convertPoint(window, ev.getPoint(), BaseRootPaneUI.this.internalGetTitlePane());
                    int state = frame.getExtendedState();
                    if (BaseRootPaneUI.this.titlePane != null && BaseRootPaneUI.this.titlePane instanceof TitlePane && BaseRootPaneUI.this.titlePane.contains(convertedPoint) && frame.isResizable() && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0) {
                        if ((state & 6) != 0) {
                            ((TitlePane)((Object)BaseRootPaneUI.this.titlePane)).restore();
                        } else {
                            ((TitlePane)((Object)BaseRootPaneUI.this.titlePane)).maximize();
                        }
                    }
                } else if (window instanceof JDialog) {
                    JDialog frame = (JDialog)window;
                    Point convertedPoint = SwingUtilities.convertPoint(window, ev.getPoint(), BaseRootPaneUI.this.internalGetTitlePane());
                    if (BaseRootPaneUI.this.titlePane != null && BaseRootPaneUI.this.titlePane instanceof BaseTitlePane && BaseRootPaneUI.this.titlePane.contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0) {
                        if (((BaseTitlePane)((BaseRootPaneUI)BaseRootPaneUI.this).titlePane).state == 6) {
                            ((TitlePane)((Object)BaseRootPaneUI.this.titlePane)).restore();
                        } else if (frame.isResizable()) {
                            ((TitlePane)((Object)BaseRootPaneUI.this.titlePane)).maximize();
                        }
                    }
                }
            }
        }

        private int calculateCorner(Component c, int x, int y) {
            int xPosition = this.calculatePosition(x, c.getWidth());
            int yPosition = this.calculatePosition(y, c.getHeight());
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return cursorMapping[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }

    private static class BaseRootLayout
    implements LayoutManager2 {
        private BaseRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof BaseRootPaneUI && (titlePane = ((BaseRootPaneUI)root.getUI()).internalGetTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return MINIMUM_SIZE;
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return MAXIMUM_SIZE;
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof BaseRootPaneUI) {
                    titlePane = ((BaseRootPaneUI)root.getUI()).internalGetTitlePane();
                    int titleHeight = 0;
                    if (titlePane != null) {
                        titleHeight = titlePane.getSize().height;
                    }
                    root.getGlassPane().setBounds(i.left, i.top + titleHeight, w, h - titleHeight);
                } else {
                    root.getGlassPane().setBounds(i.left, i.top, w, h);
                }
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof BaseRootPaneUI && (titlePane = ((BaseRootPaneUI)root.getUI()).internalGetTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }

    public static class RenderedTitleBar
    extends JPanel {
        private final HashMap<String, RenderedTitleButton> buttons = new HashMap();

        public RenderedTitleBar() {
            super(new TitlebarLayoutManager());
            this.setOpaque(false);
        }

        public void addButton(RenderedTitleButton button) {
            RenderedTitleButton oldButton = this.buttons.get(button.getButtonName());
            if (oldButton != null) {
                this.remove(oldButton);
            }
            super.add(button);
            this.buttons.put(button.getButtonName(), button);
        }

        public RenderedTitleButton getButton(String buttonName) {
            return this.buttons.get(buttonName);
        }
    }

    public static class TitlebarLayoutManager
    implements LayoutManager {
        private Dimension preferredSize = null;

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.preferredSize;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = 0;
            int count = parent.getComponentCount();
            int[] w = new int[count];
            for (int i = 0; i < count; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                w[i] = c.getPreferredSize().width;
                width += w[i];
                width += 4;
            }
            if (this.preferredSize == null) {
                this.preferredSize = new Dimension(width, parent.getHeight());
            } else {
                this.preferredSize.width = width;
                this.preferredSize.height = parent.getHeight();
            }
            int x = parent.getWidth() - width;
            if (!parent.getComponentOrientation().isLeftToRight()) {
                x = 0;
            }
            int y = 0;
            int h = parent.getHeight() - 2;
            for (int i = 0; i < count; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                c.setBounds(x, y, w[i], h);
                x += w[i] + 4;
            }
        }
    }

    private static class ResizingPanel
    extends JPanel {
        private BufferedImage bi = null;

        public ResizingPanel(BufferedImage bi) {
            this.bi = bi;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.bi, 0, 0, null);
        }
    }
}

