/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import plaf.UIUtilities;

public class BaseTitleButton
extends JButton {
    protected float alpha = 1.0f;

    public BaseTitleButton() {
        this.init();
    }

    public BaseTitleButton(Icon ico) {
        super(ico);
        this.init();
    }

    public BaseTitleButton(Action action, String accessibleName, Icon icon, float alpha) {
        this.setAction(action);
        this.setIcon(icon);
        this.getAccessibleContext().setAccessibleName(accessibleName);
        this.alpha = Math.max(0.2f, alpha);
        this.init();
    }

    protected void init() {
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setText(null);
        this.setOpaque(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setFocusable(false);
        this.setMargin(null);
        this.putClientProperty("paintActive", Boolean.TRUE);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void paint(Graphics g) {
        if (UIUtilities.isActive(this) || (double)this.alpha >= 1.0) {
            super.paint(g);
        } else {
            Graphics2D g2D = (Graphics2D)g;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.alpha);
            g2D.setComposite(alphaComposite);
            super.paint(g);
            g2D.setComposite(savedComposite);
        }
    }
}

