/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import plaf.UIUtilities;

public class BaseTitleToggleButton
extends JToggleButton {
    protected float alpha = 1.0f;

    public BaseTitleToggleButton() {
        this.init();
    }

    public BaseTitleToggleButton(Icon ico) {
        super(ico);
        this.init();
    }

    protected void init() {
        this.setOpaque(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setFocusable(false);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public void requestFocus() {
    }

    public BaseTitleToggleButton(Action action, String accessibleName, Icon icon, float alpha) {
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setAction(action);
        this.setText(null);
        this.setIcon(icon);
        this.putClientProperty("paintActive", Boolean.TRUE);
        this.getAccessibleContext().setAccessibleName(accessibleName);
        this.alpha = Math.max(0.2f, alpha);
    }

    @Override
    public void paint(Graphics g) {
        if (UIUtilities.isActive(this) || (double)this.alpha >= 1.0) {
            super.paint(g);
        } else {
            Graphics2D g2D = (Graphics2D)g;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.alpha);
            g2D.setComposite(alphaComposite);
            super.paint(g);
            g2D.setComposite(savedComposite);
        }
    }
}

