/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import BaseClasses.FrameBorder;
import IconRenderers.BasicCheckIcon;
import IconRenderers.BasicRadioIcon;
import IconRenderers.CloseButtonIconRenderer;
import IconRenderers.ControlButtonColors;
import IconRenderers.IconRenderer;
import IconRenderers.MinButtonIconRenderer;
import IconRenderers.RestoreButtonIconRenderer;
import IconRenderers.TreeOpenClosedIcon;
import Renderers.BasicGradientRenderer;
import Renderers.BasicRenderer;
import Renderers.GelRenderer;
import Renderers.GlossyRenderer;
import Renderers.JavTRenderer;
import Renderers.MetalRenderer;
import Renderers.MetallicRenderer;
import Renderers.Renderer;
import Renderers.WindowsRenderer;
import UIRenderers.RenderedButtonUI;
import UIRenderers.RenderedCheckBoxUI;
import UIRenderers.RenderedComboBoxUI;
import UIRenderers.RenderedFileChooserUI;
import UIRenderers.RenderedLabelUI;
import UIRenderers.RenderedMenuBarUI;
import UIRenderers.RenderedMenuCheckItemUI;
import UIRenderers.RenderedMenuItemUI;
import UIRenderers.RenderedMenuRadioItemUI;
import UIRenderers.RenderedMenuSeparatorUI;
import UIRenderers.RenderedMenuUI;
import UIRenderers.RenderedOptionPaneUI;
import UIRenderers.RenderedPopupMenuBorderUI;
import UIRenderers.RenderedProgressBarUI;
import UIRenderers.RenderedRadioButtonUI;
import UIRenderers.RenderedScrollBarUI;
import UIRenderers.RenderedSeparatorUI;
import UIRenderers.RenderedSpinnerUI;
import UIRenderers.RenderedSplitPaneUI;
import UIRenderers.RenderedTabbedPaneUI;
import UIRenderers.RenderedToggleButtonUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import plaf.AbstractBorderFactory;
import plaf.AbstractIconFactory;
import plaf.AbstractLookAndFeel;
import plaf.AbstractTheme;
import plaf.Defaults;
import plaf.RenderedBorderFactory;
import plaf.RenderedDefaultTheme;
import plaf.RenderedIconFactory;

public class LightLookAndFeel
extends AbstractLookAndFeel {
    private static RenderedDefaultTheme myTheme = null;
    private static final ArrayList themesList = new ArrayList();
    private static final HashMap themesMap = new HashMap();
    private static final Properties defaultProps = new Properties();
    private static final Properties smallFontProps = new Properties();
    private static final Properties largeFontProps = new Properties();
    private static final Properties giantFontProps = new Properties();

    public static List getThemes() {
        return themesList;
    }

    public static Properties getThemeProperties(String name) {
        return (Properties)themesMap.get(name);
    }

    public static void setTheme(String name) {
        LightLookAndFeel.setTheme((Properties)themesMap.get(name));
        if (myTheme != null) {
            AbstractTheme.setInternalName(name);
        }
    }

    public static void setTheme(Properties themesProps) {
        currentThemeName = "renderedThemeLight";
        if (myTheme == null) {
            myTheme = new RenderedDefaultTheme();
        }
        if (myTheme != null && themesProps != null) {
            myTheme.setUpColor();
            myTheme.setProperties(themesProps);
            myTheme.setUpColorArrs();
            AbstractLookAndFeel.setTheme(myTheme);
        }
    }

    public static void setCurrentTheme(Properties themesProps) {
        LightLookAndFeel.setTheme(themesProps);
    }

    @Override
    public String getName() {
        return "RenderedLight";
    }

    @Override
    public String getID() {
        return "RenderedLight";
    }

    @Override
    public String getDescription() {
        return "The Light Rendered Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public AbstractBorderFactory getBorderFactory() {
        return RenderedBorderFactory.getInstance();
    }

    @Override
    public AbstractIconFactory getIconFactory() {
        return RenderedIconFactory.getInstance();
    }

    @Override
    protected void createDefaultTheme() {
        if (myTheme == null) {
            myTheme = new RenderedDefaultTheme();
        }
        LightLookAndFeel.setTheme(myTheme);
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        if (!"renderedThemeLight".equals(currentThemeName)) {
            LightLookAndFeel.setTheme("Default");
        }
        super.initClassDefaults(table);
        this.initTheme();
    }

    public void initTheme() {
        Color menuBlue = new Color(153, 153, 255);
        Color startColor = new Color(204, 204, 255);
        Color borderColor = Color.BLUE;
        Color mainColor = menuBlue;
        Color textColor = Color.black;
        Color mainBackcolor = Color.white;
        Color mainForecolor = mainColor;
        Color disabledColor = Color.lightGray.brighter();
        Color CLOSE_OVER_RED = new Color(232, 17, 35);
        Color CLOSE_PRESSED_RED = new Color(241, 112, 122);
        Color titleGradientStart = new Color(204, 204, 255);
        Color titleGradientEnd = new Color(102, 102, 255);
        ColorUIResource uiActiveBackcolor = new ColorUIResource(mainBackcolor);
        ColorUIResource uiMenuForecolor = new ColorUIResource(mainForecolor);
        ColorUIResource uiDisabledForecolor = new ColorUIResource(mainBackcolor.darker());
        BasicRenderer labelRenderer = new BasicRenderer();
        labelRenderer.setColors(mainBackcolor);
        labelRenderer.setTextColors(mainForecolor, mainForecolor, mainForecolor, mainForecolor.darker());
        labelRenderer.setPaintBorder(false);
        IconRenderer.getDefaultArrowRenderer().getColors().setColors(0, mainForecolor.brighter());
        IconRenderer.getDefaultArrowRenderer().getColors().setColors(2, mainBackcolor);
        BasicGradientRenderer bgRenderer = new BasicGradientRenderer();
        bgRenderer.setPaintBorder(false);
        bgRenderer.setRounded(false);
        bgRenderer.setTextColor(Color.black);
        bgRenderer.setColorNormal(Color.white);
        bgRenderer.setStartColors(Color.white);
        bgRenderer.setEndColors(Color.white);
        bgRenderer.setEndColorSelected(mainColor);
        bgRenderer.setStartColorSelected(startColor);
        bgRenderer.setEndColorPressed(mainColor);
        bgRenderer.setStartColorPressed(startColor);
        bgRenderer.setEndColorDisabled(disabledColor);
        bgRenderer.setStartColorDisabled(disabledColor);
        BasicCheckIcon menuCheckIcon = new BasicCheckIcon();
        menuCheckIcon.getColors().setColors(0, null, Color.gray, Color.lightGray, Color.green.darker(), Color.lightGray, Color.green.darker(), Color.green.darker());
        menuCheckIcon.setColors(1, Color.white);
        menuCheckIcon.setColor(1, 6, Color.white);
        menuCheckIcon.setColors(2, Color.black);
        menuCheckIcon.setColor(1, 5, Color.white);
        menuCheckIcon.setColor(2, 6, Color.black);
        menuCheckIcon.setColor(2, 5, Color.black);
        BasicRadioIcon menuRadioIcon = new BasicRadioIcon();
        menuRadioIcon.setColors(menuCheckIcon.getColors());
        UIManager.put("CheckBoxMenuItem.checkIcon", menuCheckIcon);
        UIManager.put("CheckBox.icon", menuCheckIcon);
        UIManager.put("RadioButton.icon", menuRadioIcon);
        UIManager.put("RadioButtonMenuItem.checkIcon", menuRadioIcon);
        BasicGradientRenderer menuCheckRadioRenderer = new BasicGradientRenderer();
        menuCheckRadioRenderer.setPaintBorder(false);
        menuCheckRadioRenderer.setRounded(false);
        menuCheckRadioRenderer.setTextColors(Color.black);
        menuCheckRadioRenderer.getColors().setColors(1, Color.white, startColor, disabledColor, Color.white, disabledColor, startColor, startColor);
        menuCheckRadioRenderer.getColors().setColors(4, Color.white, mainColor, disabledColor, Color.white, disabledColor, mainColor, mainColor);
        RenderedMenuCheckItemUI.setDefaultRenderer(menuCheckRadioRenderer);
        RenderedMenuRadioItemUI.setDefaultRenderer(menuCheckRadioRenderer);
        UIManager.put("RenderedUI.MenuSeparator.background", Color.white);
        UIManager.put("RenderedUI.MenuSeparator.bordercolor", borderColor);
        UIManager.put("RenderedUI.MenuSeparator.fillcolor", mainColor);
        UIManager.put("RenderedUI.MenuSeparator.foreground", Color.white);
        UIManager.put("RenderedUI.MenuScroller.background", Color.white);
        UIManager.put("RenderedUI.MenuScroller.bordercolor", borderColor);
        UIManager.put("RenderedUI.MenuScroller.fillcolor", mainColor);
        UIManager.put("RenderedUI.MenuScroller.foreground", borderColor);
        UIManager.put("RenderedUI.MenuScroller.showtext", false);
        UIManager.put("DockingFrame.activeTitleBackgroundStart", startColor);
        UIManager.put("DockingFrame.activeTitleBackgroundEnd", mainColor);
        UIManager.put("DockingFrame.activeTitleForeground", Color.black);
        UIManager.put("DockingFrame.background", Color.white);
        RenderedPopupMenuBorderUI.setDefaultRenderer(new GelRenderer());
        RenderedPopupMenuBorderUI.getDefaultRenderer().setRounded(false);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setColors(mainColor, startColor, mainColor, mainColor);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setTextColors(Color.white, Color.DARK_GRAY, Color.DARK_GRAY);
        RenderedScrollBarUI.getDefaultThumbRenderer().setColors(mainColor);
        RenderedScrollBarUI.setDefaultButtonRenderer(new MetalRenderer());
        RenderedScrollBarUI.getDefaultButtonRenderer().setColors(mainColor);
        RenderedScrollBarUI.getDefaultArrowRenderer().getColors().setColors(1, Color.white);
        RenderedScrollBarUI.getDefaultArrowRenderer().getColors().setColors(2, Color.black);
        RenderedScrollBarUI.setDefaultTrackRenderer(new JavTRenderer());
        RenderedScrollBarUI.getDefaultTrackRenderer().setColors(new Color(204, 204, 255));
        RenderedScrollBarUI.getDefaultTrackRenderer().setBorderColor(Color.black);
        RenderedScrollBarUI.getDefaultThumbRenderer().setBorderColor(Color.white);
        UIManager.put("MenuScroller.background", mainColor);
        UIManager.put("MenuScroller.foreground", Color.WHITE);
        UIManager.put("MenuScroller.bordercolor", Color.WHITE);
        UIManager.put("MenuBar.background", Color.WHITE);
        UIManager.put("Menu.background", Color.WHITE);
        UIManager.put("PopupMenu.background", Color.WHITE);
        UIManager.put("Menu.selectionBackground", mainColor);
        UIManager.put("Menu.selectionForeground", Color.WHITE);
        UIManager.put("Menu.borderColor", borderColor);
        UIManager.put("Menu.selectionBorderColor", borderColor);
        UIManager.put("MenuItem.borderColor", borderColor);
        UIManager.put("MenuItem.acceleratorForeground", borderColor);
        UIManager.put("MenuItem.acceleratorSelectionForeground", Color.WHITE);
        UIManager.put("MenuItem.background", Color.WHITE);
        UIManager.put("MenuItem.foreground", textColor);
        UIManager.put("MenuItem.selectionForeground", Color.WHITE);
        Renderer menuBarRenderer = RenderedMenuBarUI.getDefaultRenderer();
        menuBarRenderer.setPaintBorder(false);
        menuBarRenderer.setColors(mainBackcolor);
        menuBarRenderer.getColors().setColors(2, mainBackcolor);
        menuBarRenderer.setTextColors(mainForecolor, mainForecolor.brighter(), mainForecolor.darker());
        UIManager.put("MenuBarUI", RenderedMenuBarUI.class.getName());
        UIManager.put("ProgressBarUI", RenderedProgressBarUI.class.getName());
        UIManager.put("RenderedUI.MenuSeparator.background", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.bordercolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.fillcolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.foreground", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.header.background", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.header.bordercolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.header.fillcolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.header.foreground", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.footer.background", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.footer.bordercolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.footer.fillcolor", uiMenuForecolor);
        GelRenderer PopupMenuBorderRenderer = new GelRenderer();
        RenderedPopupMenuBorderUI.setDefaultRenderer(PopupMenuBorderRenderer);
        PopupMenuBorderRenderer.setRounded(false);
        PopupMenuBorderRenderer.setColors(startColor, startColor, startColor, startColor);
        PopupMenuBorderRenderer.setTextColors(mainForecolor, mainForecolor, mainForecolor);
        PopupMenuBorderRenderer.setBorderColors(mainForecolor);
        UIManager.put("MenuScroller.background", uiActiveBackcolor);
        UIManager.put("MenuScroller.foreground", uiMenuForecolor);
        UIManager.put("MenuScroller.bordercolor", uiMenuForecolor);
        UIManager.put("Menu.background", uiActiveBackcolor);
        UIManager.put("PopupMenu.background", uiActiveBackcolor);
        UIManager.put("Menu.selectionBackground", uiMenuForecolor);
        UIManager.put("Menu.selectionForeground", uiActiveBackcolor);
        UIManager.put("Menu.acceleratorForeground", uiMenuForecolor);
        UIManager.put("Menu.acceleratorSelectionForeground", uiActiveBackcolor);
        UIManager.put("Menu.borderColor", borderColor);
        UIManager.put("Menu.selectionBorderColor", borderColor);
        UIManager.put("MenuItem.borderColor", borderColor);
        UIManager.put("MenuItem.acceleratorForeground", uiMenuForecolor);
        UIManager.put("MenuItem.acceleratorSelectionForeground", uiActiveBackcolor);
        UIManager.put("MenuItem.background", uiActiveBackcolor);
        UIManager.put("MenuItem.foreground", textColor);
        UIManager.put("MenuItem.selectionForeground", Color.white);
        UIManager.put("MenuItem.selectionBackground", uiMenuForecolor);
        UIManager.put("CheckBoxMenuItem.selectionBackground", uiMenuForecolor);
        UIManager.put("CheckBoxMenuItem.selectionForeground", uiActiveBackcolor);
        UIManager.put("CheckBoxMenuItem.foreground", textColor);
        UIManager.put("CheckBoxMenuItem.background", uiActiveBackcolor);
        UIManager.put("CheckBoxMenuItem.acceleratorForeground", textColor);
        UIManager.put("CheckBoxMenuItem.disabledBackground", mainBackcolor.darker());
        UIManager.put("CheckBoxMenuItem.disabledForeground", uiDisabledForecolor);
        UIManager.put("RadioButtonMenuItem.selectionBackground", uiMenuForecolor);
        UIManager.put("RadioButtonMenuItem.selectionForeground", uiActiveBackcolor);
        UIManager.put("RadioButtonMenuItem.foreground", textColor);
        UIManager.put("RadioButtonMenuItem.background", uiActiveBackcolor);
        UIManager.put("RadioButtonMenuItem.acceleratorForeground", textColor);
        UIManager.put("RadioButtonMenuItem.disabledBackground", mainBackcolor.darker());
        UIManager.put("RadioButtonMenuItem.disabledForeground", uiDisabledForecolor);
        UIManager.put("PopupMenu.border", Defaults.getPopupMenuBorder());
        UIManager.put("RenderedPopupMenuBorder.bordercolor", Color.blue);
        bgRenderer.setPaintBorder(false);
        bgRenderer.setRounded(false);
        bgRenderer.setEndColorDisabled(disabledColor);
        bgRenderer.setStartColorDisabled(disabledColor);
        bgRenderer.setColorNormal(mainBackcolor);
        bgRenderer.setStartColors(mainBackcolor);
        bgRenderer.setEndColors(mainBackcolor);
        bgRenderer.setEndColorSelected(mainForecolor);
        bgRenderer.setStartColorSelected(mainForecolor);
        bgRenderer.setTextColors(textColor, textColor, textColor);
        bgRenderer.setEndColorPressed(mainColor);
        bgRenderer.setStartColorPressed(startColor);
        RenderedMenuUI.setDefaultRenderer(bgRenderer);
        RenderedMenuItemUI.setDefaultRenderer(bgRenderer);
        UIManager.put("MenuUI", RenderedMenuUI.class.getName());
        UIManager.put("MenuItemUI", RenderedMenuItemUI.class.getName());
        UIManager.put("RadioButtonMenuItemUI", RenderedMenuRadioItemUI.class.getName());
        UIManager.put("CheckBoxMenuItemUI", RenderedMenuCheckItemUI.class.getName());
        UIManager.put("PopupMenuSeparatorUI", RenderedMenuSeparatorUI.class.getName());
        UIManager.put("Button.background", mainBackcolor);
        UIManager.put("Button.foreground", textColor);
        UIManager.put("Button.opaque", false);
        WindowsRenderer buttonRenderer = new WindowsRenderer();
        buttonRenderer.getColors().setColors(2, null, textColor, null, textColor, null, textColor, textColor);
        RenderedButtonUI.setDefaultRenderer(buttonRenderer);
        buttonRenderer.setHorizontalIconAlignment(0);
        buttonRenderer.setVerticalIconAlignment(0);
        UIManager.put("ButtonUI", RenderedButtonUI.class.getName());
        UIManager.put("CheckBox.background", uiActiveBackcolor);
        UIManager.put("CheckBox.foreground", textColor);
        UIManager.put("CheckBox.opaque", false);
        RenderedCheckBoxUI.setDefaultRenderer(labelRenderer);
        UIManager.put("CheckBoxUI", RenderedCheckBoxUI.class.getName());
        UIManager.put("ComboBox.border", new LineBorder(Color.BLACK));
        UIManager.put("ComboBox.selectionForeground", uiActiveBackcolor);
        UIManager.put("ComboBox.selectionBackground", uiMenuForecolor);
        UIManager.put("ComboBox.background", uiActiveBackcolor);
        UIManager.put("ComboBox.foreground", textColor);
        UIManager.put("ComboBox.disabledBackground", Color.lightGray);
        UIManager.put("ComboBox.disabledForeground", Color.gray);
        RenderedComboBoxUI.setDefaultButtonRenderer(new MetallicRenderer());
        RenderedComboBoxUI.getDefaultArrowRenderer().getColors().setColors(2, mainColor, mainColor, disabledColor.darker(), mainColor, disabledColor.darker(), mainColor, mainColor);
        RenderedComboBoxUI.getDefaultArrowRenderer().getColors().setColors(0, Color.white, Color.white, disabledColor, Color.white, disabledColor, Color.white, Color.white);
        RenderedComboBoxUI.getDefaultButtonRenderer().getColors().setColors(1, mainColor, mainColor, disabledColor, mainColor, disabledColor, mainColor, mainColor);
        RenderedComboBoxUI.getDefaultButtonRenderer().getColors().setColors(2, mainColor, mainColor, disabledColor, mainColor, disabledColor, mainColor, mainColor);
        UIManager.put("ComboBoxUI", RenderedComboBoxUI.class.getName());
        UIManager.put("EditorPane.background", mainBackcolor);
        UIManager.put("EditorPane.foreground", textColor);
        UIManager.put("EditorPane.border", new LineBorder(Color.BLACK));
        UIManager.put("FileChooser.openButtonText", "Open Project");
        UIManager.put("FileChooser.saveButtonText", "Save Project");
        UIManager.put("FileChooserUI", RenderedFileChooserUI.class.getName());
        MetalRenderer shortcutButtonRenderer = new MetalRenderer();
        shortcutButtonRenderer.getColors().setColors(1, null, startColor, null, startColor, null, startColor, startColor);
        shortcutButtonRenderer.getColors().setColors(0, mainColor);
        shortcutButtonRenderer.getColors().setColors(2, null, mainColor, null, mainColor, null, mainColor, mainColor);
        shortcutButtonRenderer.setPaintBorder(true);
        RenderedToggleButtonUI shortcutUI = new RenderedToggleButtonUI();
        shortcutUI.setDefaultIconTextPaint(true);
        shortcutUI.setRenderer(shortcutButtonRenderer);
        RenderedLabelUI.setDefaultRenderer(labelRenderer);
        UIManager.put("Label.background", mainBackcolor);
        UIManager.put("Label.foreground", textColor);
        UIManager.put("Label.disabledForeground", uiDisabledForecolor);
        UIManager.put("Label.opaque", false);
        UIManager.put("List.border", new LineBorder(Color.BLACK));
        UIManager.put("List.selectionForeground", uiActiveBackcolor);
        UIManager.put("List.selectionBackground", uiMenuForecolor);
        UIManager.put("List.background", uiActiveBackcolor);
        UIManager.put("List.foreground", textColor);
        UIManager.put("OptionPane.messageForeground", textColor);
        LineBorder borderOut = new LineBorder(Color.black, 1, false);
        EmptyBorder borderIn = new EmptyBorder(15, 15, 15, 15);
        CompoundBorder border = new CompoundBorder(borderOut, borderIn);
        UIManager.put("OptionPane.border", border);
        UIManager.put("OptionPane.background", mainBackcolor);
        UIManager.put("OptionPane.foreground", textColor);
        UIManager.put("OptionPane.buttons.opaque", false);
        UIManager.put("OptionPaneUI", RenderedOptionPaneUI.class.getName());
        GlossyRenderer optionPaneButtonRenderer = new GlossyRenderer();
        optionPaneButtonRenderer.getColors().setColors(1, disabledColor, menuBlue, disabledColor, startColor, disabledColor, startColor, startColor);
        optionPaneButtonRenderer.getColors().setColors(0, textColor);
        optionPaneButtonRenderer.getColors().setColors(2, Color.black);
        optionPaneButtonRenderer.setRounded(true);
        optionPaneButtonRenderer.setPaintBorder(true);
        GlossyRenderer optionPaneCancelButtonRenderer = new GlossyRenderer();
        optionPaneCancelButtonRenderer.getColors().setColors(1, disabledColor, CLOSE_OVER_RED, disabledColor, CLOSE_OVER_RED, disabledColor, CLOSE_OVER_RED, CLOSE_OVER_RED);
        optionPaneCancelButtonRenderer.getColors().setColors(0, Color.black, Color.white, Color.white, Color.white, disabledColor, Color.white, Color.white);
        optionPaneCancelButtonRenderer.getColors().setColors(2, Color.black);
        optionPaneCancelButtonRenderer.setRounded(true);
        optionPaneCancelButtonRenderer.setPaintBorder(true);
        UIManager.put("OptionPane.yesbutton.renderer", optionPaneButtonRenderer);
        UIManager.put("OptionPane.nobutton.renderer", optionPaneButtonRenderer);
        UIManager.put("OptionPane.okbutton.renderer", optionPaneButtonRenderer);
        UIManager.put("OptionPane.cancelbutton.renderer", optionPaneCancelButtonRenderer);
        UIManager.put("Panel.background", mainBackcolor);
        UIManager.put("Panel.foreground", textColor);
        UIManager.put("ScrollPane.background", mainBackcolor);
        RenderedScrollBarUI.getDefaultThumbRenderer().setColors(mainForecolor);
        RenderedScrollBarUI.getDefaultThumbRenderer().setBorderColor(mainBackcolor);
        RenderedScrollBarUI.setDefaultTrackRenderer(new JavTRenderer());
        RenderedScrollBarUI.getDefaultTrackRenderer().setColors(startColor);
        RenderedScrollBarUI.getDefaultTrackRenderer().setBorderColor(Color.black);
        RenderedProgressBarUI.setDefaultThumbRenderer(RenderedScrollBarUI.getDefaultThumbRenderer());
        RenderedProgressBarUI.setDefaultTrackRenderer(RenderedScrollBarUI.getDefaultTrackRenderer());
        RenderedProgressBarUI.getDefaultValueRenderer().setTextColor(mainForecolor);
        UIManager.put("ScrollBarUI", RenderedScrollBarUI.class.getName());
        UIManager.put("Separator.foreground", uiMenuForecolor);
        UIManager.put("Separator.background", Color.BLACK);
        UIManager.put("SeparatorUI", RenderedSeparatorUI.class.getName());
        UIManager.put("Spinner.border", new LineBorder(Color.BLACK));
        UIManager.put("Spinner.background", uiActiveBackcolor);
        UIManager.put("Spinner.foreground", textColor);
        UIManager.put("SpinnerUI", RenderedSpinnerUI.class.getName());
        UIManager.put("SplitPane.background", mainBackcolor);
        UIManager.put("SplitPane.foreground", mainBackcolor);
        UIManager.put("SplitPaneUI", RenderedSplitPaneUI.class.getName());
        UIManager.put("RenderedUI.Slider.thumbBorderColor", mainForecolor.brighter());
        UIManager.put("RenderedUI.Slider.thumbFillcolor", mainBackcolor);
        UIManager.put("RenderedUI.Slider.forecolor", textColor);
        UIManager.put("TabbedPane.background", uiActiveBackcolor);
        UIManager.put("TabbedPane.foreground", textColor);
        UIManager.put("TabbedPane.selected", uiMenuForecolor);
        UIManager.put("TabbedPaneUI", RenderedTabbedPaneUI.class.getName());
        RenderedTabbedPaneUI.getDefaultRenderer().getColors().setColor(1, 0, mainBackcolor.brighter());
        RenderedTabbedPaneUI.getDefaultRenderer().getColors().setColor(1, 3, mainBackcolor);
        RenderedTabbedPaneUI.getDefaultRenderer().getColors().setColor(0, 0, mainBackcolor);
        RenderedTabbedPaneUI.getDefaultRenderer().getColors().setColor(0, 3, textColor);
        UIManager.put("Table.background", mainBackcolor);
        UIManager.put("Table.foreground", textColor);
        UIManager.put("Table.gridColor", mainForecolor);
        UIManager.put("Table.selectionBackground", mainForecolor);
        UIManager.put("Table.selectionForeground", mainBackcolor);
        UIManager.put("Table.border", new LineBorder(Color.BLACK));
        UIManager.put("TableHeader.foreground", textColor);
        UIManager.put("TableHeader.background", mainForecolor);
        UIManager.put("Table.dropCellForeground", new LineBorder(mainForecolor));
        UIManager.put("Table.dropCellBackground", new LineBorder(mainBackcolor));
        UIManager.put("TaskPaneContainer.background", new Color(122, 161, 230));
        UIManager.put("TaskPaneContainer.forecolor", new Color(214, 223, 247));
        UIManager.put("TaskPane.titleBackgroundGradientStart", new Color(214, 223, 247));
        UIManager.put("TaskPane.titleBackgroundGradientEnd", new Color(214, 223, 247));
        UIManager.put("TaskPane.borderColor", startColor);
        UIManager.put("TaskPane.specialTitleBackground", new Color(33, 89, 201));
        UIManager.put("TaskPane.titleOver", uiActiveBackcolor);
        UIManager.put("TaskPane.specialTitleOver", Color.white);
        UIManager.put("TaskPane.specialTitleForeground", Color.lightGray);
        UIManager.put("swingx/TaskPaneUI", "org.jdesktop.swingx.plaf.windows.WindowsTaskPaneUI");
        UIManager.put("TaskPane.background", new Color(214, 223, 247));
        UIManager.put("TextArea.background", mainBackcolor);
        UIManager.put("TextArea.foreground", textColor);
        UIManager.put("TextArea.selectionBackground", mainForecolor);
        UIManager.put("TextArea.selectionForeground", mainBackcolor);
        UIManager.put("TextArea.border", new LineBorder(Color.BLACK));
        UIManager.put("TextField.border", new LineBorder(Color.BLACK));
        UIManager.put("TextField.background", mainBackcolor);
        UIManager.put("TextField.foreground", textColor);
        UIManager.put("TextField.selectionBackground", mainForecolor);
        UIManager.put("TextField.selectionForeground", mainBackcolor);
        UIManager.put("TextPane.background", mainBackcolor);
        UIManager.put("TextPane.foreground", textColor);
        UIManager.put("TextPane.selectionBackground", mainForecolor);
        UIManager.put("TextPane.selectionForeground", mainBackcolor);
        UIManager.put("TextPane.border", new LineBorder(Color.BLACK));
        UIManager.put("TitledBorder.titleColor", mainForecolor);
        UIManager.put("TitledBorder.border", new LineBorder(mainForecolor));
        UIManager.put("RenderedUI.TitlePane.activetitlecolor", Color.black);
        UIManager.put("RenderedUI.TitlePane.inactivetitlecolor", Color.darkGray);
        ControlButtonColors closeControlButtonColors = new ControlButtonColors();
        closeControlButtonColors.setColors(2, Color.lightGray, Color.white, null, null, null, Color.white, null);
        closeControlButtonColors.setColors(5, Color.gray, Color.white, null, null, null, Color.white, null);
        closeControlButtonColors.setColors(1, null, CLOSE_PRESSED_RED, null, null, null, CLOSE_OVER_RED, null);
        closeControlButtonColors.setColors(4, null, CLOSE_PRESSED_RED, null, null, null, CLOSE_PRESSED_RED, null);
        UIManager.put("RenderedUI.TitlePaneButton.close.colors", closeControlButtonColors);
        UIManager.put("RenderedUI.TitlePane.horizontalspacing", 0);
        UIManager.put("RenderedUI.TitlePane.verticalspacing", 0);
        UIManager.put("RenderedUI.TitlePane.height", 32);
        Color activeFrameColor = Color.black;
        Color inactiveFrameColor = new Color(187, 187, 187);
        UIManager.put("RootPane.frameBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
        UIManager.put("TitlePane.border", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
        UIManager.put("RootPane.plainDialogBorder", new FrameBorder(Color.DARK_GRAY, inactiveFrameColor, 1, false));
        UIManager.put("RootPane.informationDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
        UIManager.put("RootPane.errorDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
        UIManager.put("RootPane.colorChooserDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
        UIManager.put("RootPane.fileChooserDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
        UIManager.put("questionDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
        UIManager.put("RootPane.warningDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
        ControlButtonColors basicCtrlButtonColors = new ControlButtonColors();
        basicCtrlButtonColors.setColors(2, Color.lightGray, Color.black, null, null, null, Color.black, null);
        basicCtrlButtonColors.setColors(5, Color.gray, Color.darkGray, null, null, null, Color.darkGray, null);
        UIManager.put("RenderedUI.TitlePaneButton.min.colors", basicCtrlButtonColors);
        UIManager.put("RenderedUI.TitlePaneButton.max.colors", basicCtrlButtonColors);
        UIManager.put("RenderedUI.TitlePaneButton.dock.colors", basicCtrlButtonColors);
        UIManager.put("RenderedUI.TitlePaneButton.alwaysontop.colors", basicCtrlButtonColors);
        UIManager.put("RenderedUI.TitlePaneButton.iconify.renderer", MinButtonIconRenderer.class.getName());
        UIManager.put("RenderedUI.TitlePaneButton.iconify.renderer", MinButtonIconRenderer.class.getName());
        UIManager.put("RenderedUI.TitlePaneButton.maximize.renderer", RestoreButtonIconRenderer.class.getName());
        UIManager.put("RenderedUI.TitlePaneButton.close.renderer", CloseButtonIconRenderer.class.getName());
        UIManager.put("ToggleButton.background", mainBackcolor);
        UIManager.put("ToggleButton.foreground", textColor);
        UIManager.put("ToggleButton.opaque", false);
        UIManager.put("ToolBar.background", uiActiveBackcolor);
        UIManager.put("ToolTip.background", uiMenuForecolor);
        UIManager.put("ToolTip.foreground", textColor);
        UIManager.put("ToolTip.border", new LineBorder(Color.BLACK));
        UIManager.put("Tree.background", Color.white);
        UIManager.put("Tree.dropLineColor", textColor);
        UIManager.put("Tree.foreground", textColor);
        UIManager.put("Tree.selectionBackground", startColor);
        UIManager.put("Tree.selectionForeground", mainBackcolor);
        UIManager.put("Tree.textBackground", Color.white);
        UIManager.put("Tree.textForeground", textColor);
        TreeOpenClosedIcon closedIcon = new TreeOpenClosedIcon(true);
        TreeOpenClosedIcon openedIcon = new TreeOpenClosedIcon(false);
        closedIcon.getColors().setColor(1, 0, Color.white);
        closedIcon.getColors().setColor(0, 0, Color.black);
        closedIcon.getColors().setColor(2, 0, Color.black);
        openedIcon.setColors(closedIcon.getColors());
        UIManager.put("Tree.collapsedIcon", closedIcon);
        UIManager.put("Tree.expandedIcon", openedIcon);
        RenderedToggleButtonUI.setDefaultRenderer(buttonRenderer);
        UIManager.put("ToggleButtonUI", RenderedToggleButtonUI.class.getName());
        RenderedRadioButtonUI.setDefaultRenderer(RenderedLabelUI.getDefaultRenderer());
        UIManager.put("RadioButtonUI", RenderedRadioButtonUI.class.getName());
        BasicGradientRenderer defaultRenderer = new BasicGradientRenderer();
        defaultRenderer.setStartColors(titleGradientStart);
        defaultRenderer.setEndColors(titleGradientEnd);
        defaultRenderer.getColors().setColors(0, Color.white, Color.white, disabledColor, Color.white, Color.DARK_GRAY, Color.white, Color.white);
        UIManager.put("RenderedUI.TitlePaneRenderer", defaultRenderer);
        UIManager.put("RootPaneUI", "UIRenderers.RenderedRootPaneUI");
        UIManager.put("RootPane.frameBorder", new FrameBorder(Color.black, Color.gray, 2, false));
        UIManager.put("GhostTextPane.background", mainBackcolor);
        UIManager.put("GhostTextPane.foreground", textColor);
        UIManager.put("GhostTextPane.selectionBackground", mainForecolor);
        UIManager.put("DockingFrame.activeTitleBackgroundStart", titleGradientStart);
        UIManager.put("DockingFrame.activeTitleBackgroundEnd", titleGradientEnd);
        UIManager.put("DockingFrame.activeTitleForeground", mainForecolor);
        UIManager.put("DockingFrame.background", mainForecolor);
        UIManager.put("DockingFrame.titlebar.hidedocked", false);
        UIManager.put("DockingFrame.titlebar.hideundocked", true);
        UIManager.put("DockingFrame.titlebar.docked.height", 24);
        UIManager.put("DockingFrame.titlebar.undocked.height", 28);
        UIManager.put("Plot.link.active", Color.red);
        UIManager.put("Plot.link.inactive", Color.blue);
        UIManager.put("Plot.tooltip.green", new Color(0, 204, 0));
        UIManager.put("Plot.tooltip.blue", new Color(0, 0, 204));
        UIManager.put("Plot.tooltip.yellow", new Color(204, 235, 204));
        UIManager.put("Plot.tooltip.red", new Color(204, 0, 0));
        UIManager.put("MolBioTools.ChromatWindow.background", Color.white);
        UIManager.put("MolBioTools.ChromatWindow.colorA", new Color(0, 255, 0, 30));
        UIManager.put("MolBioTools.ChromatWindow.colorT", new Color(255, 0, 0, 30));
        UIManager.put("MolBioTools.ChromatWindow.colorG", new Color(0, 0, 0, 30));
        UIManager.put("MolBioTools.ChromatWindow.colorC", new Color(0, 0, 255, 30));
        UIManager.put("MolBioTools.ChromatWindow.bordercolorA", new Color(0, 150, 0));
        UIManager.put("MolBioTools.ChromatWindow.bordercolorT", new Color(200, 0, 0));
        UIManager.put("MolBioTools.ChromatWindow.bordercolorG", Color.black);
        UIManager.put("MolBioTools.ChromatWindow.bordercolorC", new Color(0, 0, 200));
        UIManager.put("SequenceEditor.background", startColor);
        UIManager.put("SequenceEditor.foreground", Color.black);
        UIManager.put("StatusLabel.background", mainBackcolor);
        UIManager.put("StatusLabel.foreground", textColor);
        UIManager.put("wikipane.titlecolor", Color.white);
        UIManager.put("wikipane.titlebackcolor", Color.lightGray);
        UIManager.put("wikipane.forecolor", Color.black);
        UIManager.put("wikipane.backcolor", Color.white);
        UIManager.put("wikipane.visitedlinkcolor", Color.red);
        UIManager.put("wikipane.linkcolor", Color.BLUE);
        UIManager.put("wikipane.hoverlinkcolor", Color.red);
        UIManager.put("wikipane.activelinkcolor", Color.orange);
    }

    static {
        smallFontProps.setProperty("controlTextFont", "Dialog 10");
        smallFontProps.setProperty("systemTextFont", "Dialog 10");
        smallFontProps.setProperty("userTextFont", "Dialog 10");
        smallFontProps.setProperty("menuTextFont", "Dialog 10");
        smallFontProps.setProperty("windowTitleFont", "Dialog bold 10");
        smallFontProps.setProperty("subTextFont", "Dialog 8");
        largeFontProps.setProperty("controlTextFont", "Dialog 14");
        largeFontProps.setProperty("systemTextFont", "Dialog 14");
        largeFontProps.setProperty("userTextFont", "Dialog 14");
        largeFontProps.setProperty("menuTextFont", "Dialog 14");
        largeFontProps.setProperty("windowTitleFont", "Dialog bold 14");
        largeFontProps.setProperty("subTextFont", "Dialog 12");
        giantFontProps.setProperty("controlTextFont", "Dialog 18");
        giantFontProps.setProperty("systemTextFont", "Dialog 18");
        giantFontProps.setProperty("userTextFont", "Dialog 18");
        giantFontProps.setProperty("menuTextFont", "Dialog 18");
        giantFontProps.setProperty("windowTitleFont", "Dialog 18");
        giantFontProps.setProperty("subTextFont", "Dialog 16");
        themesList.add("Default");
        themesList.add("Small-Font");
        themesList.add("Large-Font");
        themesList.add("Giant-Font");
        themesMap.put("Default", defaultProps);
        themesMap.put("Small-Font", smallFontProps);
        themesMap.put("Large-Font", largeFontProps);
        themesMap.put("Giant-Font", giantFontProps);
    }
}

