/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import UIRenderers.RenderedMenuSeparatorUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class Themes {
    public static final String[] themeNames = new String[]{"Default", "Dark", "Dark II", "Light", "Purple"};
    public static final String[] themeKeys = new String[]{"Default", "dark", "dark2", "light", "purple"};
    public static final boolean[] enabledThemes = new boolean[]{true, true, true, true, false};

    private static String getKeyForName(String name) {
        for (int x = 0; x < themeNames.length; ++x) {
            if (!themeKeys[x].equalsIgnoreCase(name)) continue;
            return themeNames[x];
        }
        return themeNames[0];
    }

    private static int getIndexForKey(String name) {
        for (int x = 0; x < themeKeys.length; ++x) {
            if (!themeKeys[x].equalsIgnoreCase(name)) continue;
            return x;
        }
        return -1;
    }

    public static void setThemeEnabled(String themeKey, boolean enabled) {
        int index = Themes.getIndexForKey(themeKey);
        Themes.setThemeEnabled(index, enabled);
    }

    public static void setThemeEnabled(int index, boolean enabled) {
        if (index < 0 || index >= themeNames.length || enabledThemes[index] == enabled) {
            return;
        }
        Themes.enabledThemes[index] = enabled;
    }

    public static void setTheme(String themeKey, String appName, String appKey, Component parentComponent, boolean showConfirmation) {
        Themes.setTheme(Themes.getKeyForName(themeKey), themeKey, appName, appKey, parentComponent, showConfirmation);
    }

    public static void setTheme(String themeName, String themeKey, String appName, String appThemeKey, Component parentComponent, boolean showConfirmation) {
        if (themeKey == null || themeKey.length() == 0) {
            return;
        }
        Preferences.userRoot().put(appThemeKey, themeKey.toLowerCase());
        if (showConfirmation) {
            JOptionPane.showMessageDialog(parentComponent, themeName + " theme will be applied next time " + appName + " is started", "Theme set", 1);
        }
    }

    public static String getTheme(String appThemeKey) {
        return Themes.getTheme(appThemeKey, themeKeys[0]);
    }

    public static String getTheme(String appThemeKey, String defaultTheme) {
        String theme = Preferences.userRoot().get(appThemeKey, defaultTheme);
        return theme;
    }

    public static void setThemeMenus(JMenu parentMenu, String appName, String appThemeKey, Component parentComponent, boolean showConfirmation) {
        JMenuItem[] items = Themes.getThemeMenus(appName, appThemeKey, parentComponent, showConfirmation);
        JPopupMenu.Separator topSep = new JPopupMenu.Separator();
        topSep.setToolTipText("Themes");
        parentMenu.add(topSep);
        for (JMenuItem item : items) {
            if (item == null) continue;
            parentMenu.add(item);
        }
        parentMenu.add(new JPopupMenu.Separator());
    }

    public static void setThemeMenus(JMenuBar menuBar, String appName, String appThemeKey, Component parentComponent, boolean showConfirmation) {
        Themes.setThemeMenus(menuBar, appName, appThemeKey, parentComponent, showConfirmation, menuBar.getComponentCount());
    }

    public static void setThemeMenus(JMenuBar menuBar, String appName, String appThemeKey, Component parentComponent, boolean showConfirmation, int index) {
        JMenu parentMenu = new JMenu("Theme");
        JMenuItem[] items = Themes.getThemeMenus(appName, appThemeKey, parentComponent, showConfirmation);
        JPopupMenu.Separator topSep = new JPopupMenu.Separator();
        topSep.setUI(new RenderedMenuSeparatorUI(1));
        topSep.setToolTipText("Set Theme");
        parentMenu.add(topSep);
        for (JMenuItem item : items) {
            if (item == null) continue;
            parentMenu.add(item);
        }
        JPopupMenu.Separator botSep = new JPopupMenu.Separator();
        botSep.setUI(new RenderedMenuSeparatorUI(3, false));
        botSep.setToolTipText("Set Theme");
        parentMenu.add(botSep);
        int currentCount = menuBar.getComponentCount();
        if (index < 0) {
            if ((index = currentCount + index) < 0) {
                index = currentCount;
            }
        } else if (index > currentCount) {
            index = currentCount;
        }
        menuBar.add((Component)parentMenu, index);
    }

    public static JMenuItem[] getThemeMenus(final String appName, final String appKey, final Component parentComponent, final boolean showConfirmation) {
        JMenuItem[] items = new JMenuItem[themeNames.length];
        int index = 0;
        for (int x = 0; x < themeNames.length; ++x) {
            if (!enabledThemes[x]) continue;
            JMenuItem newItem = new JMenuItem("Set theme: " + themeNames[x]);
            newItem.setToolTipText("Set theme to " + themeNames[x]);
            final String themeKey = themeKeys[x];
            newItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Themes.setTheme(themeKey, appName, appKey, parentComponent, showConfirmation);
                }
            });
            items[index] = newItem;
            ++index;
        }
        return items;
    }

    public static JMenuItem getThemeMenu(String themeName, final String themeKey, final String appName, final String appKey, final Component parentComponent, final boolean showConfirmation) {
        JMenuItem newItem = new JMenuItem("Set theme: " + themeName);
        newItem.setToolTipText("Set theme to " + themeName);
        newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Themes.setTheme(themeKey, appName, appKey, parentComponent, showConfirmation);
            }
        });
        return newItem;
    }
}

