/*
 * Decompiled with CFR 0.152.
 */
package plot;

import AbiFileReader.AbiFile;
import FileConverters.ImpFileReader;
import GenbankFileReader.GenBankFile;
import java.io.File;
import java.io.IOException;
import plot.DefaultConverter;

class AbiFileReader
extends AbiFile
implements ImpFileReader,
DefaultConverter {
    private static String[] extensions = new String[]{"ab1"};

    AbiFileReader() {
    }

    @Override
    public String[] getReadFileExtensions() {
        return extensions;
    }

    @Override
    public String getReadFormatDescription() {
        return "Abi Chromatogram File";
    }

    @Override
    public GenBankFile loadFile(File file) {
        try {
            AbiFile abi = AbiFileReader.loadAbi(file);
            GenBankFile gb = new GenBankFile();
            gb.sequence = abi.getChromatogram().sequence;
            if (gb.header.name == null || gb.header.name.length() == 0) {
                gb.header.name = file.getName();
            }
            return gb;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public boolean acceptFileForRead(File file) {
        String lc = file.getAbsolutePath().toLowerCase();
        return lc.endsWith("ab1");
    }

    @Override
    public int getSortOrder() {
        return 4;
    }

    @Override
    public String getReadError() {
        return "";
    }
}

