/*
 * Decompiled with CFR 0.152.
 */
package plot;

import CloneManagerFileReader.CloneManagerReader;
import FileConverters.ImpFileReader;
import GenbankFileReader.GenBankFile;
import java.io.File;
import plot.DefaultConverter;

class CloneManagerFileReader
extends CloneManagerReader
implements ImpFileReader,
DefaultConverter {
    private static String[] extensions = new String[]{"cm5"};

    CloneManagerFileReader() {
    }

    @Override
    public String[] getReadFileExtensions() {
        return extensions;
    }

    @Override
    public String getReadFormatDescription() {
        return "CloneManager 5 File";
    }

    @Override
    public GenBankFile loadFile(File file) {
        return CloneManagerFileReader.loadCM5File(file);
    }

    @Override
    public boolean acceptFileForRead(File file) {
        String lc = file.getAbsolutePath().toLowerCase();
        return lc.endsWith("cm5");
    }

    @Override
    public int getSortOrder() {
        return 3;
    }

    @Override
    public String getReadError() {
        return "";
    }
}

