/*
 * Decompiled with CFR 0.152.
 */
package plot;

import plot.SpacedObject;

class Cluster {
    Cluster prevCluster;
    Cluster nextCluster;
    SpacedObject firstSO;
    SpacedObject lastSO;
    int size = 0;
    int min = 0;
    private int max = 0;

    public Cluster(SpacedObject o) {
        this.firstSO = o;
        this.lastSO = o;
        this.size = o.getSize();
        this.min = o.getDistance();
        this.max = this.min + this.size;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
        this.max = min + this.max;
    }

    public int getMax() {
        return this.min + this.size;
    }

    public void append(Cluster cluster) {
        Cluster.mergeClusters(this, cluster);
    }

    public void appendTo(Cluster cluster) {
        Cluster.mergeClusters(cluster, this);
    }

    public void commitDistances() {
        if (this.firstSO == null) {
            return;
        }
        this.firstSO.setDistance(this.min);
        SpacedObject curr = this.firstSO.next;
        while (curr != null) {
            curr.setDistance(curr.prev.getDistance() + curr.prev.getSize());
            curr = curr.next;
        }
    }

    private static void mergeClusters(Cluster receiver, Cluster donor) {
        if (receiver == donor) {
            return;
        }
        SpacedObject donorFirst = donor.firstSO;
        SpacedObject donorLast = donor.lastSO;
        if (donorFirst == null || donorLast == null) {
            return;
        }
        if (receiver.firstSO == null) {
            receiver.firstSO = donorFirst;
            receiver.lastSO = donorLast;
        } else {
            donorFirst.prev = receiver.lastSO;
            receiver.lastSO.next = donorFirst;
            receiver.lastSO = donorLast;
        }
        receiver.size += donor.size;
        receiver.max += donor.size;
        donor.firstSO = null;
        donor.lastSO = null;
        donor.size = 0;
        receiver.nextCluster = donor.nextCluster;
        if (receiver.nextCluster != null) {
            receiver.nextCluster.prevCluster = receiver;
        }
        donor.prevCluster = null;
        donor.nextCluster = null;
    }

    public static void link(Cluster c1, Cluster c2) {
        if (c1.nextCluster != null) {
            c1.nextCluster.prevCluster = null;
        }
        if (c2.prevCluster != null) {
            c2.prevCluster.nextCluster = null;
        }
        c1.nextCluster = c2;
        c2.prevCluster = c1;
    }

    public void clear() {
        Cluster.dispose(this);
    }

    private static void dispose(Cluster c) {
        Cluster currC = c;
        while (currC != null) {
            if (currC.firstSO != null) {
                currC.firstSO.clear();
                currC.firstSO = null;
            }
            currC.lastSO = null;
            if (currC.nextCluster == null) break;
            Cluster nextC = currC.nextCluster;
            currC.nextCluster = null;
            currC = nextC;
            currC.prevCluster = null;
        }
    }
}

