/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import DNATools.DegenerateFinder;
import GenbankFileReader.Locus;
import SequenceEditorPanels.ROI;
import StatusBarDialogs.FrmStatusBar;
import StatusBarDialogs.ThreadRunner;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import plot.DefaultEnzymes;
import plot.DefaultFeatures;
import plot.DefaultLadders;
import plot.DefaultPrimers;
import plot.Enzyme;
import plot.Feature;
import plot.FoundPrimer;
import plot.LibraryFeature;
import plot.PLOTJ;
import plot.PlotPrimer;
import plot.PrimerCategory;
import plot.ProjectDocument;
import plot.ProjectEnzyme;
import plot.UserFeatures;
import plot.UserLadders;
import plot.UserLibrary;

class DefaultLibraries {
    public static final int OVERHANG_5 = 5;
    public static final int OVERHANG_3 = 3;
    public static final int OVERHANG_BLUNT = 0;
    public static DefaultFeatures defaultFeatures;
    public static DefaultPrimers defaultPrimers;
    public static DefaultLadders defaultLadders;
    public static DefaultEnzymes defaultEnzymes;
    public static final UserFeatures userFeatures;
    public static final UserLadders userLadders;
    public static final UserLibrary userLibrary;
    public static final PrimerCategory catNoCategory;
    public static final BinaryChain<PrimerCategory> primerCategories;

    DefaultLibraries() {
    }

    public static void findFeatures(PLOTJ owner) {
        ArrayList<Feature> results = DefaultLibraries.findFeaturesAsArrayList(owner);
        if (results != null && !results.isEmpty()) {
            ProjectDocument project = owner.getProject();
            for (Feature f : results) {
                project.addROI((ROI)f);
            }
        }
    }

    public static void findFeatures(ProjectDocument project, FrmStatusBar statusBarForm) {
        ArrayList<Feature> results = DefaultLibraries.findFeaturesAsArrayList(project, statusBarForm);
        if (results != null && !results.isEmpty()) {
            for (Feature f : results) {
                project.addROI((ROI)f);
            }
        }
    }

    public static Enzyme getEnzyme(String enzyme) {
        return DefaultLibraries.defaultEnzymes.items.get(enzyme);
    }

    public static ArrayList<Feature> findFeaturesAsArrayList(PLOTJ owner) {
        return DefaultLibraries.findFeaturesAsArrayList(owner.getProject(), owner.statusBarForm);
    }

    public static ArrayList<Feature> findFeaturesAsArrayList(final ProjectDocument project, final FrmStatusBar statusBarForm) {
        int featureCount = (defaultFeatures != null ? 0 : DefaultLibraries.defaultFeatures.items.length) + (userFeatures == null ? 0 : DefaultLibraries.userFeatures.items.size());
        if (project.length() == 0 || featureCount == 0) {
            return null;
        }
        FeatureThreadRunner t = new FeatureThreadRunner(){

            @Override
            public void run() {
                Locus[] results2;
                int cValue = 0;
                DegenerateFinder finder = new DegenerateFinder(project.getSequence(), project.isCircular());
                finder.setCodonTable(project.getCodonTable());
                if (defaultFeatures != null && DefaultLibraries.defaultFeatures.items.length > 0) {
                    for (LibraryFeature feature : DefaultLibraries.defaultFeatures.items) {
                        if (feature.seq.length() > 3 && (results2 = feature.type == 0 ? finder.findDNASequence(feature.seq, true, true) : finder.findAASequence(feature.seq, true, true)) != null && results2.length > 0) {
                            for (Locus pos : results2) {
                                Feature f = Feature.fromLibraryFeature(feature);
                                f.set(pos.getStart(), pos.getStop(), pos.isAntisense());
                                this.results.add(f);
                            }
                        }
                        if (statusBarForm == null) continue;
                        statusBarForm.setValue(++cValue);
                    }
                }
                if (userFeatures != null && !DefaultLibraries.userFeatures.items.isEmpty()) {
                    for (LibraryFeature feature : DefaultLibraries.userFeatures.items) {
                        if (feature.seq.length() > 3 && (results2 = feature.type == 0 ? finder.findDNASequence(feature.seq, true, true) : finder.findAASequence(feature.seq, true, true)) != null && results2.length > 0) {
                            for (Locus pos : results2) {
                                Feature f = Feature.fromLibraryFeature(feature);
                                f.set(pos.getStart(), pos.getStop(), pos.isAntisense());
                                this.results.add(f);
                            }
                        }
                        if (statusBarForm == null) continue;
                        statusBarForm.setValue(++cValue);
                    }
                }
            }
        };
        if (statusBarForm != null) {
            statusBarForm.setTitle("Finding Features");
            statusBarForm.setMaximum(featureCount);
            statusBarForm.setValue(0);
            statusBarForm.progressBar.getActiveThumbRenderer().getColors().setColor(1, 0, Color.blue);
            statusBarForm.run(t);
        } else {
            t.run();
        }
        return t.results;
    }

    public static FileTime getFileLastModTime(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        Path file = Paths.get(path, new String[0]);
        File tmpFile = file.toFile();
        if (!tmpFile.exists()) {
            return null;
        }
        try {
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            FileTime modTime = attr.lastModifiedTime();
            return modTime;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static void findPrimers(final ProjectDocument project, final FrmStatusBar statusBarForm) {
        if (project == null) {
            return;
        }
        project.foundCategories.clear();
        if (project.length() == 0) {
            return;
        }
        int primerCount = (defaultPrimers == null ? 0 : DefaultPrimers.items.length) + (userLibrary == null ? 0 : DefaultLibraries.userLibrary.items.size());
        if (primerCount == 0) {
            return;
        }
        ThreadRunner runner = new ThreadRunner(){

            @Override
            public void run() {
                String seq = project.getSequence().toUpperCase();
                int seqLen = seq.length();
                if (project.isCircular()) {
                    seq = seq + seq;
                }
                int processed = 0;
                if (defaultPrimers != null) {
                    if (DefaultPrimers.items.length > 0) {
                        for (PlotPrimer primer : DefaultPrimers.items) {
                            FoundPrimer.findSites(primer, seq, seqLen, true, true, project);
                            ++processed;
                            if (statusBarForm == null) continue;
                            statusBarForm.setValue(processed);
                        }
                    }
                }
                if (userLibrary != null && !DefaultLibraries.userLibrary.items.isEmpty()) {
                    for (PlotPrimer primer : DefaultLibraries.userLibrary.items) {
                        FoundPrimer.findSites(primer, seq, seqLen, true, true, project);
                        ++processed;
                        if (statusBarForm == null) continue;
                        statusBarForm.setValue(processed);
                    }
                }
            }
        };
        if (statusBarForm != null) {
            statusBarForm.setTitle("Finding Primers");
            statusBarForm.setMaximum(primerCount);
            statusBarForm.setValue(0);
            statusBarForm.setBarFillColor(Color.green);
            statusBarForm.run(runner);
        } else {
            runner.run();
        }
    }

    public static void initEnzymes(ProjectDocument project) {
        for (Enzyme e : DefaultLibraries.defaultEnzymes.items) {
            ProjectEnzyme clone = new ProjectEnzyme(e);
            project.defaultEnzymes.add(clone, e.name);
            if (e.sShared == null) continue;
            clone.proto = project.defaultEnzymes.get(clone.enzyme.sShared);
        }
    }

    static {
        userFeatures = new UserFeatures();
        userLadders = new UserLadders();
        userLibrary = new UserLibrary();
        catNoCategory = new PrimerCategory(" [No Category] ");
        primerCategories = new BinaryChain();
    }

    static abstract class FeatureThreadRunner
    extends ThreadRunner {
        final ArrayList<Feature> results = new ArrayList();

        FeatureThreadRunner() {
        }
    }
}

