/*
 * Decompiled with CFR 0.152.
 */
package plot;

import MiscTools.StringTools;
import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Pattern;

public class Enzyme
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int OVERHANG_3_PRIME = 3;
    public static final int OVERHANG_5_PRIME = 5;
    public static final int OVERHANG_BLUNT = 0;
    static final Comparator sortComparator = new Comparator<Enzyme>(){

        @Override
        public int compare(Enzyme o1, Enzyme o2) {
            return o1.name.compareToIgnoreCase(o2.name);
        }
    };
    String name = "";
    String sShared = null;
    String sequence = "";
    String filteredSeq = "";
    String tempComment = "";
    int overhang;
    boolean asymetrical = false;
    boolean degenerate = false;
    boolean isoschizomer = false;
    boolean homing = false;
    int isDam = 0;
    int isDcm = 0;
    int isCpG = 0;
    int requiresMeth = 0;
    boolean requiresMult = false;
    int optTemp = 37;
    String optTempComment;
    String regExString;
    transient boolean isDefault = false;
    transient Enzyme proto = null;
    transient Pattern regExPattern = null;

    public String getName() {
        return this.name;
    }

    public String getDisplaySequence() {
        return this.sequence;
    }

    public String getSequence() {
        return this.filteredSeq;
    }

    public String getTempComment() {
        return this.tempComment;
    }

    public int getOverhang() {
        return this.overhang;
    }

    public boolean isAsymetrical() {
        return this.asymetrical;
    }

    public boolean isDegenerate() {
        return this.degenerate;
    }

    public boolean isIsoschizomer() {
        return this.isoschizomer;
    }

    public boolean isHoming() {
        return this.homing;
    }

    public int getIsDam() {
        return this.isDam;
    }

    public int getIsDcm() {
        return this.isDcm;
    }

    public int getIsCpG() {
        return this.isCpG;
    }

    public int getRequiresMeth() {
        return this.requiresMeth;
    }

    public boolean isRequiresMult() {
        return this.requiresMult;
    }

    public int getOptTemp() {
        return this.optTemp;
    }

    public String getOptTempComment() {
        return this.optTempComment;
    }

    public String getRegExString() {
        return this.regExString;
    }

    public boolean isIsDefault() {
        return this.isDefault;
    }

    public Enzyme getProto() {
        return this.proto;
    }

    public Enzyme clone() {
        Enzyme clone = new Enzyme();
        clone.asymetrical = this.asymetrical;
        clone.degenerate = this.degenerate;
        clone.filteredSeq = this.filteredSeq;
        clone.homing = this.homing;
        clone.isCpG = this.isCpG;
        clone.isDam = this.isDam;
        clone.isDcm = this.isDcm;
        clone.isDefault = this.isDefault;
        clone.isoschizomer = this.isoschizomer;
        clone.name = this.name;
        clone.optTemp = this.optTemp;
        clone.optTempComment = this.optTempComment;
        clone.overhang = this.overhang;
        clone.regExPattern = this.regExPattern;
        clone.regExString = this.regExString;
        clone.requiresMeth = this.requiresMeth;
        clone.requiresMult = this.requiresMult;
        clone.proto = null;
        clone.sequence = this.sequence;
        clone.sShared = this.sShared;
        clone.tempComment = this.tempComment;
        return clone;
    }

    public String toString() {
        return this.name;
    }

    static Enzyme fromString(String line) {
        if (line != null && line.length() > 0 && !line.startsWith(";")) {
            String[] strings = line.split("\t");
            Enzyme enzyme = new Enzyme();
            if (strings.length > 0) {
                enzyme.name = strings[0];
            }
            if (strings.length > 1 && strings[1].length() > 0) {
                enzyme.sShared = strings[1];
            }
            if (strings.length > 2) {
                enzyme.filteredSeq = strings[2];
            }
            if (strings.length > 3) {
                enzyme.sequence = strings[3];
            }
            if (strings.length > 4) {
                enzyme.overhang = StringTools.filterStringToInt(strings[4]);
            }
            if (strings.length > 5) {
                enzyme.asymetrical = strings[5].equals("1");
            }
            if (strings.length > 6) {
                enzyme.degenerate = strings[6].equals("1");
            }
            if (strings.length > 7) {
                enzyme.homing = strings[7].equals("1");
            }
            if (strings.length > 8) {
                boolean bl = enzyme.isoschizomer = enzyme.sShared != null;
            }
            if (strings.length > 9) {
                enzyme.isDam = StringTools.filterStringToInt(strings[9]);
            }
            if (strings.length > 10) {
                enzyme.isDcm = StringTools.filterStringToInt(strings[10]);
            }
            if (strings.length > 11) {
                enzyme.isCpG = StringTools.filterStringToInt(strings[11]);
            }
            if (strings.length > 12) {
                enzyme.requiresMeth = StringTools.filterStringToInt(strings[12]);
            }
            if (strings.length > 13) {
                enzyme.requiresMult = strings[13].equals("1");
            }
            if (strings.length > 14) {
                enzyme.optTempComment = strings[14];
            }
            if (strings.length > 15 && strings[15].length() > 0) {
                enzyme.optTemp = StringTools.filterStringToInt(strings[15]);
            }
            if (strings.length > 16) {
                enzyme.regExString = strings[16];
            }
            return enzyme;
        }
        return null;
    }
}

