/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import plot.EnzymeMix;
import plot.ProjectEnzyme;

class EnzymeListCellRenderer
extends JLabel
implements ListCellRenderer {
    private Color selectionBackColor = null;
    private Color selectionForeColor = null;
    private Color backColor = null;
    private Color foreColor = null;

    public EnzymeListCellRenderer() {
        this.setOpaque(true);
        this.selectionForeColor = UIManager.getColor("List.selectionForeground");
        this.selectionBackColor = UIManager.getColor("List.selectionBackground");
        this.foreColor = UIManager.getColor("List.foreground");
        this.backColor = UIManager.getColor("List.background");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setForeground(this.selectionForeColor != null ? this.selectionForeColor : list.getSelectionForeground());
            this.setBackground(this.selectionBackColor != null ? this.selectionBackColor : list.getSelectionBackground());
        } else {
            this.setForeground(this.foreColor != null ? this.foreColor : list.getForeground());
            this.setBackground(this.backColor != null ? this.backColor : list.getBackground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        if (value instanceof ProjectEnzyme) {
            ProjectEnzyme enzyme = (ProjectEnzyme)value;
            this.setText(enzyme.enzyme.getName() + " (" + (enzyme.cuts != null ? String.valueOf(enzyme.cuts.length) : "0") + ")");
        } else if (value instanceof EnzymeMix) {
            this.setText(((EnzymeMix)value).getName());
        } else if (value instanceof String) {
            this.setText((String)value);
        } else {
            this.setText(value != null ? value.toString() : "");
        }
        this.setIconTextGap(7);
        return this;
    }
}

