/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BioDocumentFilters.BioKeyFilter;
import Buttons.GlossyButton;
import Clipboards.ClipBoard;
import GhostTextControls.GhostTextArea;
import MiscTools.StringTools;
import ProteinTools.AminoAcid;
import ProteinTools.AminoAcids;
import SequenceEditorPanels.ProteinEditorPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import plot.Globals;
import plot.JOptionPanes;
import plot.MainExclusiveDlg;
import plot.PLOTJ;

class FrmAAToDNA
extends MainExclusiveDlg {
    private JComboBox<String> cmbOrg;
    private GlossyButton cmdCancel;
    private GlossyButton cmdOK;
    public ProteinEditorPanel editor;
    private ButtonGroup groupMenu;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem2;
    private JScrollPane jScrollPane2;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JSplitPane jSplitPane1;
    private JRadioButtonMenuItem mnuAcidic;
    private JRadioButtonMenuItem mnuAmidic;
    private JRadioButtonMenuItem mnuBasic;
    private JMenuItem mnuClose;
    private JMenu mnuColorByProperty;
    private JMenu mnuColorByResidue;
    private JMenuItem mnuColumns20;
    private JMenuItem mnuColumns25;
    private JMenuItem mnuColumns30;
    private JMenuItem mnuColumns35;
    private JMenuItem mnuColumns40;
    private JMenuItem mnuColumns45;
    private JMenuItem mnuColumns50;
    private JRadioButtonMenuItem mnuEssential;
    private JMenuItem mnuGetAA;
    private JMenuItem mnuGetDNA;
    private JMenuItem mnuGoToCodon;
    private JRadioButtonMenuItem mnuHydrophobic;
    private JRadioButtonMenuItem mnuHydroxilic;
    private JRadioButtonMenuItem mnuIP;
    private JRadioButtonMenuItem mnuMolWt;
    private JRadioButtonMenuItem mnuNonPolar;
    private JRadioButtonMenuItem mnuNone;
    private JRadioButtonMenuItem mnuPolar;
    private JRadioButtonMenuItem mnuPositive;
    private JPopupMenu.Separator mnuSepCodons;
    private JRadioButtonMenuItem mnuSolubility;
    private JCheckBoxMenuItem mnuSpaceCodons;
    private JRadioButtonMenuItem mnuSulfur;
    private JRadioButtonMenuItem mnuSurface;
    private JCheckBoxMenuItem mnuToggleAntisense;
    private JCheckBoxMenuItem mnuToggleFrame1;
    private JCheckBoxMenuItem mnuToggleFrame2;
    private JCheckBoxMenuItem mnuToggleFrame3;
    private JMenu mnuView;
    private JRadioButtonMenuItem mnuVolume;
    private GhostTextArea txtAA;

    public FrmAAToDNA(PLOTJ parent) {
        super((Window)parent);
        this.initComponents();
        this.editor.setShowFrame2(false);
        this.editor.setShowFrame3(false);
        this.editor.setShowAntisense(false);
        AminoAcids aas = this.editor.getCodonTable().getAminoAcids();
        for (int x = 0; x < 27; ++x) {
            AminoAcid aa = aas.get(x);
            if (aa == null) continue;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(aa.getName() + " (" + aa.getAbbr3() + ", " + aa.getAbbr1() + ")");
            item.addActionListener(new ColorAA(aa.getAbbr1()));
            this.groupMenu.add(item);
            this.mnuColorByResidue.add(item);
        }
        this.txtAA.setDocumentFilter(BioKeyFilter.ProteinFilter);
        this.setLocationRelativeTo(parent);
        this.setIconImage(Globals.icon.getImage());
        this.updateFrameChecks();
    }

    private void updateFrameChecks() {
        this.mnuSpaceCodons.setSelected(this.editor.isSpaceCodons());
        this.mnuToggleFrame1.setSelected(this.editor.isShowFrame1());
        this.mnuToggleFrame2.setSelected(this.editor.isShowFrame2());
        this.mnuToggleFrame3.setSelected(this.editor.isShowFrame3());
        this.mnuToggleAntisense.setSelected(this.editor.isShowAntisense());
    }

    @Override
    public void doOK() {
        this.editor.getCodonTable().setOrganism(this.cmbOrg.getSelectedIndex());
        this.editor.setAASequence(this.txtAA.getText());
        this.editor.requestFocus();
    }

    @Override
    public void doCancel() {
        this.dispose();
    }

    private void initComponents() {
        this.jMenuItem2 = new JMenuItem();
        this.groupMenu = new ButtonGroup();
        this.cmbOrg = new JComboBox();
        this.jLabel1 = new JLabel();
        this.cmdOK = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.txtAA = new GhostTextArea();
        this.editor = new ProteinEditorPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.mnuClose = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.mnuGetDNA = new JMenuItem();
        this.mnuGetAA = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.mnuGoToCodon = new JMenuItem();
        this.mnuView = new JMenu();
        this.mnuToggleFrame1 = new JCheckBoxMenuItem();
        this.mnuToggleFrame2 = new JCheckBoxMenuItem();
        this.mnuToggleFrame3 = new JCheckBoxMenuItem();
        this.mnuToggleAntisense = new JCheckBoxMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenu3 = new JMenu();
        this.mnuNone = new JRadioButtonMenuItem();
        this.mnuColorByProperty = new JMenu();
        this.mnuAcidic = new JRadioButtonMenuItem();
        this.mnuAmidic = new JRadioButtonMenuItem();
        this.mnuBasic = new JRadioButtonMenuItem();
        this.mnuPositive = new JRadioButtonMenuItem();
        this.mnuEssential = new JRadioButtonMenuItem();
        this.mnuHydrophobic = new JRadioButtonMenuItem();
        this.mnuHydroxilic = new JRadioButtonMenuItem();
        this.mnuIP = new JRadioButtonMenuItem();
        this.mnuMolWt = new JRadioButtonMenuItem();
        this.mnuNonPolar = new JRadioButtonMenuItem();
        this.mnuPolar = new JRadioButtonMenuItem();
        this.mnuSolubility = new JRadioButtonMenuItem();
        this.mnuSulfur = new JRadioButtonMenuItem();
        this.mnuSurface = new JRadioButtonMenuItem();
        this.mnuVolume = new JRadioButtonMenuItem();
        this.mnuColorByResidue = new JMenu();
        this.jMenu4 = new JMenu();
        this.mnuSpaceCodons = new JCheckBoxMenuItem();
        this.mnuSepCodons = new JPopupMenu.Separator();
        this.mnuColumns20 = new JMenuItem();
        this.mnuColumns25 = new JMenuItem();
        this.mnuColumns30 = new JMenuItem();
        this.mnuColumns35 = new JMenuItem();
        this.mnuColumns40 = new JMenuItem();
        this.mnuColumns45 = new JMenuItem();
        this.mnuColumns50 = new JMenuItem();
        this.jMenuItem2.setText("jMenuItem2");
        this.setDefaultCloseOperation(2);
        this.setTitle("pLOT Protein to DNA Tool");
        this.cmbOrg.setModel(new DefaultComboBoxModel<String>(new String[]{"Human", "Rat", "Mouse", "E.coli", "S.cerevisiae", "Pan Troglodytes Troglodytes", "Arabidopsis thaliana", "Vertebrate Mitochondria", "Invertebrate Mitochondria", "Eubacterial", "Standard", "Yeast", "Caenorhabditis elegans", "Drosophila melanogaster", "Insect", "Pig", "Streptomyces", "Pichia pastoris", "Chinese Hamster", "Nicotiana tabacum", "Zea mays"}));
        this.cmbOrg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.cmbOrgActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Organism:");
        this.cmdOK.setText("Convert");
        this.cmdOK.setColorHot(new Color(204, 204, 255));
        this.cmdOK.setColorNormal(new Color(240, 240, 240));
        this.cmdOK.setColorPressed(new Color(204, 204, 255));
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.cmdOKActionPerformed(evt);
            }
        });
        this.cmdCancel.setText("Close");
        this.cmdCancel.setColorHot(new Color(204, 204, 255));
        this.cmdCancel.setColorNormal(new Color(240, 240, 240));
        this.cmdCancel.setColorPressed(new Color(204, 204, 255));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(150);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.4);
        this.txtAA.setBlankText("Enter amino acid sequence here");
        this.txtAA.setBorder(null);
        this.txtAA.setColumns(20);
        this.txtAA.setLineWrap(true);
        this.txtAA.setRows(5);
        this.txtAA.setFont(new Font("Segoe UI", 0, 14));
        this.jScrollPane2.setViewportView(this.txtAA);
        this.jSplitPane1.setTopComponent(this.jScrollPane2);
        this.editor.setBackground(new Color(204, 204, 255));
        this.editor.setBorder(null);
        this.editor.setFont(new Font("Monospaced", 0, 18));
        this.jSplitPane1.setRightComponent(this.editor);
        this.jMenu1.setText("File");
        this.mnuClose.setText("Close");
        this.jMenu1.add(this.mnuClose);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.mnuGetDNA.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.mnuGetDNA.setIcon(new ImageIcon(this.getClass().getResource("/images24/DNA.png")));
        this.mnuGetDNA.setText("Copy DNA Sequence");
        this.mnuGetDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuGetDNAActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuGetDNA);
        this.mnuGetAA.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuGetAA.setText("Copy protein Sequence");
        this.mnuGetAA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuGetAAActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuGetAA);
        this.jMenu2.add(this.jSeparator2);
        this.mnuGoToCodon.setText("Go to codon #");
        this.mnuGoToCodon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuGoToCodonActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuGoToCodon);
        this.jMenuBar1.add(this.jMenu2);
        this.mnuView.setText("View");
        this.mnuToggleFrame1.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuToggleFrame1.setSelected(true);
        this.mnuToggleFrame1.setText("Show Frame 1 Translation");
        this.mnuToggleFrame1.setIcon(new ImageIcon(this.getClass().getResource("/images24/T1.png")));
        this.mnuToggleFrame1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuToggleFrame1ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame1);
        this.mnuToggleFrame2.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.mnuToggleFrame2.setSelected(true);
        this.mnuToggleFrame2.setText("Show Frame 2 Translation");
        this.mnuToggleFrame2.setIcon(new ImageIcon(this.getClass().getResource("/images24/T2.png")));
        this.mnuToggleFrame2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuToggleFrame2ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame2);
        this.mnuToggleFrame3.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.mnuToggleFrame3.setSelected(true);
        this.mnuToggleFrame3.setText("Show Frame 3 Translation");
        this.mnuToggleFrame3.setIcon(new ImageIcon(this.getClass().getResource("/images24/T3.png")));
        this.mnuToggleFrame3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuToggleFrame3ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame3);
        this.mnuToggleAntisense.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.mnuToggleAntisense.setSelected(true);
        this.mnuToggleAntisense.setText("Show Antisense");
        this.mnuToggleAntisense.setIcon(new ImageIcon(this.getClass().getResource("/images24/AS.png")));
        this.mnuToggleAntisense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuToggleAntisenseActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleAntisense);
        this.mnuView.add(this.jSeparator1);
        this.jMenu3.setText("Set Codon Colors");
        this.groupMenu.add(this.mnuNone);
        this.mnuNone.setSelected(true);
        this.mnuNone.setText("No Color");
        this.mnuNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuNoneActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.mnuNone);
        this.mnuColorByProperty.setText("Color by Property");
        this.groupMenu.add(this.mnuAcidic);
        this.mnuAcidic.setText("Acidic");
        this.mnuAcidic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuAcidicActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuAcidic);
        this.groupMenu.add(this.mnuAmidic);
        this.mnuAmidic.setText("Amidic");
        this.mnuAmidic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuAmidicActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuAmidic);
        this.groupMenu.add(this.mnuBasic);
        this.mnuBasic.setText("Basic");
        this.mnuBasic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuBasicActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuBasic);
        this.groupMenu.add(this.mnuPositive);
        this.mnuPositive.setText("Charge");
        this.mnuPositive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuPositiveActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuPositive);
        this.groupMenu.add(this.mnuEssential);
        this.mnuEssential.setText("Essential");
        this.mnuEssential.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuEssentialActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuEssential);
        this.groupMenu.add(this.mnuHydrophobic);
        this.mnuHydrophobic.setText("Hydrophobic");
        this.mnuHydrophobic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuHydrophobicActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuHydrophobic);
        this.groupMenu.add(this.mnuHydroxilic);
        this.mnuHydroxilic.setText("Hydroxilic");
        this.mnuHydroxilic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuHydroxilicActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuHydroxilic);
        this.groupMenu.add(this.mnuIP);
        this.mnuIP.setText("Isoelectric Point");
        this.mnuIP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuIPActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuIP);
        this.groupMenu.add(this.mnuMolWt);
        this.mnuMolWt.setText("Mol. wt");
        this.mnuMolWt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuMolWtActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuMolWt);
        this.groupMenu.add(this.mnuNonPolar);
        this.mnuNonPolar.setText("Polarity");
        this.mnuNonPolar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuNonPolarActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuNonPolar);
        this.groupMenu.add(this.mnuPolar);
        this.mnuPolar.setText("Polar Uncharged");
        this.mnuPolar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuPolarActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuPolar);
        this.groupMenu.add(this.mnuSolubility);
        this.mnuSolubility.setText("Solubility");
        this.mnuSolubility.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuSolubilityActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuSolubility);
        this.groupMenu.add(this.mnuSulfur);
        this.mnuSulfur.setText("Sulfur-containing");
        this.mnuSulfur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuSulfurActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuSulfur);
        this.groupMenu.add(this.mnuSurface);
        this.mnuSurface.setText("Surface area");
        this.mnuSurface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuSurfaceActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuSurface);
        this.groupMenu.add(this.mnuVolume);
        this.mnuVolume.setText("Volume");
        this.mnuVolume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuVolumeActionPerformed(evt);
            }
        });
        this.mnuColorByProperty.add(this.mnuVolume);
        this.jMenu3.add(this.mnuColorByProperty);
        this.mnuColorByResidue.setText("Color by Residue");
        this.jMenu3.add(this.mnuColorByResidue);
        this.mnuView.add(this.jMenu3);
        this.jMenuBar1.add(this.mnuView);
        this.jMenu4.setText("Layout");
        this.mnuSpaceCodons.setSelected(true);
        this.mnuSpaceCodons.setText("Space Codons");
        this.mnuSpaceCodons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuSpaceCodonsActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuSpaceCodons);
        this.jMenu4.add(this.mnuSepCodons);
        this.mnuColumns20.setText("Set Columns to 20");
        this.mnuColumns20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuColumns20ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuColumns20);
        this.mnuColumns25.setText("Set Columns to 25");
        this.mnuColumns25.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuColumns25ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuColumns25);
        this.mnuColumns30.setText("Set Columns to 30");
        this.mnuColumns30.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuColumns30ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuColumns30);
        this.mnuColumns35.setText("Set Columns to 35");
        this.mnuColumns35.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuColumns35ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuColumns35);
        this.mnuColumns40.setText("Set Columns to 40");
        this.mnuColumns40.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuColumns40ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuColumns40);
        this.mnuColumns45.setText("Set Columns to 45");
        this.mnuColumns45.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuColumns45ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuColumns45);
        this.mnuColumns50.setText("Set Columns to 50");
        this.mnuColumns50.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAAToDNA.this.mnuColumns50ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuColumns50);
        this.jMenuBar1.add(this.jMenu4);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSplitPane1).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmbOrg, -2, 357, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdOK, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdCancel, -2, 91, -2).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbOrg, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.cmdOK, -2, 28, -2).addComponent(this.cmdCancel, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 408, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmbOrgActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void mnuGetDNAActionPerformed(ActionEvent evt) {
        ClipBoard.setText(this.editor.getDNASequence());
    }

    private void mnuAcidicActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Acidic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuBasicActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Basic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuNonPolarActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.R_group_polarity, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuNoneActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.None, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuMolWtActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Mwt, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuIPActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.PI, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuVolumeActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Volume, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuSurfaceActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Surface, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuSolubilityActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Solubility, Color.red, Color.GREEN);
        this.editor.reDraw();
    }

    private void mnuSulfurActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Sulfur_Containing, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuPositiveActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.R_group_charge, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuPolarActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Polar_uncharged, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuAmidicActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Amidic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuHydrophobicActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Hydrophobic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuHydroxilicActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Hydroxylic, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuEssentialActionPerformed(ActionEvent evt) {
        this.editor.getCodonTable().getAminoAcids().colorBy(AminoAcid.Properties.Essential, Color.GREEN, Color.RED);
        this.editor.reDraw();
    }

    private void mnuGoToCodonActionPerformed(ActionEvent evt) {
        String input;
        int count = this.editor.getCodonCount() - 1;
        if (count > 0 && (input = JOptionPanes.showInputDialog(this, "Codon to select (1 - " + count + ")", "Go to a specified codon", 3)) != null && input.length() > 0) {
            this.editor.setSelected(StringTools.filterStringToInt(input, -1) - 1);
        }
    }

    private void mnuToggleFrame1ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame1(!this.editor.isShowFrame1());
        this.updateFrameChecks();
    }

    private void mnuToggleFrame2ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame2(!this.editor.isShowFrame2());
        this.updateFrameChecks();
    }

    private void mnuToggleFrame3ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame3(!this.editor.isShowFrame3());
        this.updateFrameChecks();
    }

    private void mnuSpaceCodonsActionPerformed(ActionEvent evt) {
        this.editor.setSpaceCodons(this.mnuSpaceCodons.isSelected());
        this.updateFrameChecks();
    }

    private void mnuColumns20ActionPerformed(ActionEvent evt) {
        this.editor.setColumnCount(20);
    }

    private void mnuColumns25ActionPerformed(ActionEvent evt) {
        this.editor.setColumnCount(25);
    }

    private void mnuColumns30ActionPerformed(ActionEvent evt) {
        this.editor.setColumnCount(30);
    }

    private void mnuColumns35ActionPerformed(ActionEvent evt) {
        this.editor.setColumnCount(35);
    }

    private void mnuColumns40ActionPerformed(ActionEvent evt) {
        this.editor.setColumnCount(40);
    }

    private void mnuColumns45ActionPerformed(ActionEvent evt) {
        this.editor.setColumnCount(45);
    }

    private void mnuColumns50ActionPerformed(ActionEvent evt) {
        this.editor.setColumnCount(50);
    }

    private void mnuGetAAActionPerformed(ActionEvent evt) {
        ClipBoard.setText(this.editor.getAASequence());
    }

    private void mnuToggleAntisenseActionPerformed(ActionEvent evt) {
        this.editor.setShowAntisense(this.mnuToggleAntisense.isSelected());
        this.updateFrameChecks();
    }

    class ColorAA
    implements ActionListener {
        char aa = '\u0000';

        public ColorAA(char aa) {
            this.aa = aa;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            FrmAAToDNA.this.editor.getCodonTable().getAminoAcids().colorBy(this.aa, Color.GREEN);
            FrmAAToDNA.this.editor.reDraw();
        }
    }
}

