/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BioDocumentFilters.BioAllowedKeyFilter;
import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import DocumentFilters.DocumentKeyFilter;
import GhostTextControls.GhostTextArea;
import GhostTextControls.GhostTextBox;
import JXTableEditorsAndRenderers.ColorCellEditor;
import JXTableEditorsAndRenderers.ColorCellRenderer;
import JXTableEditorsAndRenderers.ComboBoxCellEditor;
import JXTableEditorsAndRenderers.DefaultTableHeaderCellRenderer;
import JXTableEditorsAndRenderers.GhostTextAreaCellEditor;
import JXTableEditorsAndRenderers.GhostTextAreaCellRenderer;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.ROI;
import UndoRedo.ChangeEvent;
import UndoRedo.Undoable;
import UndoRedo.UndoableAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.JXTable;
import plot.Feature;
import plot.FeatureRenderer;
import plot.Globals;
import plot.GraphicsListRenderer;
import plot.GraphicsTypeCellRenderer;
import plot.IconCellRenderer;
import plot.IconListRenderer;
import plot.JOptionPanes;
import plot.MainExclusiveDlg;
import plot.PLOTJ;
import plot.ProjectDocument;
import plot.StaticArrayComboModel;
import plot.Undoables;

class FrmAnnotations
extends MainExclusiveDlg {
    private boolean featuresChanged = false;
    private static final int COL_NAME = 0;
    private static final int COL_GRAPHIC = 1;
    private static final int COL_START = 2;
    private static final int COL_STOP = 3;
    private static final int COL_GCOLOR = 4;
    private static final int COL_LCOLOR = 5;
    private static final int COL_ALPHA = 6;
    private static final int COL_WIDTH = 7;
    private static final int COL_OFFSET = 8;
    private static final int COL_ORIENT = 9;
    private static final int COL_SHOWLABEL = 10;
    private static final int COL_SHOWGRAPHIC = 11;
    private static final int COL_GBTYPE = 12;
    private static final int COL_NOTES = 13;
    private final FeatureTableModel tblFeaturesModel;
    private final ExtensibleArray<ROI> workingFeatures = new ExtensibleArray<ROI>(ROI.class);
    private GlossyButton cmdAddNew;
    private GlossyButton cmdBot;
    private GlossyButton cmdCancel;
    private GlossyButton cmdCancel2;
    private GlossyButton cmdDelete;
    private GlossyButton cmdDown;
    private GlossyButton cmdDuplicate;
    private GlossyButton cmdOK;
    private GlossyButton cmdSave2;
    private GlossyButton cmdTop;
    private GlossyButton cmdUp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    JTabbedPane tabPanel;
    private JXTable tblFeatures;
    private GhostTextBox txtAcc;
    private GhostTextBox txtName;
    private GhostTextArea txtNotes;
    private GhostTextBox txtOrg;
    private GhostTextBox txtSrc;

    public FrmAnnotations(PLOTJ parent) {
        super((Window)parent);
        this.initComponents();
        Color color = UIManager.getColor("TextArea.background");
        if (color != null) {
            this.txtNotes.setBackcolor(color);
            this.txtNotes.setBackground(color);
        }
        if ((color = UIManager.getColor("TextArea.foreground")) != null) {
            this.txtNotes.setForeground(color);
        }
        if ((color = UIManager.getColor("Table.foreground")) != null) {
            this.tblFeatures.setForeground(color);
        }
        if ((color = UIManager.getColor("Table.background")) != null) {
            this.tblFeatures.setBackground(color);
        }
        if ((color = UIManager.getColor("Table.selectionforeground")) != null) {
            this.tblFeatures.setSelectionForeground(color);
        }
        if ((color = UIManager.getColor("Table.selectionbackground")) != null) {
            this.tblFeatures.setSelectionBackground(color);
        }
        ProjectDocument project = this.getProject();
        this.txtName.setText(project.getName());
        this.txtSrc.setText(project.getSource());
        this.txtOrg.setText(project.getOrganism());
        this.txtAcc.setText(project.getAccession());
        this.txtNotes.setText(project.getNotes());
        this.tblFeaturesModel = new FeatureTableModel();
        this.tblFeatures.setModel(this.tblFeaturesModel);
        this.tblFeatures.setAutoCreateRowSorter(false);
        this.tblFeatures.setRowSorter(null);
        this.setLocationRelativeTo(parent);
        this.setIconImage(Globals.icon.getImage());
        TextCellEditor textEditor = new TextCellEditor();
        NumberCellEditor numEditor = new NumberCellEditor();
        numEditor.numberBox.setHorizontalAlignment(0);
        ColorCellEditor gColEditor = new ColorCellEditor();
        gColEditor.setTitle("Select new graphic color.");
        ColorCellEditor lColEditor = new ColorCellEditor();
        lColEditor.setTitle("Select new label text color.");
        ColorCellRenderer colorRenderer = new ColorCellRenderer();
        ComboNumberCellEditor alphaEditor = new ComboNumberCellEditor(0, 255);
        DefaultTableCellRenderer centeredRenderer = new DefaultTableCellRenderer();
        centeredRenderer.setHorizontalAlignment(0);
        GhostTextAreaCellEditor noteEditor = new GhostTextAreaCellEditor();
        noteEditor.getTextArea().setBlankText("(Optional) Feature Notes");
        GhostTextAreaCellRenderer noteRenderer = new GhostTextAreaCellRenderer();
        noteRenderer.getTextArea().setBlankText("(Optional) Feature Notes");
        StaticArrayComboModel<FeatureRenderer> modelGraphicTypes = new StaticArrayComboModel<FeatureRenderer>(FeatureRenderer.drawFeatures);
        GraphicsListRenderer rendererGraphicTypes = new GraphicsListRenderer();
        JComboBox<Object> fCombo = new JComboBox<Object>();
        fCombo.setModel(modelGraphicTypes);
        fCombo.setRenderer(rendererGraphicTypes);
        fCombo.setSelectedIndex(0);
        ComboBoxCellEditor graphicEditor = new ComboBoxCellEditor(fCombo);
        GraphicsTypeCellRenderer graphicRenderer = new GraphicsTypeCellRenderer();
        StaticArrayComboModel<Integer> modelOrient = new StaticArrayComboModel<Integer>(Globals.orientItemValues);
        IconListRenderer rendererOrient = new IconListRenderer(null, Globals.orientIcons);
        JComboBox<Object> cmbOrient = new JComboBox<Object>();
        cmbOrient.setModel(modelOrient);
        cmbOrient.setRenderer(rendererOrient);
        cmbOrient.setSelectedIndex(0);
        rendererOrient.setSelectionBackColor(this.tblFeatures.getSelectionBackground());
        ComboBoxCellEditor orientEditor = new ComboBoxCellEditor(cmbOrient);
        IconCellRenderer orientRenderer = new IconCellRenderer(null, Globals.orientIcons);
        JComboBox cmbGBType = new JComboBox();
        Globals.populateGenbankTypes(cmbGBType);
        ComboBoxCellEditor gbEditor = new ComboBoxCellEditor(cmbGBType);
        DefaultTableColumnModel model = (DefaultTableColumnModel)this.tblFeatures.getColumnModel();
        DefaultTableHeaderCellRenderer lcRenderer = new DefaultTableHeaderCellRenderer();
        lcRenderer.setHorizontalAlignment(2);
        DefaultTableHeaderCellRenderer hcRenderer = new DefaultTableHeaderCellRenderer();
        hcRenderer.setHorizontalAlignment(0);
        model.getColumn(0).setHeaderRenderer(lcRenderer);
        model.getColumn(1).setHeaderRenderer(lcRenderer);
        model.getColumn(13).setHeaderRenderer(lcRenderer);
        model.getColumn(3).setHeaderRenderer(hcRenderer);
        model.getColumn(2).setHeaderRenderer(hcRenderer);
        model.getColumn(6).setHeaderRenderer(hcRenderer);
        model.getColumn(7).setHeaderRenderer(hcRenderer);
        model.getColumn(8).setHeaderRenderer(hcRenderer);
        model.getColumn(9).setHeaderRenderer(hcRenderer);
        model.getColumn(12).setHeaderRenderer(hcRenderer);
        model.getColumn(4).setHeaderRenderer(hcRenderer);
        model.getColumn(5).setHeaderRenderer(hcRenderer);
        model.getColumn(10).setHeaderRenderer(hcRenderer);
        model.getColumn(11).setHeaderRenderer(hcRenderer);
        model.getColumn(0).setCellEditor(textEditor);
        model.getColumn(1).setCellEditor(graphicEditor);
        model.getColumn(1).setCellRenderer(graphicRenderer);
        model.getColumn(2).setCellEditor(numEditor);
        model.getColumn(2).setCellRenderer(centeredRenderer);
        model.getColumn(3).setCellEditor(numEditor);
        model.getColumn(3).setCellRenderer(centeredRenderer);
        model.getColumn(6).setCellEditor(alphaEditor);
        model.getColumn(6).setCellRenderer(centeredRenderer);
        model.getColumn(7).setCellRenderer(centeredRenderer);
        model.getColumn(8).setCellRenderer(centeredRenderer);
        model.getColumn(9).setCellEditor(orientEditor);
        model.getColumn(9).setCellRenderer(orientRenderer);
        model.getColumn(12).setCellEditor(gbEditor);
        model.getColumn(12).setCellRenderer(centeredRenderer);
        model.getColumn(4).setCellEditor(gColEditor);
        model.getColumn(5).setCellEditor(lColEditor);
        model.getColumn(4).setCellRenderer(colorRenderer);
        model.getColumn(5).setCellRenderer(colorRenderer);
        model.getColumn(13).setCellEditor(noteEditor);
        model.getColumn(13).setCellRenderer(noteRenderer);
        int count = project.getFeatureCount();
        for (int x = 0; x < count; ++x) {
            this.addFeature(project.getFeature(x));
        }
        this.setCtrlS_DoOK();
    }

    @Override
    public void doCancel() {
        if (this.featuresChanged) {
            int retVal = JOptionPanes.showConfirmDialog(this, "There are unsaved annotation changes.  Save now?", "Save changes?", 3, 1);
            switch (retVal) {
                case 0: {
                    this.save();
                    return;
                }
                case 2: {
                    return;
                }
            }
        }
        this.workingFeatures.clear();
        this.dispose();
    }

    @Override
    public void doOK() {
        this.save();
    }

    public void save() {
        String oldVal5;
        String newVal5;
        String oldVal4;
        String newVal4;
        String oldVal3;
        String newVal3;
        String oldVal2;
        String newVal2;
        Undoable editChild;
        String oldVal;
        final ProjectDocument project = this.getProject();
        ExtensibleArray<ChangeEvent> events = new ExtensibleArray<ChangeEvent>(ChangeEvent.class);
        final boolean isChanged = project.isChanged();
        Undoable main = new Undoable(){

            @Override
            public boolean undo() {
                project.setChanged(isChanged);
                return true;
            }

            @Override
            public boolean redo() {
                project.setChanged(true);
                return true;
            }
        };
        final String newVal = this.txtName.getText();
        if (!newVal.equals(oldVal = project.getName())) {
            editChild = new Undoable(){

                @Override
                public boolean undo() {
                    project.setName(oldVal);
                    return true;
                }

                @Override
                public boolean redo() {
                    project.setName(newVal);
                    return true;
                }
            };
            main.addEdit(editChild);
            events.add(new ChangeEvent(0, oldVal, newVal));
        }
        if (!(newVal2 = this.txtSrc.getText()).equals(oldVal2 = project.getSource())) {
            editChild = new Undoable(){

                @Override
                public boolean undo() {
                    project.setSource(oldVal2);
                    return true;
                }

                @Override
                public boolean redo() {
                    project.setSource(newVal2);
                    return true;
                }
            };
            main.addEdit(editChild);
            events.add(new ChangeEvent(2, oldVal2, newVal2));
        }
        if (!(newVal3 = this.txtOrg.getText()).equals(oldVal3 = project.getOrganism())) {
            editChild = new Undoable(){

                @Override
                public boolean undo() {
                    project.setOrganism(oldVal3);
                    return true;
                }

                @Override
                public boolean redo() {
                    project.setOrganism(newVal3);
                    return true;
                }
            };
            main.addEdit(editChild);
            events.add(new ChangeEvent(1, oldVal3, newVal3));
        }
        if (!(newVal4 = this.txtAcc.getText()).equals(oldVal4 = project.getAccession())) {
            editChild = new Undoable(){

                @Override
                public boolean undo() {
                    project.setAccession(oldVal3);
                    return true;
                }

                @Override
                public boolean redo() {
                    project.setAccession(newVal3);
                    return true;
                }
            };
            main.addEdit(editChild);
            events.add(new ChangeEvent(3, oldVal4, newVal4));
        }
        if (!(newVal5 = this.txtNotes.getText()).equals(oldVal5 = project.getNotes())) {
            editChild = new Undoable(){

                @Override
                public boolean undo() {
                    project.setNotes(oldVal5);
                    return true;
                }

                @Override
                public boolean redo() {
                    project.setNotes(newVal5);
                    return true;
                }
            };
            main.addEdit(editChild);
        }
        if (this.featuresChanged) {
            editChild = Undoables.createUndoable_Features(project, this.workingFeatures);
            editChild.setAfterRedoAction(new UndoableAction(){

                @Override
                public boolean run() {
                    project.setSelectedItem(null);
                    return true;
                }
            });
            main.addEdit(editChild);
        }
        if (main.childCount() > 0) {
            events.add(new ChangeEvent(106));
            events.add(new ChangeEvent(10));
            final ChangeEvent[] eventsArray = events.toArray();
            if (project.isListenerActive()) {
                UndoableAction beforeAction = new UndoableAction(){

                    @Override
                    public boolean run() {
                        project.setListenersEnabled(false);
                        return true;
                    }
                };
                UndoableAction afterAction = new UndoableAction(){

                    @Override
                    public boolean run() {
                        project.setListenersEnabled(true);
                        project.fireEvents(eventsArray);
                        return true;
                    }
                };
                main.setBeforeRedoAction(beforeAction);
                main.setAfterRedoAction(afterAction);
                main.setBeforeUndoAction(beforeAction);
                main.setAfterUndoAction(afterAction);
            }
            project.runEdit(main);
            ((PLOTJ)this.getParent()).resetMap();
        }
        this.dispose();
    }

    public final void addFeature(Feature f) {
        this.tblFeaturesModel.add(f.clone());
    }

    private void initComponents() {
        this.tabPanel = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblFeatures = new JXTable();
        this.cmdOK = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.cmdDuplicate = new GlossyButton();
        this.cmdDelete = new GlossyButton();
        this.cmdAddNew = new GlossyButton();
        this.cmdTop = new GlossyButton();
        this.cmdUp = new GlossyButton();
        this.cmdDown = new GlossyButton();
        this.cmdBot = new GlossyButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.txtName = new GhostTextBox();
        this.txtSrc = new GhostTextBox();
        this.txtOrg = new GhostTextBox();
        this.txtAcc = new GhostTextBox();
        this.cmdSave2 = new GlossyButton();
        this.cmdCancel2 = new GlossyButton();
        this.jScrollPane2 = new JScrollPane();
        this.txtNotes = new GhostTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Project Properties");
        this.tblFeatures.setAutoCreateRowSorter(false);
        this.tblFeatures.setBackground(new Color(255, 255, 255));
        this.tblFeatures.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tblFeatures.setColumnSelectionAllowed(true);
        this.tblFeatures.setDoubleBuffered(true);
        this.tblFeatures.setHorizontalScrollEnabled(true);
        this.tblFeatures.setRowHeight(24);
        this.tblFeatures.setShowGrid(true);
        this.tblFeatures.setSortable(false);
        this.tblFeatures.setSortsOnUpdates(false);
        this.tblFeatures.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblFeatures);
        this.tblFeatures.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.cmdOK.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save2.png")));
        this.cmdOK.setText("Save");
        this.cmdOK.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdOK.setShiftOnPress(true);
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdOKActionPerformed(evt);
            }
        });
        this.cmdCancel.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel.png")));
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdCancel.setShiftOnPress(true);
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdCancelActionPerformed(evt);
            }
        });
        this.cmdDuplicate.setIcon(new ImageIcon(this.getClass().getResource("/images24/Duplicate.png")));
        this.cmdDuplicate.setText("Duplicate");
        this.cmdDuplicate.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdDuplicate.setShiftOnPress(true);
        this.cmdDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdDuplicateActionPerformed(evt);
            }
        });
        this.cmdDelete.setIcon(new ImageIcon(this.getClass().getResource("/images24/X.png")));
        this.cmdDelete.setText("Delete");
        this.cmdDelete.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdDelete.setShiftOnPress(true);
        this.cmdDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdDeleteActionPerformed(evt);
            }
        });
        this.cmdAddNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.cmdAddNew.setText("Add New");
        this.cmdAddNew.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdAddNew.setShiftOnPress(true);
        this.cmdAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdAddNewActionPerformed(evt);
            }
        });
        this.cmdTop.setIcon(new ImageIcon(this.getClass().getResource("/images24/MoveFirst_4.png")));
        this.cmdTop.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdTop.setColorHot(new Color(240, 240, 240));
        this.cmdTop.setColorNormal(new Color(240, 240, 240));
        this.cmdTop.setColorPressed(new Color(240, 240, 240));
        this.cmdTop.setShiftOnPress(true);
        this.cmdTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdTopActionPerformed(evt);
            }
        });
        this.cmdUp.setIcon(new ImageIcon(this.getClass().getResource("/images24/MoveUp.png")));
        this.cmdUp.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdUp.setColorHot(new Color(240, 240, 240));
        this.cmdUp.setColorNormal(new Color(240, 240, 240));
        this.cmdUp.setColorPressed(new Color(240, 240, 240));
        this.cmdUp.setShiftOnPress(true);
        this.cmdUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdUpActionPerformed(evt);
            }
        });
        this.cmdDown.setIcon(new ImageIcon(this.getClass().getResource("/images24/MoveDown3.png")));
        this.cmdDown.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdDown.setColorHot(new Color(240, 240, 240));
        this.cmdDown.setColorNormal(new Color(240, 240, 240));
        this.cmdDown.setColorPressed(new Color(240, 240, 240));
        this.cmdDown.setShiftOnPress(true);
        this.cmdDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdDownActionPerformed(evt);
            }
        });
        this.cmdBot.setIcon(new ImageIcon(this.getClass().getResource("/images24/MoveLast_4.png")));
        this.cmdBot.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdBot.setColorHot(new Color(240, 240, 240));
        this.cmdBot.setColorNormal(new Color(240, 240, 240));
        this.cmdBot.setColorPressed(new Color(240, 240, 240));
        this.cmdBot.setShiftOnPress(true);
        this.cmdBot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdBotActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 571, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdTop, -2, 25, -2).addComponent(this.cmdUp, -2, 25, -2).addComponent(this.cmdDown, -2, 25, -2).addComponent(this.cmdBot, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdCancel, -2, 93, -2).addComponent(this.cmdOK, -2, 93, -2).addComponent(this.cmdDelete, -2, 93, -2).addComponent(this.cmdDuplicate, -2, 93, -2).addComponent(this.cmdAddNew, -2, 93, -2)).addGap(6, 6, 6)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 403, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdAddNew, -2, 56, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cmdTop, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdUp, -2, 21, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdDuplicate, -2, 56, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cmdDown, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdBot, -2, 21, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdDelete, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdOK, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdCancel, -2, 59, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.tabPanel.addTab("Feature Annotations", this.jPanel1);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Sequence Name");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(" Source");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Organism");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Accession #");
        this.txtName.setBlankText("Sequence Name");
        this.txtSrc.setBlankText("Source");
        this.txtOrg.setBlankText("Organism");
        this.txtAcc.setBlankText("Accession #");
        this.cmdSave2.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save2.png")));
        this.cmdSave2.setText("Save");
        this.cmdSave2.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdSave2.setCaptionAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdSave2.setColorHot(new Color(153, 153, 255));
        this.cmdSave2.setColorNormal(new Color(153, 153, 255));
        this.cmdSave2.setColorPressed(new Color(153, 153, 255));
        this.cmdSave2.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdSave2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdSave2ActionPerformed(evt);
            }
        });
        this.cmdCancel2.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel.png")));
        this.cmdCancel2.setText("Cancel");
        this.cmdCancel2.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdCancel2.setCaptionAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdCancel2.setColorHot(new Color(153, 153, 255));
        this.cmdCancel2.setColorNormal(new Color(153, 153, 255));
        this.cmdCancel2.setColorPressed(new Color(153, 153, 255));
        this.cmdCancel2.setHorizontalAlignment(2);
        this.cmdCancel2.setHorizontalTextPosition(4);
        this.cmdCancel2.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdCancel2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAnnotations.this.cmdCancel2ActionPerformed(evt);
            }
        });
        this.jScrollPane2.setBackground(new Color(255, 255, 255));
        this.txtNotes.setBackground(new Color(255, 255, 255));
        this.txtNotes.setColumns(20);
        this.txtNotes.setRows(5);
        this.txtNotes.setBlankText("(Optional) Project notes.");
        this.jScrollPane2.setViewportView(this.txtNotes);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(14, 14, 14).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2, -2, 60, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.txtSrc, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtOrg, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtAcc, -2, 78, -2)).addComponent(this.txtName, -2, 429, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdCancel2, -1, -1, Short.MAX_VALUE).addComponent(this.cmdSave2, -1, -1, Short.MAX_VALUE)).addContainerGap(62, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(14, 14, 14).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtName, -2, -1, -2).addComponent(this.cmdSave2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.txtSrc, -2, -1, -2).addComponent(this.txtOrg, -2, -1, -2).addComponent(this.txtAcc, -2, -1, -2)).addComponent(this.cmdCancel2, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jScrollPane2, -1, 315, Short.MAX_VALUE).addContainerGap()));
        this.tabPanel.addTab("Sequence Details", this.jPanel2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabPanel));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabPanel));
        this.pack();
    }

    private void cmdAddNewActionPerformed(ActionEvent evt) {
        Feature f = new Feature();
        f.setName("New Feature");
        f.setGBType("misc_feature");
        f.setStart(1);
        f.setStop(1);
        this.tblFeaturesModel.add(f, true);
        this.featuresChanged = true;
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmdCancel2ActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmdSave2ActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void cmdDeleteActionPerformed(ActionEvent evt) {
        int index = this.tblFeatures.getSelectedRow();
        if (index < 0 || index > this.workingFeatures.size() - 1) {
            return;
        }
        this.tblFeaturesModel.removeRow(index);
        this.featuresChanged = true;
        if (index == this.tblFeaturesModel.getRowCount()) {
            --index;
        }
        if (index > -1) {
            this.tblFeatures.changeSelection(index, 0, false, false);
        }
    }

    private void cmdDuplicateActionPerformed(ActionEvent evt) {
        int index = this.tblFeatures.getSelectedRow();
        if (index < 0 || index > this.workingFeatures.size() - 1) {
            return;
        }
        Feature f = (Feature)this.workingFeatures.get(index);
        if (f != null) {
            this.tblFeaturesModel.add(f.clone());
            this.featuresChanged = true;
            this.tblFeatures.changeSelection(this.tblFeaturesModel.getRowCount(), 0, false, false);
        }
    }

    private void cmdTopActionPerformed(ActionEvent evt) {
        int index = this.tblFeatures.getSelectedRow();
        if (index < 1 || index > this.workingFeatures.size() - 1) {
            return;
        }
        Feature f = (Feature)this.workingFeatures.get(index);
        if (f != null) {
            this.tblFeaturesModel.removeRow(index);
            this.tblFeaturesModel.addRow(f, 0);
            this.featuresChanged = true;
            this.tblFeatures.changeSelection(index, 0, false, false);
        }
    }

    private void cmdUpActionPerformed(ActionEvent evt) {
        int index = this.tblFeatures.getSelectedRow();
        if (index < 1 || index > this.workingFeatures.size() - 1) {
            return;
        }
        Feature f = (Feature)this.workingFeatures.get(index);
        if (f != null) {
            this.tblFeaturesModel.removeRow(index);
            this.tblFeaturesModel.addRow(f, index - 1);
            this.featuresChanged = true;
            this.tblFeatures.changeSelection(index - 1, 0, false, false);
        }
    }

    private void cmdDownActionPerformed(ActionEvent evt) {
        int index = this.tblFeatures.getSelectedRow();
        if (index < 0 || index >= this.workingFeatures.size() - 1) {
            return;
        }
        Feature f = (Feature)this.workingFeatures.get(index);
        if (f != null) {
            this.tblFeaturesModel.removeRow(index);
            this.tblFeaturesModel.addRow(f, index + 1);
            this.featuresChanged = true;
            this.tblFeatures.changeSelection(index + 1, 0, false, false);
        }
    }

    private void cmdBotActionPerformed(ActionEvent evt) {
        int index = this.tblFeatures.getSelectedRow();
        if (index < 0 || index >= this.workingFeatures.size() - 1) {
            return;
        }
        Feature f = (Feature)this.workingFeatures.get(index);
        if (f != null) {
            this.tblFeaturesModel.removeRow(index);
            this.tblFeaturesModel.addRow(f);
            this.featuresChanged = true;
            this.tblFeatures.changeSelection(index, 0, false, false);
        }
    }

    private class FeatureTableModel
    extends DefaultTableModel {
        Class[] types;

        public FeatureTableModel() {
            super(null, new String[]{"Feature Name", "Graphic Type", "Start", "Stop", "Graphic", "Label", "Graphic Alpha", "Width", "Offset", "Strand", "Label", "Graphic", "Genbank Type", "Notes"});
            this.types = new Class[]{String.class, Integer.class, Integer.class, Integer.class, Color.class, Color.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, String.class, String.class};
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        public void addRow(Feature feature) {
            int row = FrmAnnotations.this.workingFeatures.size();
            FrmAnnotations.this.workingFeatures.add(feature);
            this.fireTableRowsInserted(row, row);
        }

        public void addRow(Feature feature, int index) {
            if (index >= FrmAnnotations.this.workingFeatures.size()) {
                this.addRow(feature);
                return;
            }
            if (index > -1 && index <= FrmAnnotations.this.workingFeatures.size()) {
                FrmAnnotations.this.workingFeatures.insert(feature, index);
                this.fireTableRowsInserted(index, index);
            }
        }

        @Override
        public void removeRow(int row) {
            FrmAnnotations.this.workingFeatures.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            Feature f = (Feature)FrmAnnotations.this.workingFeatures.get(row);
            switch (col) {
                case 0: {
                    return f.getName();
                }
                case 1: {
                    return f.renderer;
                }
                case 2: {
                    return f.getStart();
                }
                case 3: {
                    return f.getStop();
                }
                case 4: {
                    return f.getBackColor();
                }
                case 5: {
                    return f.getTextColor();
                }
                case 6: {
                    return f.getAlpha();
                }
                case 7: {
                    return f.getWidth();
                }
                case 8: {
                    return f.getOffset();
                }
                case 9: {
                    return f.isAntisense() ? 1 : 0;
                }
                case 10: {
                    return f.showLabel();
                }
                case 11: {
                    return !f.isHidden();
                }
                case 12: {
                    return f.getGBType();
                }
                case 13: {
                    return f.getNote();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Feature f = (Feature)FrmAnnotations.this.workingFeatures.get(row);
            switch (column) {
                case 0: {
                    f.setName((String)value);
                    break;
                }
                case 1: {
                    f.renderer = (FeatureRenderer)value;
                    break;
                }
                case 2: {
                    f.setStart((Integer)value);
                    break;
                }
                case 3: {
                    f.setStop((Integer)value);
                    break;
                }
                case 4: {
                    f.setBackColor((Color)value);
                    break;
                }
                case 5: {
                    f.setTextColor((Color)value);
                    break;
                }
                case 6: {
                    f.setAlpha(Integer.parseInt((String)value));
                    break;
                }
                case 7: {
                    f.setWidth((Integer)value);
                    break;
                }
                case 8: {
                    f.setOffset((Integer)value);
                    break;
                }
                case 9: {
                    f.setAntisense((Integer)value == 1);
                    break;
                }
                case 10: {
                    f.setShowLabel((Boolean)value);
                    break;
                }
                case 11: {
                    f.setHidden((Boolean)value == false);
                    break;
                }
                case 12: {
                    f.setGBType((String)value);
                    break;
                }
                case 13: {
                    f.setNote((String)value);
                }
            }
            FrmAnnotations.this.featuresChanged = true;
            this.fireTableCellUpdated(row, column);
        }

        @Override
        public int getColumnCount() {
            return 14;
        }

        @Override
        public int getRowCount() {
            return FrmAnnotations.this.workingFeatures.size();
        }

        public void clear() {
            FrmAnnotations.this.workingFeatures.clear();
        }

        public void add(Feature f) {
            this.add(f, false);
        }

        public void add(Feature f, boolean scrollTo) {
            FrmAnnotations.this.workingFeatures.add(f);
            int row = FrmAnnotations.this.workingFeatures.size() - 1;
            this.fireTableRowsInserted(row, row);
            if (scrollTo) {
                FrmAnnotations.this.tblFeatures.setRowSelectionInterval(row, row);
                FrmAnnotations.this.tblFeatures.scrollRowToVisible(row);
            }
        }
    }

    private static class TextCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        static GhostTextBox textBox = new GhostTextBox();
        BioAllowedKeyFilter nameFilter = new BioAllowedKeyFilter("\\w\\-'");
        DefaultCellEditor nameTextBox = new DefaultCellEditor(textBox);

        @Override
        public Object getCellEditorValue() {
            return this.nameTextBox.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            switch (column) {
                case 0: {
                    textBox.setDocumentFilter(this.nameFilter);
                    break;
                }
                default: {
                    textBox.setDocumentFilter(null);
                }
            }
            return this.nameTextBox.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class NumberCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        GhostTextBox numberBox = new GhostTextBox();
        DefaultCellEditor numberTextBox = new DefaultCellEditor(this.numberBox);
        private int column = 0;

        public NumberCellEditor() {
            this.numberBox.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        }

        @Override
        public Object getCellEditorValue() {
            int val = this.numberBox.getText().length() == 0 ? 1 : Integer.parseInt(this.numberBox.getText());
            switch (this.column) {
                case 2: 
                case 3: {
                    ProjectDocument project = FrmAnnotations.this.getProject();
                    if (val > 0 && val <= project.length()) {
                        return val;
                    }
                    return this.column == 2 ? 1 : project.length();
                }
                case 6: {
                    return Math.max(0, Math.min(255, val));
                }
            }
            return this.numberTextBox.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.column = column;
            return this.numberTextBox.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static class ComboNumberCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox cmbBox = new JComboBox();
        DefaultCellEditor comboBox = new DefaultCellEditor(this.cmbBox);

        public ComboNumberCellEditor(int min, int max) {
            ++max;
            for (int x = min; x < max; ++x) {
                this.cmbBox.addItem(String.valueOf(x));
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int alpha = (Integer)value;
            if (alpha < 0 || alpha > 255) {
                alpha = 255;
            }
            this.cmbBox.setSelectedIndex(alpha);
            return this.comboBox.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

