/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BioDocumentFilters.BioAllowedKeyFilter;
import CustomLabels.ColorLabel;
import DocumentFilters.DocumentKeyFilter;
import GhostTextControls.GhostTextArea;
import GhostTextControls.GhostTextBox;
import MiscTools.StringTools;
import ProteinTools.CodonTable;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.ROI;
import Sequences.DNA;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import plot.Feature;
import plot.Globals;
import plot.JOptionPanes;
import plot.PLOTJ;
import plot.ProjectDocument;
import plot.TempFeatureDlg;

class FrmCodonToBp
extends TempFeatureDlg {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    boolean haveSeq;
    private JCheckBox chkSelFeat;
    private JButton cmdAddAnnotation;
    private JButton cmdCancel;
    private JButton cmdSave;
    private ButtonGroup grpInsertPosition;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private ColorLabel lblColorGraphic;
    private ColorLabel lblColorLabel;
    private JRadioButton opFirst;
    private JRadioButton opLast;
    private StatusLabel statusLabel;
    private JTabbedPane tabPane;
    private JToggleButton toggleLink;
    private GhostTextArea txtBatch;
    private GhostTextBox txtBp;
    private GhostTextBox txtCodon;

    public FrmCodonToBp(PLOTJ parent) {
        super(parent);
        this.initComponents();
        boolean hasF = this.getProject().hasSelectedItemType(0) && !this.getProject().getSelectedItem().isAntisense();
        this.chkSelFeat.setVisible(hasF && Globals.debugMode);
        this.chkSelFeat.setEnabled(hasF);
        MouseListener menuMouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                JComponent c = (JComponent)arg0.getComponent();
                ToolTipManager.sharedInstance().setEnabled(false);
                if (!(c instanceof JSeparator)) {
                    FrmCodonToBp.this.statusLabel.setText(c.getToolTipText(), 3000);
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                FrmCodonToBp.this.statusLabel.setText("");
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        };
        this.cmdSave.addMouseListener(menuMouseListener);
        this.cmdCancel.addMouseListener(menuMouseListener);
        this.cmdAddAnnotation.addMouseListener(menuMouseListener);
        this.opFirst.addMouseListener(menuMouseListener);
        this.opLast.addMouseListener(menuMouseListener);
        this.lblColorLabel.addMouseListener(menuMouseListener);
        this.lblColorGraphic.addMouseListener(menuMouseListener);
        this.txtBp.addMouseListener(menuMouseListener);
        this.txtCodon.addMouseListener(menuMouseListener);
        ProjectDocument project = this.getProject();
        this.txtCodon.setSelectionOnFocus(true);
        this.haveSeq = project.length() > 0;
        this.cmdAddAnnotation.setEnabled(this.haveSeq);
        this.cmdSave.setEnabled(this.haveSeq);
        this.txtCodon.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        this.txtBatch.setDocumentFilter(new BioAllowedKeyFilter("0123456789\n"));
        this.txtCodon.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FrmCodonToBp.this.calc();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FrmCodonToBp.this.calc();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FrmCodonToBp.this.calc();
            }
        });
        this.setIconImage(Globals.icon.getImage());
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(2);
        this.txtCodon.requestFocus();
    }

    private void calc() {
        int codonNum = this.txtCodon.getText().length() == 0 ? 1 : StringTools.filterStringToInt(this.txtCodon.getText());
        if (codonNum == 0) {
            codonNum = 1;
        }
        int bpNum = DNA.codonNumberToBpStart(codonNum);
        if (this.chkSelFeat.isEnabled() && this.chkSelFeat.isSelected()) {
            bpNum += this.getProject().getSelectedItem().getStart() - 1;
        }
        this.txtBp.setText("" + bpNum);
    }

    private void initComponents() {
        this.grpInsertPosition = new ButtonGroup();
        this.tabPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.txtBp = new GhostTextBox();
        this.jLabel2 = new JLabel();
        this.txtCodon = new GhostTextBox();
        this.jLabel1 = new JLabel();
        this.chkSelFeat = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.txtBatch = new GhostTextArea();
        this.jPanel3 = new JPanel();
        this.toggleLink = new JToggleButton();
        this.lblColorLabel = new ColorLabel();
        this.lblColorGraphic = new ColorLabel();
        this.jLabel3 = new JLabel();
        this.opFirst = new JRadioButton();
        this.opLast = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.cmdAddAnnotation = new JButton();
        this.cmdSave = new JButton();
        this.cmdCancel = new JButton();
        this.statusLabel = new StatusLabel();
        this.setTitle("Calculate Codon # from Bp");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Position"));
        this.txtBp.setEditable(false);
        this.txtBp.setBlankText("Codon Number");
        this.txtBp.setHorizontalAlignment(0);
        this.txtBp.setText("1");
        this.txtBp.setToolTipText("First base position of the entered codon #");
        this.txtBp.setMaximumSize(new Dimension(64, 24));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Bp Position");
        this.jLabel2.setHorizontalTextPosition(0);
        this.txtCodon.setBlankText("Base Pair Number");
        this.txtCodon.setHorizontalAlignment(0);
        this.txtCodon.setText("1");
        this.txtCodon.setToolTipText("Enter codon # to annotate with codon 1 being set at the origin");
        this.txtCodon.setMaximumSize(new Dimension(64, 24));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Codon #");
        this.jLabel1.setHorizontalTextPosition(0);
        this.chkSelFeat.setText("Set Bp relative to the start of the selected feature");
        this.chkSelFeat.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(66, 66, 66).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtCodon, -1, 90, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtBp, -1, 90, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addGap(60, 60, 60)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.chkSelFeat).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtCodon, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtBp, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 62, Short.MAX_VALUE).addComponent(this.chkSelFeat).addContainerGap()));
        this.tabPane.addTab("Manual Input", this.jPanel1);
        this.txtBatch.setColumns(20);
        this.txtBatch.setRows(5);
        this.txtBatch.setBlankText("Enter base positions on separate lines");
        this.jScrollPane1.setViewportView(this.txtBatch);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 331, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 145, Short.MAX_VALUE).addContainerGap()));
        this.tabPane.addTab("Batch Input", this.jPanel2);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Annotation Options"));
        this.jPanel3.setOpaque(false);
        this.toggleLink.setIcon(new ImageIcon(this.getClass().getResource("/images16/Link.png")));
        this.toggleLink.setFocusPainted(false);
        this.lblColorLabel.setText("Label Color");
        this.lblColorLabel.setToolTipText("Click to select color for generated annotation labels");
        this.lblColorLabel.setColor(Color.black);
        this.lblColorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmCodonToBp.this.lblColorLabelMouseClicked(evt);
            }
        });
        this.lblColorGraphic.setText("Graphic Color");
        this.lblColorGraphic.setToolTipText("Click to select color for generated annotation graphics");
        this.lblColorGraphic.setColor(Color.cyan);
        this.lblColorGraphic.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmCodonToBp.this.lblColorGraphicMouseClicked(evt);
            }
        });
        this.jLabel3.setText("Insert as");
        this.grpInsertPosition.add(this.opFirst);
        this.opFirst.setSelected(true);
        this.opFirst.setText("First");
        this.opFirst.setToolTipText("Insert new annotations at the top of the drawing order");
        this.grpInsertPosition.add(this.opLast);
        this.opLast.setText("Last");
        this.opLast.setToolTipText("Insert new annotations at the bottom of the drawing order");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblColorGraphic, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.toggleLink, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblColorLabel, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.opFirst).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.opLast))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(7, 7, 7).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblColorGraphic, -2, -1, -2).addComponent(this.toggleLink, -2, 23, -2).addComponent(this.lblColorLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel3).addComponent(this.opFirst).addComponent(this.opLast)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setLayout(new GridLayout(1, 0, 5, 0));
        this.cmdAddAnnotation.setText("Annotate");
        this.cmdAddAnnotation.setToolTipText("Annotate the current position");
        this.cmdAddAnnotation.setBorder(BorderFactory.createLineBorder(Globals.buttonBorderColor));
        this.cmdAddAnnotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCodonToBp.this.cmdAddAnnotationActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cmdAddAnnotation);
        this.cmdSave.setText("Save & Close");
        this.cmdSave.setToolTipText("Save annotations and close window");
        this.cmdSave.setBorder(BorderFactory.createLineBorder(Globals.buttonBorderColor));
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCodonToBp.this.cmdSaveActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cmdSave);
        this.cmdCancel.setText("Cancel & Close");
        this.cmdCancel.setToolTipText("Close window and remove added annotations");
        this.cmdCancel.setBorder(BorderFactory.createLineBorder(Globals.buttonBorderColor));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmCodonToBp.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cmdCancel);
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPane, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.statusLabel, GroupLayout.Alignment.LEADING, -1, 343, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tabPane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.statusLabel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    @Override
    public void doCancel() {
        if (!this.haveSeq) {
            this.cmdCancelActionPerformed(null);
        } else {
            this.cmdSaveActionPerformed(null);
        }
    }

    private void annotate() {
        ProjectDocument project = this.getProject();
        if (project.length() > 0) {
            boolean added = false;
            Color gColor = this.lblColorGraphic.getColor();
            Color lColor = this.lblColorLabel.getColor();
            if (this.tabPane.getSelectedIndex() == 0) {
                if (this.txtCodon.getText().length() == 0) {
                    return;
                }
                int bpStart = StringTools.filterStringToInt(this.txtBp.getText());
                int bpStop = bpStart + 2;
                if (bpStart < 1 || bpStart > project.length()) {
                    return;
                }
                String codon = project.getSequence(bpStart, bpStop);
                String aa = project.getCodonTable().translate(codon, 1, CodonTable.LetterCode.e3_Letter_Code);
                String name = JOptionPanes.showInputDialog(this, "Enter new feature name", "p." + aa + this.txtCodon.getText());
                if (name != null) {
                    this.addAnnotation(name, bpStart, bpStop, gColor, lColor);
                    added = true;
                }
            } else {
                String[] lines;
                if (this.txtBatch.getText().length() == 0) {
                    return;
                }
                for (String line : lines = this.txtBatch.getText().split("\n")) {
                    if (line.length() <= 0) continue;
                    int bpStart = StringTools.filterStringToInt(line, 0);
                    int bpStop = bpStart + 2;
                    if (bpStart <= 0 || bpStart > project.length()) continue;
                    String codon = project.getSequence(bpStart, bpStop);
                    String aa = project.getCodonTable().translate(codon, 1, CodonTable.LetterCode.e3_Letter_Code);
                    this.addAnnotation("p." + aa + DNA.bpNumToCodonNumber(bpStart), bpStart, bpStop, gColor, lColor);
                    added = true;
                }
            }
            if (added) {
                ((PLOTJ)this.getParent()).resetMap();
            }
            this.txtCodon.requestFocus();
        }
    }

    private void addAnnotation(String name, int bpStart, int bpStop, Color g, Color l) {
        ProjectDocument project = this.getProject();
        Feature f = new Feature();
        f.setName(name);
        f.setBackColor(g);
        f.setTextColor(l);
        f.setPosition(bpStart, bpStop);
        f.setOffset(110);
        this.addedFeatures.add(f);
        project.addROI((ROI)f);
    }

    private void lblColorGraphicMouseClicked(MouseEvent evt) {
        this.selectColor(0);
    }

    private void lblColorLabelMouseClicked(MouseEvent evt) {
        this.selectColor(1);
    }

    private void cmdAddAnnotationActionPerformed(ActionEvent evt) {
        this.annotate();
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        super.doOK();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        super.doCancel();
    }

    @Override
    public void doOK() {
        this.cmdAddAnnotationActionPerformed(null);
    }

    private void selectColor(int src) {
        Color color = src == 0 ? JColorChooser.showDialog(this, "Select Color", this.lblColorGraphic.getColor()) : JColorChooser.showDialog(this, "Select Color", this.lblColorLabel.getColor());
        if (color != null) {
            if (src == 0 || this.toggleLink.isSelected()) {
                this.lblColorGraphic.setColor(color);
            }
            if (src == 1 || this.toggleLink.isSelected()) {
                this.lblColorLabel.setColor(color);
            }
        }
    }
}

