/*
 * Decompiled with CFR 0.152.
 */
package plot;

import AboutWindow.AboutForm;
import BinaryTrees.BinaryChain;
import BioDocumentFilters.BioAllowedKeyFilter;
import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import DocumentFilters.DocumentAllowedKeyFilter;
import EditorTable.BasicDataTable;
import EditorTable.DataTableListener;
import EditorTable.DataTableModel;
import EditorTable.DataTableModelEvent;
import ListModels.UniqueComboModel;
import ListModels.UniqueListModel;
import MiscTools.StringTools;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.ExtensibleArray;
import Sequences.DNA;
import UndoRedo.Undoable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Position;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import plot.DefaultLibraries;
import plot.Enzyme;
import plot.EnzymeFeature;
import plot.EnzymeFilter;
import plot.EnzymeListCellRenderer;
import plot.EnzymeMix;
import plot.EnzymeMixList;
import plot.Globals;
import plot.JOptionPanes;
import plot.MainExclusiveDlg;
import plot.PLOTJ;
import plot.ProjectDocument;
import plot.ProjectEnzyme;
import plot.UserList;

class FrmEnzymes
extends MainExclusiveDlg
implements DataTableListener {
    public static final int COL_MINCUTS = 0;
    public static final int COL_MAXCUTS = 1;
    public static final int COL_MINBP = 2;
    public static final int COL_MAXBP = 3;
    private static final EnzymeListCellRenderer enzymeRenderer = new EnzymeListCellRenderer();
    private static final Comparator sortEnzyme = new Comparator<ProjectEnzyme>(){

        @Override
        public int compare(ProjectEnzyme o1, ProjectEnzyme o2) {
            return o1.enzyme.name.compareTo(o2.enzyme.name);
        }
    };
    private static final Comparator sortEnzymeMix = new Comparator<EnzymeMix>(){

        @Override
        public int compare(EnzymeMix o1, EnzymeMix o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmEnzymes.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmEnzymes.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    checkAction checkBoxActionAction = new checkAction();
    private final UniqueListModel<ProjectEnzyme> listModelSelected;
    private final UniqueComboModel<EnzymeMixList> comboModelMix;
    private final DefaultListModel<ProjectEnzyme> listModelSelectable;
    private final DefaultListModel<ProjectEnzyme> listModelFoundCompatible;
    private final DefaultListModel<ProjectEnzyme> listModelFoundMatch;
    private final UniqueListModel<EnzymeMix> listModelSelectedMixes;
    private final DefaultListModel<EnzymeMix> listModelSelectableMix;
    private BinaryChain<ProjectEnzyme> activeEnzymes;
    private boolean changed = false;
    ImageIcon iconRed;
    ImageIcon iconOrange;
    ImageIcon iconWhite;
    private final MouseListener statusLabelMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmEnzymes.this.statusLabel.setText(c.getToolTipText(), 0);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmEnzymes.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    private final FilterTableModel enzymeFilterModel = new FilterTableModel();
    private static final EnzymeMixList manualMixListItem = new EnzymeMixList(" Manually Select Enzymes ");
    private static final int FIRST_CUSTOM_MIX_INDEX = 1;
    private JCheckBox chk4Bp;
    private JCheckBox chk5Bp;
    private JCheckBox chk6Bp;
    private JCheckBox chk7Bp;
    private JCheckBox chk8Bp;
    private JCheckBox chkAsymetric;
    private JCheckBox chkContinuous;
    private JCheckBox chkCpG;
    private JCheckBox chkDam;
    private JCheckBox chkDcm;
    private JCheckBox chkDegenerate;
    private JCheckBox chkHoming;
    private JCheckBox chkIso;
    private JCheckBox chkMax;
    private JCheckBox chkMin;
    private JCheckBox chkOH3;
    private JCheckBox chkOH5;
    private JCheckBox chkOHBlunt;
    private JCheckBox chkSymetric;
    private JComboBox<String> cmbUserLists;
    private JComboBox<EnzymeMixList> cmbUserMixLists;
    private GlossyButton cmdAddCompat;
    private GlossyButton cmdAddFreq;
    private GlossyButton cmdAddMix;
    private GlossyButton cmdAddSingle;
    private GlossyButton cmdAddSingle2;
    private GlossyButton cmdEditUserList;
    private GlossyButton cmdEditUserMix;
    private GlossyButton cmdHelpFilter;
    private GlossyButton cmdRebase;
    private GlossyButton cmdRebase1;
    private GlossyButton cmdRebase3;
    private GlossyButton cmdRemFreq;
    private GlossyButton cmdRemMix;
    private GlossyButton cmdRemSingle;
    private GlossyButton cmdRemSingle2;
    private GlossyButton cmdSearchExact;
    private GlossyButton cmdSearchPartial;
    private GlossyButton cmdUpdateFreq;
    private GlossyButton glossyButton1;
    private GlossyButton glossyButton2;
    private JLabel infoCpg;
    private JLabel infoCpg1;
    private JLabel infoCpg3;
    private JLabel infoDam;
    private JLabel infoDam1;
    private JLabel infoDam3;
    private JLabel infoDcm;
    private JLabel infoDcm1;
    private JLabel infoDcm3;
    private JLabel infoMisc;
    private JLabel infoMisc1;
    private JLabel infoMisc3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane10;
    private JScrollPane jScrollPane11;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JScrollPane jScrollPane9;
    private JSeparator jSeparator1;
    private JList<String> lstCompatibleFound;
    private JList<String> lstCompatibleSrc;
    private JList<String> lstSearchSeq;
    private JList<String> lstSelectableMix;
    private JList<String> lstSelectableSingle;
    private JList<String> lstSelectedCompEnds;
    private JList<String> lstSelectedMix;
    private JList<String> lstSelectedSingle;
    private JList<String> lstSelectedSite;
    private JTabbedPane selectionTypeTabs;
    private StatusLabel statusLabel;
    private BasicDataTable tblFreq;
    private JTextField txtCompQry;
    private JTextField txtFoundSite;
    private JTextField txtMax;
    private JTextField txtMaxBp;
    private JTextField txtMaxCuts;
    private JTextField txtMin;
    private JTextField txtMinBp;
    private JTextField txtMinCuts;
    private JTextField txtNameComp;
    private JTextField txtNameMix;
    private JTextField txtNameSingle;
    private JTextField txtSearchSeq;
    private JTextField txtSeqFoundComp;
    private JTextField txtSeqSingle;

    public boolean canceled() {
        return !this.changed;
    }

    public FrmEnzymes(PLOTJ parent) {
        super((Window)parent);
        this.initComponents();
        this.activeEnzymes = this.getProject().defaultEnzymes;
        this.tblFreq.setModel(this.enzymeFilterModel);
        this.tblFreq.addDataTableListener(this);
        this.iconWhite = new ImageIcon(this.getClass().getResource("/images39/infowhite.png"));
        this.iconOrange = new ImageIcon(this.getClass().getResource("/images39/infoorange.png"));
        this.iconRed = new ImageIcon(this.getClass().getResource("/images39/infored.png"));
        FocusListener textBoxFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextField txt = (JTextField)e.getSource();
                txt.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ProjectDocument project = FrmEnzymes.this.getProject();
                int start = StringTools.filterStringToInt(FrmEnzymes.this.txtMinBp.getText(), 1);
                int stop = StringTools.filterStringToInt(FrmEnzymes.this.txtMaxBp.getText(), project.length());
                int min = StringTools.filterStringToInt(FrmEnzymes.this.txtMinCuts.getText(), 1);
                int max = StringTools.filterStringToInt(FrmEnzymes.this.txtMaxCuts.getText(), 1);
                JTextField txt = (JTextField)e.getSource();
                if (txt == FrmEnzymes.this.txtMinCuts) {
                    if (min > max) {
                        max = min;
                    }
                } else if (txt == FrmEnzymes.this.txtMaxCuts) {
                    if (max < min) {
                        min = max;
                    }
                } else if (txt == FrmEnzymes.this.txtMinBp) {
                    if ((start = Math.max(1, Math.min(start, project.length()))) > stop) {
                        stop = start;
                    }
                } else if (txt == FrmEnzymes.this.txtMaxBp && (stop = Math.max(1, Math.min(stop, project.length()))) < start) {
                    start = stop;
                }
                FrmEnzymes.this.txtMinBp.setText("" + start);
                FrmEnzymes.this.txtMaxBp.setText("" + stop);
                FrmEnzymes.this.txtMinCuts.setText("" + min);
                FrmEnzymes.this.txtMaxCuts.setText("" + max);
            }
        };
        this.txtMinBp.addFocusListener(textBoxFocusListener);
        this.txtMaxBp.addFocusListener(textBoxFocusListener);
        this.txtMinCuts.addFocusListener(textBoxFocusListener);
        this.txtMaxCuts.addFocusListener(textBoxFocusListener);
        ((AbstractDocument)this.txtMin.getDocument()).setDocumentFilter(DocumentAllowedKeyFilter.NumberFilter);
        ((AbstractDocument)this.txtMax.getDocument()).setDocumentFilter(DocumentAllowedKeyFilter.NumberFilter);
        ((AbstractDocument)this.txtSearchSeq.getDocument()).setDocumentFilter(new BioAllowedKeyFilter("ACGTRYSWKMBDHVNacgtryswkmbdhvn"));
        this.listModelSelected = new UniqueListModel();
        this.listModelFoundMatch = new DefaultListModel();
        this.comboModelMix = new UniqueComboModel();
        this.listModelSelectable = new DefaultListModel();
        this.listModelFoundCompatible = new DefaultListModel();
        this.listModelSelectedMixes = new UniqueListModel();
        this.listModelSelectableMix = new DefaultListModel();
        this.populateSelectableModel();
        this.populateSelectedModel();
        this.populateMixModel();
        this.cmbUserMixLists.setModel(this.comboModelMix);
        this.lstSelectableSingle.setModel(this.listModelSelectable);
        this.lstSelectableMix.setModel(this.listModelSelectable);
        this.lstSelectedMix.setModel(this.listModelSelectedMixes);
        this.lstSearchSeq.setModel(this.listModelFoundMatch);
        this.lstCompatibleSrc.setModel(this.listModelSelectable);
        this.lstCompatibleFound.setModel(this.listModelFoundCompatible);
        this.lstSelectedCompEnds.setModel(this.listModelSelected);
        this.lstSelectedSingle.setModel(this.listModelSelected);
        this.lstSelectedSite.setModel(this.listModelSelected);
        this.lstSelectableSingle.setCellRenderer(enzymeRenderer);
        this.lstSelectedSingle.setCellRenderer(enzymeRenderer);
        this.lstSelectedCompEnds.setCellRenderer(enzymeRenderer);
        this.lstSelectableMix.setCellRenderer(enzymeRenderer);
        this.lstSearchSeq.setCellRenderer(enzymeRenderer);
        this.lstSelectedMix.setCellRenderer(enzymeRenderer);
        this.lstCompatibleFound.setCellRenderer(enzymeRenderer);
        this.lstSelectedCompEnds.setCellRenderer(enzymeRenderer);
        this.lstSelectedSite.setCellRenderer(enzymeRenderer);
        this.lstCompatibleSrc.setCellRenderer(enzymeRenderer);
        this.lstCompatibleFound.setCellRenderer(enzymeRenderer);
        this.populateUserListCombo();
        this.populateMixCombo();
        this.setLocationRelativeTo(parent);
        this.setIconImage(Globals.icon.getImage());
        this.txtNameSingle.requestFocus();
        this.txtNameSingle.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateList();
            }

            private void updateList() {
                String name = FrmEnzymes.this.txtNameSingle.getText();
                int x = Math.max(0, FrmEnzymes.this.lstSelectableSingle.getNextMatch(name, 0, Position.Bias.Forward));
                FrmEnzymes.this.lstSelectableSingle.setSelectedIndex(x);
                FrmEnzymes.this.lstSelectableSingle.ensureIndexIsVisible(x);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.txtNameMix.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateList();
            }

            private void updateList() {
                String name = FrmEnzymes.this.txtNameMix.getText();
                int x = Math.max(0, FrmEnzymes.this.lstSelectableSingle.getNextMatch(name, 0, Position.Bias.Forward));
                FrmEnzymes.this.lstSelectableMix.setSelectedIndex(x);
                FrmEnzymes.this.lstSelectableMix.ensureIndexIsVisible(x);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.txtNameComp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateList();
            }

            private void updateList() {
                String name = FrmEnzymes.this.txtNameComp.getText();
                int x = Math.max(0, FrmEnzymes.this.lstCompatibleSrc.getNextMatch(name, 0, Position.Bias.Forward));
                FrmEnzymes.this.lstCompatibleSrc.setSelectedIndex(x);
                FrmEnzymes.this.lstCompatibleSrc.ensureIndexIsVisible(x);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.tblFreq.setShowRowHeaders(false);
        this.tblFreq.setColumnHeadings("Min. Cuts", "Max. Cuts", "Starting Bp", "End Bp");
        this.tblFreq.getColumn(0).setCellAlignment(0);
        this.tblFreq.getColumn(1).setCellAlignment(0);
        this.tblFreq.getColumn(2).setCellAlignment(0);
        this.tblFreq.getColumn(3).setCellAlignment(0);
        for (int x = 0; x < this.getComponentCount(); ++x) {
            Component c = this.getComponent(x);
            if (!(c instanceof JComponent)) continue;
            this.assignListeners((JComponent)c);
        }
        ProjectDocument project = this.getProject();
        if (!project.enzymeFilters.isEmpty()) {
            for (EnzymeFilter ef : project.enzymeFilters) {
                this.enzymeFilterModel.addRow(ef);
            }
            this.tblFreq.select(0, 0);
        } else {
            this.txtMinBp.setText("1");
            this.txtMaxBp.setText("" + project.length());
            this.txtMaxCuts.setText("1");
            this.txtMinCuts.setText("1");
        }
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.setCtrlS_DoOK();
    }

    private void assignListeners(JComponent c) {
        if (c.getToolTipText() != null && c.getToolTipText().length() > 0) {
            c.addMouseListener(this.menuMouseListener);
        }
        for (int x = 0; x < c.getComponentCount(); ++x) {
            Component child = c.getComponent(x);
            if (!(child instanceof JComponent)) continue;
            this.assignListeners((JComponent)child);
        }
    }

    private void populateUserListCombo() {
        this.cmbUserLists.removeAllItems();
        this.cmbUserLists.addItem(" [ All Enzymes ]");
        if (DefaultLibraries.userLibrary.userLists.size() > 0) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.cmbUserLists.getModel();
            DefaultLibraries.userLibrary.userLists.sort(UserList.byName);
            for (UserList list : DefaultLibraries.userLibrary.userLists) {
                model.addElement(list);
            }
        }
    }

    @Override
    public void doOK() {
        if (this.lstSelectableSingle.hasFocus() || this.txtNameSingle.hasFocus()) {
            this.cmdAddSingleActionPerformed(null);
            return;
        }
        if (this.lstSelectedSingle.hasFocus()) {
            this.cmdRemSingleActionPerformed(null);
            return;
        }
        final ProjectDocument project = this.getProject();
        final ArrayList<EnzymeFeature> foundEnzymes = project.foundEnzymes;
        final BinaryChain<ProjectEnzyme> selectedEnzymes = project.selectedEnzymes;
        final BinaryChain<EnzymeMix> enzymeMixes = project.enzymeMixes;
        final ExtensibleArray<EnzymeFilter> enzymeFilters = project.enzymeFilters;
        project.selectedEnzymes = this.listModelSelected.items;
        project.enzymeMixes = this.listModelSelectedMixes.items;
        project.foundEnzymes = new ArrayList();
        project.enzymeFilters = this.enzymeFilterModel.dataRows;
        final ArrayList<EnzymeFeature> nfoundEnzymes = project.foundEnzymes;
        final BinaryChain<ProjectEnzyme> nselectedEnzymes = project.selectedEnzymes;
        final BinaryChain<EnzymeMix> nenzymeMixes = project.enzymeMixes;
        final ExtensibleArray<EnzymeFilter> nenzymeFilters = project.enzymeFilters;
        project.updateREs();
        final UndoRedo.ChangeEvent[] events = new UndoRedo.ChangeEvent[]{new UndoRedo.ChangeEvent(106), new UndoRedo.ChangeEvent(107), new UndoRedo.ChangeEvent(10)};
        final boolean isChanged = project.isChanged();
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                project.selectedEnzymes = selectedEnzymes;
                project.enzymeMixes = enzymeMixes;
                project.foundEnzymes = foundEnzymes;
                project.enzymeFilters = enzymeFilters;
                project.setChanged(isChanged);
                project.fireEvents(events);
                return true;
            }

            @Override
            public boolean redo() {
                project.selectedEnzymes = nselectedEnzymes;
                project.enzymeMixes = nenzymeMixes;
                project.foundEnzymes = nfoundEnzymes;
                project.enzymeFilters = nenzymeFilters;
                project.setChanged(true);
                project.fireEvents(events);
                return true;
            }
        };
        project.runEdit(edit);
        if (DefaultLibraries.userLibrary.isChanged()) {
            DefaultLibraries.userLibrary.save();
            DefaultLibraries.userLibrary.setChanged(false);
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        if (DefaultLibraries.userLibrary.isChanged()) {
            DefaultLibraries.userLibrary.save();
            DefaultLibraries.userLibrary.setChanged(false);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void populateSelectableModel() {
        this.listModelSelectable.clear();
        if (this.activeEnzymes.size() == 0) {
            return;
        }
        this.activeEnzymes.sort(ProjectEnzyme.sortComparator);
        for (ProjectEnzyme enzyme : this.activeEnzymes) {
            int SeqLen = enzyme.enzyme.filteredSeq.length();
            if (SeqLen == 4 && !this.chk4Bp.isSelected() || SeqLen == 5 && !this.chk5Bp.isSelected() || SeqLen == 6 && !this.chk6Bp.isSelected() || SeqLen == 7 && !this.chk7Bp.isSelected() || SeqLen >= 8 && !this.chk8Bp.isSelected() || enzyme.enzyme.overhang == 0 && !this.chkOHBlunt.isSelected() || enzyme.enzyme.overhang == 5 && !this.chkOH5.isSelected() || enzyme.enzyme.overhang == 3 && !this.chkOH3.isSelected() || enzyme.enzyme.degenerate && !this.chkDegenerate.isSelected() || !enzyme.enzyme.degenerate && !this.chkContinuous.isSelected() || enzyme.enzyme.asymetrical && !this.chkAsymetric.isSelected() || !enzyme.enzyme.asymetrical && !this.chkSymetric.isSelected() || enzyme.enzyme.homing && !this.chkHoming.isSelected() || enzyme.enzyme.isoschizomer && !this.chkIso.isSelected() || enzyme.enzyme.isDam != 0 && !this.chkDam.isSelected() || enzyme.enzyme.isDcm != 0 && !this.chkDcm.isSelected() || this.chkMin.isSelected() && enzyme.getCutCount() < StringTools.filterStringToInt(this.txtMin.getText(), 0) || this.chkMax.isSelected() && enzyme.getCutCount() > StringTools.filterStringToInt(this.txtMax.getText(), 0)) continue;
            this.listModelSelectable.addElement(enzyme);
        }
        this.listModelFoundCompatible.removeAllElements();
    }

    private void populateSelectedModel() {
        this.listModelSelected.clear();
        ProjectDocument project = this.getProject();
        for (int index = 0; index < project.selectedEnzymes.size(); ++index) {
            this.listModelSelected.add(project.selectedEnzymes.get(index));
        }
    }

    private void populateMixCombo() {
        this.comboModelMix.removeAllElements();
        this.cmbUserMixLists.addItem(manualMixListItem);
        if (!DefaultLibraries.userLibrary.userMixeLists.isEmpty()) {
            for (EnzymeMixList mix : DefaultLibraries.userLibrary.userMixeLists) {
                this.cmbUserMixLists.addItem(mix);
            }
        }
        this.cmbUserMixLists.setSelectedItem(manualMixListItem);
    }

    private void populateMixModel() {
        this.listModelSelectedMixes.clear();
        ProjectDocument project = this.getProject();
        for (int index = 0; index < project.enzymeMixes.size(); ++index) {
            this.listModelSelectedMixes.add(project.enzymeMixes.get(index));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.chk4Bp = new JCheckBox();
        this.chk6Bp = new JCheckBox();
        this.chk5Bp = new JCheckBox();
        this.chk7Bp = new JCheckBox();
        this.chk8Bp = new JCheckBox();
        this.chkOHBlunt = new JCheckBox();
        this.chkOH5 = new JCheckBox();
        this.chkOH3 = new JCheckBox();
        this.chkContinuous = new JCheckBox();
        this.chkDegenerate = new JCheckBox();
        this.chkAsymetric = new JCheckBox();
        this.chkSymetric = new JCheckBox();
        this.chkIso = new JCheckBox();
        this.chkHoming = new JCheckBox();
        this.txtMin = new JTextField();
        this.chkMin = new JCheckBox();
        this.chkMax = new JCheckBox();
        this.txtMax = new JTextField();
        this.chkDam = new JCheckBox();
        this.chkDcm = new JCheckBox();
        this.chkCpG = new JCheckBox();
        this.glossyButton1 = new GlossyButton();
        this.glossyButton2 = new GlossyButton();
        this.jSeparator1 = new JSeparator();
        this.cmbUserLists = new JComboBox();
        this.cmdEditUserList = new GlossyButton();
        this.jScrollPane5 = new JScrollPane();
        this.selectionTypeTabs = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstSelectedSingle = new JList();
        this.jLabel1 = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.lstSelectableSingle = new JList();
        this.jLabel6 = new JLabel();
        this.txtSeqSingle = new JTextField();
        this.txtNameSingle = new JTextField();
        this.jLabel7 = new JLabel();
        this.jPanel3 = new JPanel();
        this.cmdRemSingle = new GlossyButton();
        this.cmdAddSingle = new GlossyButton();
        this.jPanel9 = new JPanel();
        this.cmdRebase = new GlossyButton();
        this.infoDam = new JLabel();
        this.infoDcm = new JLabel();
        this.infoCpg = new JLabel();
        this.infoMisc = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel9 = new JLabel();
        this.txtNameMix = new JTextField();
        this.jScrollPane8 = new JScrollPane();
        this.lstSelectableMix = new JList();
        this.jLabel5 = new JLabel();
        this.jScrollPane9 = new JScrollPane();
        this.lstSelectedMix = new JList();
        this.jLabel13 = new JLabel();
        this.cmbUserMixLists = new JComboBox();
        this.jPanel11 = new JPanel();
        this.cmdRemMix = new GlossyButton();
        this.cmdAddMix = new GlossyButton();
        this.cmdEditUserMix = new GlossyButton();
        this.jPanel6 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.lstSelectedCompEnds = new JList();
        this.txtNameComp = new JTextField();
        this.jLabel14 = new JLabel();
        this.jScrollPane7 = new JScrollPane();
        this.lstCompatibleSrc = new JList();
        this.jLabel15 = new JLabel();
        this.txtCompQry = new JTextField();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.txtSeqFoundComp = new JTextField();
        this.jScrollPane10 = new JScrollPane();
        this.lstCompatibleFound = new JList();
        this.jLabel18 = new JLabel();
        this.jPanel14 = new JPanel();
        this.cmdAddCompat = new GlossyButton();
        this.jPanel15 = new JPanel();
        this.cmdRebase3 = new GlossyButton();
        this.infoDam3 = new JLabel();
        this.infoDcm3 = new JLabel();
        this.infoCpg3 = new JLabel();
        this.infoMisc3 = new JLabel();
        this.jPanel7 = new JPanel();
        this.txtMinCuts = new JTextField();
        this.txtMaxCuts = new JTextField();
        this.txtMaxBp = new JTextField();
        this.txtMinBp = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.tblFreq = new BasicDataTable();
        this.cmdAddFreq = new GlossyButton();
        this.cmdUpdateFreq = new GlossyButton();
        this.cmdRemFreq = new GlossyButton();
        this.cmdHelpFilter = new GlossyButton();
        this.jPanel8 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.lstSelectedSite = new JList();
        this.txtSearchSeq = new JTextField();
        this.jLabel19 = new JLabel();
        this.jScrollPane11 = new JScrollPane();
        this.lstSearchSeq = new JList();
        this.txtFoundSite = new JTextField();
        this.jPanel5 = new JPanel();
        this.cmdRemSingle2 = new GlossyButton();
        this.cmdAddSingle2 = new GlossyButton();
        this.jPanel13 = new JPanel();
        this.cmdRebase1 = new GlossyButton();
        this.infoDam1 = new JLabel();
        this.infoDcm1 = new JLabel();
        this.infoCpg1 = new JLabel();
        this.infoMisc1 = new JLabel();
        this.cmdSearchPartial = new GlossyButton();
        this.cmdSearchExact = new GlossyButton();
        this.jLabel20 = new JLabel();
        this.statusLabel = new StatusLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("pLOT Enzyme Editor");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Filter Site Selection"));
        this.chk4Bp.setAction(this.checkBoxActionAction);
        this.chk4Bp.setSelected(true);
        this.chk4Bp.setText("4bp Cutters");
        this.chk4Bp.setToolTipText("Toggles excluding enzymes with 4bp sites in the list of selectable enzymes.");
        this.chk4Bp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.checkAction(evt);
            }
        });
        this.chk6Bp.setAction(this.checkBoxActionAction);
        this.chk6Bp.setSelected(true);
        this.chk6Bp.setText("6bp Cutters");
        this.chk6Bp.setToolTipText("Toggles excluding enzymes with 6bp sites in the list of selectable enzymes.");
        this.chk5Bp.setAction(this.checkBoxActionAction);
        this.chk5Bp.setSelected(true);
        this.chk5Bp.setText("5bp Cutters");
        this.chk5Bp.setToolTipText("Toggles excluding enzymes with 5bp sites in the list of selectable enzymes.");
        this.chk7Bp.setAction(this.checkBoxActionAction);
        this.chk7Bp.setSelected(true);
        this.chk7Bp.setText("7bp Cutters");
        this.chk7Bp.setToolTipText("Toggles excluding enzymes with 7bp sites in the list of selectable enzymes.");
        this.chk8Bp.setAction(this.checkBoxActionAction);
        this.chk8Bp.setSelected(true);
        this.chk8Bp.setText("8+bp Cutters");
        this.chk8Bp.setToolTipText("Toggles excluding enzymes with 8bp or greater sites in the list of selectable enzymes.");
        this.chkOHBlunt.setAction(this.checkBoxActionAction);
        this.chkOHBlunt.setSelected(true);
        this.chkOHBlunt.setText("Blunt Cutters");
        this.chkOHBlunt.setToolTipText("Toggles blunt cutters in the list of selectable enzymes.");
        this.chkOH5.setAction(this.checkBoxActionAction);
        this.chkOH5.setSelected(true);
        this.chkOH5.setText("5' Overhangs");
        this.chkOH5.setToolTipText("Toggles enzymes leaving 5' overhang in the list of selectable enzymes.");
        this.chkOH3.setAction(this.checkBoxActionAction);
        this.chkOH3.setSelected(true);
        this.chkOH3.setText("3' Overhangs");
        this.chkOH3.setToolTipText("Toggles enzymes leaving 3' overhang in the list of selectable enzymes.");
        this.chkContinuous.setAction(this.checkBoxActionAction);
        this.chkContinuous.setSelected(true);
        this.chkContinuous.setText("Continuous Sites");
        this.chkContinuous.setToolTipText("Toggles enzymes with non-degenerate sites in the list of selectable enzymes.");
        this.chkDegenerate.setAction(this.checkBoxActionAction);
        this.chkDegenerate.setSelected(true);
        this.chkDegenerate.setText("Degenerate Sites");
        this.chkDegenerate.setToolTipText("Toggles enzymes with degenerate sites in the list of selectable enzymes.");
        this.chkAsymetric.setAction(this.checkBoxActionAction);
        this.chkAsymetric.setSelected(true);
        this.chkAsymetric.setText("Asymetric Cutters");
        this.chkAsymetric.setToolTipText("Toggles enzymes with asymetric sites in the list of selectable enzymes.");
        this.chkSymetric.setAction(this.checkBoxActionAction);
        this.chkSymetric.setSelected(true);
        this.chkSymetric.setText("Symetric Cutters");
        this.chkSymetric.setToolTipText("Toggles enzymes with symetric sites in the list of selectable enzymes.");
        this.chkIso.setAction(this.checkBoxActionAction);
        this.chkIso.setSelected(true);
        this.chkIso.setText("Isoschizomers");
        this.chkIso.setToolTipText("Toggles showing isoschizomers in the list of selectable enzymes.");
        this.chkHoming.setAction(this.checkBoxActionAction);
        this.chkHoming.setSelected(true);
        this.chkHoming.setText("Homing Enzymes");
        this.chkHoming.setToolTipText("Toggles homing enzymes in the list of selectable enzymes.");
        this.txtMin.setHorizontalAlignment(0);
        this.txtMin.setText("1");
        this.txtMin.setToolTipText("Minimum cuts in the sequence an enzyme must have in order to be included the enzyme in the list of selectable enzymes.");
        this.txtMin.setEnabled(false);
        this.txtMin.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FrmEnzymes.this.txtMinFocusLost(evt);
            }
        });
        this.chkMin.setText("Min Cuts");
        this.chkMin.setToolTipText("Toggles excluding enzymes with fewer cut sites in the sequence than specified in the text box to the right.");
        this.chkMin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.chkMinActionPerformed(evt);
            }
        });
        this.chkMax.setText("Max Cuts");
        this.chkMax.setToolTipText("Toggles excluding enzymes with greater cut sites in the sequence than specified in the text box to the right.");
        this.chkMax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.chkMaxActionPerformed(evt);
            }
        });
        this.txtMax.setHorizontalAlignment(0);
        this.txtMax.setText("1");
        this.txtMax.setToolTipText("Maximum cuts in the sequence an enzyme can have in order to be included the enzyme in the list of selectable enzymes.");
        this.txtMax.setEnabled(false);
        this.txtMax.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FrmEnzymes.this.txtMaxFocusLost(evt);
            }
        });
        this.chkDam.setAction(this.checkBoxActionAction);
        this.chkDam.setSelected(true);
        this.chkDam.setText("Dam Methylation Sensitive");
        this.chkDam.setToolTipText("Toggles Dam methylation sensitive enzymes in the list of selectable enzymes.");
        this.chkDcm.setAction(this.checkBoxActionAction);
        this.chkDcm.setSelected(true);
        this.chkDcm.setText("Dcm Methylation Sensitive");
        this.chkDcm.setToolTipText("Toggles Dcm methylation sensitive enzymes in the list of selectable enzymes.");
        this.chkCpG.setAction(this.checkBoxActionAction);
        this.chkCpG.setSelected(true);
        this.chkCpG.setText("CpG Methylation Sensitive");
        this.chkCpG.setToolTipText("Toggles CpG methylation sensitive enzymes in the list of selectable enzymes.");
        this.glossyButton1.setText("OK");
        this.glossyButton1.setToolTipText("Save changes and close.");
        this.glossyButton1.setColorHot(new Color(204, 204, 255));
        this.glossyButton1.setColorNormal(new Color(240, 240, 240));
        this.glossyButton1.setColorPressed(new Color(204, 204, 255));
        this.glossyButton1.setFont(new Font("Segoe UI", 0, 14));
        this.glossyButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.glossyButton1ActionPerformed(evt);
            }
        });
        this.glossyButton2.setText("Cancel");
        this.glossyButton2.setToolTipText("Cancel changes and close.");
        this.glossyButton2.setColorHot(new Color(255, 51, 51));
        this.glossyButton2.setColorNormal(new Color(240, 240, 240));
        this.glossyButton2.setColorPressed(new Color(255, 51, 51));
        this.glossyButton2.setFont(new Font("Segoe UI", 0, 14));
        this.glossyButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.glossyButton2ActionPerformed(evt);
            }
        });
        this.jSeparator1.setBackground(new Color(0, 0, 0));
        this.jSeparator1.setForeground(new Color(0, 0, 0));
        this.cmbUserLists.setFont(new Font("Segoe UI", 0, 14));
        this.cmbUserLists.setToolTipText("Toggle between manual selection of enzymes or selection from saved lists");
        this.cmbUserLists.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmbUserListsActionPerformed(evt);
            }
        });
        this.cmdEditUserList.setIcon(new ImageIcon(this.getClass().getResource("/images24/Edit.png")));
        this.cmdEditUserList.setToolTipText("Click to edit custom enzyme lists or show help.");
        this.cmdEditUserList.setColorHot(new Color(204, 204, 255));
        this.cmdEditUserList.setColorNormal(new Color(240, 240, 240));
        this.cmdEditUserList.setColorPressed(new Color(204, 204, 255));
        this.cmdEditUserList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdEditUserListActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.chk8Bp).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chk4Bp).addComponent(this.chk6Bp)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chk5Bp).addComponent(this.chk7Bp))).addComponent(this.chkOHBlunt).addComponent(this.chkOH5).addComponent(this.chkOH3).addComponent(this.chkDam).addComponent(this.chkContinuous).addComponent(this.chkDcm).addComponent(this.chkDegenerate).addComponent(this.chkAsymetric).addComponent(this.chkSymetric).addComponent(this.chkIso).addComponent(this.chkHoming).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkMin).addComponent(this.chkMax)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtMin, -2, 0, Short.MAX_VALUE).addComponent(this.txtMax, -2, 58, -2))).addComponent(this.chkCpG).addComponent(this.glossyButton2, -1, -1, Short.MAX_VALUE).addComponent(this.glossyButton1, -1, -1, Short.MAX_VALUE).addComponent(this.cmbUserLists, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdEditUserList, -2, 30, -2).addGap(0, 22, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbUserLists, -2, 26, -2).addComponent(this.cmdEditUserList, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chk4Bp).addComponent(this.chk5Bp)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chk6Bp).addComponent(this.chk7Bp)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chk8Bp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkOHBlunt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkOH5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkOH3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkContinuous).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkDegenerate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkAsymetric).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkSymetric).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkHoming).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkIso).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.txtMin, -2, -1, -2).addComponent(this.chkMin)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.chkMax).addComponent(this.txtMax, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkDam).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkDcm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCpG).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.glossyButton1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.glossyButton2, -2, -1, -2).addContainerGap()));
        this.jScrollPane5.setHorizontalScrollBarPolicy(31);
        this.jScrollPane5.setVerticalScrollBarPolicy(21);
        this.jScrollPane5.setViewportView(null);
        this.selectionTypeTabs.setMaximumSize(new Dimension(Short.MAX_VALUE, 520));
        this.selectionTypeTabs.setMinimumSize(new Dimension(113, 520));
        this.selectionTypeTabs.setPreferredSize(new Dimension(822, 520));
        this.selectionTypeTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmEnzymes.this.selectionTypeTabsStateChanged(evt);
            }
        });
        this.jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, 513));
        this.jPanel2.setMinimumSize(new Dimension(0, 513));
        this.jPanel2.setPreferredSize(new Dimension(822, 513));
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.lstSelectedSingle.setFont(new Font("Segoe UI", 0, 14));
        this.lstSelectedSingle.setToolTipText("Currently selected enzymes.");
        this.lstSelectedSingle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmEnzymes.this.lstSelectedSingleMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstSelectedSingle);
        this.jPanel2.add((Component)this.jScrollPane1, new AbsoluteConstraints(460, 20, 190, 490));
        this.jLabel1.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel1.setText("Selected Enzymes");
        this.jPanel2.add((Component)this.jLabel1, new AbsoluteConstraints(460, 0, 190, -1));
        this.lstSelectableSingle.setFont(new Font("Segoe UI", 0, 14));
        this.lstSelectableSingle.setToolTipText("List of selectable enzymes.  Multiple selections are allowed at once.");
        this.lstSelectableSingle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmEnzymes.this.lstSelectableSingleMouseClicked(evt);
            }
        });
        this.lstSelectableSingle.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FrmEnzymes.this.lstSelectableSingleValueChanged(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.lstSelectableSingle);
        this.jPanel2.add((Component)this.jScrollPane6, new AbsoluteConstraints(10, 60, 200, 400));
        this.jLabel6.setText("Enzyme Site Sequence");
        this.jPanel2.add((Component)this.jLabel6, new AbsoluteConstraints(10, 470, 201, -1));
        this.txtSeqSingle.setFont(new Font("Segoe UI", 0, 14));
        this.txtSeqSingle.setToolTipText("Restriction site sequence of the currently selected enzyme.");
        this.txtSeqSingle.setMaximumSize(new Dimension(Integer.MAX_VALUE, 26));
        this.jPanel2.add((Component)this.txtSeqSingle, new AbsoluteConstraints(10, 490, 201, -1));
        this.txtNameSingle.setFont(new Font("Segoe UI", 0, 14));
        this.txtNameSingle.setToolTipText("Type in an enzyme's name to go to the first partial or full match.");
        this.txtNameSingle.setPreferredSize(new Dimension(72, 26));
        this.txtNameSingle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmEnzymes.this.txtNameSingleFocusGained(evt);
            }
        });
        this.jPanel2.add((Component)this.txtNameSingle, new AbsoluteConstraints(10, 20, 200, 30));
        this.jLabel7.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel7.setText("Enzyme Name");
        this.jPanel2.add((Component)this.jLabel7, new AbsoluteConstraints(10, 0, 201, -1));
        this.jPanel3.setMaximumSize(new Dimension(210, Short.MAX_VALUE));
        this.jPanel3.setMinimumSize(new Dimension(210, 0));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new AbsoluteLayout());
        this.cmdRemSingle.setText("<<<< Remove");
        this.cmdRemSingle.setToolTipText("Remove selected enzyme(s) from list.");
        this.cmdRemSingle.setColorHot(new Color(204, 204, 255));
        this.cmdRemSingle.setColorNormal(new Color(240, 240, 240));
        this.cmdRemSingle.setColorPressed(new Color(204, 204, 255));
        this.cmdRemSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdRemSingleActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.cmdRemSingle, new AbsoluteConstraints(31, 48, 145, 36));
        this.cmdAddSingle.setText("Add >>>>");
        this.cmdAddSingle.setToolTipText("Add selected enzyme(s) to list.");
        this.cmdAddSingle.setColorHot(new Color(204, 204, 255));
        this.cmdAddSingle.setColorNormal(new Color(240, 240, 240));
        this.cmdAddSingle.setColorPressed(new Color(204, 204, 255));
        this.cmdAddSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdAddSingleActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.cmdAddSingle, new AbsoluteConstraints(31, 6, 145, 36));
        this.jPanel9.setBorder(BorderFactory.createTitledBorder("RE Information"));
        this.jPanel9.setOpaque(false);
        this.cmdRebase.setText("View REBASE Entry");
        this.cmdRebase.setToolTipText("Open the REBASE Entry for selected enzyme.");
        this.cmdRebase.setColorHot(new Color(204, 204, 255));
        this.cmdRebase.setColorNormal(new Color(240, 240, 240));
        this.cmdRebase.setColorPressed(new Color(204, 204, 255));
        this.cmdRebase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdRebaseActionPerformed(evt);
            }
        });
        this.infoDam.setBackground(new Color(255, 255, 255));
        this.infoDam.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoDam.setToolTipText("Information related to the selected enzyme's Dam methylation sensitivity.");
        this.infoDam.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoDam.setMaximumSize(new Dimension(39, 39));
        this.infoDam.setMinimumSize(new Dimension(39, 39));
        this.infoDcm.setBackground(new Color(255, 255, 255));
        this.infoDcm.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoDcm.setToolTipText("Information related to the selected enzyme's Dcm methylation sensitivity.");
        this.infoDcm.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoDcm.setMaximumSize(new Dimension(39, 39));
        this.infoDcm.setMinimumSize(new Dimension(39, 39));
        this.infoCpg.setBackground(new Color(255, 255, 255));
        this.infoCpg.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoCpg.setToolTipText("Information related to the selected enzyme's CpG methylation sensitivity.");
        this.infoCpg.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoCpg.setMaximumSize(new Dimension(39, 39));
        this.infoCpg.setMinimumSize(new Dimension(39, 39));
        this.infoMisc.setBackground(new Color(255, 255, 255));
        this.infoMisc.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoMisc.setToolTipText("Misc. information related to the selected enzyme's requirements.");
        this.infoMisc.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoMisc.setMaximumSize(new Dimension(39, 39));
        this.infoMisc.setMinimumSize(new Dimension(39, 39));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdRebase, -1, -1, Short.MAX_VALUE).addGroup(jPanel9Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.infoDam, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoDcm, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoCpg, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.infoMisc, -2, 39, -2))).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoDam, -2, 39, -2).addComponent(this.infoDcm, -2, 39, -2).addComponent(this.infoCpg, -2, 39, -2).addComponent(this.infoMisc, -2, 39, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.cmdRebase, -2, 36, -2).addContainerGap()));
        this.jPanel3.add((Component)this.jPanel9, new AbsoluteConstraints(6, 96, -1, -1));
        this.jPanel2.add((Component)this.jPanel3, new AbsoluteConstraints(230, 120, -1, -1));
        this.selectionTypeTabs.addTab("Manual Selection", this.jPanel2);
        this.jPanel4.setFont(new Font("Segoe UI", 0, 14));
        this.jPanel4.setLayout(new AbsoluteLayout());
        this.jLabel9.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel9.setText("Enzyme Name");
        this.jPanel4.add((Component)this.jLabel9, new AbsoluteConstraints(10, 50, 201, -1));
        this.txtNameMix.setFont(new Font("Segoe UI", 0, 14));
        this.txtNameMix.setToolTipText("Type in an enzyme's name to go to the first partial or full match.");
        this.txtNameMix.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmEnzymes.this.txtNameMixFocusGained(evt);
            }
        });
        this.jPanel4.add((Component)this.txtNameMix, new AbsoluteConstraints(10, 70, 200, 30));
        this.lstSelectableMix.setFont(new Font("Segoe UI", 0, 14));
        this.lstSelectableMix.setToolTipText("Selectable multiple enzymes and click Add to add to a new mix.");
        this.jScrollPane8.setViewportView(this.lstSelectableMix);
        this.jPanel4.add((Component)this.jScrollPane8, new AbsoluteConstraints(10, 110, 200, 400));
        this.jLabel5.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel5.setText("Enzyme Mix");
        this.jPanel4.add((Component)this.jLabel5, new AbsoluteConstraints(460, 0, 190, 22));
        this.lstSelectedMix.setFont(new Font("Segoe UI", 0, 14));
        this.lstSelectedMix.setToolTipText("Currently selected enzyme mixes.");
        this.lstSelectedMix.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmEnzymes.this.lstSelectedMixMouseClicked(evt);
            }
        });
        this.jScrollPane9.setViewportView(this.lstSelectedMix);
        this.jPanel4.add((Component)this.jScrollPane9, new AbsoluteConstraints(460, 20, 190, 490));
        this.jLabel13.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel13.setText("Manual / Custom Mixes");
        this.jPanel4.add((Component)this.jLabel13, new AbsoluteConstraints(10, 0, 201, -1));
        this.cmbUserMixLists.setFont(new Font("Segoe UI", 0, 14));
        this.cmbUserMixLists.setToolTipText("Toggle between manual selection of enzymes or selection from saved mix lists");
        this.cmbUserMixLists.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmbUserMixListsActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cmbUserMixLists, new AbsoluteConstraints(10, 20, 201, -1));
        this.jPanel11.setMaximumSize(new Dimension(210, Short.MAX_VALUE));
        this.jPanel11.setMinimumSize(new Dimension(210, 0));
        this.jPanel11.setOpaque(false);
        this.jPanel11.setLayout(new AbsoluteLayout());
        this.cmdRemMix.setText("<<<< Remove");
        this.cmdRemMix.setToolTipText("Remove selected enzyme mix(es) from list.");
        this.cmdRemMix.setColorHot(new Color(204, 204, 255));
        this.cmdRemMix.setColorNormal(new Color(240, 240, 240));
        this.cmdRemMix.setColorPressed(new Color(204, 204, 255));
        this.cmdRemMix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdRemMixActionPerformed(evt);
            }
        });
        this.jPanel11.add((Component)this.cmdRemMix, new AbsoluteConstraints(31, 48, 145, 36));
        this.cmdAddMix.setText("Add >>>>");
        this.cmdAddMix.setToolTipText("Add selected enzyme mix(es) to list.");
        this.cmdAddMix.setColorHot(new Color(204, 204, 255));
        this.cmdAddMix.setColorNormal(new Color(240, 240, 240));
        this.cmdAddMix.setColorPressed(new Color(204, 204, 255));
        this.cmdAddMix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdAddMixActionPerformed(evt);
            }
        });
        this.jPanel11.add((Component)this.cmdAddMix, new AbsoluteConstraints(31, 6, 145, 36));
        this.jPanel4.add((Component)this.jPanel11, new AbsoluteConstraints(230, 120, -1, -1));
        this.cmdEditUserMix.setIcon(new ImageIcon(this.getClass().getResource("/images24/Edit.png")));
        this.cmdEditUserMix.setToolTipText("Edit custom enzyme lists or show help.");
        this.cmdEditUserMix.setColorHot(new Color(204, 204, 255));
        this.cmdEditUserMix.setColorNormal(new Color(240, 240, 240));
        this.cmdEditUserMix.setColorPressed(new Color(204, 204, 255));
        this.cmdEditUserMix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdEditUserMixActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.cmdEditUserMix, new AbsoluteConstraints(220, 20, 30, 30));
        this.selectionTypeTabs.addTab("Enzyme Mix", this.jPanel4);
        this.jPanel6.setLayout(new AbsoluteLayout());
        this.lstSelectedCompEnds.setFont(new Font("Segoe UI", 0, 14));
        this.lstSelectedCompEnds.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstSelectedCompEnds.setToolTipText("Currently selected enzymes.");
        this.lstSelectedCompEnds.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmEnzymes.this.lstSelectedCompEndsMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.lstSelectedCompEnds);
        this.jPanel6.add((Component)this.jScrollPane3, new AbsoluteConstraints(460, 20, 190, 490));
        this.txtNameComp.setFont(new Font("Segoe UI", 0, 14));
        this.txtNameComp.setToolTipText("Type in an enzyme's name to go to the first partial or full match.");
        this.txtNameComp.setPreferredSize(new Dimension(72, 26));
        this.txtNameComp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmEnzymes.this.txtNameCompFocusGained(evt);
            }
        });
        this.jPanel6.add((Component)this.txtNameComp, new AbsoluteConstraints(10, 20, 200, 30));
        this.jLabel14.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel14.setText("Enzyme Name");
        this.jPanel6.add((Component)this.jLabel14, new AbsoluteConstraints(10, 0, 190, -1));
        this.lstCompatibleSrc.setFont(new Font("Segoe UI", 0, 14));
        this.lstCompatibleSrc.setSelectionMode(0);
        this.lstCompatibleSrc.setToolTipText("Select an enzyme to populate the list of enzymes with compatible sites.");
        this.lstCompatibleSrc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmEnzymes.this.lstCompatibleSrcMouseClicked(evt);
            }
        });
        this.lstCompatibleSrc.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FrmEnzymes.this.lstCompatibleSrcValueChanged(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.lstCompatibleSrc);
        this.jPanel6.add((Component)this.jScrollPane7, new AbsoluteConstraints(10, 60, 200, 400));
        this.jLabel15.setText("Enzyme Site Sequence");
        this.jPanel6.add((Component)this.jLabel15, new AbsoluteConstraints(10, 470, -1, -1));
        this.txtCompQry.setFont(new Font("Segoe UI", 0, 14));
        this.txtCompQry.setToolTipText("Restriction site sequence of the currently selected enzyme.");
        this.txtCompQry.setMaximumSize(new Dimension(Integer.MAX_VALUE, 26));
        this.jPanel6.add((Component)this.txtCompQry, new AbsoluteConstraints(10, 490, 201, -1));
        this.jLabel16.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel16.setText("Selected Enzymes");
        this.jPanel6.add((Component)this.jLabel16, new AbsoluteConstraints(460, 0, 201, -1));
        this.jLabel17.setText("Enzyme Site Sequence");
        this.jPanel6.add((Component)this.jLabel17, new AbsoluteConstraints(230, 470, -1, -1));
        this.txtSeqFoundComp.setFont(new Font("Segoe UI", 0, 14));
        this.txtSeqFoundComp.setToolTipText("Restriction site sequence of the currently selected compatible enzyme.");
        this.jPanel6.add((Component)this.txtSeqFoundComp, new AbsoluteConstraints(230, 490, 210, -1));
        this.lstCompatibleFound.setFont(new Font("Segoe UI", 0, 14));
        this.lstCompatibleFound.setToolTipText("List of selectable enzymes.  Multiple selections are allowed at once.");
        this.lstCompatibleFound.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmEnzymes.this.lstCompatibleFoundMouseClicked(evt);
            }
        });
        this.lstCompatibleFound.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FrmEnzymes.this.lstCompatibleFoundValueChanged(evt);
            }
        });
        this.jScrollPane10.setViewportView(this.lstCompatibleFound);
        this.jPanel6.add((Component)this.jScrollPane10, new AbsoluteConstraints(230, 20, 210, 260));
        this.jLabel18.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel18.setText("Compatible Enzymes");
        this.jPanel6.add((Component)this.jLabel18, new AbsoluteConstraints(230, 0, 210, -1));
        this.jPanel14.setMaximumSize(new Dimension(210, Short.MAX_VALUE));
        this.jPanel14.setMinimumSize(new Dimension(210, 0));
        this.jPanel14.setOpaque(false);
        this.jPanel14.setLayout(new AbsoluteLayout());
        this.cmdAddCompat.setText("Add >>>>");
        this.cmdAddCompat.setToolTipText("Add selected enzyme(s) to list.");
        this.cmdAddCompat.setColorHot(new Color(204, 204, 255));
        this.cmdAddCompat.setColorNormal(new Color(240, 240, 240));
        this.cmdAddCompat.setColorPressed(new Color(204, 204, 255));
        this.cmdAddCompat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdAddCompatActionPerformed(evt);
            }
        });
        this.jPanel14.add((Component)this.cmdAddCompat, new AbsoluteConstraints(30, 10, 145, 36));
        this.jPanel15.setBorder(BorderFactory.createTitledBorder("RE Information"));
        this.jPanel15.setOpaque(false);
        this.cmdRebase3.setText("View REBASE Entry");
        this.cmdRebase3.setToolTipText("Open the REBASE Entry for selected enzyme.");
        this.cmdRebase3.setColorHot(new Color(204, 204, 255));
        this.cmdRebase3.setColorNormal(new Color(240, 240, 240));
        this.cmdRebase3.setColorPressed(new Color(204, 204, 255));
        this.cmdRebase3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdRebase3ActionPerformed(evt);
            }
        });
        this.infoDam3.setBackground(new Color(255, 255, 255));
        this.infoDam3.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoDam3.setToolTipText("Information related to the selected enzyme's Dam methylation sensitivity.");
        this.infoDam3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoDam3.setMaximumSize(new Dimension(39, 39));
        this.infoDam3.setMinimumSize(new Dimension(39, 39));
        this.infoDcm3.setBackground(new Color(255, 255, 255));
        this.infoDcm3.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoDcm3.setToolTipText("Information related to the selected enzyme's Dcm methylation sensitivity.");
        this.infoDcm3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoDcm3.setMaximumSize(new Dimension(39, 39));
        this.infoDcm3.setMinimumSize(new Dimension(39, 39));
        this.infoCpg3.setBackground(new Color(255, 255, 255));
        this.infoCpg3.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoCpg3.setToolTipText("Information related to the selected enzyme's CpG methylation sensitivity.");
        this.infoCpg3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoCpg3.setMaximumSize(new Dimension(39, 39));
        this.infoCpg3.setMinimumSize(new Dimension(39, 39));
        this.infoMisc3.setBackground(new Color(255, 255, 255));
        this.infoMisc3.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoMisc3.setToolTipText("Misc. information related to the selected enzyme's requirements.");
        this.infoMisc3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoMisc3.setMaximumSize(new Dimension(39, 39));
        this.infoMisc3.setMinimumSize(new Dimension(39, 39));
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdRebase3, -1, -1, Short.MAX_VALUE).addGroup(jPanel15Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.infoDam3, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoDcm3, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoCpg3, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.infoMisc3, -2, 39, -2))).addContainerGap()));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoDam3, -2, 39, -2).addComponent(this.infoDcm3, -2, 39, -2).addComponent(this.infoCpg3, -2, 39, -2).addComponent(this.infoMisc3, -2, 39, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.cmdRebase3, -2, 36, -2).addContainerGap()));
        this.jPanel14.add((Component)this.jPanel15, new AbsoluteConstraints(0, 50, -1, -1));
        this.jPanel6.add((Component)this.jPanel14, new AbsoluteConstraints(230, 285, -1, 180));
        this.selectionTypeTabs.addTab("Compatible Ends", this.jPanel6);
        this.jPanel7.setLayout(new AbsoluteLayout());
        this.txtMinCuts.setFont(new Font("Segoe UI", 0, 14));
        this.txtMinCuts.setHorizontalAlignment(0);
        this.txtMinCuts.setText("1");
        this.txtMinCuts.setToolTipText("Minimum cuts in the interval required for an enzyme to be considered valid.");
        this.jPanel7.add((Component)this.txtMinCuts, new AbsoluteConstraints(32, 32, 108, -1));
        this.txtMaxCuts.setFont(new Font("Segoe UI", 0, 14));
        this.txtMaxCuts.setHorizontalAlignment(0);
        this.txtMaxCuts.setText("1");
        this.txtMaxCuts.setToolTipText("Maximum cuts in the interval required for an enzyme to be considered valid.");
        this.jPanel7.add((Component)this.txtMaxCuts, new AbsoluteConstraints(146, 32, 108, -1));
        this.txtMaxBp.setFont(new Font("Segoe UI", 0, 14));
        this.txtMaxBp.setHorizontalAlignment(0);
        this.txtMaxBp.setText("1");
        this.txtMaxBp.setToolTipText("Last base position of the validation interval.");
        this.jPanel7.add((Component)this.txtMaxBp, new AbsoluteConstraints(439, 32, 108, -1));
        this.txtMinBp.setFont(new Font("Segoe UI", 0, 14));
        this.txtMinBp.setHorizontalAlignment(0);
        this.txtMinBp.setText("1");
        this.txtMinBp.setToolTipText("First base position of the validation interval.");
        this.jPanel7.add((Component)this.txtMinBp, new AbsoluteConstraints(325, 32, 108, -1));
        this.jLabel2.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Min. Cuts");
        this.jPanel7.add((Component)this.jLabel2, new AbsoluteConstraints(32, 6, 108, -1));
        this.jLabel10.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setText("Max. Cuts");
        this.jPanel7.add((Component)this.jLabel10, new AbsoluteConstraints(146, 6, 108, -1));
        this.jLabel11.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel11.setHorizontalAlignment(0);
        this.jLabel11.setText("Stop");
        this.jPanel7.add((Component)this.jLabel11, new AbsoluteConstraints(439, 6, 108, -1));
        this.jLabel12.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel12.setHorizontalAlignment(0);
        this.jLabel12.setText("Start");
        this.jPanel7.add((Component)this.jLabel12, new AbsoluteConstraints(325, 6, 108, -1));
        this.tblFreq.setRowSelect(true);
        this.jPanel7.add((Component)this.tblFreq, new AbsoluteConstraints(32, 76, 515, 330));
        this.cmdAddFreq.setIcon(new ImageIcon(this.getClass().getResource("/images24/PLUS_1.png")));
        this.cmdAddFreq.setText("Add");
        this.cmdAddFreq.setToolTipText("Add as a new cut site frequency filter");
        this.cmdAddFreq.setColorHot(new Color(204, 204, 255));
        this.cmdAddFreq.setColorNormal(new Color(240, 240, 240));
        this.cmdAddFreq.setColorPressed(new Color(204, 204, 255));
        this.cmdAddFreq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdAddFreqActionPerformed(evt);
            }
        });
        this.jPanel7.add((Component)this.cmdAddFreq, new AbsoluteConstraints(565, 76, 70, 60));
        this.cmdUpdateFreq.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus_Blue.png")));
        this.cmdUpdateFreq.setText("Update");
        this.cmdUpdateFreq.setToolTipText("Update selected cut site frequency filter with the new values.");
        this.cmdUpdateFreq.setColorHot(new Color(204, 204, 255));
        this.cmdUpdateFreq.setColorNormal(new Color(240, 240, 240));
        this.cmdUpdateFreq.setColorPressed(new Color(204, 204, 255));
        this.cmdUpdateFreq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdUpdateFreqActionPerformed(evt);
            }
        });
        this.jPanel7.add((Component)this.cmdUpdateFreq, new AbsoluteConstraints(565, 142, 70, 60));
        this.cmdRemFreq.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel_1.png")));
        this.cmdRemFreq.setText("Remove");
        this.cmdRemFreq.setToolTipText("Remove selected cut site frequency filter.");
        this.cmdRemFreq.setColorHot(new Color(204, 204, 255));
        this.cmdRemFreq.setColorNormal(new Color(240, 240, 240));
        this.cmdRemFreq.setColorPressed(new Color(204, 204, 255));
        this.cmdRemFreq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdRemFreqActionPerformed(evt);
            }
        });
        this.jPanel7.add((Component)this.cmdRemFreq, new AbsoluteConstraints(565, 208, 70, 60));
        this.cmdHelpFilter.setIcon(new ImageIcon(this.getClass().getResource("/images24/QUESTION.png")));
        this.cmdHelpFilter.setToolTipText("Click for help.");
        this.cmdHelpFilter.setColorHot(new Color(204, 204, 255));
        this.cmdHelpFilter.setColorNormal(new Color(240, 240, 240));
        this.cmdHelpFilter.setColorPressed(new Color(204, 204, 255));
        this.cmdHelpFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdHelpFilterActionPerformed(evt);
            }
        });
        this.jPanel7.add((Component)this.cmdHelpFilter, new AbsoluteConstraints(570, 30, -1, -1));
        this.selectionTypeTabs.addTab("Site Frequency", this.jPanel7);
        this.jPanel8.setLayout(new AbsoluteLayout());
        this.jLabel4.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel4.setText("Selected Enzymes");
        this.jPanel8.add((Component)this.jLabel4, new AbsoluteConstraints(460, 0, 190, -1));
        this.lstSelectedSite.setFont(new Font("Segoe UI", 0, 14));
        this.lstSelectedSite.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstSelectedSite.setToolTipText("Currently selected enzymes.");
        this.lstSelectedSite.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmEnzymes.this.lstSelectedSiteMouseClicked(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.lstSelectedSite);
        this.jPanel8.add((Component)this.jScrollPane4, new AbsoluteConstraints(460, 20, 190, 490));
        this.txtSearchSeq.setFont(new Font("Segoe UI", 0, 14));
        this.txtSearchSeq.setToolTipText("Enter a complete or partial restriction site sequence and click Exact or Partial Search to populate with enzymes matching the sequence.");
        this.txtSearchSeq.setPreferredSize(new Dimension(72, 26));
        this.txtSearchSeq.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmEnzymes.this.txtSearchSeqFocusGained(evt);
            }
        });
        this.jPanel8.add((Component)this.txtSearchSeq, new AbsoluteConstraints(10, 20, 200, 30));
        this.jLabel19.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel19.setText("Sequence");
        this.jPanel8.add((Component)this.jLabel19, new AbsoluteConstraints(10, 0, 190, -1));
        this.lstSearchSeq.setFont(new Font("Segoe UI", 0, 14));
        this.lstSearchSeq.setToolTipText("List of selectable enzymes.  Multiple selections are allowed at once.");
        this.lstSearchSeq.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmEnzymes.this.lstSearchSeqMouseClicked(evt);
            }
        });
        this.lstSearchSeq.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FrmEnzymes.this.lstSearchSeqValueChanged(evt);
            }
        });
        this.jScrollPane11.setViewportView(this.lstSearchSeq);
        this.jPanel8.add((Component)this.jScrollPane11, new AbsoluteConstraints(10, 60, 200, 400));
        this.txtFoundSite.setFont(new Font("Segoe UI", 0, 14));
        this.txtFoundSite.setToolTipText("Restriction site sequence of the currently selected enzyme.");
        this.txtFoundSite.setMaximumSize(new Dimension(Integer.MAX_VALUE, 26));
        this.jPanel8.add((Component)this.txtFoundSite, new AbsoluteConstraints(10, 490, 201, -1));
        this.jPanel5.setMaximumSize(new Dimension(210, Short.MAX_VALUE));
        this.jPanel5.setMinimumSize(new Dimension(210, 0));
        this.jPanel5.setOpaque(false);
        this.jPanel5.setLayout(new AbsoluteLayout());
        this.cmdRemSingle2.setText("<<<< Remove");
        this.cmdRemSingle2.setToolTipText("Remove selected enzyme(s) from list.");
        this.cmdRemSingle2.setColorHot(new Color(204, 204, 255));
        this.cmdRemSingle2.setColorNormal(new Color(240, 240, 240));
        this.cmdRemSingle2.setColorPressed(new Color(204, 204, 255));
        this.cmdRemSingle2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdRemSingle2ActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.cmdRemSingle2, new AbsoluteConstraints(31, 48, 145, 36));
        this.cmdAddSingle2.setText("Add >>>>");
        this.cmdAddSingle2.setToolTipText("Add selected enzyme(s) to list.");
        this.cmdAddSingle2.setColorHot(new Color(204, 204, 255));
        this.cmdAddSingle2.setColorNormal(new Color(240, 240, 240));
        this.cmdAddSingle2.setColorPressed(new Color(204, 204, 255));
        this.cmdAddSingle2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdAddSingle2ActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.cmdAddSingle2, new AbsoluteConstraints(31, 6, 145, 36));
        this.jPanel13.setBorder(BorderFactory.createTitledBorder("RE Information"));
        this.jPanel13.setOpaque(false);
        this.cmdRebase1.setText("View REBASE Entry");
        this.cmdRebase1.setToolTipText("Open the REBASE Entry for selected enzyme.");
        this.cmdRebase1.setColorHot(new Color(204, 204, 255));
        this.cmdRebase1.setColorNormal(new Color(240, 240, 240));
        this.cmdRebase1.setColorPressed(new Color(204, 204, 255));
        this.cmdRebase1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdRebase1ActionPerformed(evt);
            }
        });
        this.infoDam1.setBackground(new Color(255, 255, 255));
        this.infoDam1.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoDam1.setToolTipText("Information related to the selected enzyme's Dam methylation sensitivity.");
        this.infoDam1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoDam1.setMaximumSize(new Dimension(39, 39));
        this.infoDam1.setMinimumSize(new Dimension(39, 39));
        this.infoDcm1.setBackground(new Color(255, 255, 255));
        this.infoDcm1.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoDcm1.setToolTipText("Information related to the selected enzyme's Dcm methylation sensitivity.");
        this.infoDcm1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoDcm1.setMaximumSize(new Dimension(39, 39));
        this.infoDcm1.setMinimumSize(new Dimension(39, 39));
        this.infoCpg1.setBackground(new Color(255, 255, 255));
        this.infoCpg1.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoCpg1.setToolTipText("Information related to the selected enzyme's CpG methylation sensitivity.");
        this.infoCpg1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoCpg1.setMaximumSize(new Dimension(39, 39));
        this.infoCpg1.setMinimumSize(new Dimension(39, 39));
        this.infoMisc1.setBackground(new Color(255, 255, 255));
        this.infoMisc1.setIcon(new ImageIcon(this.getClass().getResource("/images39/infowhite.png")));
        this.infoMisc1.setToolTipText("Misc. information related to the selected enzyme's requirements.");
        this.infoMisc1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.infoMisc1.setMaximumSize(new Dimension(39, 39));
        this.infoMisc1.setMinimumSize(new Dimension(39, 39));
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdRebase1, -1, -1, Short.MAX_VALUE).addGroup(jPanel13Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.infoDam1, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoDcm1, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoCpg1, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.infoMisc1, -2, 39, -2))).addContainerGap()));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoDam1, -2, 39, -2).addComponent(this.infoDcm1, -2, 39, -2).addComponent(this.infoCpg1, -2, 39, -2).addComponent(this.infoMisc1, -2, 39, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.cmdRebase1, -2, 36, -2).addContainerGap()));
        this.jPanel5.add((Component)this.jPanel13, new AbsoluteConstraints(6, 96, -1, -1));
        this.jPanel8.add((Component)this.jPanel5, new AbsoluteConstraints(230, 120, -1, -1));
        this.cmdSearchPartial.setIcon(new ImageIcon(this.getClass().getResource("/images24/Search.png")));
        this.cmdSearchPartial.setText("Partial Search");
        this.cmdSearchPartial.setToolTipText("Find enzymes with partial or exact matches to the specified sequence.");
        this.cmdSearchPartial.setColorHot(new Color(204, 204, 255));
        this.cmdSearchPartial.setColorNormal(new Color(240, 240, 240));
        this.cmdSearchPartial.setColorPressed(new Color(204, 204, 255));
        this.cmdSearchPartial.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdSearchPartial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdSearchPartialActionPerformed(evt);
            }
        });
        this.jPanel8.add((Component)this.cmdSearchPartial, new AbsoluteConstraints(260, 60, 150, 36));
        this.cmdSearchExact.setIcon(new ImageIcon(this.getClass().getResource("/images24/Search.png")));
        this.cmdSearchExact.setText("Exact Search");
        this.cmdSearchExact.setToolTipText("Find enzymes with exact matches to the specified sequence.");
        this.cmdSearchExact.setColorHot(new Color(204, 204, 255));
        this.cmdSearchExact.setColorNormal(new Color(240, 240, 240));
        this.cmdSearchExact.setColorPressed(new Color(204, 204, 255));
        this.cmdSearchExact.setHorizontalAlignment(2);
        this.cmdSearchExact.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdSearchExact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEnzymes.this.cmdSearchExactActionPerformed(evt);
            }
        });
        this.jPanel8.add((Component)this.cmdSearchExact, new AbsoluteConstraints(260, 20, 150, 36));
        this.jLabel20.setText("Enzyme Site Sequence");
        this.jPanel8.add((Component)this.jLabel20, new AbsoluteConstraints(10, 470, -1, -1));
        this.selectionTypeTabs.addTab("Search By Site", this.jPanel8);
        this.jScrollPane5.setViewportView(this.selectionTypeTabs);
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane5, -2, 668, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.statusLabel, -1, 940, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane5)).addGap(0, 0, 0).addComponent(this.statusLabel, -2, -1, -2)));
        this.pack();
    }

    private void lstSelectableSingleValueChanged(ListSelectionEvent evt) {
        int index = this.lstSelectableSingle.getSelectedIndex();
        if (index > -1) {
            ProjectEnzyme e = this.listModelSelectable.getElementAt(index);
            this.showEnzymeInfo(e.enzyme, this.infoDam, this.infoDcm, this.infoCpg, this.infoMisc);
            this.txtSeqSingle.setText(e.enzyme.sequence);
        }
    }

    private void lstSelectableSingleMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.cmdAddSingleActionPerformed(null);
        }
    }

    private void cmdAddSingleActionPerformed(ActionEvent evt) {
        this.addFrom(this.lstSelectableSingle, this.listModelSelectable);
        this.txtNameSingle.selectAll();
    }

    private void cmdRemSingleActionPerformed(ActionEvent evt) {
        this.removeSelected(this.lstSelectedSingle);
    }

    private void checkAction(ActionEvent evt) {
        this.populateSelectableModel();
    }

    private void txtMinFocusLost(FocusEvent evt) {
        if (this.chkMin.isSelected()) {
            this.populateSelectableModel();
        }
    }

    private void txtMaxFocusLost(FocusEvent evt) {
        if (this.chkMax.isSelected()) {
            this.populateSelectableModel();
        }
    }

    private void chkMinActionPerformed(ActionEvent evt) {
        this.txtMin.setEnabled(this.chkMin.isSelected());
        this.populateSelectableModel();
    }

    private void chkMaxActionPerformed(ActionEvent evt) {
        this.txtMax.enable(this.chkMax.isSelected());
        this.populateSelectableModel();
    }

    private void glossyButton1ActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void glossyButton2ActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmbUserListsActionPerformed(ActionEvent evt) {
        BinaryChain<ProjectEnzyme> enzymes = this.getProject().defaultEnzymes;
        if (this.cmbUserLists.getSelectedIndex() < 1) {
            this.activeEnzymes = enzymes;
        } else {
            UserList list = (UserList)((DefaultComboBoxModel)this.cmbUserLists.getModel()).getSelectedItem();
            if (list.enzymes != null && list.enzymes.length > 0) {
                this.activeEnzymes = new BinaryChain();
                for (String eName : list.enzymes) {
                    ProjectEnzyme e = enzymes.get(eName);
                    if (e == null) continue;
                    this.activeEnzymes.add(e, e.enzyme.name);
                }
            }
        }
        this.populateSelectableModel();
    }

    private void cmbUserMixListsActionPerformed(ActionEvent evt) {
        if (this.cmbUserMixLists.getSelectedIndex() < 1) {
            this.lstSelectableMix.setModel(this.listModelSelectable);
            this.txtNameMix.setEnabled(true);
        } else {
            EnzymeMixList mixList = (EnzymeMixList)this.cmbUserMixLists.getSelectedItem();
            if (mixList == null) {
                this.populateMixCombo();
                this.cmbUserMixLists.setSelectedIndex(0);
                return;
            }
            this.listModelSelectableMix.clear();
            for (EnzymeMix mix : mixList.enzymeMixes) {
                this.listModelSelectableMix.addElement(mix);
            }
            this.lstSelectableMix.setModel(this.listModelSelectableMix);
            this.txtNameMix.setEnabled(false);
        }
    }

    private EnzymeFilter makeFilter() {
        EnzymeFilter filter = new EnzymeFilter();
        filter.minCuts = Integer.parseInt(this.txtMinCuts.getText());
        filter.maxCuts = Integer.parseInt(this.txtMaxCuts.getText());
        filter.minBp = Integer.parseInt(this.txtMinBp.getText());
        filter.maxBp = Integer.parseInt(this.txtMaxBp.getText());
        return filter;
    }

    private void cmdAddFreqActionPerformed(ActionEvent evt) {
        this.enzymeFilterModel.addRow(this.makeFilter());
        this.txtMinCuts.requestFocus();
    }

    private void cmdUpdateFreqActionPerformed(ActionEvent evt) {
        int row = this.tblFreq.getSelectionRowStart();
        if (row == -1) {
            return;
        }
        this.enzymeFilterModel.setRow(row, this.makeFilter());
        this.txtMinCuts.requestFocus();
    }

    private void cmdRemFreqActionPerformed(ActionEvent evt) {
        int row = this.tblFreq.getSelectionRowStart();
        if (row == -1) {
            return;
        }
        this.enzymeFilterModel.removeRow(row);
        this.txtMinCuts.requestFocus();
    }

    private void cmdRemMixActionPerformed(ActionEvent evt) {
        int[] selIndex = this.lstSelectedMix.getSelectedIndices();
        for (int x = selIndex.length - 1; x >= 0; --x) {
            EnzymeMix e = this.listModelSelectedMixes.getElementAt(selIndex[x]);
            if (e == null) continue;
            this.listModelSelectedMixes.remove(e.getName());
        }
    }

    private void cmdAddMixActionPerformed(ActionEvent evt) {
        int[] indices = this.lstSelectableMix.getSelectedIndices();
        if (indices == null || indices.length == 0) {
            return;
        }
        if (this.lstSelectableMix.getModel() == this.listModelSelectable) {
            EnzymeMix mix = new EnzymeMix();
            for (int x = 0; x < indices.length; ++x) {
                mix.addEnzyme(this.listModelSelectable.elementAt((int)indices[x]).enzyme.name);
            }
            this.listModelSelectedMixes.add(mix, false);
        } else if (this.lstSelectableMix.getModel() == this.listModelSelectableMix) {
            for (int x = 0; x < indices.length; ++x) {
                this.listModelSelectedMixes.add(this.listModelSelectableMix.elementAt(indices[x]), false);
            }
        }
        this.listModelSelectedMixes.sort(sortEnzymeMix, true);
    }

    private void lstCompatibleSrcValueChanged(ListSelectionEvent evt) {
        int index = this.lstCompatibleSrc.getSelectedIndex();
        this.listModelFoundCompatible.clear();
        if (index == -1) {
            this.txtCompQry.setText("");
            return;
        }
        ProjectEnzyme e = this.listModelSelectable.getElementAt(index);
        if (e == null) {
            return;
        }
        this.showEnzymeInfo(e.enzyme, this.infoDam3, this.infoDcm3, this.infoCpg3, this.infoMisc3);
        this.txtCompQry.setText(e.enzyme.sequence);
        String oH = this.getOverhang(e.enzyme.sequence);
        for (int x = 0; x < this.listModelSelectable.getSize(); ++x) {
            ProjectEnzyme qEL;
            if (x == index) continue;
            boolean match = false;
            ProjectEnzyme qE = qEL = this.listModelSelectable.getElementAt(x);
            if (e.enzyme.overhang != qE.enzyme.overhang) {
                match = false;
            } else if (e.enzyme.overhang == 0) {
                match = true;
            } else {
                String qOH = this.getOverhang(this.listModelSelectable.getElementAt((int)x).enzyme.sequence);
                if (oH.length() != qOH.length()) {
                    match = false;
                } else if (oH.equals(qOH)) {
                    match = true;
                } else if ((e.enzyme.degenerate || qE.enzyme.degenerate) && this.compareDegenerate(oH, qOH)) {
                    match = true;
                }
            }
            if (!match) continue;
            this.listModelFoundCompatible.addElement(qEL);
        }
    }

    private boolean compareDegenerate(String seq1, String seq2) {
        for (int x = 0; x < seq1.length(); ++x) {
            char c2;
            char c1 = seq1.charAt(x);
            if (DNA.compare(c1, c2 = seq2.charAt(x))) continue;
            return false;
        }
        return true;
    }

    private String getOverhang(String seq) {
        String oh = "";
        int cut1 = -1;
        int cut2 = -1;
        for (int x = 0; x < seq.length(); ++x) {
            char chr = seq.charAt(x);
            if (chr != '.' && chr != '\'') continue;
            if (cut1 == -1) {
                cut1 = x;
                continue;
            }
            cut2 = x;
            if (cut1 == cut2 - 1) {
                return "";
            }
            oh = seq.substring(cut1 + 1, cut2);
            break;
        }
        return oh;
    }

    private void lstCompatibleFoundMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.cmdAddCompatActionPerformed(null);
        }
    }

    private void lstCompatibleFoundValueChanged(ListSelectionEvent evt) {
        int index = this.lstCompatibleFound.getSelectedIndex();
        if (index == -1) {
            this.txtSeqFoundComp.setText("");
            return;
        }
        ProjectEnzyme e = this.listModelFoundCompatible.getElementAt(index);
        this.txtSeqFoundComp.setText(e.enzyme.sequence);
    }

    private void lstSearchSeqValueChanged(ListSelectionEvent evt) {
        int index = this.lstSearchSeq.getSelectedIndex();
        if (index > -1) {
            ProjectEnzyme e = this.listModelFoundMatch.getElementAt(index);
            this.txtFoundSite.setText(e.enzyme.sequence);
            this.showEnzymeInfo(e.enzyme, this.infoDam1, this.infoDcm1, this.infoCpg1, this.infoMisc1);
        }
    }

    private void cmdRemSingle2ActionPerformed(ActionEvent evt) {
        this.removeSelected(this.lstSelectedSite);
    }

    private void removeSelected(JList list) {
        int[] selIndex = list.getSelectedIndices();
        for (int x = selIndex.length - 1; x >= 0; --x) {
            ProjectEnzyme e = this.listModelSelected.getElementAt(selIndex[x]);
            if (e == null) continue;
            this.listModelSelected.remove(e.enzyme.name);
        }
    }

    private void addFrom(JList list, DefaultListModel<ProjectEnzyme> model) {
        int[] selIndex = list.getSelectedIndices();
        for (int x = 0; x < selIndex.length; ++x) {
            ProjectEnzyme e = model.getElementAt(selIndex[x]);
            if (e == null) continue;
            this.listModelSelected.add(e, e.enzyme.name);
        }
        this.listModelSelected.sort(sortEnzyme);
    }

    private void cmdAddSingle2ActionPerformed(ActionEvent evt) {
        this.addFrom(this.lstSearchSeq, this.listModelFoundMatch);
    }

    private void cmdSearchPartialActionPerformed(ActionEvent evt) {
        this.findMatch(false);
    }

    private void cmdSearchExactActionPerformed(ActionEvent evt) {
        this.findMatch(true);
    }

    private void lstSearchSeqMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.cmdAddSingle2ActionPerformed(null);
        }
    }

    private void lstCompatibleSrcMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.cmdAddCompatActionPerformed(null);
        }
    }

    private void cmdRebase1ActionPerformed(ActionEvent evt) {
        this.openREBASE(this.lstSearchSeq, this.listModelFoundMatch);
    }

    private void cmdRebaseActionPerformed(ActionEvent evt) {
        this.openREBASE(this.lstSelectableSingle, this.listModelSelectable);
    }

    private void openREBASE(JList list, DefaultListModel<ProjectEnzyme> model) {
        int index = list.getSelectedIndex();
        if (index > -1) {
            Enzyme e = model.getElementAt((int)index).enzyme;
            String url = "http://rebase.neb.com/cgi-bin/reb_get.pl?enzname=" + e.name;
            try {
                Desktop.getDesktop().browse(new URL(url).toURI());
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException | URISyntaxException ex) {
                Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void cmdAddCompatActionPerformed(ActionEvent evt) {
        this.addFrom(this.lstCompatibleFound, this.listModelFoundCompatible);
    }

    private void cmdRebase3ActionPerformed(ActionEvent evt) {
        this.openREBASE(this.lstCompatibleFound, this.listModelFoundCompatible);
    }

    private void cmdEditUserListActionPerformed(ActionEvent evt) {
        int index = this.cmbUserLists.getSelectedIndex();
        int selCount = this.listModelSelected.getSize();
        JPopupMenu menu = new JPopupMenu();
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        sep.setToolTipText("New list options");
        menu.add(sep);
        sep.addMouseListener(this.statusLabelMouseListener);
        JMenuItem menuItem = new JMenuItem("Add selected enzymes as a new list");
        menu.add(menuItem);
        menuItem.setEnabled(selCount > 0);
        menuItem.setToolTipText("Adds the currently selected enzymes as a new user list.");
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName;
                block3: {
                    newName = "New List";
                    do {
                        if ((newName = JOptionPanes.showInputDialog(FrmEnzymes.this, "Enter new list name", "Create a new user enzymes list", 3, null, null, newName)) == null || newName.length() == 0) {
                            return;
                        }
                        if (!DefaultLibraries.userLibrary.userLists.containsKey(newName)) break block3;
                    } while (JOptionPanes.showConfirmDialog((Component)FrmEnzymes.this, (Object)"A user list by that name already exists.", "Error.  List exists", 2) == 0);
                    return;
                }
                UserList list = new UserList();
                list.name = newName;
                DefaultLibraries.userLibrary.userLists.add(list);
                list.enzymes = new String[FrmEnzymes.this.listModelSelected.getSize()];
                for (int x = 0; x < FrmEnzymes.this.listModelSelected.getSize(); ++x) {
                    list.enzymes[x] = ((ProjectEnzyme)((FrmEnzymes)FrmEnzymes.this).listModelSelected.getElementAt((int)x)).enzyme.name;
                }
                FrmEnzymes.this.populateUserListCombo();
                FrmEnzymes.this.cmbUserLists.setSelectedItem(list);
                DefaultLibraries.userLibrary.setChanged(true);
            }
        });
        sep = new JPopupMenu.Separator();
        sep.setToolTipText("Selected list options");
        sep.addMouseListener(this.statusLabelMouseListener);
        menu.add(sep);
        menuItem = new JMenuItem("Rename selected enzymes list");
        menu.add(menuItem);
        menuItem.setEnabled(index > 0);
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.setToolTipText("Rename the currently selected user list.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = FrmEnzymes.this.cmbUserLists.getSelectedIndex();
                if (selIndex < 1) {
                    return;
                }
                UserList currentList = (UserList)FrmEnzymes.this.cmbUserLists.getModel().getSelectedItem();
                String newName = currentList.name;
                if ((newName = JOptionPanes.showInputDialog(FrmEnzymes.this, "Enter a new name", "Rename user list", 3, null, null, newName)) != null && newName.length() > 0 && !newName.equals(currentList.name)) {
                    DefaultLibraries.userLibrary.userLists.remove(currentList.name);
                    currentList.name = newName;
                    DefaultLibraries.userLibrary.userLists.add(currentList);
                    FrmEnzymes.this.populateUserListCombo();
                    FrmEnzymes.this.cmbUserLists.setSelectedItem(currentList);
                    DefaultLibraries.userLibrary.setChanged(true);
                }
            }
        });
        menuItem = new JMenuItem("Update current list");
        menu.add(menuItem);
        menuItem.setEnabled(index > 0);
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.setToolTipText("Updates the currently selected list to contain only the currently selected enzymes.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = FrmEnzymes.this.cmbUserLists.getSelectedIndex();
                if (selIndex > 0 && JOptionPanes.showConfirmDialog(FrmEnzymes.this, "Update the user list to contain the selected enzymes?") == 0) {
                    UserList currentList = (UserList)FrmEnzymes.this.cmbUserLists.getModel().getSelectedItem();
                    currentList.enzymes = new String[FrmEnzymes.this.listModelSelected.getSize()];
                    for (int x = 0; x < FrmEnzymes.this.listModelSelected.getSize(); ++x) {
                        currentList.enzymes[x] = ((ProjectEnzyme)((FrmEnzymes)FrmEnzymes.this).listModelSelected.getElementAt((int)x)).enzyme.name;
                    }
                    FrmEnzymes.this.cmbUserLists.setSelectedIndex(selIndex);
                    DefaultLibraries.userLibrary.setChanged(true);
                }
            }
        });
        menuItem = new JMenuItem("Delete selected enzymes list");
        menu.add(menuItem);
        menuItem.setEnabled(index > 0);
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.setToolTipText("Delete the currently selected user list.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = FrmEnzymes.this.cmbUserLists.getSelectedIndex();
                if (selIndex < 1) {
                    return;
                }
                if (JOptionPanes.showConfirmDialog(FrmEnzymes.this, "Really remove this user list?") == 0) {
                    UserList currentList = (UserList)FrmEnzymes.this.cmbUserLists.getModel().getSelectedItem();
                    DefaultLibraries.userLibrary.userLists.remove(currentList.name);
                    FrmEnzymes.this.cmbUserLists.removeItemAt(selIndex);
                    FrmEnzymes.this.cmbUserLists.setSelectedIndex(0);
                    DefaultLibraries.userLibrary.setChanged(true);
                }
            }
        });
        menuItem = new JMenuItem("Help");
        menu.add(menuItem);
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.setToolTipText("Click for help with this item.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PLOTJ)FrmEnzymes.this.getParent()).showHelp("re_userlist");
            }
        });
        menu.show(this.cmdEditUserList, 0, this.cmdEditUserList.getHeight());
    }

    private void cmdEditUserMixActionPerformed(ActionEvent evt) {
        int index = this.cmbUserMixLists.getSelectedIndex();
        int selCount = this.listModelSelectedMixes.getSize();
        JPopupMenu menu = new JPopupMenu();
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        sep.setToolTipText("New mix list options");
        menu.add(sep);
        sep.addMouseListener(this.statusLabelMouseListener);
        JMenuItem menuItem = new JMenuItem("Add selected enzyme mixes as a new custom mix");
        menu.add(menuItem);
        menuItem.setEnabled(selCount > 0);
        menuItem.setToolTipText("Adds the currently selected enzyme mixes as a new custom mix list.");
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName;
                block3: {
                    newName = "New List";
                    do {
                        if ((newName = JOptionPanes.showInputDialog(FrmEnzymes.this, "Enter new mix list name", "Create a new user enzyme mix list", 3, null, null, newName)) == null || newName.length() == 0) {
                            return;
                        }
                        if (!DefaultLibraries.userLibrary.userMixeLists.containsKey(newName)) break block3;
                    } while (JOptionPanes.showConfirmDialog((Component)FrmEnzymes.this, (Object)"An enzyme mix list by that name already exists.", "Error.  List exists", 2) == 0);
                    return;
                }
                EnzymeMixList list = new EnzymeMixList();
                list.setName(newName);
                DefaultLibraries.userLibrary.userMixeLists.add(list);
                list.enzymeMixes.clear();
                for (int x = 0; x < FrmEnzymes.this.listModelSelectedMixes.getSize(); ++x) {
                    list.enzymeMixes.put((EnzymeMix)FrmEnzymes.this.listModelSelectedMixes.getElementAt(x));
                }
                FrmEnzymes.this.populateMixCombo();
                FrmEnzymes.this.cmbUserMixLists.setSelectedItem(list);
                DefaultLibraries.userLibrary.setChanged(true);
            }
        });
        sep = new JPopupMenu.Separator();
        sep.setToolTipText("Selected list options");
        sep.addMouseListener(this.statusLabelMouseListener);
        menu.add(sep);
        menuItem = new JMenuItem("Rename selected enzyme mix list");
        menu.add(menuItem);
        menuItem.setEnabled(index > 0);
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.setToolTipText("Rename the currently selected enzyme mix list.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = FrmEnzymes.this.cmbUserMixLists.getSelectedIndex();
                if (selIndex < 1) {
                    return;
                }
                EnzymeMixList currentList = (EnzymeMixList)FrmEnzymes.this.comboModelMix.getSelectedItem();
                if (currentList == null || currentList == manualMixListItem) {
                    return;
                }
                String newName = currentList.getName();
                if ((newName = JOptionPanes.showInputDialog(FrmEnzymes.this, "Enter a new name", "Rename mix list", 3, null, null, newName)) != null && newName.length() > 0 && !newName.equals(currentList.getName())) {
                    DefaultLibraries.userLibrary.userMixeLists.remove(currentList.getName());
                    currentList.setName(newName);
                    DefaultLibraries.userLibrary.userMixeLists.add(currentList);
                    FrmEnzymes.this.populateMixCombo();
                    FrmEnzymes.this.cmbUserMixLists.setSelectedItem(currentList.getName());
                    DefaultLibraries.userLibrary.setChanged(true);
                }
            }
        });
        menuItem = new JMenuItem("Update current mix list");
        menu.add(menuItem);
        menuItem.setEnabled(index > 0);
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.setToolTipText("Updates the current mix list to contain only the currently selected enzyme mixes.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = FrmEnzymes.this.cmbUserMixLists.getSelectedIndex();
                if (selIndex > 0 && JOptionPanes.showConfirmDialog(FrmEnzymes.this, "Update the enzyme mix list to contain the selected mixes?") == 0) {
                    EnzymeMixList currentList = (EnzymeMixList)FrmEnzymes.this.comboModelMix.getSelectedItem();
                    if (currentList == null || currentList == manualMixListItem) {
                        return;
                    }
                    currentList.enzymeMixes.clear();
                    for (int x = 0; x < FrmEnzymes.this.listModelSelectedMixes.getSize(); ++x) {
                        currentList.enzymeMixes.put((EnzymeMix)FrmEnzymes.this.listModelSelectedMixes.getElementAt(x));
                    }
                    FrmEnzymes.this.cmbUserMixLists.setSelectedIndex(selIndex);
                    DefaultLibraries.userLibrary.setChanged(true);
                }
            }
        });
        menuItem = new JMenuItem("Delete selected enzyme mix list");
        menu.add(menuItem);
        menuItem.setEnabled(index > 0);
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.setToolTipText("Delete the currently selected enzyme mix list.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selIndex = FrmEnzymes.this.cmbUserLists.getSelectedIndex();
                if (selIndex < 1) {
                    return;
                }
                if (JOptionPanes.showConfirmDialog(FrmEnzymes.this, "Really remove this mix list?") == 0) {
                    EnzymeMixList currentList = (EnzymeMixList)FrmEnzymes.this.comboModelMix.getSelectedItem();
                    if (currentList == null || currentList == manualMixListItem) {
                        return;
                    }
                    DefaultLibraries.userLibrary.userMixeLists.remove(currentList.getName());
                    FrmEnzymes.this.cmbUserMixLists.removeItemAt(selIndex);
                    FrmEnzymes.this.cmbUserMixLists.setSelectedIndex(0);
                    DefaultLibraries.userLibrary.setChanged(true);
                }
            }
        });
        menuItem = new JMenuItem("Help");
        menu.add(menuItem);
        menuItem.addMouseListener(this.statusLabelMouseListener);
        menuItem.setToolTipText("Click for help with this item.");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmEnzymes.this.showHelp("re_usermixlist");
            }
        });
        menu.show(this.cmdEditUserMix, 0, this.cmdEditUserMix.getHeight());
    }

    private void selectionTypeTabsStateChanged(ChangeEvent evt) {
        int tabIndex = this.selectionTypeTabs.getSelectedIndex();
        switch (tabIndex) {
            case 0: {
                this.txtNameSingle.requestFocus();
                this.txtNameSingle.selectAll();
                break;
            }
            case 1: {
                this.txtNameMix.requestFocus();
                this.txtNameMix.selectAll();
                break;
            }
            case 2: {
                this.txtNameComp.requestFocus();
                this.txtNameComp.selectAll();
                break;
            }
            case 3: {
                this.txtMinCuts.requestFocus();
                this.txtMinCuts.selectAll();
                break;
            }
            case 4: {
                this.txtSearchSeq.requestFocus();
                this.txtSearchSeq.selectAll();
            }
        }
    }

    private void cmdHelpFilterActionPerformed(ActionEvent evt) {
        this.showHelp("re_filters");
    }

    private void txtNameSingleFocusGained(FocusEvent evt) {
        this.txtNameSingle.selectAll();
    }

    private void txtNameMixFocusGained(FocusEvent evt) {
        this.txtNameMix.selectAll();
    }

    private void txtNameCompFocusGained(FocusEvent evt) {
        this.txtNameComp.selectAll();
    }

    private void txtSearchSeqFocusGained(FocusEvent evt) {
        this.txtSearchSeq.selectAll();
    }

    private void lstSelectedSingleMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.removeSelected(this.lstSelectedSingle);
        }
    }

    private void lstSelectedMixMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.cmdRemMixActionPerformed(null);
        }
    }

    private void lstSelectedSiteMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.removeSelected(this.lstSelectedSite);
        }
    }

    private void lstSelectedCompEndsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.removeSelected(this.lstSelectedCompEnds);
        }
    }

    private void showHelp(String contents) {
        ((PLOTJ)this.getParent()).showHelp(contents);
    }

    void findMatch(boolean exact) {
        this.listModelFoundMatch.removeAllElements();
        String searchSeq = this.txtSearchSeq.getText().toUpperCase();
        if (searchSeq.length() == 0) {
            return;
        }
        for (int x = 0; x < this.listModelSelectable.getSize(); ++x) {
            ProjectEnzyme item = this.listModelSelectable.getElementAt(x);
            if ((exact || !item.enzyme.filteredSeq.contains(searchSeq)) && (!exact || !item.enzyme.filteredSeq.equals(searchSeq))) continue;
            this.listModelFoundMatch.addElement(item);
        }
    }

    private void showEnzymeInfo(Enzyme enzyme, JLabel infoDam, JLabel infoDcm, JLabel infoCpg, JLabel infoMisc) {
        switch (enzyme.isDam) {
            case 0: {
                infoDam.setIcon(this.iconWhite);
                infoDam.setToolTipText("Enzyme is not sensitive to Dam methylation.");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                infoDam.setIcon(this.iconRed);
                infoDam.setToolTipText("Enzyme is blocked by Dam methylation.");
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                infoDam.setIcon(this.iconOrange);
                infoDam.setToolTipText("Enzyme is impaired by Dam methylation.");
            }
        }
        switch (enzyme.isDcm) {
            case 0: {
                infoDcm.setIcon(this.iconWhite);
                infoDcm.setToolTipText("Enzyme is not sensitive to Dcm methylation.");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                infoDcm.setIcon(this.iconRed);
                infoDcm.setToolTipText("Enzyme is blocked by Dcm methylation.");
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                infoDcm.setIcon(this.iconOrange);
                infoDcm.setToolTipText("Enzyme is impaired by Dcm methylation.");
            }
        }
        switch (enzyme.isCpG) {
            case 0: {
                infoCpg.setIcon(this.iconWhite);
                infoCpg.setToolTipText("Enzyme is not sensitive to CpG methylation.");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                infoCpg.setIcon(this.iconRed);
                infoCpg.setToolTipText("Enzyme is blocked by CpG methylation.");
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                infoCpg.setIcon(this.iconOrange);
                infoCpg.setToolTipText("Enzyme is impaired by CpG methylation.");
            }
        }
        if (enzyme.requiresMeth != 0 || enzyme.requiresMult) {
            if (enzyme.requiresMeth != 0 && enzyme.requiresMult) {
                infoMisc.setToolTipText("<b>Requires<b> methylation for efficient digest.");
            } else if (enzyme.requiresMeth != 0) {
                infoMisc.setToolTipText("<html><b>Requires<b> methylation for efficient digest.  <b>Requires<b> 2+ sites for efficient digest.</html>");
            } else {
                infoMisc.setToolTipText("<b>Requires<b> 2+ sites for efficient digest.");
            }
            infoMisc.setIcon(this.iconOrange);
        } else {
            infoMisc.setBackground(Color.white);
            infoMisc.setToolTipText("No additional information or requirements.");
            infoMisc.setIcon(this.iconWhite);
        }
    }

    @Override
    public void tablePropertyChanged(int ... events) {
        block3: for (int event : events) {
            switch (event) {
                case 0: {
                    int row = this.tblFreq.getSelectionRowStart();
                    if (row <= -1) continue block3;
                    this.txtMinCuts.setText(String.valueOf(this.tblFreq.getValue(0, row)));
                    this.txtMaxCuts.setText(String.valueOf(this.tblFreq.getValue(1, row)));
                    this.txtMinBp.setText(String.valueOf(this.tblFreq.getValue(2, row)));
                    this.txtMaxBp.setText(String.valueOf(this.tblFreq.getValue(3, row)));
                }
            }
        }
    }

    class checkAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            FrmEnzymes.this.populateSelectableModel();
        }
    }

    private class FilterTableModel
    extends DataTableModel {
        protected final ExtensibleArray<EnzymeFilter> dataRows = new ExtensibleArray<EnzymeFilter>(EnzymeFilter.class);
        protected final ExtensibleArray<String> columns = new ExtensibleArray<String>(String.class);

        public FilterTableModel() {
            this.columns.add("Min. Cuts");
            this.columns.add("Max Cuts");
            this.columns.add("Min Bp");
            this.columns.add("max Bp");
        }

        @Override
        public void clear() {
            this.dataRows.clear();
            this.fireEvents(new DataTableModelEvent(this));
        }

        @Override
        public int getColumnCount() {
            return this.columns != null ? this.columns.size() : 0;
        }

        @Override
        public int getRowCount() {
            return this.dataRows.size();
        }

        @Override
        public boolean isCellEditable(int col, int row) {
            return true;
        }

        EnzymeFilter get(int row) {
            this.ensureRow(row);
            EnzymeFilter filter = this.dataRows.get(row);
            return filter;
        }

        @Override
        public void setValue(int col, int row, Object value) {
            if (row < 0) {
                return;
            }
            EnzymeFilter filter = this.get(row);
            switch (col) {
                case 0: {
                    filter.minCuts = Integer.parseInt((String)value);
                    return;
                }
                case 1: {
                    filter.maxCuts = Integer.parseInt((String)value);
                    return;
                }
                case 2: {
                    filter.minBp = Integer.parseInt((String)value);
                    return;
                }
                case 3: {
                    filter.maxCuts = Integer.parseInt((String)value);
                    return;
                }
            }
            this.fireEvents(new DataTableModelEvent(this));
        }

        @Override
        public Object getValue(int col, int row) {
            if (row < 0 || this.columns.size() <= col) {
                return null;
            }
            EnzymeFilter filter = this.get(row);
            switch (col) {
                case 0: {
                    return filter.minCuts;
                }
                case 1: {
                    return filter.maxCuts;
                }
                case 2: {
                    return filter.minBp;
                }
                case 3: {
                    return filter.maxBp;
                }
            }
            return null;
        }

        private void ensureRow(int row) {
            if (row >= this.dataRows.size()) {
                for (int x = this.dataRows.size() - 1; x < row; ++x) {
                    this.dataRows.add(new EnzymeFilter());
                }
            }
        }

        @Override
        public int addRow(Object ... values) {
            int row;
            int lastRow = row = this.dataRows.size() - 1;
            for (Object value : values) {
                if (!(value instanceof EnzymeFilter)) continue;
                this.ensureRow(++row);
                this.dataRows.replace((EnzymeFilter)values[0], row);
            }
            this.fireEvents(new DataTableModelEvent(this, row, row, -1, -1, 0));
            if (lastRow < row) {
                return row;
            }
            return -1;
        }

        @Override
        public void setRow(int row, Object ... values) {
            if (row < 0) {
                throw new IllegalArgumentException("index out of range: " + row);
            }
            if (values.length == 1 && values[0] instanceof EnzymeFilter) {
                this.dataRows.replace((EnzymeFilter)values[0], row);
                this.fireEvents(new DataTableModelEvent(this, row, row, -1, -1, 0));
            }
        }

        @Override
        public void removeRow(int row) {
            this.dataRows.remove(row);
            this.fireEvents(new DataTableModelEvent(this, row, row, -1, -1, -1));
        }

        @Override
        public boolean swap(int row1, int row2) {
            boolean retVal = this.dataRows.swap(row1, row2);
            this.fireEvents(new DataTableModelEvent(this, row1, row2, -1, -1, 0));
            return retVal;
        }

        @Override
        public void insertColumn(Object value, int index) {
        }

        @Override
        public Object getColumn(int index) {
            return this.columns.get(index);
        }

        @Override
        public void setColumn(int index, Object value) {
        }

        @Override
        public void setColumns(Object ... values) {
        }

        @Override
        public void setColumnCount(int count) {
        }

        @Override
        public void resizeColumn(int count) {
        }
    }
}

