/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import BioDocumentFilters.BioAllowedKeyFilter;
import Buttons.GlossyButton;
import CheckedListBox.CheckListBox;
import CheckedListBox.CheckListItem;
import DNATools.DNAGappedFinder;
import GenbankFileReader.Locus;
import ProteinTools.AAGappedFinder;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.ROI;
import Sequences.SequenceExportFormat;
import UIRenderers.GhostTextFieldUI;
import UndoRedo.Undoable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import plot.Feature;
import plot.FrmNewFeature;
import plot.Globals;
import plot.MainExclusiveDlg;
import plot.PLOTJ;
import plot.ProjectDocument;

class FrmFind
extends MainExclusiveDlg {
    private BinaryChain<Feature> foundFeatures = new BinaryChain();
    private SequenceExportFormat lastPastedSEF = null;
    private String sequence = null;
    private int seqLen = 0;
    DNAGappedFinder finder;
    AAGappedFinder aaFinder;
    private final DocumentListener docListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            if (FrmFind.this.txtSearchString.getText().length() > 2 && FrmFind.this.txtSearchString.getText().length() <= FrmFind.this.getProject().length()) {
                FrmFind.this.findSequence();
            } else {
                ((FrmFind)FrmFind.this).lstResults.listModel.clear();
            }
        }
    };
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmFind.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmFind.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    private JCheckBox chkASense;
    private JCheckBox chkSense;
    private GlossyButton cmdCancel;
    private GlossyButton cmdOK;
    private ButtonGroup grpSeqType;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private CheckListBox lstResults;
    private JRadioButton opAA;
    private JRadioButton opDNA;
    private StatusLabel statusLabel;
    private JTextField txtSearchString;

    private void sequencePasted() {
        try {
            SequenceExportFormat data;
            if (Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(SequenceExportFormat.copiedSequenceFlavor) && (data = (SequenceExportFormat)Toolkit.getDefaultToolkit().getSystemClipboard().getData(SequenceExportFormat.copiedSequenceFlavor)) != null && data.annotations.length > 0) {
                this.lastPastedSEF = data;
                return;
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        this.lastPastedSEF = null;
    }

    public FrmFind(PLOTJ parent) {
        super((Window)parent);
        this.initComponents();
        this.txtSearchString.setUI(new GhostTextFieldUI());
        this.sequence = this.getProject().getSequence().toUpperCase();
        this.seqLen = this.sequence.length();
        ((AbstractDocument)this.txtSearchString.getDocument()).setDocumentFilter(BioAllowedKeyFilter.DNA_DEGEN_GAP_Filter);
        this.txtSearchString.getDocument().addDocumentListener(this.docListener);
        this.chkSense.addMouseListener(this.menuMouseListener);
        this.chkASense.addMouseListener(this.menuMouseListener);
        this.cmdOK.addMouseListener(this.menuMouseListener);
        this.cmdCancel.addMouseListener(this.menuMouseListener);
        this.opDNA.addMouseListener(this.menuMouseListener);
        this.opAA.addMouseListener(this.menuMouseListener);
        this.txtSearchString.addMouseListener(this.menuMouseListener);
        this.setIconImage(Globals.icon.getImage());
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void doOK() {
        final ProjectDocument project = this.getProject();
        if (!this.lstResults.listModel.isEmpty()) {
            final FrmNewFeature f = new FrmNewFeature(this){

                @Override
                public void loadFeature(Feature feature) {
                    this.loadedFeature = feature;
                    this.txtFName.setText(feature.getName());
                    this.cmdGColor.setAllBackColors(feature.getBackColor());
                    this.cmdLColor.setAllBackColors(feature.getTextColor());
                    this.cmbGBType.getEditor().setItem(feature.getGBType().length() == 0 ? "misc_feature" : feature.getGBType());
                    if (feature.renderer != null) {
                        this.cmbGraphic.setSelectedItem(feature.renderer);
                    }
                    this.spinWidth.setValue(feature.getWidth());
                    this.spinRadius.setValue(feature.getOffset());
                    this.txtNotes.setText(feature.getNote());
                }

                @Override
                public void doOK() {
                    this.saved = true;
                    Feature feat = (Feature)this.getROI();
                    final ExtensibleArray<Feature> addedFeatures = new ExtensibleArray<Feature>(Feature.class);
                    for (int x = 0; x < ((FrmFind)FrmFind.this).lstResults.listModel.getSize(); ++x) {
                        CheckListItem chk = ((FrmFind)FrmFind.this).lstResults.listModel.get(x);
                        if (!chk.isChecked()) continue;
                        Feature newFeature = feat.clone();
                        Locus pos = (Locus)chk.obj;
                        newFeature.set(pos.getStart(), pos.getStop(), pos.isAntisense());
                        addedFeatures.add(newFeature);
                    }
                    final boolean changed = project.isChanged();
                    Undoable edit = new Undoable(){

                        @Override
                        public boolean undo() {
                            boolean active = project.disableListeners();
                            for (Feature feature : addedFeatures) {
                                project.removeROI(feature);
                            }
                            project.setListenersEnabled(active);
                            project.fireEvents(115, 106);
                            project.setChanged(changed);
                            return true;
                        }

                        @Override
                        public boolean redo() {
                            boolean active = project.disableListeners();
                            for (Feature feature : addedFeatures) {
                                project.addROI((ROI)feature);
                            }
                            project.setListenersEnabled(active);
                            project.fireEvents(106);
                            project.setChanged(true);
                            return true;
                        }
                    };
                    project.runEdit(edit);
                    this.setVisible(false);
                    ((FrmFind)this.getParent()).dispose();
                }
            };
            f.txtStart.setDocumentFilter(null);
            f.txtEnd.setDocumentFilter(null);
            f.txtStart.setText("-");
            f.txtEnd.setText("-");
            f.txtStart.setEnabled(false);
            f.txtEnd.setEnabled(false);
            f.cmbOrient.setEnabled(false);
            f.setLocationRelativeTo(this);
            if (this.lastPastedSEF != null) {
                this.foundFeatures.clear();
                for (ROI annotation : this.lastPastedSEF.annotations) {
                    Feature feat = Feature.fromAnnotation(annotation);
                    this.foundFeatures.add(feat, feat.getName());
                }
                if (this.foundFeatures.size() > 0) {
                    f.loadFeature(this.foundFeatures.get(0));
                } else {
                    f.txtFName.setText(this.lastPastedSEF.name);
                }
                f.txtFName.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            FrmFind.this.genNamesPopupMenu(f).show(f.txtFName, e.getX(), e.getY());
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            FrmFind.this.genNamesPopupMenu(f).show(f.txtFName, e.getX(), e.getY());
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }
                });
            }
            f.setVisible(true);
        }
    }

    private JPopupMenu genNamesPopupMenu(final FrmNewFeature f) {
        JPopupMenu menu = new JPopupMenu();
        if (!this.foundFeatures.isEmpty()) {
            MouseListener mml = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                }

                @Override
                public void mouseReleased(MouseEvent arg0) {
                }

                @Override
                public void mouseEntered(MouseEvent arg0) {
                    JComponent c = (JComponent)arg0.getComponent();
                    ToolTipManager.sharedInstance().setEnabled(false);
                    if (!(c instanceof JSeparator)) {
                        f.statusLabel.setText(c.getToolTipText(), 3000);
                    }
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                    f.statusLabel.setText("");
                    ToolTipManager.sharedInstance().setEnabled(true);
                }
            };
            menu.add(Globals.genToolTipSep("Set Properties", 1, mml));
            JMenuItem item = this.genFPropertiesMenuItem(new Feature("Reset to Default Poperties"), f, mml);
            item.setToolTipText("Set default properties");
            menu.add(item);
            menu.add(Globals.genToolTipSep("Copy Properties From", 0, mml));
            for (Feature feat : this.foundFeatures) {
                item = this.genFPropertiesMenuItem(feat, f, mml);
                item.setToolTipText("Set properties from pasted feature: " + feat.getName());
                if (this.lastPastedSEF.name.equals(feat.getName())) {
                    menu.add((Component)item, 3);
                    continue;
                }
                menu.add(item);
            }
            menu.add(Globals.genToolTipSep("Set Default", 2, mml));
        }
        return menu;
    }

    private JMenuItem genFPropertiesMenuItem(final Feature feat, final FrmNewFeature f, MouseListener mml) {
        JMenuItem item = new JMenuItem(feat.getName());
        if (mml != null) {
            item.addMouseListener(mml);
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                f.loadFeature(feat);
            }
        });
        return item;
    }

    @Override
    public void doCancel() {
        this.dispose();
    }

    private void findSequence() {
        String searchText = this.txtSearchString.getText();
        this.lstResults.listModel.removeAllElements();
        if (searchText.length() < 3 || searchText.length() > this.getProject().length()) {
            return;
        }
        Locus[] results = null;
        if (this.opDNA.isSelected()) {
            if (this.finder == null) {
                this.finder = new DNAGappedFinder(this.sequence, this.getProject().isCircular());
                this.finder.setAllowDegenerate(true);
            }
            if (this.finder.find(searchText, this.chkSense.isSelected(), this.chkASense.isSelected())) {
                results = this.finder.getMatches();
            }
        } else {
            if (this.aaFinder == null) {
                this.aaFinder = new AAGappedFinder(this.sequence, this.getProject().isCircular());
                this.aaFinder.setAllowDegenerate(true);
            }
            if (this.aaFinder.find(searchText, this.chkSense.isSelected(), this.chkASense.isSelected())) {
                results = this.aaFinder.getMatches();
            }
        }
        if (results != null && results.length > 0) {
            for (Locus pos : results) {
                if (!pos.isAntisense()) {
                    this.lstResults.listModel.addElement(new CheckListItem("Match found at bp(s): " + pos.getStart() + " - " + pos.getStop() + ", " + pos.getLength(this.seqLen) + "bp", true, pos));
                    continue;
                }
                this.lstResults.listModel.addElement(new CheckListItem("Match found at bp(s):  complement(" + pos.getStop() + " - " + pos.getStart() + "), " + pos.getLength(this.seqLen) + "bp", true, pos));
            }
        }
    }

    private void initComponents() {
        this.grpSeqType = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.chkSense = new JCheckBox();
        this.chkASense = new JCheckBox();
        this.opDNA = new JRadioButton();
        this.opAA = new JRadioButton();
        this.cmdOK = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.lstResults = new CheckListBox();
        this.statusLabel = new StatusLabel();
        this.txtSearchString = new JTextField(){

            @Override
            public void paste() {
                FrmFind.this.sequencePasted();
                super.paste();
            }
        };
        this.setDefaultCloseOperation(2);
        this.setTitle("pLOT Find Sequence");
        this.jLabel1.setText("Sequence to find:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Search Options"));
        this.jPanel1.setOpaque(false);
        this.chkSense.setSelected(true);
        this.chkSense.setText("Sense");
        this.chkSense.setToolTipText("Toggle search on the sense strand.");
        this.chkSense.setContentAreaFilled(false);
        this.chkSense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmFind.this.chkSenseActionPerformed(evt);
            }
        });
        this.chkASense.setSelected(true);
        this.chkASense.setText("Antisense");
        this.chkASense.setToolTipText("Toggle search on the antisense strand.");
        this.chkASense.setContentAreaFilled(false);
        this.chkASense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmFind.this.chkASenseActionPerformed(evt);
            }
        });
        this.grpSeqType.add(this.opDNA);
        this.opDNA.setSelected(true);
        this.opDNA.setText("DNA");
        this.opDNA.setToolTipText("Search for a DNA sequence.");
        this.opDNA.setContentAreaFilled(false);
        this.opDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmFind.this.opDNAActionPerformed(evt);
            }
        });
        this.grpSeqType.add(this.opAA);
        this.opAA.setText("Amino Acids");
        this.opAA.setToolTipText("Search for a protein sequence.");
        this.opAA.setContentAreaFilled(false);
        this.opAA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmFind.this.opAAActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.chkSense).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkASense).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.opDNA).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.opAA).addContainerGap(114, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkSense).addComponent(this.chkASense).addComponent(this.opDNA).addComponent(this.opAA)));
        this.cmdOK.setText("Convert to Features");
        this.cmdOK.setToolTipText("Convert selected found matches to annotations and close the search window.");
        this.cmdOK.setColorHot(new Color(204, 204, 255));
        this.cmdOK.setColorNormal(new Color(240, 240, 240));
        this.cmdOK.setColorPressed(new Color(204, 204, 255));
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmFind.this.cmdOKActionPerformed(evt);
            }
        });
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setToolTipText("Closes the search window.");
        this.cmdCancel.setColorHot(new Color(204, 204, 255));
        this.cmdCancel.setColorNormal(new Color(240, 240, 240));
        this.cmdCancel.setColorPressed(new Color(204, 204, 255));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmFind.this.cmdCancelActionPerformed(evt);
            }
        });
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.txtSearchString.setToolTipText("Search Sequence");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lstResults, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtSearchString))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdOK, -1, -1, Short.MAX_VALUE).addComponent(this.cmdCancel, -1, -1, Short.MAX_VALUE))).addComponent(this.statusLabel, -1, 571, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtSearchString).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cmdOK, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdCancel, -2, -1, -2).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lstResults, -1, 238, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.statusLabel, -2, -1, -2).addGap(0, 0, 0)));
        this.pack();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void chkSenseActionPerformed(ActionEvent evt) {
        if (!this.chkASense.isSelected() && !this.chkSense.isSelected()) {
            this.chkASense.setSelected(true);
        }
        this.findSequence();
    }

    private void chkASenseActionPerformed(ActionEvent evt) {
        if (!this.chkASense.isSelected() && !this.chkSense.isSelected()) {
            this.chkSense.setSelected(true);
        }
        this.findSequence();
    }

    private void opAAActionPerformed(ActionEvent evt) {
        ((AbstractDocument)this.txtSearchString.getDocument()).setDocumentFilter(BioAllowedKeyFilter.ProteinGapFilter);
        this.txtSearchString.getDocument().addDocumentListener(this.docListener);
        this.findSequence();
    }

    private void opDNAActionPerformed(ActionEvent evt) {
        ((AbstractDocument)this.txtSearchString.getDocument()).setDocumentFilter(BioAllowedKeyFilter.DNA_DEGEN_GAP_Filter);
        this.txtSearchString.getDocument().addDocumentListener(this.docListener);
        this.findSequence();
    }
}

