/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Buttons.GlossyButton;
import GenbankFileReader.GenBankFile;
import GhostTextControls.GhostTextBox;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import plot.JOptionPanes;
import plot.MainExclusiveDlg;
import plot.PLOTJ;

class FrmGBDownload
extends MainExclusiveDlg
implements PropertyChangeListener {
    private int totalBytes = 0;
    private static final int BUFFERSIZE = 1024;
    private GenBankFile gbr;
    private String id = "";
    private String fileContents = "";
    private boolean gbLoaded = false;
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    DownloadTask task = null;
    private GlossyButton cmdCancel;
    private GlossyButton cmdGet;
    private JLabel lblGBID;
    private JLabel lblStatus;
    private JPanel panelInput;
    private GhostTextBox txtGBID;
    private int returnStatus = 0;

    public boolean loaded() {
        return this.gbLoaded;
    }

    public GenBankFile getGBFile() {
        return this.gbr;
    }

    public FrmGBDownload(PLOTJ parent) {
        super((Window)parent);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.panelInput = new JPanel();
        this.lblGBID = new JLabel();
        this.txtGBID = new GhostTextBox();
        this.lblStatus = new JLabel();
        this.cmdGet = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.setTitle("Fetch Genbank Sequence");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrmGBDownload.this.closeDialog(evt);
            }
        });
        this.lblGBID.setText("Genbank Entry ID");
        this.txtGBID.setText("MN908947.3");
        this.txtGBID.setBlankText("Genbank ID (ex: MN908947.3)");
        this.txtGBID.setSelectionOnFocus(true);
        this.lblStatus.setHorizontalAlignment(0);
        this.cmdGet.setText("Retrieve");
        this.cmdGet.setColorHot(new Color(153, 153, 255));
        this.cmdGet.setColorNormal(new Color(240, 240, 240));
        this.cmdGet.setColorPressed(new Color(153, 153, 255));
        this.cmdGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGBDownload.this.cmdGetActionPerformed(evt);
            }
        });
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setColorHot(new Color(255, 102, 102));
        this.cmdCancel.setColorNormal(new Color(240, 240, 240));
        this.cmdCancel.setColorPressed(new Color(255, 102, 102));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGBDownload.this.cmdCancelActionPerformed(evt);
            }
        });
        GroupLayout panelInputLayout = new GroupLayout(this.panelInput);
        this.panelInput.setLayout(panelInputLayout);
        panelInputLayout.setHorizontalGroup(panelInputLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGBID, GroupLayout.Alignment.TRAILING, -2, 249, -2).addGroup(panelInputLayout.createSequentialGroup().addContainerGap().addGroup(panelInputLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelInputLayout.createSequentialGroup().addComponent(this.cmdGet, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdCancel, -2, 122, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, panelInputLayout.createSequentialGroup().addGroup(panelInputLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtGBID, -1, -1, Short.MAX_VALUE).addComponent(this.lblStatus, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        panelInputLayout.setVerticalGroup(panelInputLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelInputLayout.createSequentialGroup().addComponent(this.lblGBID).addGap(8, 8, 8).addComponent(this.txtGBID, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStatus, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelInputLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdCancel, -2, -1, -2).addComponent(this.cmdGet, -2, -1, -2)).addContainerGap(8, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelInput, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.panelInput, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void getGB() {
        this.id = this.txtGBID.getText().trim();
        if (this.id.length() == 0) {
            JOptionPanes.showMessageDialog(this, "Genbank ID cannot be blank", "Retrieval Error", 0);
            return;
        }
        this.cmdGet.setEnabled(false);
        this.cmdCancel.setEnabled(false);
        this.txtGBID.setEnabled(false);
        this.task = new DownloadTask(this, "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=nucleotide&id=" + this.id + "&rettype=gb&retmode=text");
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    private void cmdGetActionPerformed(ActionEvent evt) {
        this.getGB();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    private void completedDownload() {
        if (this.fileContents.length() > 0) {
            this.gbr = GenBankFile.loadString(this.fileContents);
            if (this.gbr != null) {
                GenBankFile src = this.getGBFile();
                if (src == null || !((PLOTJ)this.getParent()).loadFile(src)) {
                    this.hide();
                    PLOTJ pLOTJ = (PLOTJ)this.getParent();
                    StringBuilder stringBuilder = new StringBuilder().append("An error occurred while parsing the downloaded file\n");
                    this.getGBFile();
                    JOptionPanes.showMessageDialog(pLOTJ, stringBuilder.append(GenBankFile.getErrorMessage()).toString(), "Retrieval Error", 0);
                } else {
                    ((PLOTJ)this.getParent()).resetMap();
                }
                this.doClose(1);
            } else {
                JOptionPanes.showMessageDialog(this, "Failed to parse genbank entry " + this.id + "\n" + GenBankFile.getErrorMessage(), "Retrieval Error", 0);
                this.cmdGet.setEnabled(true);
                this.cmdCancel.setEnabled(true);
                this.txtGBID.setEnabled(true);
            }
        }
    }

    @Override
    public void doOK() {
        this.getGB();
        this.doClose(1);
    }

    @Override
    public void doCancel() {
        if (this.task != null) {
            this.task.cancel(true);
        }
        this.doClose(0);
    }

    public class DownloadTask
    extends SwingWorker<Void, Void> {
        private String downloadURL;
        private FrmGBDownload gui;
        private ByteArrayOutputStream output = new ByteArrayOutputStream();

        public DownloadTask(FrmGBDownload gui, String downloadURL) {
            this.gui = gui;
            this.downloadURL = downloadURL;
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                int bytesRead;
                FrmGBDownload.this.lblStatus.setText("Connecting to Genbank..");
                URL url = new URL(this.downloadURL);
                InputStream in = url.openStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    FrmGBDownload.this.totalBytes += bytesRead;
                    this.output.write(buffer, 0, bytesRead);
                    FrmGBDownload.this.lblStatus.setText("Downloading: " + FrmGBDownload.this.totalBytes);
                }
            }
            catch (MalformedURLException ex) {
                FrmGBDownload.this.lblStatus.setText("Download error");
                JOptionPanes.showMessageDialog(this.gui, "Failed to retreive genbank entry: " + FrmGBDownload.this.id, "Retrieval Error", 0);
                this.cancel(true);
            }
            catch (IOException ex) {
                FrmGBDownload.this.lblStatus.setText("Download error");
                if (ex.getMessage().startsWith("Server returned HTTP response code: 400")) {
                    JOptionPanes.showMessageDialog(this.gui, "Failed to retreive genbank entry: " + FrmGBDownload.this.id + "\nServer could not find the file", "Retrieval Error", 0);
                } else {
                    JOptionPanes.showMessageDialog(this.gui, "Failed to retreive genbank entry: " + FrmGBDownload.this.id + "\n" + ex.getMessage(), "Retrieval Error", 0);
                }
                this.cancel(true);
            }
            return null;
        }

        @Override
        protected void done() {
            FrmGBDownload.this.cmdGet.setEnabled(true);
            FrmGBDownload.this.cmdCancel.setEnabled(true);
            FrmGBDownload.this.txtGBID.setEnabled(true);
            if (!this.isCancelled()) {
                FrmGBDownload.this.fileContents = this.output.toString();
                FrmGBDownload.this.completedDownload();
            }
        }
    }
}

