/*
 * Decompiled with CFR 0.152.
 */
package plot;

import IconListBoxes.IconListBox;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.SequenceEditorPanel;
import Sequences.SequenceExportFormat;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import plaf.BaseRootPaneUI;
import plot.Globals;
import plot.JOptionPanes;
import plot.ListDragListener;
import plot.MobileBlock;
import plot.SEFTransferHandler;

class FrmMolBlocks
extends JFrame {
    File currentFile;
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmMolBlocks.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmMolBlocks.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    private boolean dropEnabled = true;
    private static final String helpText = "<html><b><u>Sequence Blocks</u></b><br>Drag and drop annotations from a project to the list to store the sequence, <br>and annotations properties.  These blocks can be dragged and dropped <br>into projects to insert the sequence and proterties into that project. <br><br>The list of stored sequence blocks can be saved to an external file and <br>loaded at a later timer using the Save, Save as, and Open buttons.<br><br>Sequence can be removed using the Delete button or the delete key.</html>";
    private static final DataFlavor localObjectFlavor = new DataFlavor(List.class, "List of SequenceExportFormat");
    private final FileFilter blocksFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String lc = file.getAbsolutePath().toLowerCase();
            return lc.endsWith(".xml") || lc.endsWith(".block");
        }

        @Override
        public String getDescription() {
            return "pLOT Sequence Blocks XML File";
        }
    };
    final String ext = ".xml";
    private JButton cmdDelete;
    private JButton cmdNew;
    private JButton cmdOpen;
    private JButton cmdSave;
    private SequenceEditorPanel editor;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane3;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator23;
    private JPopupMenu.Separator jSeparator34;
    private JLabel lblHelp;
    private IconListBox lstBlocks;
    private JMenuBar menuBar;
    private JMenuItem mnuNew;
    private JMenuItem mnuOpen;
    private JMenuItem mnuSave;
    private JMenuItem mnuSaveAs;
    private JMenuItem mnuToggleAS;
    private JMenuItem mnuToggleFrame1;
    private JMenuItem mnuToggleFrame2;
    private JMenuItem mnuToggleFrame3;
    private JMenu mnuView;
    private StatusLabel statusLabel;
    private JToolBar toolBar;

    public FrmMolBlocks() {
        this.initComponents();
        this.setIconImage(Globals.icon.getImage());
        BaseRootPaneUI.addAlwaysOnTop(this, this.menuMouseListener);
        this.toolBar.setFloatable(false);
        this.cmdNew.addMouseListener(this.menuMouseListener);
        this.cmdDelete.addMouseListener(this.menuMouseListener);
        this.cmdSave.addMouseListener(this.menuMouseListener);
        this.lblHelp.setToolTipText(helpText);
        this.lstBlocks.clear();
        this.lstBlocks.setDragEnabled(true);
        this.lstBlocks.setDropMode(DropMode.INSERT);
        this.lstBlocks.setTransferHandler(new SEFTransferHandler(this.lstBlocks){

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return super.canImport(support);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    SequenceExportFormat[] sef = (SequenceExportFormat[])support.getTransferable().getTransferData(SequenceExportFormat.copiedSequencesFlavor);
                    if (sef == null) {
                        return false;
                    }
                    JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
                    int index = dl.getIndex();
                    this.droppedItems(sef, index, index);
                    return true;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    return false;
                }
            }

            @Override
            public void droppedItems(SequenceExportFormat[] sef, int x, int y) {
                if (x == -1) {
                    x = 0;
                }
                for (int index = 0; index < sef.length; ++index) {
                    FrmMolBlocks.this.lstBlocks.addItem(new MobileBlock(sef[index]), x);
                }
            }
        });
        ListDragListener listener = new ListDragListener(this.lstBlocks){

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
                FrmMolBlocks.this.dropEnabled = false;
            }

            @Override
            public void dragExit(DragSourceEvent dse) {
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                FrmMolBlocks.this.dropEnabled = true;
            }
        };
        this.setKeys();
        this.updateEnables();
    }

    private void setKeys() {
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMolBlocks.this.delete();
            }
        });
    }

    public void delete() {
        int[] indicies = this.lstBlocks.getSelectedIndices();
        if (indicies.length > 0) {
            int cIndex = indicies.length == 1 ? indicies[0] : this.lstBlocks.getSelectedIndex();
            for (int x = indicies.length - 1; x >= 0; --x) {
                if (indicies[x] <= -1) continue;
                this.lstBlocks.removeItem(indicies[x]);
            }
            if (cIndex < this.lstBlocks.getItemCount() && cIndex > 0) {
                this.lstBlocks.setSelectedIndex(cIndex);
            } else if (this.lstBlocks.getItemCount() > 0) {
                this.lstBlocks.setSelectedIndex(this.lstBlocks.getItemCount() - 1);
            }
        }
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.cmdNew = new JButton();
        this.cmdOpen = new JButton();
        this.cmdSave = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.cmdDelete = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.lblHelp = new JLabel();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.lstBlocks = new IconListBox();
        this.jLabel1 = new JLabel();
        this.editor = new SequenceEditorPanel();
        this.statusLabel = new StatusLabel();
        this.menuBar = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.mnuNew = new JMenuItem();
        this.mnuOpen = new JMenuItem();
        this.mnuSave = new JMenuItem();
        this.mnuSaveAs = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.mnuView = new JMenu();
        this.jSeparator34 = new JPopupMenu.Separator();
        this.mnuToggleFrame1 = new JMenuItem();
        this.mnuToggleFrame2 = new JMenuItem();
        this.mnuToggleFrame3 = new JMenuItem();
        this.mnuToggleAS = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator23 = new JPopupMenu.Separator();
        this.setTitle("Sequence Blocks");
        this.toolBar.setRollover(true);
        this.cmdNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/New.png")));
        this.cmdNew.setToolTipText("Start a new project.");
        this.cmdNew.setContentAreaFilled(false);
        this.cmdNew.setFocusable(false);
        this.cmdNew.setHorizontalTextPosition(0);
        this.cmdNew.setVerticalTextPosition(3);
        this.cmdNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.cmdNewActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdNew);
        this.cmdOpen.setIcon(new ImageIcon(this.getClass().getResource("/images24/Open.png")));
        this.cmdOpen.setToolTipText("Open an existing project");
        this.cmdOpen.setContentAreaFilled(false);
        this.cmdOpen.setFocusable(false);
        this.cmdOpen.setHorizontalTextPosition(0);
        this.cmdOpen.setVerticalTextPosition(3);
        this.cmdOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.cmdOpenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdOpen);
        this.cmdSave.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.cmdSave.setToolTipText("Save the current project.");
        this.cmdSave.setContentAreaFilled(false);
        this.cmdSave.setFocusable(false);
        this.cmdSave.setHorizontalTextPosition(0);
        this.cmdSave.setVerticalTextPosition(3);
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.cmdSaveActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdSave);
        this.toolBar.add(this.jSeparator1);
        this.cmdDelete.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToNoGraphic.png")));
        this.cmdDelete.setToolTipText("Remove selected items");
        this.cmdDelete.setContentAreaFilled(false);
        this.cmdDelete.setFocusable(false);
        this.cmdDelete.setHorizontalTextPosition(0);
        this.cmdDelete.setVerticalTextPosition(3);
        this.cmdDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.cmdDeleteActionPerformed(evt);
            }
        });
        this.toolBar.add(this.cmdDelete);
        this.toolBar.add(this.jSeparator2);
        this.lblHelp.setHorizontalAlignment(0);
        this.lblHelp.setIcon(new ImageIcon(this.getClass().getResource("/images24/QUESTION.png")));
        this.toolBar.add(this.lblHelp);
        this.lstBlocks.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FrmMolBlocks.this.lstBlocksValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.lstBlocks);
        this.jLabel1.setText("Sequence Preview");
        this.editor.setAutoColumnCount(true);
        this.editor.setEditable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editor, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 116, -2).addGap(0, 158, Short.MAX_VALUE)).addComponent(this.jScrollPane3)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 278, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(4, 4, 4).addComponent(this.editor, -1, 143, Short.MAX_VALUE).addContainerGap()));
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.jMenu1.setText("File");
        this.mnuNew.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.mnuNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/New.png")));
        this.mnuNew.setText("Start a New File");
        this.mnuNew.setToolTipText("Start a new sequence blocks xml file.");
        this.mnuNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.mnuNewActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuNew);
        this.mnuOpen.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.mnuOpen.setIcon(new ImageIcon(this.getClass().getResource("/images24/Open.png")));
        this.mnuOpen.setText("Open Existing Project");
        this.mnuOpen.setToolTipText("Open an existing sequence blocks xml file");
        this.mnuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.mnuOpenActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuOpen);
        this.mnuSave.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.mnuSave.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.mnuSave.setText("Save List");
        this.mnuSave.setToolTipText("Save the current blocks");
        this.mnuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.mnuSaveActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuSave);
        this.mnuSaveAs.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.mnuSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.mnuSaveAs.setText("Save Project As...");
        this.mnuSaveAs.setToolTipText("Save the current blocks to an xml file.");
        this.mnuSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.mnuSaveAsActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuSaveAs);
        this.menuBar.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.menuBar.add(this.jMenu2);
        this.mnuView.setText("View");
        this.mnuView.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                FrmMolBlocks.this.mnuViewMenuSelected(evt);
            }
        });
        this.jSeparator34.setToolTipText("Change Feature Viewer Format");
        this.mnuView.add(this.jSeparator34);
        this.mnuToggleFrame1.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuToggleFrame1.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuToggleFrame1.setText("Toggle Feature Viewer Reading Frame 1");
        this.mnuToggleFrame1.setToolTipText("Toggle showing reading frame 1 translation in the Feature Viewer window.");
        this.mnuToggleFrame1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.mnuToggleFrame1ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame1);
        this.mnuToggleFrame2.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.mnuToggleFrame2.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuToggleFrame2.setText("Toggle Feature Viewer Reading Frame 2");
        this.mnuToggleFrame2.setToolTipText("Toggle showing reading frame 2 translation in the Feature Viewer window.");
        this.mnuToggleFrame2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.mnuToggleFrame2ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame2);
        this.mnuToggleFrame3.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.mnuToggleFrame3.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuToggleFrame3.setText("Toggle Feature Viewer Reading Frame 3");
        this.mnuToggleFrame3.setToolTipText("Toggle showing reading frame 3 translation in the Feature Viewer window.");
        this.mnuToggleFrame3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.mnuToggleFrame3ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame3);
        this.mnuToggleAS.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.mnuToggleAS.setIcon(new ImageIcon(this.getClass().getResource("/images24/AS.png")));
        this.mnuToggleAS.setText("Toggle Feature Viewer Antisense");
        this.mnuToggleAS.setToolTipText("Toggle showing the antisense strand in the Feature Viewer window.");
        this.mnuToggleAS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.mnuToggleASActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleAS);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/images24/AS.png")));
        this.jMenuItem2.setText("Toggle Feature Viewer Numbers");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMolBlocks.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.jMenuItem2);
        this.jSeparator23.setToolTipText("Map Mode");
        this.mnuView.add(this.jSeparator23);
        this.menuBar.add(this.mnuView);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolBar, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.statusLabel, -1, 286, Short.MAX_VALUE)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.toolBar, -2, 32, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.statusLabel, -2, -1, -2).addGap(0, 0, 0)));
        this.pack();
    }

    private void cmdNewActionPerformed(ActionEvent evt) {
        this.newList();
    }

    private void cmdOpenActionPerformed(ActionEvent evt) {
        this.open();
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void newList() {
        this.lstBlocks.clear();
    }

    private void open(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            SequenceExportFormat[] blocks = (SequenceExportFormat[])objectInputStream.readObject();
            this.lstBlocks.clear();
            for (int x = 0; x < blocks.length; ++x) {
                this.lstBlocks.addItem(new MobileBlock(blocks[x]));
            }
            this.currentFile = file;
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void save() {
        if (this.currentFile == null) {
            this.saveAs();
        } else {
            try {
                int count = this.lstBlocks.getModel().getSize();
                SequenceExportFormat[] blocks = new SequenceExportFormat[count];
                for (int x = 0; x < count; ++x) {
                    blocks[x] = (SequenceExportFormat)this.lstBlocks.getItem(x).getItem();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(this.currentFile);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(blocks);
                objectOutputStream.flush();
                objectOutputStream.close();
                this.statusLabel.setText("Saved to: " + this.currentFile.getAbsolutePath());
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                this.statusLabel.setText("Save failed!");
            }
        }
    }

    public void open() {
        int val;
        JFileChooser c = new JFileChooser();
        c.setFileFilter(this.blocksFilter);
        if (this.currentFile != null) {
            c.setSelectedFile(this.currentFile);
        }
        if ((val = c.showOpenDialog(null)) != 0) {
            return;
        }
        File file = c.getSelectedFile();
        if (file != null && file.getName().toLowerCase().endsWith(".xml")) {
            this.open(file);
        }
    }

    private void saveAs() {
        JFileChooser c = new JFileChooser();
        c.setFileFilter(this.blocksFilter);
        if (c.showSaveDialog(null) != 0) {
            return;
        }
        File file = c.getSelectedFile();
        if (file != null) {
            if (!file.getName().toLowerCase().endsWith(".xml")) {
                file = new File(file.getAbsoluteFile() + ".xml");
            }
            this.currentFile = file;
            if (!this.currentFile.exists() || this.currentFile.exists() && JOptionPanes.showConfirmDialog(null, (Object)"Overwrite existing file?", "File exists", 0) == 0) {
                this.save();
            }
        }
    }

    private void updateEnables() {
        boolean enabled = this.lstBlocks.getSelectedIndex() > -1;
        this.cmdDelete.setEnabled(enabled);
    }

    private void lstBlocksValueChanged(ListSelectionEvent evt) {
        Object item;
        int selIndex;
        this.editor.clear();
        if (this.lstBlocks.getModel().getSize() > 0 && (selIndex = this.lstBlocks.getSelectedIndex()) > -1 && (item = this.lstBlocks.getItem(this.lstBlocks.getSelectedIndex()).getItem()) != null) {
            SequenceExportFormat sef = (SequenceExportFormat)item;
            this.editor.getDocument().setSequence(sef);
            this.editor.select(0);
            this.editor.setSelectionLength(0);
        }
        this.updateEnables();
    }

    private void mnuNewActionPerformed(ActionEvent evt) {
        this.newList();
    }

    private void mnuOpenActionPerformed(ActionEvent evt) {
        this.open();
    }

    private void mnuSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void mnuSaveAsActionPerformed(ActionEvent evt) {
        this.saveAs();
    }

    private void cmdDeleteActionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void mnuToggleFrame1ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame1(!this.editor.isShowFrame1());
    }

    private void mnuToggleFrame2ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame2(!this.editor.isShowFrame2());
    }

    private void mnuToggleFrame3ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame3(!this.editor.isShowFrame3());
    }

    private void mnuToggleASActionPerformed(ActionEvent evt) {
        this.editor.setShowAntisense(!this.editor.isShowAntisense());
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.editor.setShowNumbers(!this.editor.isShowNumbers());
    }

    private void mnuViewMenuSelected(MenuEvent evt) {
        this.mnuView.getPopupMenu().setLightWeightPopupEnabled(false);
    }
}

