/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Buttons.GlossyButton;
import GenbankFileReader.GenBankFile;
import GhostTextControls.GhostTextBox;
import MouseMenuListeners.Listeners;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.SequenceEditorPanel;
import Sequences.SequenceExportFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import plot.DefaultLibraries;
import plot.FileSeqDandDHandler;
import plot.Globals;
import plot.MainExclusiveDlg;
import plot.PLOTJ;
import plot.ProjectDocument;

class FrmNewSeq
extends MainExclusiveDlg {
    public boolean saved = false;
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmNewSeq.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmNewSeq.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    public JCheckBox chkAnnotate;
    private JCheckBox chkCircular;
    private GlossyButton cmdCancel;
    private GlossyButton cmdOK;
    private SequenceEditorPanel editor;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu2;
    private JMenuBar mainMenuBar;
    private JMenuItem mnuCopy;
    private JMenuItem mnuCut;
    private JMenuItem mnuPaste;
    private JMenuItem mnuToggleAS;
    private JMenuItem mnuToggleFrame1;
    private JMenuItem mnuToggleFrame2;
    private JMenuItem mnuToggleFrame3;
    private JMenu mnuView;
    private JPopupMenu.Separator sepCopyPaste;
    private JPopupMenu.Separator sepViewSep;
    private StatusLabel statusLabel;
    private GhostTextBox txtName;
    private GhostTextBox txtOrg;
    private GhostTextBox txtSource;

    public FrmNewSeq(PLOTJ parent) {
        super((Window)parent);
        this.initComponents();
        this.editor.setDocument(new ProjectDocument());
        this.txtName.requestFocus();
        Listeners.setMenuBarListeners(this.mainMenuBar, this.menuMouseListener);
        this.setLocationRelativeTo(parent);
        this.setIconImage(Globals.icon.getImage());
        this.setDefaultCloseOperation(2);
        FileSeqDandDHandler seqDandD = new FileSeqDandDHandler(this.editor){

            public void droppedFiles(List filesList, int x, int y) {
                if (filesList.size() != 1) {
                    return;
                }
                GenBankFile gbFile = GenBankFile.loadGBFile((File)filesList.get(0));
                if (gbFile != null) {
                    FrmNewSeq.this.editor.setDocument(gbFile);
                }
                FrmNewSeq.this.chkCircular.setSelected(FrmNewSeq.this.editor.getDocument().isCircular());
            }

            @Override
            public void droppedSequence(SequenceExportFormat[] sef, int x, int y) {
                int index = FrmNewSeq.this.editor.getBaseIndex(x, y);
                FrmNewSeq.this.editor.select(index);
                if (sef.length == 1) {
                    FrmNewSeq.this.editor.setSelection(sef[0]);
                } else {
                    FrmNewSeq.this.editor.setSelection(SequenceExportFormat.merge(sef));
                }
            }

            @Override
            public void droppedSequence(GenBankFile file, int x, int y) {
                ProjectDocument document = new ProjectDocument();
                ProjectDocument.fromGenbankFile(file, document);
                FrmNewSeq.this.editor.setDocument(document);
            }
        };
        this.editor.setTransferHandler(seqDandD);
        this.editor.requestFocus();
    }

    private void initComponents() {
        this.txtName = new GhostTextBox();
        this.jLabel1 = new JLabel();
        this.chkCircular = new JCheckBox();
        this.chkAnnotate = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.cmdOK = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.txtSource = new GhostTextBox();
        this.txtOrg = new GhostTextBox();
        this.editor = new SequenceEditorPanel(){

            @Override
            public JPopupMenu getPopupMenu(int x, int y) {
                if (this.isShowFrame1() || this.isShowFrame2() || this.isShowFrame3()) {
                    return super.getPopupMenu(x, y);
                }
                return null;
            }
        };
        this.statusLabel = new StatusLabel();
        this.mainMenuBar = new JMenuBar();
        this.jMenu2 = new JMenu();
        this.sepCopyPaste = new JPopupMenu.Separator();
        this.mnuCopy = new JMenuItem();
        this.mnuCut = new JMenuItem();
        this.mnuPaste = new JMenuItem();
        this.mnuView = new JMenu();
        this.sepViewSep = new JPopupMenu.Separator();
        this.mnuToggleFrame1 = new JMenuItem();
        this.mnuToggleFrame2 = new JMenuItem();
        this.mnuToggleFrame3 = new JMenuItem();
        this.mnuToggleAS = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("pLOT - Enter New Sequence");
        this.setLocationByPlatform(true);
        this.txtName.setBlankText("Enter Sequence Name");
        this.txtName.setFont(new Font("Segoe UI", 0, 14));
        this.txtName.setNextFocusableComponent(this.txtSource);
        this.txtName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmNewSeq.this.txtNameFocusGained(evt);
            }
        });
        this.jLabel1.setText("Sequence Name");
        this.chkCircular.setText("Sequence is circular");
        this.chkCircular.setNextFocusableComponent(this.chkAnnotate);
        this.chkAnnotate.setSelected(true);
        this.chkAnnotate.setText("Automatically Annotate");
        this.chkAnnotate.setNextFocusableComponent(this.cmdOK);
        this.jLabel2.setText("Sequence:");
        this.cmdOK.setText("OK");
        this.cmdOK.setToolTipText("Close and commit sequence");
        this.cmdOK.setColorHot(new Color(204, 204, 255));
        this.cmdOK.setColorNormal(new Color(240, 240, 240));
        this.cmdOK.setColorPressed(new Color(204, 204, 255));
        this.cmdOK.setNextFocusableComponent(this.cmdCancel);
        this.cmdOK.setShiftOnPress(true);
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewSeq.this.cmdOKActionPerformed(evt);
            }
        });
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setToolTipText("Cancel and return to the current project.");
        this.cmdCancel.setColorHot(new Color(204, 204, 255));
        this.cmdCancel.setColorNormal(new Color(240, 240, 240));
        this.cmdCancel.setColorPressed(new Color(204, 204, 255));
        this.cmdCancel.setNextFocusableComponent(this.txtName);
        this.cmdCancel.setShiftOnPress(true);
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewSeq.this.cmdCancelActionPerformed(evt);
            }
        });
        this.txtSource.setBlankText("(Optional) Source");
        this.txtSource.setFont(new Font("Segoe UI", 0, 14));
        this.txtSource.setNextFocusableComponent(this.txtOrg);
        this.txtSource.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmNewSeq.this.txtSourceFocusGained(evt);
            }
        });
        this.txtOrg.setBlankText("(Optional) Organism");
        this.txtOrg.setFont(new Font("Segoe UI", 0, 14));
        this.txtOrg.setNextFocusableComponent(this.editor);
        this.txtOrg.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FrmNewSeq.this.txtOrgFocusLost(evt);
            }
        });
        this.editor.setAutoColumnCount(true);
        this.editor.setBackground(new Color(255, 255, 255));
        this.editor.setBlinking(true);
        this.editor.setDisplayPanelBackground(new Color(255, 255, 255));
        this.editor.setHandleFocusGained(true);
        this.editor.setHandleFocusLost(true);
        this.editor.setHorizontalIconAlignment(SequenceEditorPanel.HorizontalAlignment.TILED);
        this.editor.setScrollbarThumbColorOut(new Color(143, 143, 245));
        this.editor.setScrollbarThumbColorPressed(new Color(143, 143, 245));
        this.editor.setScrollbarThumbColorRollOver(new Color(143, 143, 245));
        this.editor.setScrollbarTrackColor(new Color(165, 169, 200));
        this.editor.setScrollbarTrackColorPressed(new Color(165, 169, 200));
        this.editor.setScrollbarTrackColorRollover(new Color(165, 169, 200));
        this.editor.setShowFrame1(false);
        this.editor.setShowFrame2(false);
        this.editor.setShowFrame3(false);
        this.statusLabel.setBackground(new Color(255, 255, 255));
        this.statusLabel.setForeground(new Color(0, 0, 0));
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 505, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 25, Short.MAX_VALUE));
        this.jMenu2.setText("Edit");
        this.sepCopyPaste.setToolTipText("Copy/Paste Options");
        this.jMenu2.add(this.sepCopyPaste);
        this.mnuCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.mnuCopy.setIcon(new ImageIcon(this.getClass().getResource("/images24/Copy2.png")));
        this.mnuCopy.setText("Copy");
        this.mnuCopy.setToolTipText("Copy the selected sequence and ccorresponding annotations to the clipboard.");
        this.mnuCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewSeq.this.mnuCopyActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuCopy);
        this.mnuCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.mnuCut.setIcon(new ImageIcon(this.getClass().getResource("/images24/Copy2.png")));
        this.mnuCut.setText("Cut");
        this.mnuCut.setToolTipText("Copy the selected sequence and ccorresponding annotations to the clipboard and delete selection from the sequence.");
        this.mnuCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewSeq.this.mnuCutActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuCut);
        this.mnuPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.mnuPaste.setIcon(new ImageIcon(this.getClass().getResource("/images24/Paste.png")));
        this.mnuPaste.setText("Paste");
        this.mnuPaste.setToolTipText("Paste the clipboard contents.");
        this.mnuPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewSeq.this.mnuPasteActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuPaste);
        this.mainMenuBar.add(this.jMenu2);
        this.mnuView.setText("View");
        this.mnuView.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                FrmNewSeq.this.mnuViewMenuSelected(evt);
            }
        });
        this.sepViewSep.setToolTipText("Change Feature Viewer Format");
        this.mnuView.add(this.sepViewSep);
        this.mnuToggleFrame1.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuToggleFrame1.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuToggleFrame1.setText("Toggle Feature Viewer Reading Frame 1");
        this.mnuToggleFrame1.setToolTipText("Toggle showing reading frame 1 translation in the Feature Viewer window.");
        this.mnuToggleFrame1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewSeq.this.mnuToggleFrame1ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame1);
        this.mnuToggleFrame2.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.mnuToggleFrame2.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuToggleFrame2.setText("Toggle Feature Viewer Reading Frame 2");
        this.mnuToggleFrame2.setToolTipText("Toggle showing reading frame 2 translation in the Feature Viewer window.");
        this.mnuToggleFrame2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewSeq.this.mnuToggleFrame2ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame2);
        this.mnuToggleFrame3.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.mnuToggleFrame3.setIcon(new ImageIcon(this.getClass().getResource("/images24/ssM.png")));
        this.mnuToggleFrame3.setText("Toggle Feature Viewer Reading Frame 3");
        this.mnuToggleFrame3.setToolTipText("Toggle showing reading frame 3 translation in the Feature Viewer window.");
        this.mnuToggleFrame3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewSeq.this.mnuToggleFrame3ActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleFrame3);
        this.mnuToggleAS.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.mnuToggleAS.setIcon(new ImageIcon(this.getClass().getResource("/images24/AS.png")));
        this.mnuToggleAS.setText("Toggle Feature Viewer Antisense");
        this.mnuToggleAS.setToolTipText("Toggle showing the antisense strand in the Feature Viewer window.");
        this.mnuToggleAS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmNewSeq.this.mnuToggleASActionPerformed(evt);
            }
        });
        this.mnuView.add(this.mnuToggleAS);
        this.mainMenuBar.add(this.mnuView);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtName, -2, 229, -2).addComponent(this.jLabel1, -2, 118, -2).addComponent(this.txtSource, -2, 229, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkCircular).addComponent(this.chkAnnotate)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdCancel, -1, 91, Short.MAX_VALUE).addComponent(this.cmdOK, -1, -1, Short.MAX_VALUE))).addComponent(this.txtOrg, -2, 229, -2).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.editor, -1, 505, Short.MAX_VALUE).addComponent(this.statusLabel, -1, 505, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cmdOK, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdCancel, -2, 28, -2)).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.chkCircular).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkAnnotate)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSource, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtOrg, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editor, -1, 237, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.statusLabel, -2, 25, -2).addGap(0, 0, 0)));
        this.pack();
    }

    public String getSequence() {
        return this.editor.getSequence();
    }

    public String getSequenceName() {
        return this.txtName.getText();
    }

    public boolean annotate() {
        return this.chkAnnotate.isSelected();
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        ProjectDocument project = ProjectDocument.fromDNASequenceDocument(this.editor.getDocument());
        String newName = this.txtName.getText();
        if (newName != null && newName.length() > 0) {
            project.setName(newName);
        }
        project.setCircular(this.chkCircular.isSelected());
        project.setOrganism(this.txtOrg.getText());
        project.setSource(this.txtSource.getText());
        this.saved = true;
        this.setVisible(false);
        project.setListenersEnabled(false);
        if (this.chkAnnotate.isSelected()) {
            DefaultLibraries.findFeatures(project, ((PLOTJ)this.getParent()).statusBarForm);
        }
        project.setListenersEnabled(true);
        project.setFile(null);
        ((PLOTJ)this.getParent()).setProject(project);
        project.setChanged(true);
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void mnuPasteActionPerformed(ActionEvent evt) {
        String seqName;
        boolean isEmpty = this.editor.getDocument().length() == 0;
        this.editor.pasteFromClipboard();
        String name = this.txtName.getText();
        if ((name == null || name.length() == 0) && (seqName = this.editor.getDocument().getName()) != null && seqName.length() > 0) {
            this.txtName.setText(seqName);
        }
        if (isEmpty) {
            this.chkCircular.setSelected(this.editor.getDocument().isCircular());
        }
    }

    private void mnuCutActionPerformed(ActionEvent evt) {
        this.copyCut(true);
    }

    private void copyCut(boolean cut) {
        this.editor.copySelectionToClipboard();
        if (cut) {
            this.editor.setSelection("");
        }
    }

    private void mnuCopyActionPerformed(ActionEvent evt) {
        this.copyCut(false);
    }

    private void mnuToggleFrame1ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame1(!this.editor.isShowFrame1());
    }

    private void mnuToggleFrame2ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame2(!this.editor.isShowFrame2());
    }

    private void mnuToggleFrame3ActionPerformed(ActionEvent evt) {
        this.editor.setShowFrame3(!this.editor.isShowFrame3());
    }

    private void mnuToggleASActionPerformed(ActionEvent evt) {
        this.editor.setShowAntisense(!this.editor.isShowAntisense());
    }

    private void mnuViewMenuSelected(MenuEvent evt) {
        this.mnuView.getPopupMenu().setLightWeightPopupEnabled(false);
    }

    private void txtNameFocusGained(FocusEvent evt) {
        this.txtName.selectAll();
    }

    private void txtSourceFocusGained(FocusEvent evt) {
        this.txtSource.selectAll();
    }

    private void txtOrgFocusLost(FocusEvent evt) {
        this.txtOrg.selectAll();
    }

    @Override
    public void doOK() {
        this.cmdOKActionPerformed(null);
    }

    @Override
    public void doCancel() {
        this.cmdCancelActionPerformed(null);
    }
}

