/*
 * Decompiled with CFR 0.152.
 */
package plot;

import ScrollPanels.StatusLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

abstract class FrmSearchRecentsAbstract
extends JDialog {
    protected ArrayList<File> files;
    protected DefaultListModel model;
    protected Frame myParent;
    protected final JLabel label = new JLabel();
    private JCheckBox chkNoPath;
    private JCheckBox chkShowPath;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane6;
    private JList<File> lstFiles;
    private StatusLabel statusLabel;
    private JTextField txtNameSingle;

    public FrmSearchRecentsAbstract(Frame parent, boolean modal, ArrayList<File> files) {
        super(parent, modal);
        this.files = files;
        this.initComponents();
        this.model = new DefaultListModel();
        this.lstFiles.setModel(this.model);
        this.txtNameSingle.requestFocus();
        this.txtNameSingle.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FrmSearchRecentsAbstract.this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FrmSearchRecentsAbstract.this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.setLocationRelativeTo(parent);
        this.myParent = parent;
        this.label.setOpaque(true);
        this.lstFiles.setCellRenderer(new ListCellRenderer<File>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends File> list, File value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    FrmSearchRecentsAbstract.this.label.setBackground(list.getForeground());
                    FrmSearchRecentsAbstract.this.label.setForeground(list.getBackground());
                } else {
                    FrmSearchRecentsAbstract.this.label.setForeground(list.getForeground());
                    FrmSearchRecentsAbstract.this.label.setBackground(list.getBackground());
                }
                FrmSearchRecentsAbstract.this.label.setText(FrmSearchRecentsAbstract.this.chkShowPath.isSelected() ? value.getAbsolutePath() : value.getName());
                return FrmSearchRecentsAbstract.this.label;
            }
        });
        this.updateList();
        String cancelName = "cancel";
        String okName = "OK";
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), okName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmSearchRecentsAbstract.this.doCancel();
            }
        });
        actionMap.put(okName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmSearchRecentsAbstract.this.doOK();
            }
        });
        this.init();
    }

    public void doCancel() {
        this.dispose();
    }

    public abstract void doOK();

    public abstract void init();

    public File getSelectedValue() {
        return this.lstFiles.getSelectedValue();
    }

    public void setFileIcon(ImageIcon icon) {
        this.label.setIcon(icon);
    }

    public void setStatusLabelIcon(ImageIcon icon) {
        this.statusLabel.setIcon(icon);
    }

    private void updateList() {
        String name = this.txtNameSingle.getText().trim().toLowerCase();
        if (name.length() == 0) {
            name = null;
        }
        boolean noPath = this.chkNoPath.isSelected();
        this.model.removeAllElements();
        for (File fName : this.files) {
            if (name == null) {
                this.model.addElement(fName);
                continue;
            }
            String lcName = noPath ? fName.getName() : fName.getAbsolutePath();
            if (!lcName.toLowerCase().contains(name)) continue;
            this.model.addElement(fName);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.txtNameSingle = new JTextField();
        this.jScrollPane6 = new JScrollPane();
        this.lstFiles = new JList();
        this.jLabel1 = new JLabel();
        this.chkNoPath = new JCheckBox();
        this.chkShowPath = new JCheckBox();
        this.statusLabel = new StatusLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Search Recent File Names");
        this.txtNameSingle.setFont(new Font("Segoe UI", 0, 14));
        this.txtNameSingle.setToolTipText("Type in an enzyme's name to go to the first partial or full match.");
        this.txtNameSingle.setPreferredSize(new Dimension(72, 26));
        this.txtNameSingle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmSearchRecentsAbstract.this.txtNameSingleFocusGained(evt);
            }
        });
        this.lstFiles.setFont(new Font("Segoe UI", 0, 14));
        this.lstFiles.setSelectionMode(0);
        this.lstFiles.setToolTipText("List of selectable enzymes.  Multiple selections are allowed at once.");
        this.lstFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmSearchRecentsAbstract.this.lstFilesMouseClicked(evt);
            }
        });
        this.lstFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FrmSearchRecentsAbstract.this.lstFilesValueChanged(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.lstFiles);
        this.jLabel1.setText("Search Text");
        this.chkNoPath.setSelected(true);
        this.chkNoPath.setText("Search filename only");
        this.chkNoPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSearchRecentsAbstract.this.chkNoPathActionPerformed(evt);
            }
        });
        this.chkShowPath.setSelected(true);
        this.chkShowPath.setText("Show Path");
        this.chkShowPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSearchRecentsAbstract.this.chkShowPathActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.chkNoPath).addGap(18, 18, 18).addComponent(this.chkShowPath))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.txtNameSingle, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtNameSingle, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkShowPath).addComponent(this.chkNoPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -1, 334, Short.MAX_VALUE).addContainerGap()));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 408, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel, -1, 408, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel, -2, -1, -2)));
        this.pack();
    }

    private void txtNameSingleFocusGained(FocusEvent evt) {
        this.txtNameSingle.selectAll();
    }

    private void lstFilesMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() > 1) {
            this.doOK();
        }
    }

    private void lstFilesValueChanged(ListSelectionEvent evt) {
        File file = this.lstFiles.getSelectedValue();
        if (file == null) {
            this.statusLabel.setText("");
        } else if (this.chkShowPath.isSelected()) {
            this.statusLabel.setText(file.getName());
        } else {
            this.statusLabel.setText(file.getPath());
        }
    }

    private void chkShowPathActionPerformed(ActionEvent evt) {
        this.lstFiles.repaint();
    }

    private void chkNoPathActionPerformed(ActionEvent evt) {
        this.updateList();
    }
}

